/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.DoubleArrayReservation;
import org.apache.solr.analytics.stream.reservation.FloatArrayReservation;
import org.apache.solr.analytics.stream.reservation.IntArrayReservation;
import org.apache.solr.analytics.stream.reservation.LongArrayReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.stream.reservation.StringArrayReservation;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public abstract class UniqueCollector<T>
extends ReductionDataCollector<UniqueData<T>> {
    public static final String name = "unique";
    private final String exprStr;
    private long count;
    Set<T> tempSet;
    Iterator<T> iter;

    public UniqueCollector(AnalyticsValueStream param) {
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.tempSet = new HashSet<T>();
    }

    public long count() {
        return this.count;
    }

    @Override
    public UniqueData<T> newData() {
        UniqueData data = new UniqueData();
        data.set = new HashSet();
        data.exists = false;
        return data;
    }

    @Override
    protected void apply(UniqueData<T> data) {
        data.set.addAll(this.tempSet);
    }

    public int startExport() {
        this.iter = ((UniqueData)this.ioData).set.iterator();
        return ((UniqueData)this.ioData).set.size();
    }

    public T exportNext() {
        return this.iter.next();
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.count = ((UniqueData)data).set.size();
    }

    @Override
    public void setData(ReductionData data) {
        this.count = ((UniqueData)data).set.size();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class UniqueData<T>
    extends ReductionData {
        Set<T> set;
    }

    public static class UniqueStringCollector
    extends UniqueCollector<String> {
        private StringValueStream param;

        public UniqueStringCollector(StringValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempSet.clear();
            this.param.streamStrings(val -> this.tempSet.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new StringArrayReservation(value -> ((UniqueData)this.ioData).set.add(value), size -> {}, () -> (String)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class UniqueDoubleCollector
    extends UniqueCollector<Double> {
        private DoubleValueStream param;

        public UniqueDoubleCollector(DoubleValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempSet.clear();
            this.param.streamDoubles(val -> this.tempSet.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new DoubleArrayReservation(value -> ((UniqueData)this.ioData).set.add(value), size -> {}, () -> (Double)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class UniqueFloatCollector
    extends UniqueCollector<Float> {
        private FloatValueStream param;

        public UniqueFloatCollector(FloatValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempSet.clear();
            this.param.streamFloats(val -> this.tempSet.add(Float.valueOf(val)));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new FloatArrayReservation(value -> ((UniqueData)this.ioData).set.add(Float.valueOf(value)), size -> {}, () -> ((Float)this.exportNext()).floatValue(), () -> this.startExport()));
        }
    }

    public static class UniqueLongCollector
    extends UniqueCollector<Long> {
        private LongValueStream param;

        public UniqueLongCollector(LongValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempSet.clear();
            this.param.streamLongs(val -> this.tempSet.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new LongArrayReservation(value -> ((UniqueData)this.ioData).set.add(value), size -> {}, () -> (Long)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class UniqueIntCollector
    extends UniqueCollector<Integer> {
        private IntValueStream param;

        public UniqueIntCollector(IntValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempSet.clear();
            this.param.streamInts(val -> this.tempSet.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new IntArrayReservation(value -> ((UniqueData)this.ioData).set.add(value), size -> {}, () -> (Integer)this.exportNext(), () -> this.startExport()));
        }
    }
}

