if not modules then modules = { } end modules ['lang-txt'] = {
    version   = 1.001,
    comment   = "companion to lang-lab.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files",
    dataonly  = true,
}

-- The content of this file is derived from the mkii lang-* files and
-- early 2011 the mkii labels are generated from this file. The
-- translations have been collected over years by users, using named
-- glyphs. This file uses utf exclusively.
--
-- Many of the initial translations were done by Tobias Burnus but
-- completed by numerous users. The following list is incomplete so feel
-- free to send me corrections.
--
-- In 2019+ Tomas Hala and his students (from Mendel University in Brno, CZ), added 
-- some more languages and did some extensive checking of the entries in this file.
--
-- af    Afrikaans      ...
-- als   Tosk Albanian  see Albanian (sq)
-- ar    Arabic         Idris Samawi Hamid, Khaled Hosny
-- be    Belarussian    Darya Hryshkavets (2019)
-- bg    Bulgarian      Vladislav Hinkin, Aleš Ďurčanský (2019)
-- ca    Catalan        ...; additions Javier Gambin Monzo + Samuel Conca Coles (2022)
-- cn    Chinese        Wang Lei, ...
-- cnr   Montenegrin    Теодора Шушкавчевић (2024)
-- cnr-latn Montenegrin Teodora Šuškavčević (2024)
-- cs    Czech          Tom Hudec, Petr Sojka, Richard Gabriel; additions Tomáš Hála (2022)
-- da    Danish         Arne Jorgensen
-- de    German         Tobias Burnus, ...
-- en    English        Hans Hagen, ...
-- eo    Esperanto      Alain Delmotte (2021)
-- es    Spanish        Andrés Montoya, ...; additions Javier Gambin Monzo + Samuel Conca Coles (2022)
-- et    Estonian       Clyde Johnston (2018)
-- fa    Persian        Mohammad Hossein Bateni (2016)
-- fi    Finnish        ...; additions Ossi Salo (2022)
-- fr    French         Daniel Flipo, Arthur Reutenauer; additions Arnaud Pierre Henri De Barbentane + Adrien Patton (2022)
-- gr    Greek          Apostolos Syropoulos, Thomas Schmitz; additions Evangelia Baltzi (2024)
-- hr    Croatian       Željko Vrba, Richard Gabriel, Vedran Miletić
-- hu    Hungarian      Adam Reviczky
-- hy    Armenian       Kristina Nazarjanová (2022)
-- id    Indonesian     Keiko Budhi Saputra (2024)
-- it    Italian        Giuseppe Bilotta, Luigi Scarso
-- ja    Japanese       Richard Gabriel
-- kr    Korean         Jeong Dalyoung
-- la    Latin          ...
-- lt    Lithuanian     Marius Aleknevičius; additions Ignas Vaičiulėnas (2024)
-- mk    Macedonian     Jakub Loula, Tomáš Hála (2019), Stojan Trajanovski (2019)
-- mo    Moldovan       see Romanian (ro)
-- ms    Malay          Sin Huei Ong (2024)
-- nb    Norwegian      Hans Fredrik Nordhaug, ...
-- nn    Norwegian      Hans Fredrik Nordhaug, ...
-- nl    Dutch          Hans Hagen
-- pl    Polish         Grzegorz Sapijaszko (2011)
-- pt    Portuguese     Pedro F. M. Mendonça; additions Joana Sophia Bogas Carneiro (2023)
-- ro    Romanian       Dan Seracu, ...; additions Valentina Badrajan (2024)
-- ru    Russian        Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- sk    Slovak         Tomáš Hála (2012, 2022)
-- sl    Slovenian      Mojca Miklavec; additions Lea Buljeta (2024)
-- sq    Albanian       Vullkan Hana (2024)
-- sr    Serbian        Ivan Pešić (2020)
-- sr-latn Serbian      Ivan Pešić (2020)
-- sv    Swedish        ...; additions Edith and Mikael Sundqvist (2023)
-- tk    Turkish        Tobias Burnus
-- tr    Turkmen        Nazar Annagurban
-- ua    Ukrainian      Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...; additions Bohdan Kyianytsia + Mykhailo Vitaliyovych Kryvda (2024)
-- vi    Vietnamese     Han The Thanh

-- For the moment we keep this table in memory. In the future we can then
-- enable labels.

-- thinspace == sixperemspace = 0x2006
-- print("!"..utf.char(0x2006).."!")

-- Will be done when needed:
-- (TH) editor|editors:mnem missing
-- (HH) save memory at functions
-- (MS) btx settings for sv

languages       = languages or { }
local languages = languages

languages.data  = languages.data or utilities.storage.allocate { }
local data      = languages.data

local hairspace = utf.char(0x200A)

data.labels={
 ["btx"]={
  ["In"]={
   ["labels"]={
    ["be"]="У",
    ["bg"]="в",
    ["ca"]="En",
    ["cnr"]="У",
    ["cnr-latn"]="U",
    ["cs"]="In",
    ["de"]="In",
    ["en"]="In",
    ["eo"]="En",
    ["es"]="En",
    ["fa"]="در",
    ["fr"]="Dans",
    ["gr"]="Σε",
    ["hy"]="Մեջ",
    ["id"]="Di",
    ["mk"]="во",
    ["ms"]="Dalam",
    ["ro"]="În",
    ["sk"]="In",
    ["sl"]="V",
    ["sr"]="У",
    ["sr-latn"]="U",
    ["ua"]="У",
   },
  },
  ["Number"]={
   ["labels"]={
    ["be"]="Нумар",
    ["bg"]="номер",
    ["ca"]="Nombre",
    ["cnr"]="Број",
    ["cnr-latn"]="Broj",
    ["cs"]="Číslo",
    ["de"]="Nummer",
    ["en"]="Number",
    ["eo"]="Nombro",
    ["es"]="Numero",
    ["fa"]="شماره",
    ["fr"]="Numéro",
    ["gr"]="Νούμερο",
    ["hy"]="Համար",
    ["id"]="Nomor",
    ["lt"]="Numeris",
    ["mk"]="Број",
    ["ms"]="Nombor",
    ["nl"]="Nummer",
    ["pt"]="Numero",
    ["ro"]="Număr",
    ["sk"]="Číslo",
    ["sl"]="Število",
    ["sq"]="Numër",
    ["sr"]="Број",
    ["sr-latn"]="Broj",
    ["ua"]="Номер",
   },
  },
  ["Volume"]={
   ["labels"]={
    ["be"]="Гук",
    ["bg"]="обем",
    ["ca"]="Volum",
    ["cnr"]="Том",
    ["cnr-latn"]="Tom",
    ["cs"]="Svazek",
    ["de"]="Band",
    ["en"]="Volume",
    ["eo"]="Volumo",
    ["es"]="Volumen",
    ["et"]="Köide",
    ["fa"]="جلد",
    ["fr"]="Volume",
    ["gr"]="Τόμος",
    ["hy"]="Ծավալ",
    ["id"]="Volume",
    ["lt"]="Grupė",
    ["mk"]="Том",
    ["ms"]="Jilid",
    ["nl"]="Deel",
    ["pt"]="Volume",
    ["ro"]="Volum",
    ["sk"]="Zväzok",
    ["sl"]="Volumen",
    ["sq"]="Zëri",
    ["sr"]="Том",
    ["sr-latn"]="Tom",
    ["ua"]="Том",
   },
  },
  ["and"]={
   ["labels"]={
    ["be"]="i",
    ["bg"]="a",
    ["ca"]="i",
    ["cnr"]="и",
    ["cnr-latn"]="i",
    ["cs"]="a",
    ["de"]="und",
    ["en"]="and",
    ["eo"]="kaj",
    ["es"]="y",
    ["et"]="ja",
    ["fa"]="و",
    ["fr"]="et",
    ["gr"]="και",
    ["hy"]="և",
    ["id"]="dan",
    ["it"]="e",
    ["lt"]="ir",
    ["mk"]="и",
    ["ms"]="dan",
    ["nl"]="en",
    ["pt"]="e",
    ["ro"]="și",
    ["sk"]="a",
    ["sl"]="in",
    ["sq"]="dhe",
    ["sr"]="и",
    ["sr-latn"]="i",
    ["ua"]="і",
   },
  },
  ["edition"]={
   ["labels"]={
    ["be"]="Выданне",
    ["bg"]="издание",
    ["ca"]="Edició",
    ["cnr"]="Изданје",
    ["cnr-latn"]="Izdanje",
    ["cs"]="vydání",
    ["de"]="Auflage",
    ["en"]="edition",
    ["eo"]="eldono",
    ["es"]="edición",
    ["et"]="väljaanne",
    ["fa"]="ویرایش",
    ["fi"]="versio",
    ["fr"]="édition",
    ["gr"]="έκδοση",
    ["hy"]="հրատարակություն",
    ["id"]="edisi",
    ["it"]="edizione",
    ["lt"]="leidimas",
    ["mk"]="издание",
    ["ms"]="edisi",
    ["nl"]="editie",
    ["pt"]="edicao",
    ["ro"]="ediție",
    ["sk"]="vydanie",
    ["sl"]="izdaja",
    ["sq"]="botimi",
    ["sr"]="издање",
    ["sr-latn"]="izdanje",
    ["ua"]="видання",
   },
  },
  ["editor"]={
   ["labels"]={
    ["be"]="реэдактар",
    ["bg"]="редактор",
    ["ca"]="editor",
    ["cnr"]="Уредник",
    ["cnr-latn"]="Urednik",
    ["cs"]="editor",
    ["de"]="Herausgeber",
    ["en"]="editor",
    ["eo"]="eldonisto",
    ["es"]="editor",
    ["et"]="toimetaja",
    ["fa"]="ویراستار",
    ["fr"]="éditeur",
    ["gr"]="συντάκτης",
    ["hy"]="խմբագիր",
    ["id"]="editor",
    ["it"]="a cura di",
    ["lt"]="redaktorius",
    ["mk"]="уредник",
    ["ms"]="editor",
    ["pt"]="editor",
    ["ro"]="editor",
    ["sk"]="editor",
    ["sl"]="urednik",
    ["sq"]="botuesi",
    ["sr"]="уредник",
    ["sr-latn"]="urednik",
    ["ua"]="редактор",
   },
  },
  ["editor:f"]={
   ["labels"]={
    ["cnr"]="Уредница",
    ["cnr-latn"]="Urednica",
    ["cs"]="editorka",
    ["gr"]="συντάκτης",
    ["lt"]="redaktorė",
    ["sk"]="editorka",
    ["sl"]="urednica",
    ["sr"]="Уредница",
    ["sr-latn"]="Urednica",
    ["sq"]="botuesja",
    ["ua"]="редактор",
   },
  },
  ["editors"]={
   ["labels"]={
    ["be"]="рэдактары",
    ["bg"]="редактори",
    ["ca"]="editors",
    ["cnr"]="Уредници",
    ["cnr-latn"]="Urednici",
    ["cs"]="editoři",
    ["de"]="Herausgeber",
    ["en"]="editors",
    ["eo"]="eldonistoj",
    ["es"]="editores",
    ["et"]="toimetajad",
    ["fa"]="ویراستاران",
    ["fr"]="éditeurs",
    ["gr"]="συντάκτες",
    ["hy"]="խմբագիրներ",
    ["id"]="editor",
    ["it"]="a cura di",
    ["lt"]="redaktoriai",
    ["mk"]="уредници",
    ["ms"]="para penyunting",
    ["pt"]="editores",
    ["ro"]="editori",
    ["sk"]="editori",
    ["sl"]="uredniki",
    ["sq"]="botuesit",
    ["sr"]="уредници",
    ["sr-latn"]="urednici",
    ["ua"]="редактори",
   },
  },
  ["editors:f"]={
   ["labels"]={
    ["cnr"]="Уреднице",
    ["cnr-latn"]="Urednice",
    ["cs"]="editorky",
    ["gr"]="συντάκτες",
    ["lt"]="redaktorės",
    ["sk"]="editorky",
    ["sl"]="urednice",
    ["sq"]="botueset",
    ["sr"]="Уреднице",
    ["sr-latn"]="Urednice",
   },
  },
  ["in"]={
   ["labels"]={
    ["be"]="у",
    ["bg"]="в",
    ["ca"]="en",
    ["cnr"]="У",
    ["cnr-latn"]="U",
    ["cs"]="v",
    ["de"]="in",
    ["en"]="in",
    ["eo"]="en",
    ["es"]="en",
    ["fa"]="در",
    ["fr"]="dans",
    ["gr"]="σε",
    ["hy"]="մեջ",
    ["id"]="di",
    ["mk"]="во",
    ["ms"]="dalam",
    ["pt"]="em",
    ["ro"]="în",
    ["sk"]="v",
    ["sl"]="v",
    ["sq"]="në",
    ["sr"]="у",
    ["sr-latn"]="u",
    ["ua"]="у",
   },
  },
  ["mastersthesis"]={
   ["labels"]={
    ["be"]="Дыпломная работа",
    ["bg"]="дипломна работа",
    ["ca"]="Tesi de maestria",
    ["cnr"]="Мастер рад",
    ["cnr-latn"]="Master rad",
    ["cs"]="Diplomová práce",
    ["de"]="Masterarbeit",
    ["en"]="Master's thesis",
    ["eo"]="Magistreca disertaĵo",
    ["es"]="Tesis de maestría",
    ["et"]="magistritöö",
    ["fa"]="پایان‌نامه کارشناسی ارشد",
    ["fi"]="Pro gradu tutkielma",
    ["fr"]="Thèse de master (DEA, DESS, master)",
    ["gr"]="Μεταπτυχιακή εργασία",
    ["hy"]="Մագիստրոսական թեզ",
    ["id"]="Tesis",
    ["it"]="Tesi di laurea",
    ["lt"]="Magistro baigiamasis darbas",
    ["mk"]="Магистерска дисертација",
    ["ms"]="Tesis sarjana",
    ["nl"]="Masterproef",
    ["pt"]="Tese de mestrado",
    ["ro"]="Teză de master",
    ["sk"]="Diplomová práca",
    ["sl"]="Magistrsko delo",
    ["sq"]="Tema e diplomës",
    ["sr"]="Мастер дисертација",
    ["sr-latn"]="Master disertacija",
    ["ua"]="Магістерська робота",
   },
  },
  ["number"]={
   ["labels"]={
    ["be"]="нумар",
    ["bg"]="номер",
    ["ca"]="nombre",
    ["cnr"]="Број",
    ["cnr-latn"]="Broj",
    ["cs"]="číslo",
    ["de"]="Nummer",
    ["en"]="number",
    ["eo"]="numero",
    ["es"]="numero",
    ["fa"]="شماره",
    ["fi"]="numero",
    ["fr"]="numéro",
    ["gr"]="νούμερο",
    ["hy"]="համար",
    ["id"]="Nomor",
    ["lt"]="numeris",
    ["mk"]="број",
    ["ms"]="nombor",
    ["nl"]="nummer",
    ["pt"]="numero",
    ["ro"]="număr",
    ["sk"]="číslo",
    ["sl"]="število",
    ["sq"]="numër",
    ["sr"]="број",
    ["sr-latn"]="broj",
    ["ua"]="номер",
   },
  },
  ["of"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="на",
    ["ca"]="de",
    ["cnr"]="Од",
    ["cnr-latn"]="Od",
    ["cs"]="z",
    ["de"]="von",
    ["en"]="of",
    ["eo"]="de",
    ["es"]="de",
    ["fa"]="از",
    ["fr"]="de",
    ["gr"]="από",
    ["hy"]="-ից",
    ["id"]="dari",
    ["mk"]="од",
    ["ms"]="daripada/dari",
    ["nl"]="van",
    ["pt"]="de",
    ["ro"]="de",
    ["sk"]="z",
    ["sl"]="od",
    ["sq"]="e",
    ["sr"]="од",
    ["sr-latn"]="od",
    ["ua"]="з",
   },
  },
  ["others"]={
   ["labels"]={
    ["ca"]="et al.",
    ["cnr"]="И др.",
    ["cnr-latn"]="I dr.",
    ["cs"]="a~kol.",
    ["de"]="et al.",
    ["en"]="et al.",
    ["eo"]="aliaj",
    ["es"]="otros",
    ["et"]="jt",
    ["fa"]="دیگران",
    ["fr"]="et al.",
    ["gr"]="άλλοι",
    ["hy"]="եւ այլն",
    ["id"]="dkk.",
    ["mk"]="и др.",
    ["ms"]="et al.",
    ["pt"]="etc",
    ["ro"]="alții",
    ["sk"]="a~kol.",
    ["sq"]="etj...",
    ["sr"]="и др.",
    ["sr-latn"]="i dr.",
    ["ua"]="та ін.",
   },
  },
  ["p"]={
   ["labels"]={
    ["be"]="стар.",
    ["ca"]="p.",
    ["cnr"]="Стр.",
    ["cnr-latn"]="Str.",
    ["cs"]="s.",
    ["de"]="S.",
    ["en"]="p.",
    ["eo"]="p.",
    ["es"]="p",
    ["et"]="lk",
    ["fa"]="ص",
    ["fr"]="p.",
    ["gr"]="σελ.",
    ["hy"]="էջ",
    ["id"]="hal.",
    ["mk"]="стр.",
    ["ms"]="p",
    ["pt"]="p",
    ["ro"]="p.",
    ["sk"]="s.",
    ["sq"]="fq.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
    ["ua"]="с.",
   },
  },
  ["pages"]={
   ["labels"]={
    ["be"]="старонка",
    ["bg"]="страни",
    ["ca"]="pagines",
    ["cnr"]="Странице",
    ["cnr-latn"]="Stranice",
    ["cs"]="strany",
    ["de"]="Seiten",
    ["en"]="pages",
    ["eo"]="paĝoj",
    ["es"]="paginas",
    ["et"]="leheküljed",
    ["fa"]="صفحات",
    ["fi"]="sivut",
    ["fr"]="pages",
    ["gr"]="σελλίδες",
    ["hy"]="էջեր",
    ["id"]="halaman",
    ["lt"]="puslapiai",
    ["mk"]="страници",
    ["ms"]="halaman",
    ["nl"]="paginas",
    ["pt"]="paginas",
    ["ro"]="pagini",
    ["sk"]="strany",
    ["sl"]="strani",
    ["sq"]="faqe",
    ["sr"]="страницa",
    ["sr-latn"]="stranica",
    ["ua"]="сторінки",
   },
  },
  ["patent"]={
   ["labels"]={
    ["be"]="патэнт",
    ["bg"]="патент",
    ["ca"]="Patent",
    ["cnr"]="Патент",
    ["cnr-latn"]="Patent",
    ["cs"]="Patent",
    ["de"]="Patent",
    ["en"]="Patent",
    ["eo"]="Patento",
    ["es"]="Patente",
    ["et"]="Patent",
    ["fa"]="اختراع ثبت‌شده",
    ["fi"]="patentti",
    ["fr"]="Brevet",
    ["gr"]="ευρεσιτεχνία",
    ["hy"]="Արտոնագիր",
    ["id"]="Paten",
    ["it"]="Brevetto",
    ["lt"]="Patentas",
    ["mk"]="Патент",
    ["ms"]="Paten",
    ["nl"]="Octrooi",
    ["pt"]="Patente",
    ["ro"]="Brevet",
    ["sk"]="Patent",
    ["sl"]="patent",
    ["sq"]="Patentë",
    ["sr"]="Патент",
    ["sr-latn"]="Patent",
    ["ua"]="Патент",
   },
  },
  ["phdthesis"]={
   ["labels"]={
    ["be"]="Доктарская дысертацыя",
    ["bg"]="дисертачна работа",
    ["ca"]="Tesi doctoral",
    ["cnr"]="Докторат",
    ["cnr-latn"]="Doktorat",
    ["cs"]="Disertační práce",
    ["de"]="Dissertation",
    ["en"]="PhD thesis",
    ["eo"]="Doktoriĝa disertaĵo",
    ["es"]="Tesis doctoral",
    ["et"]="doktoritöö",
    ["fa"]="رساله دکتری",
    ["fr"]="Thèse de doctorat",
    ["gr"]="Διδακτορική διατριβή",
    ["hy"]="Դոկտորական թեզ",
    ["id"]="Disertasi",
    ["it"]="Tesi di dottorato",
    ["lt"]="Daktaro disertacija",
    ["mk"]="Докторска дисертација",
    ["ms"]="Tesis PhD",
    ["nl"]="Proefschrift",
    ["pt"]="Tese de douturamento",
    ["ro"]="Teză de doctorat",
    ["sk"]="Dizertačná práca",
    ["sl"]="doktorsko delo",
    ["sq"]="Tema e doktoraturës",
    ["sr"]="Докторска дисертација",
    ["sr-latn"]="Doktorska disertacija",
    ["ua"]="Дисертація",
   },
  },
  ["pp"]={
   ["labels"]={
    ["ca"]="pp",
    ["cnr"]="Стр.",
    ["cnr-latn"]="Str.",
    ["cs"]="s.",
    ["de"]="S.",
    ["en"]="pp.",
    ["eo"]="pp.",
    ["es"]="pp",
    ["et"]="lk-d",
    ["fa"]="صص",
    ["gr"]="σελ.",
    ["hy"]="էջ",
    ["id"]="hal.",
    ["mk"]="стр.",
    ["ms"]="hlm.",
    ["pt"]="pp",
    ["ro"]="p.",
    ["sk"]="s.",
    ["sq"]="fq.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
    ["ua"]="ст.",
   },
  },
  ["technicalreport"]={
   ["labels"]={
    ["be"]="Тэхнічны даклад",
    ["bg"]="технически доклад",
    ["ca"]="Report tecnic",
    ["cnr"]="Технички извјештај",
    ["cnr-latn"]="Tehnički izvještaj",
    ["cs"]="Technická zpráva",
    ["de"]="Technischer Bericht",
    ["en"]="Technical report",
    ["eo"]="Teknika raporto",
    ["es"]="Informe técnico",
    ["et"]="tehniline raport",
    ["fa"]="گزارش فنی",
    ["fi"]="Tekninen raportti",
    ["fr"]="Rapport technique",
    ["gr"]="Τεχνική έκθεση",
    ["hy"]="Տեխնիկական հաշվետվություն",
    ["id"]="Laporan Teknis",
    ["it"]="Relazione tecnica",
    ["lt"]="Techninė ataskaita",
    ["mk"]="Технички извештај",
    ["ms"]="Laporan teknikal",
    ["nl"]="Technisch rapport",
    ["pt"]="Reporte tecnico",
    ["ro"]="Raportul tehnic",
    ["sk"]="Technická zpráva",
    ["sl"]="Tehnično poročilo",
    ["sq"]="Raport teknik",
    ["sr"]="Технички извештај",
    ["sr-latn"]="Tehnički izveštaj",
    ["ua"]="Технічний звіт",
   },
  },
  ["volume"]={
   ["labels"]={
    ["be"]="гучнасць",
    ["bg"]="обем",
    ["ca"]="volum",
    ["cnr"]="том",
    ["cnr-latn"]="tom",
    ["cs"]="svazek",
    ["de"]="Band",
    ["en"]="volume",
    ["eo"]="volumo",
    ["es"]="volumen",
    ["et"]="köide",
    ["fa"]="جلد",
    ["fr"]="volume",
    ["gr"]="τόμος",
    ["hy"]="ծավալ",
    ["id"]="volume",
    ["lt"]="grupė",
    ["mk"]="том",
    ["ms"]="jilid",
    ["nl"]="deel",
    ["pt"]="volume",
    ["ro"]="volum",
    ["sk"]="zväzok",
    ["sl"]="volumen",
    ["sq"]="zëri",
    ["sr"]="том",
    ["sr-latn"]="tom",
    ["ua"]="том",
   },
  },
  ["with"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="със",
    ["ca"]="en",
    ["cnr"]="са",
    ["cnr-latn"]="sa",
    ["cs"]="s",
    ["de"]="mit",
    ["en"]="with",
    ["eo"]="kun",
    ["es"]="con",
    ["et"]="koos",
    ["fa"]="با",
    ["fi"]="kanssa",
    ["fr"]="avec",
    ["gr"]="με",
    ["hy"]="ի հետ",
    ["id"]="dengan",
    ["it"]="con",
    ["lt"]="su",
    ["mk"]="со",
    ["ms"]="dengan",
    ["nl"]="met",
    ["pt"]="com",
    ["ro"]="cu",
    ["sk"]="s",
    ["sq"]="me",
    ["sr"]="са",
    ["sr-latn"]="sa",
    ["ua"]="з",
   },
  },
 },
 ["functions"]={
  ["Pr"]={
   ["labels"]={
    ["ca"]="Pr",
    ["cs"]="P",
    ["en"]="Pr",
    ["eo"]="P",
    ["es"]="Pr",
    ["fa"]="توابع",
    ["hy"]="P",
    ["id"]="Tn",
    ["mk"]="P",
    ["ms"]="pr",
    ["pt"]="Pr",
    ["ro"]="P",
    ["sk"]="P",
    ["sl"]="Pr",
    ["sq"]="Pr",
    ["sr"]="P",
    ["sr-latn"]="P",
    ["sv"]="Pr",
    ["ua"]="Ймовірність",
   },
  },
  ["arccos"]={
   ["labels"]={
    ["ca"]="arc cos",
    ["cnr"]="arccos",
    ["cnr-latn"]="arccos",
    ["cs"]="arccos",
    ["en"]="arccos",
    ["eo"]="arccos",
    ["es"]="arc\\sixperemspace cos",
    ["fa"]="arccos",
    ["hr"]="arc\\sixperemspace cos",
    ["hy"]="arccos",
    ["id"]="arccos",
    ["lt"]="arccos",
    ["mk"]="arccos",
    ["ms"]="arccos",
    ["pl"]="arc\\sixperemspace cos",
    ["pt"]="arccos",
    ["ro"]="arccos",
    ["sk"]="arccos",
    ["sl"]="arc\\sixperemspace cos",
    ["sr"]="arccos",
    ["sr-latn"]="arccos",
    ["sv"]="arccos",
    ["ua"]="arccos",
   },
  },
  ["arccosh"]={
   ["labels"]={
    ["ca"]="arccosh",
    ["cnr"]="arccosh",
    ["cnr-latn"]="arccosh",
    ["cs"]="arccosh",
    ["en"]="arccosh",
    ["eo"]="arccosh",
    ["es"]="arc\\sixperemspace cosh",
    ["fa"]="arccosh",
    ["hr"]="arc\\sixperemspace cosh",
    ["hy"]="arccosh",
    ["id"]="arccosh",
    ["lt"]="arccosh",
    ["mk"]="arccosh",
    ["ms"]="arccosh",
    ["pl"]="arc\\sixperemspace cosh",
    ["pt"]="arccosh",
    ["ro"]="arccosh",
    ["sk"]="arccosh",
    ["sl"]="arc\\sixperemspace cosh",
    ["sr"]="arccosh",
    ["sr-latn"]="arccosh",
    ["sv"]="arcosh",
    ["ua"]="arccosh",
   },
  },
  ["arccot"]={
   ["labels"]={
    ["ca"]="arc cot",
    ["cnr"]="arcctg",
    ["cnr-latn"]="arcctg",
    ["cs"]="arccotg",
    ["en"]="arccot",
    ["eo"]="arcctan",
    ["es"]="arc\\sixperemspace cot",
    ["fa"]="arccot",
    ["hr"]="arc\\sixperemspace ctg",
    ["hy"]="arcctg",
    ["id"]="arccot",
    ["lt"]="arccot",
    ["mk"]="arccotg",
    ["ms"]="arccot",
    ["pl"]="arc\\sixperemspace ctg",
    ["pt"]="arccot",
    ["ro"]="arccotg",
    ["sk"]="arccotg",
    ["sl"]="arc\\sixperemspace cot",
    ["sr"]="arcctg",
    ["sr-latn"]="arcctg",
    ["sv"]="arccot",
    ["ua"]="arccotg",
   },
  },
  ["arcsin"]={
   ["labels"]={
    ["ca"]="arc sen",
    ["cnr"]="arcsin",
    ["cnr-latn"]="arcsin",
    ["cs"]="arcsin",
    ["en"]="arcsin",
    ["eo"]="arcsin",
    ["es"]="arc\\sixperemspace sen",
    ["fa"]="arcsin",
    ["hr"]="arc\\sixperemspace sin",
    ["hy"]="arcsin",
    ["id"]="arcsin",
    ["lt"]="arcsin",
    ["mk"]="arcsin",
    ["ms"]="arcsin",
    ["pl"]="arc\\sixperemspace sin",
    ["pt"]="arcsin",
    ["ro"]="arcsin",
    ["sk"]="arcsin",
    ["sl"]="arc\\sixperemspace sin",
    ["sr"]="arcsin",
    ["sr-latn"]="arcsin",
    ["sv"]="arcsin",
    ["ua"]="arcsin",
   },
  },
  ["arcsinh"]={
   ["labels"]={
    ["ca"]="arc senh",
    ["cnr"]="arcsinh",
    ["cnr-latn"]="arcsinh",
    ["cs"]="arcsinh",
    ["en"]="arcsinh",
    ["eo"]="arcsinh",
    ["es"]="arc\\sixperemspace senh",
    ["fa"]="arcsinh",
    ["hr"]="arc\\sixperemspace sinh",
    ["hy"]="arcsinh",
    ["id"]="arcsinh",
    ["lt"]="arcsinh",
    ["mk"]="arcsinh",
    ["ms"]="arcsinh",
    ["pl"]="arc\\sixperemspace sinh",
    ["pt"]="arcsinh",
    ["ro"]="arcsinh",
    ["sk"]="arcsinh",
    ["sr"]="arcsinh",
    ["sr-latn"]="arcsinh",
    ["sv"]="arsinh",
    ["ua"]="arcsinh",
   },
  },
  ["arctan"]={
   ["labels"]={
    ["ca"]="arc tan",
    ["cnr"]="arctg",
    ["cnr-latn"]="arctg",
    ["cs"]="arctg",
    ["en"]="arctan",
    ["eo"]="arctang",
    ["es"]="arc\\sixperemspace tan",
    ["fa"]="arctan",
    ["hr"]="arc\\sixperemspace tg",
    ["hy"]="arctan",
    ["id"]="arctan",
    ["lt"]="arctan",
    ["mk"]="arctg",
    ["ms"]="arctan",
    ["pl"]="arc\\sixperemspace tg",
    ["pt"]="arctan",
    ["ro"]="arctg",
    ["sk"]="arctg",
    ["sl"]="arc\\sixperemspace tg",
    ["sr"]="arctg",
    ["sr-latn"]="arctg",
    ["sv"]="arctan",
    ["ua"]="arctg",
   },
  },
  ["arctanh"]={
   ["labels"]={
    ["ca"]="arc tanh",
    ["cnr"]="arctgh",
    ["cnr-latn"]="arctgh",
    ["cs"]="arctgh",
    ["en"]="arctanh",
    ["eo"]="arctanh",
    ["es"]="arc\\sixperemspace tanh",
    ["fa"]="arctanh",
    ["hr"]="arc\\sixperemspace tgh",
    ["hy"]="arctanh",
    ["id"]="arctanh",
    ["lt"]="arctanh",
    ["mk"]="arctgh",
    ["ms"]="arctanh",
    ["pl"]="arc\\sixperemspace tgh",
    ["pt"]="arctanh",
    ["ro"]="arctgh",
    ["sk"]="arctgh",
    ["sl"]="arc\\sixperemspace tgh",
    ["sr"]="arctgh",
    ["sr-latn"]="arctgh",
    ["sv"]="artanh",
    ["ua"]="arctgh",
   },
  },
  ["arg"]={
   ["labels"]={
    ["ca"]="arg",
    ["cnr"]="arg",
    ["cnr-latn"]="arg",
    ["cs"]="arg",
    ["en"]="arg",
    ["eo"]="arg",
    ["es"]="arg",
    ["fa"]="arg",
    ["hy"]="arg",
    ["id"]="arg",
    ["mk"]="arg",
    ["ms"]="arg",
    ["pt"]="arg",
    ["ro"]="arg",
    ["sk"]="arg",
    ["sl"]="arg",
    ["sr"]="arg",
    ["sr-latn"]="arg",
    ["sv"]="arg",
    ["ua"]="arg",
   },
  },
  ["cos"]={
   ["labels"]={
    ["ca"]="cos",
    ["cnr"]="cos",
    ["cnr-latn"]="cos",
    ["cs"]="cos",
    ["en"]="cos",
    ["eo"]="cos",
    ["es"]="cos",
    ["fa"]="cos",
    ["gr"]="συν",
    ["hy"]="cos",
    ["id"]="cos",
    ["lt"]="cos",
    ["mk"]="cos",
    ["ms"]="kos",
    ["pt"]="cos",
    ["ro"]="cos",
    ["sk"]="cos",
    ["sr"]="cos",
    ["sr-latn"]="cos",
    ["sv"]="cos",
    ["ua"]="cos",
   },
  },
  ["cosh"]={
   ["labels"]={
    ["ca"]="cosh",
    ["cnr"]="cosh",
    ["cnr-latn"]="cosh",
    ["cs"]="cosh",
    ["en"]="cosh",
    ["eo"]="cosh",
    ["es"]="cosh",
    ["fa"]="cosh",
    ["gr"]="cosh",
    ["hy"]="cosh",
    ["id"]="cosh",
    ["mk"]="cosh",
    ["ms"]="cosh",
    ["pt"]="cosh",
    ["ro"]="cosh",
    ["sk"]="cosh",
    ["sl"]="cosh",
    ["sr"]="cosh",
    ["sr-latn"]="cosh",
    ["sv"]="cosh",
    ["ua"]="cosh",
   },
  },
  ["cot"]={
   ["labels"]={
    ["ca"]="cot",
    ["cnr"]="ctg",
    ["cnr-latn"]="ctg",
    ["cs"]="cotg",
    ["en"]="cot",
    ["eo"]="cotan",
    ["es"]="cot",
    ["fa"]="cot",
    ["gr"]="cot",
    ["hr"]="ctg",
    ["hy"]="cot",
    ["id"]="cot",
    ["lt"]="cot",
    ["mk"]="ctg",
    ["ms"]="cot",
    ["pl"]="ctg",
    ["pt"]="cot",
    ["ro"]="cotg",
    ["sk"]="cotg",
    ["sl"]="ctg",
    ["sr"]="ctg",
    ["sr-latn"]="ctg",
    ["sv"]="cot",
    ["ua"]="cotg",
   },
  },
  ["coth"]={
   ["labels"]={
    ["ca"]="coth",
    ["cnr"]="ctgh",
    ["cnr-latn"]="ctgh",
    ["cs"]="cotgh",
    ["en"]="coth",
    ["eo"]="cotanh",
    ["es"]="coth",
    ["fa"]="coth",
    ["gr"]="coth",
    ["hy"]="coth",
    ["id"]="coth",
    ["mk"]="ctgh",
    ["ms"]="coth",
    ["pt"]="coth",
    ["ro"]="cotgh",
    ["sk"]="cotgh",
    ["sl"]="ctgh",
    ["sr"]="ctgh",
    ["sr-latn"]="ctgh",
    ["sv"]="coth",
    ["ua"]="cotgh",
   },
  },
  ["crossproduct"]={
   ["labels"]={
    ["cnr"]="×",
    ["cnr-latn"]="×",
    ["en"]="×",
    ["fa"]="×",
    ["sr"]="×",
    ["sr-latn"]="×",
    ["ua"]="×",
   },
  },
  ["csc"]={
   ["labels"]={
    ["ca"]="csc",
    ["cnr"]="cosec",
    ["cnr-latn"]="cosec",
    ["cs"]="cosec",
    ["en"]="csc",
    ["eo"]="cosec",
    ["es"]="csc",
    ["fa"]="csc",
    ["gr"]="csc",
    ["hy"]="csc",
    ["id"]="csc",
    ["mk"]="cosec",
    ["ms"]="csc",
    ["pt"]="csc",
    ["ro"]="cosec",
    ["sk"]="cosec",
    ["sl"]="csc",
    ["sr"]="cosec",
    ["sr-latn"]="cosec",
    ["sv"]="csc",
    ["ua"]="cosec",
   },
  },
  ["deg"]={
   ["labels"]={
    ["ca"]="gr",
    ["cnr"]="deg",
    ["cnr-latn"]="deg",
    ["cs"]="deg",
    ["en"]="deg",
    ["eo"]="gr",
    ["es"]="gr",
    ["fa"]="deg",
    ["gr"]="deg",
    ["hy"]="deg",
    ["id"]="derajat",
    ["lt"]="deg",
    ["mk"]="deg",
    ["ms"]="deg",
    ["pt"]="deg",
    ["ro"]="unghi",
    ["sk"]="deg",
    ["sl"]="deg",
    ["sr"]="deg",
    ["sr-latn"]="deg",
    ["sv"]="deg",
    ["ua"]="deg",
   },
  },
  ["det"]={
   ["labels"]={
    ["ca"]="det",
    ["cnr"]="det",
    ["cnr-latn"]="det",
    ["cs"]="det",
    ["en"]="det",
    ["eo"]="det",
    ["es"]="det",
    ["fa"]="det",
    ["hy"]="det",
    ["id"]="det",
    ["ms"]="det",
    ["pt"]="det",
    ["ro"]="det",
    ["sk"]="det",
    ["sl"]="det",
    ["sr"]="det",
    ["sr-latn"]="det",
    ["sv"]="det",
    ["ua"]="дет",
   },
  },
  ["diff"]={
   ["labels"]={
    ["ca"]="d",
    ["cnr"]="d",
    ["cnr-latn"]="d",
    ["cs"]="d",
    ["en"]="d",
    ["eo"]="dif",
    ["gr"]="d",
    ["fa"]="d",
    ["hy"]="d",
    ["id"]="d",
    ["ms"]="d",
    ["pt"]="d",
    ["ro"]="d",
    ["sk"]="d",
    ["sl"]="d",
    ["sr"]="d",
    ["sr-latn"]="d",
    ["sv"]="d",
    ["ua"]="диф",
   },
  },
  ["dim"]={
   ["labels"]={
    ["ca"]="dim",
    ["cnr"]="dim",
    ["cnr-latn"]="dim",
    ["cs"]="dim",
    ["en"]="dim",
    ["eo"]="dim",
    ["es"]="dim",
    ["fa"]="dim",
    ["gr"]="dim",
    ["hy"]="dim",
    ["id"]="dim",
    ["mk"]="dim",
    ["ms"]="dim",
    ["pt"]="dim",
    ["ro"]="dim",
    ["sk"]="dim",
    ["sl"]="dim",
    ["sr"]="dim",
    ["sr-latn"]="dim",
    ["sv"]="dim",
    ["ua"]="розмірність",
   },
  },
  ["exp"]={
   ["labels"]={
    ["ca"]="exp",
    ["cnr"]="exp",
    ["cnr-latn"]="exp",
    ["cs"]="exp",
    ["en"]="exp",
    ["eo"]="eksp",
    ["es"]="exp",
    ["fa"]="exp",
    ["gr"]="exp",
    ["hy"]="exp",
    ["id"]="exp",
    ["ms"]="exp",
    ["pt"]="exp",
    ["ro"]="exp",
    ["sk"]="exp",
    ["sl"]="exp",
    ["sr"]="exp",
    ["sr-latn"]="exp",
    ["sv"]="exp",
    ["ua"]="експ",
   },
  },
  ["gcd"]={
   ["labels"]={
    ["ca"]="med",
    ["cnr"]="НЗД",
    ["cnr-latn"]="NZD",
    ["cs"]="NSD",
    ["de"]="ggT",
    ["en"]="gcd",
    ["eo"]="",
    ["es"]="mcd",
    ["fa"]="gcd",
    ["gr"]="ΜΚΔ",
    ["hr"]="nzd",
    ["hy"]="ԱԸԲ",
    ["id"]="FPB",
    ["mk"]="НЗД",
    ["ms"]="FSTB",
    ["nl"]="ggd",
    ["pt"]="gcd",
    ["ro"]="CMMDC",
    ["sk"]="NSD",
    ["sl"]="D",
    ["sr"]="НЗД",
    ["sr-latn"]="NZD",
    ["sv"]="sgd",
    ["ua"]="НСД",
   },
  },
  ["hom"]={
   ["labels"]={
    ["ca"]="hom",
    ["cnr"]="Hom",
    ["cnr-latn"]="Hom",
    ["cs"]="Hom",
    ["en"]="hom",
    ["eo"]="hom",
    ["es"]="hom",
    ["fa"]="hom",
    ["gr"]="hom",
    ["hy"]="հոմ",
    ["id"]="hom",
    ["ms"]="hom",
    ["pt"]="hom",
    ["ro"]="hom",
    ["sk"]="Hom",
    ["sl"]="hom",
    ["sr"]="Hom",
    ["sr-latn"]="Hom",
    ["sv"]="hom",
    ["ua"]="гом",
   },
  },
  ["inf"]={
   ["labels"]={
    ["ca"]="inf",
    ["cnr"]="inf",
    ["cnr-latn"]="inf",
    ["cs"]="inf",
    ["en"]="inf",
    ["eo"]="inf",
    ["es"]="inf",
    ["fa"]="inf",
    ["gr"]="inf",
    ["hy"]="inf",
    ["id"]="inf",
    ["lt"]="inf",
    ["mk"]="inf",
    ["ms"]="inf",
    ["pt"]="inf",
    ["ro"]="inf",
    ["sk"]="inf",
    ["sl"]="inf",
    ["sr"]="inf",
    ["sr-latn"]="inf",
    ["sv"]="inf",
    ["ua"]="інф",
   },
  },
  ["injlim"]={
   ["labels"]={
    ["ca"]="inj",
    ["cnr"]="inj\\sixperemspace lim",
    ["cnr-latn"]="inj\\sixperemspace lim",
    ["cs"]="inj\\sixperemspace lim",
    ["en"]="inj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace iny",
    ["fa"]="inj\\sixperemspace lim",
    ["gr"]="inj\\sixperemspace lim",
    ["hy"]="inj\\sixperemspace lim",
    ["id"]="inj\\sixperemspace lim",
    ["ms"]="inj\\sixperemspace lim",
    ["pt"]="inj\\sixperemspace lim",
    ["sk"]="inj\\sixperemspace lim",
    ["sl"]="inj\\sixperemspace lim",
    ["sr"]="inj\\sixperemspace lim",
    ["sr-latn"]="inj\\sixperemspace lim",
    ["sv"]="inj\\sixperemspace lim",
    ["ua"]="ін’єктивна границя",
   },
  },
  ["inv"]={
   ["labels"]={
    ["ca"]="inv",
    ["cnr"]="inv",
    ["cnr-latn"]="inv",
    ["cs"]="inv",
    ["en"]="inv",
    ["eo"]="inv",
    ["es"]="inv",
    ["fa"]="inv",
    ["gr"]="inv",
    ["hy"]="inv",
    ["id"]="inv",
    ["mk"]="inv",
    ["ms"]="inv",
    ["pt"]="inv",
    ["sk"]="inv",
    ["sl"]="inv",
    ["sr"]="inv",
    ["sr-latn"]="inv",
    ["sv"]="inv",
    ["ua"]="обернений",
   },
  },
  ["ker"]={
   ["labels"]={
    ["ca"]="Ker",
    ["cnr"]="ker",
    ["cnr-latn"]="ker",
    ["cs"]="ker",
    ["en"]="ker",
    ["eo"]="",
    ["es"]="Ker",
    ["fa"]="ker",
    ["gr"]="ker",
    ["hy"]="ker",
    ["id"]="ker",
    ["ms"]="ker",
    ["pt"]="ker",
    ["sk"]="ker",
    ["sl"]="ker",
    ["sr"]="ker",
    ["sr-latn"]="ker",
    ["sv"]="ker",
    ["ua"]="ker",
   },
  },
  ["laplace"]={
   ["labels"]={
    ["cnr"]="∆",
    ["cnr-latn"]="∆",
    ["en"]="∆",
    ["gr"]="Δ",
    ["sl"]="∆",
    ["fa"]="∆",
    ["sr"]="∆",
    ["sr-latn"]="∆",
   },
  },
  ["lcm"]={
   ["labels"]={
    ["ca"]="MCM",
    ["cnr"]="НЗС",
    ["cnr-latn"]="NZS",
    ["cs"]="NSN",
    ["de"]="kgV",
    ["en"]="lcm",
    ["eo"]="",
    ["es"]="MCM",
    ["fa"]="lcm",
    ["gr"]="LCM",
    ["hr"]="nzv",
    ["hy"]="աըբ",
    ["id"]="KPK",
    ["mk"]="НЗС",
    ["ms"]="GSTK",
    ["nl"]="kgv",
    ["pt"]="lcm",
    ["sk"]="NSN",
    ["sl"]="S",
    ["sr"]="НЗС",
    ["sr-latn"]="NZS",
    ["sv"]="lcm",
    ["ua"]="НСН",
   },
  },
  ["lg"]={
   ["labels"]={
    ["ca"]="log",
    ["cnr"]="lg",
    ["cnr-latn"]="lg",
    ["cs"]="log",
    ["de"]="log",
    ["en"]="lg",
    ["eo"]="log",
    ["es"]="log",
    ["fa"]="lg",
    ["fr"]="log",
    ["gr"]="log",
    ["hy"]="lg",
    ["id"]="log",
    ["lt"]="lg",
    ["mk"]="lg",
    ["ms"]="log",
    ["pt"]="lg",
    ["ro"]="lg",
    ["sk"]="log",
    ["sl"]="v",
    ["sr"]="lg",
    ["sr-latn"]="lg",
    ["sv"]="lg",
    ["ua"]="логарифм",
   },
  },
  ["lim"]={
   ["labels"]={
    ["ca"]="lim",
    ["cnr"]="lim",
    ["cnr-latn"]="lim",
    ["cs"]="lim",
    ["en"]="lim",
    ["eo"]="lim",
    ["es"]="lím",
    ["fa"]="lim",
    ["gr"]="Lim",
    ["hy"]="lim",
    ["id"]="lim",
    ["lt"]="lim",
    ["mk"]="lim",
    ["ms"]="lim",
    ["pt"]="lim",
    ["sk"]="lim",
    ["sl"]="lim",
    ["sr"]="lim",
    ["sr-latn"]="lim",
    ["sv"]="lim",
    ["ua"]="межа",
   },
  },
  ["liminf"]={
   ["labels"]={
    ["ca"]="lim inf",
    ["cnr"]="lim\\sixperemspace inf",
    ["cnr-latn"]="lim\\sixperemspace inf",
    ["cs"]="lim\\sixperemspace inf",
    ["en"]="lim\\sixperemspace inf",
    ["eo"]="subinf",
    ["es"]="lím\\sixperemspace inf",
    ["fa"]="lim\\sixperemspace inf",
    ["gr"]="lim\\sixperemspace inf",
    ["hy"]="lim\\sixperemspace infs",
    ["id"]="lim\\sixperemspace inf",
    ["mk"]="lim\\sixperemspace inf",
    ["ms"]="lim\\sixperemspace inf",
    ["pt"]="lim\\sixperemspace inf",
    ["sk"]="lim\\sixperemspace inf",
    ["sl"]="lim\\sixperemspace inf",
    ["sr"]="lim\\sixperemspace inf",
    ["sr-latn"]="lim\\sixperemspace inf",
    ["sv"]="lim\\sixperemspace inf",
    ["ua"]="нижня межа",
   },
  },
  ["limsup"]={
   ["labels"]={
    ["ca"]="lim sup",
    ["cnr"]="lim\\sixperemspace sup",
    ["cnr-latn"]="lim\\sixperemspace sup",
    ["cs"]="lim\\sixperemspace sup",
    ["en"]="lim\\sixperemspace sup",
    ["eo"]="suplim",
    ["es"]="lím\\sixperemspace sup",
    ["fa"]="lim\\sixperemspace sup",
    ["gr"]="lim\\sixperemspace sup",
    ["hy"]="lim\\sixperemspace sup",
    ["id"]="lim\\sixperemspace sup",
    ["mk"]="lim\\sixperemspace sup",
    ["ms"]="lim\\sixperemspace sup",
    ["pt"]="lim\\sixperemspace sup",
    ["sk"]="lim\\sixperemspace sup",
    ["sl"]="lim\\sixperemspace inf",
    ["sr"]="lim\\sixperemspace sup",
    ["sr-latn"]="lim\\sixperemspace sup",
    ["sv"]="lim\\sixperemspace sup",
    ["ua"]="верхня межа",
   },
  },
  ["ln"]={
   ["labels"]={
    ["ca"]="ln",
    ["cnr"]="ln",
    ["cnr-latn"]="ln",
    ["cs"]="ln",
    ["en"]="ln",
    ["eo"]="ln",
    ["es"]="ln",
    ["fa"]="ln",
    ["gr"]="ln",
    ["hy"]="ln",
    ["id"]="ln",
    ["lt"]="ln",
    ["mk"]="ln",
    ["ms"]="ln",
    ["pt"]="ln",
    ["ro"]="ln",
    ["sk"]="ln",
    ["sl"]="ln",
    ["sr"]="ln",
    ["sr-latn"]="ln",
    ["sv"]="ln",
    ["ua"]="лн",
   },
  },
  ["log"]={
   ["labels"]={
    ["ca"]="log",
    ["cnr"]="log",
    ["cnr-latn"]="log",
    ["cs"]="log",
    ["en"]="log",
    ["eo"]="log",
    ["es"]="log",
    ["fa"]="log",
    ["gr"]="log",
    ["hy"]="log",
    ["id"]="log",
    ["lt"]="log",
    ["mk"]="log",
    ["ms"]="log",
    ["pt"]="log",
    ["ro"]="log",
    ["sk"]="log",
    ["sl"]="log",
    ["sr"]="log",
    ["sr-latn"]="log",
    ["sv"]="log",
    ["ua"]="лог",
   },
  },
  ["max"]={
   ["labels"]={
    ["ca"]="max",
    ["cnr"]="max",
    ["cnr-latn"]="max",
    ["cs"]="max",
    ["en"]="max",
    ["eo"]="maks",
    ["es"]="máx",
    ["fa"]="max",
    ["fi"]="max",
    ["hy"]="max",
    ["id"]="max",
    ["lt"]="max",
    ["mk"]="max",
    ["ms"]="max",
    ["pt"]="max",
    ["ro"]="max",
    ["sk"]="max",
    ["sl"]="max",
    ["sr"]="max",
    ["sr-latn"]="max",
    ["sv"]="max",
    ["ua"]="максимум",
   },
  },
  ["median"]={
   ["labels"]={
    ["ca"]="mitjana",
    ["cnr"]="median",
    ["cnr-latn"]="median",
    ["comment"]="cs+sk: \\tilde won't work",
    ["cs"]="Me",
    ["en"]="median",
    ["eo"]="mediano",
    ["es"]="Mediana",
    ["fa"]="median",
    ["fi"]="mediaani",
    ["fr"]="médiane",
    ["hy"]="միջին",
    ["id"]="median",
    ["lt"]="mediana",
    ["ms"]="median",
    ["pt"]="median",
    ["sk"]="Med",
    ["sq"]="median",
    ["sr"]="median",
    ["sr-latn"]="median",
    ["sv"]="median",
    ["ua"]="медіана",
   },
  },
  ["min"]={
   ["labels"]={
    ["ca"]="min",
    ["cnr"]="min",
    ["cnr-latn"]="min",
    ["cs"]="min",
    ["en"]="min",
    ["eo"]="min",
    ["es"]="mín",
    ["fa"]="min",
    ["fi"]="min",
    ["hy"]="min",
    ["id"]="min",
    ["lt"]="min",
    ["mk"]="min",
    ["ms"]="min",
    ["pt"]="min",
    ["ro"]="min",
    ["sk"]="min",
    ["sl"]="min",
    ["sq"]="min",
    ["sr"]="min",
    ["sr-latn"]="min",
    ["sv"]="min",
    ["ua"]="мінімум",
   },
  },
  ["mod"]={
   ["labels"]={
    ["ca"]="mod",
    ["cnr"]="mod",
    ["cnr-latn"]="mod",
    ["cs"]="mod",
    ["en"]="mod",
    ["eo"]="mod",
    ["es"]="mod",
    ["fa"]="mod",
    ["fi"]="mod",
    ["gr"]="mod",
    ["hy"]="mod",
    ["id"]="mod",
    ["lt"]="mod",
    ["mk"]="mod",
    ["ms"]="mod",
    ["pt"]="mod",
    ["sk"]="mod",
    ["sl"]="mod",
    ["sq"]="mod",
    ["sr"]="mod",
    ["sr-latn"]="mod",
    ["sv"]="mod",
    ["ua"]="мод",
   },
  },
  ["neg"]={
   ["labels"]={
    ["cnr"]="¬",
    ["cnr-latn"]="¬",
    ["en"]="¬",
    ["sl"]="¬",
    ["sr"]="¬",
    ["fa"]="¬",
    ["sr-latn"]="¬",
    ["ua"]="-",
   },
  },
  ["partial"]={
   ["labels"]={
    ["cnr"]="∂",
    ["cnr-latn"]="∂",
    ["en"]="∂",
    ["gr"]="θ",
    ["sl"]="∂",
    ["fa"]="∂",
    ["sr"]="∂",
    ["sr-latn"]="∂",
    ["ua"]="-",
   },
  },
  ["projlim"]={
   ["labels"]={
    ["ca"]="lim proy",
    ["cnr"]="proj\\sixperemspace lim",
    ["cnr-latn"]="proj\\sixperemspace lim",
    ["cs"]="proj\\sixperemspace lim",
    ["en"]="proj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace proy",
    ["fa"]="proj\\sixperemspace lim",
    ["gr"]="proj\\sixperemspace lim",
    ["hy"]="proj\\sixperemspace lim",
    ["id"]="proj\\sixperemspace lim",
    ["ms"]="proj\\sixperemspace lim",
    ["pt"]="proj\\sixperemspace lim",
    ["sk"]="proj\\sixperemspace lim",
    ["sl"]="proj\\sixperemspace lim",
    ["sr"]="proj\\sixperemspace lim",
    ["sr-latn"]="proj\\sixperemspace lim",
    ["sv"]="proj\\sixperemspace lim",
    ["ua"]="проективна границя",
   },
  },
  ["scalarproduct"]={
   ["labels"]={
    ["cnr"]="·",
    ["cnr-latn"]="·",
    ["en"]="·",
    ["fa"]="·",
    ["gr"]=".",
    ["sl"]="·",
    ["sr"]="·",
    ["sr-latn"]="·",
    ["ua"]=".",
   },
  },
  ["sec"]={
   ["labels"]={
    ["ca"]="sec",
    ["cnr"]="sec",
    ["cnr-latn"]="sec",
    ["cs"]="sec",
    ["en"]="sec",
    ["eo"]="sek",
    ["es"]="sec",
    ["fa"]="sec",
    ["fi"]="sek",
    ["gr"]="sec",
    ["hy"]="sec",
    ["id"]="sec",
    ["lt"]="sec",
    ["mk"]="sec",
    ["ms"]="sec",
    ["pt"]="sec",
    ["ro"]="sec",
    ["sk"]="sec",
    ["sl"]="sec",
    ["sr"]="sec",
    ["sr-latn"]="sec",
    ["sv"]="sec",
    ["ua"]="секанс",
   },
  },
  ["sin"]={
   ["labels"]={
    ["ca"]="sen",
    ["cnr"]="sin",
    ["cnr-latn"]="sin",
    ["cs"]="sin",
    ["en"]="sin",
    ["eo"]="sin",
    ["es"]="sen",
    ["fa"]="sin",
    ["fi"]="sin",
    ["gr"]="ημ",
    ["hy"]="sin",
    ["id"]="sin",
    ["lt"]="sin",
    ["mk"]="sin",
    ["ms"]="sin",
    ["pt"]="sen",
    ["ro"]="sin",
    ["sk"]="sin",
    ["sl"]="sin",
    ["sr"]="sin",
    ["sr-latn"]="sin",
    ["sv"]="sin",
    ["ua"]="син",
   },
  },
  ["sinh"]={
   ["labels"]={
    ["ca"]="senh",
    ["cnr"]="sinh",
    ["cnr-latn"]="sinh",
    ["cs"]="sinh",
    ["en"]="sinh",
    ["eo"]="sinh",
    ["es"]="senh",
    ["fa"]="sinh",
    ["gr"]="sinh",
    ["hy"]="sinh",
    ["id"]="sinh",
    ["lt"]="sinh",
    ["mk"]="sinh",
    ["ms"]="sinh",
    ["pt"]="sinh",
    ["sk"]="sinh",
    ["sl"]="sinh",
    ["sr"]="sinh",
    ["sr-latn"]="sinh",
    ["sv"]="sinh",
    ["ua"]="гіперсин",
   },
  },
  ["sup"]={
   ["labels"]={
    ["cnr"]="sup",
    ["cnr-latn"]="sup",
    ["cs"]="sup",
    ["en"]="sup",
    ["eo"]="sup",
    ["es"]="sup",
    ["fa"]="sup",
    ["gr"]="sup",
    ["hy"]="sup",
    ["id"]="sup",
    ["mk"]="sup",
    ["ms"]="sup",
    ["pt"]="sup",
    ["ro"]="sup",
    ["sk"]="sup",
    ["sl"]="sup",
    ["sr"]="sup",
    ["sr-latn"]="sup",
    ["sv"]="sup",
    ["ua"]="суп",
   },
  },
  ["tan"]={
   ["labels"]={
    ["cnr"]="tg",
    ["cnr-latn"]="tg",
    ["cs"]="tg",
    ["en"]="tan",
    ["eo"]="tan",
    ["es"]="tan",
    ["fa"]="tan",
    ["hr"]="tg",
    ["hy"]="tan",
    ["id"]="tan",
    ["lt"]="tan",
    ["mk"]="tg",
    ["ms"]="tan",
    ["pl"]="tg",
    ["pt"]="tan",
    ["ro"]="tg",
    ["sk"]="tg",
    ["sl"]="tg",
    ["sr"]="tg",
    ["sr-latn"]="tg",
    ["sv"]="tan",
    ["ua"]="tg",
   },
  },
  ["tanh"]={
   ["labels"]={
    ["cnr"]="tgh",
    ["cnr-latn"]="tgh",
    ["cs"]="tgh",
    ["en"]="tanh",
    ["eo"]="tanh",
    ["es"]="tanh",
    ["fa"]="tanh",
    ["hy"]="tanh",
    ["id"]="tanh",
    ["lt"]="tanh",
    ["mk"]="tgh",
    ["ms"]="tanh",
    ["pt"]="tanh",
    ["ro"]="tanh",
    ["sk"]="tgh",
    ["sl"]="tgh",
    ["sr"]="tgh",
    ["sr-latn"]="tgh",
    ["sv"]="tanh",
    ["ua"]="tgh",
   },
  },
 },
 ["texts"]={
  ["and"]={
   ["labels"]={
    ["af"]="",
    ["ca"]=" i ",
    ["cnr"]=" и ",
    ["cnr-latn"]=" i ",
    ["cs"]=" a ",
    ["da"]="",
    ["de"]=" und ",
    ["en"]=" and ",
    ["eo"]=" kaj ",
    ["es"]=" y ",
    ["et"]=" ja ",
    ["fa"]=" و ",
    ["fi"]="",
    ["fr"]=" et ",
    ["gr"]=" και ",
    ["hr"]=" i ",
    ["hu"]=" és ",
    ["hy"]=" և ",
    ["id"]=" dan ",
    ["it"]="",
    ["la"]="",
    ["lt"]=" ir ",
    ["mk"]=" и ",
    ["ms"]=" dan ",
    ["nb"]="",
    ["nl"]=" en ",
    ["nn"]="",
    ["pl"]=" i ",
    ["pt"]=" e ",
    ["ro"]=" și ",
    ["ru"]="",
    ["sk"]=" a ",
    ["sl"]=" in ",
    ["sq"]=" dhe ",
    ["sr"]=" и ",
    ["sr-latn"]=" i ",
    ["sv"]=" och ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]=" і ",
    ["vi"]="",
   },
  },
  ["appendix"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Bylae ",
    ["ar"]="ملحق ",
    ["be"]="Апендыцыт ",
    ["ca"]="Apèndix ",
    ["cn"]="附录 ",
    ["cnr"]="Додатак ",
    ["cnr-latn"]="Dodatak ",
    ["cs"]="Příloha ",
    ["da"]="Bilag ",
    ["de"]="Anhang ",
    ["en"]="Appendix ",
    ["eo"]="Anekso ",
    ["es"]="Apéndice ",
    ["et"]="Lisa ",
    ["fa"]="پیوست ",
    ["fi"]="Liite ",
    ["fr"]="Annexe ",
    ["gr"]="Παράρτημα ",
    ["hr"]="Dodatak ",
    ["hu"]="Melléklet ",
    ["hy"]="Հավելված ",
    ["id"]="Apendiks ",
    ["it"]="",
    ["ja"]="付録",
    ["kr"]="부록",
    ["la"]="",
    ["lt"]="Priedas",
    ["mk"]="Додаток ",
    ["ms"]="Lampiran ",
    ["nb"]="Tillegg ",
    ["nl"]="",
    ["nn"]="Tillegg ",
    ["pl"]="Dodatek ",
    ["pt"]="Apendice ",
    ["ro"]="Apendice ",
    ["ru"]="",
    ["sk"]="Príloha ",
    ["sl"]="Dodatek ",
    ["sr"]="Додатак ",
    ["sr-latn"]="Dodatak ",
    ["sv"]="Bilaga ",
    ["tk"]="Goşmaça ",
    ["tr"]="",
    ["ua"]="Aпендикс ",
    ["vi"]="",
   },
  },
  ["april"]={
   ["labels"]={
    ["af"]="april",
    ["ar"]="أبريل",
    ["ar-dz"]="أفريل",
    ["ar-sy"]="نيسان",
    ["be"]="красавіка",
    ["bg"]="април",
    ["ca"]="abril",
    ["cn"]="四月",
    ["cnr"]="Април",
    ["cnr-latn"]="April",
    ["cs"]="dubna",
    ["da"]="april",
    ["de"]="April",
    ["en"]="April",
    ["eo"]="Aprilo",
    ["es"]="abril",
    ["et"]="aprill",
    ["fa"]="آوریل",
    ["fi"]="huhtikuu",
    ["fr"]="avril",
    ["gr"]="Απρίλιος",
    ["hr"]="travnja",
    ["hu"]="április",
    ["hy"]="Ապրիլ",
    ["id"]="April",
    ["it"]="aprile",
    ["ja"]="4",
    ["kr"]="4",
    ["la"]="Aprilis",
    ["lt"]="balandžio",
    ["mk"]="април",
    ["ms"]="April",
    ["nb"]="april",
    ["nl"]="april",
    ["nn"]="april",
    ["pl"]="kwietnia",
    ["pt"]="abril",
    ["ro"]="aprilie",
    ["ru"]="апреля",
    ["sk"]="apríla",
    ["sl"]="april",
    ["sq"]="Prill",
    ["sr"]="aприл",
    ["sr-latn"]="april",
    ["sv"]="april",
    ["tk"]="aprel",
    ["tr"]="nisan",
    ["ua"]="квітня",
    ["vi"]="tháng tư",
   },
  },
  ["april:jalali"]={
   ["labels"]={
    ["ca"]="Tir",
    ["en"]="Tir",
    ["fa"]="تیر",
    ["hy"]="Տիր",
   },
  },
  ["april:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="апр.",
    ["ca"]="abr",
    ["cnr"]="Апр",
    ["cnr-latn"]="Аpr",
    ["cs"]="dub.",
    ["da"]="",
    ["de"]="Apr.",
    ["en"]="apr",
    ["eo"]="Apr.",
    ["es"]="abr.",
    ["et"]="apr",
    ["fi"]="",
    ["fr"]="avr.",
    ["gr"]="",
    ["hr"]="tra",
    ["hu"]="ápr.",
    ["hy"]="Ապր",
    ["id"]="Apr",
    ["it"]="",
    ["la"]="",
    ["lt"]="apr",
    ["mk"]="апр.",
    ["ms"]="Apr.",
    ["nb"]="april",
    ["nl"]="",
    ["nn"]="april",
    ["pl"]="kwi.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="apr.",
    ["sl"]="apr",
    ["sr"]="апр",
    ["sr-latn"]="apr",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="квіт",
    ["vi"]="",
   },
  },
  ["atpage"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="في صفحة ",
    ["ca"]="a la pagina ",
    ["cnr"]="на страници ",
    ["cnr-latn"]="na stranici ",
    ["cs"]="na straně ",
    ["da"]="på side ",
    ["de"]="auf Seite ",
    ["en"]="at page ",
    ["eo"]="je paĝo ",
    ["es"]="en la página ",
    ["et"]="leheküljel ",
    ["fa"]="در صفحه ",
    ["fi"]="sivulla ",
    ["fr"]="à la page ",
    ["gr"]="στη σελλίδα ",
    ["hr"]="na stranici ",
    ["hu"]="oldal ",
    ["hy"]="էջում ",
    ["id"]="di halaman ",
    ["it"]="a pagina ",
    ["la"]="",
    ["lt"]="puslapyje ",
    ["mk"]="на страница ",
    ["ms"]="di halaman ",
    ["nb"]="på side ",
    ["nl"]="op pagina ",
    ["nn"]="på side ",
    ["pl"]="na stronie ",
    ["pt"]="na pagina ",
    ["ro"]="la pagina ",
    ["ru"]="на странице ",
    ["sk"]="na strane ",
    ["sl"]="na strani ",
    ["sq"]="në faqen ",
    ["sr"]="на страници ",
    ["sr-latn"]="na stranici ",
    ["sv"]="på sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="на сторінці ",
    ["vi"]="",
   },
  },
  ["august"]={
   ["labels"]={
    ["af"]="augustus",
    ["ar"]="أغسطس",
    ["ar-dz"]="أوت",
    ["ar-ma"]="غشت",
    ["ar-sy"]="آب",
    ["be"]="жнівня",
    ["bg"]="август",
    ["ca"]="agost",
    ["cn"]="八月",
    ["cnr"]="август",
    ["cnr-latn"]="avgust",
    ["cs"]="srpna",
    ["da"]="august",
    ["de"]="August",
    ["en"]="August",
    ["eo"]="Aŭgusto",
    ["es"]="agosto",
    ["et"]="august",
    ["fa"]="اوت",
    ["fi"]="elokuu",
    ["fr"]="août",
    ["gr"]="Αύγουστος",
    ["hr"]="kolovoza",
    ["hu"]="augusztus",
    ["hy"]="Օգոստոս",
    ["id"]="Agustus",
    ["it"]="agosto",
    ["ja"]="8",
    ["kr"]="8",
    ["la"]="Augustus",
    ["lt"]="rugpjūčio",
    ["mk"]="август",
    ["ms"]="Ogos",
    ["nb"]="august",
    ["nl"]="augustus",
    ["nn"]="august",
    ["pl"]="sierpnia",
    ["pt"]="agosto",
    ["ro"]="august",
    ["ru"]="августа",
    ["sk"]="augusta",
    ["sl"]="avgust",
    ["sq"]="Gusht",
    ["sr"]="август",
    ["sr-latn"]="avgust",
    ["sv"]="augusti",
    ["tk"]="awgust",
    ["tr"]="ağustos",
    ["ua"]="серпня",
    ["vi"]="tháng tám",
   },
  },
  ["august:jalali"]={
   ["labels"]={
    ["ca"]="Aban",
    ["en"]="Aban",
    ["fa"]="آبان",
    ["hy"]="Աբան",
   },
  },
  ["august:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="авг.",
    ["ca"]="ag",
    ["cnr"]="авг",
    ["cnr-latn"]="avg",
    ["cs"]="srp.",
    ["da"]="",
    ["de"]="Aug.",
    ["en"]="aug",
    ["eo"]="Aŭg.",
    ["es"]="ago.",
    ["et"]="aug",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="Αυγ",
    ["hr"]="kol",
    ["hu"]="aug.",
    ["hy"]="Օգ",
    ["id"]="Agu",
    ["it"]="",
    ["la"]="",
    ["lt"]="aug",
    ["mk"]="авг.",
    ["ms"]="Og",
    ["nb"]="aug.",
    ["nl"]="",
    ["nn"]="aug.",
    ["pl"]="sier.",
    ["pt"]="",
    ["ro"]="aug.",
    ["ru"]="",
    ["sk"]="aug.",
    ["sl"]="avg",
    ["sr"]="авг",
    ["sr-latn"]="avg",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="сер",
    ["vi"]="",
   },
  },
  ["chapter"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Hoofstuk ",
    ["ar"]="باب ",
    ["be"]="Глава ",
    ["bg"]="Eпизод ",
    ["ca"]="Capítol ",
    ["cn"]={ "第 ", " 章" },
    ["cnr"]="Поглавље ",
    ["cnr-latn"]="Poglavlje ",
    ["cs"]="Kapitola ",
    ["da"]="",
    ["de"]="Kapitel ",
    ["en"]="Chapter ",
    ["eo"]="Ĉapitro ",
    ["es"]="Capítulo ",
    ["et"]="Peatükk ",
    ["fa"]="فصل ",
    ["fi"]="luku",
    ["fr"]="Chapitre ",
    ["gr"]="Κεφάλαιο ",
    ["hr"]="Poglavlje ",
    ["hu"]={ "", " fejezet" },
    ["hy"]="Գլուխ ",
    ["id"]="Bab ",
    ["it"]="",
    ["ja"]={ "第", "章" },
    ["kr"]={ "제", "장" },
    ["la"]="",
    ["lt"]="Skyrius ",
    ["mk"]="Глава ",
    ["ms"]="Bab ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Rozdział ",
    ["pt"]="Capitulo ",
    ["ro"]="Capitol ",
    ["ru"]="",
    ["sk"]="Kapitola ",
    ["sl"]="Poglavje ",
    ["sq"]="Kapitulli ",
    ["sr"]="Глава ",
    ["sr-latn"]="Glava ",
    ["sv"]="Kapitel ",
    ["tk"]="Bap ",
    ["tr"]="",
    ["ua"]="Розділ ",
    ["vi"]="Chương ",
   },
  },
  ["continued"]={
   ["labels"]={
    ["af"]="",
    ["be"]=" (працяг)",
    ["bg"]=" (продължение)",
    ["ca"]=" (continua)",
    ["cnr"]=" (Наставак)",
    ["cnr-latn"]=" (Nastavak)",
    ["cs"]=" (pokračování)",
    ["da"]="",
    ["de"]=" (Fortsetzung)",
    ["en"]=" (continued)",
    ["eo"]=" (daŭrigota)",
    ["es"]=" (continúa)",
    ["et"]=" (jätkub)",
    ["fa"]=" (ادامه دارد)",
    ["fi"]=" (jatkuu)",
    ["fr"]="",
    ["gr"]="",
    ["hr"]=" (nastavak)",
    ["hu"]=" (folytatás)",
    ["hy"]=" (շարունակություն)",
    ["id"]=" (lanjutan)",
    ["it"]="",
    ["la"]="",
    ["lt"]=" (tęsinys)",
    ["mk"]=" (продолжение)",
    ["ms"]=" (diteruskan)",
    ["nb"]="",
    ["nl"]=" (vervolgd)",
    ["nn"]="",
    ["pl"]="",
    ["pt"]=" (continua)",
    ["ro"]=" (continuare)",
    ["ru"]="",
    ["sk"]=" (pokračovanie)",
    ["sl"]=" (nadeljevalo)",
    ["sq"]=" (vazhdimi)",
    ["sr"]=" (наставак)",
    ["sr-latn"]=" (nastavak)",
    ["sv"]=" (forts.)",
    ["tk"]="",
    ["tr"]="",
    ["ua"]=" (продовжуючи)",
    ["vi"]="",
   },
  },
  ["day"]={
   ["labels"]={
    ["bg"]="ден",
    ["ca"]="dia",
    ["cnr"]="дан",
    ["cnr-latn"]="dan",
    ["cs"]="den",
    ["de"]="Tag",
    ["en"]="day",
    ["eo"]="tago",
    ["et"]="päev",
    ["fa"]="روز",
    ["fi"]="päivä",
    ["fr"]="jour",
    ["gr"]="ημέρα",
    ["hy"]="օր",
    ["id"]="hari",
    ["kr"]="일",
    ["lt"]="para",
    ["mk"]="ден",
    ["ms"]="hari",
    ["nl"]="dag",
    ["pt"]="dia",
    ["ro"]="ziuă",
    ["sk"]="deň",
    ["sl"]="dan",
    ["sq"]="ditë",
    ["sr"]="дан",
    ["sr-latn"]="dan",
    ["sv"]="dag",
    ["ua"]="день",
   },
  },
  ["day:genitive"]={
   ["labels"]={
    ["cnr"]="дана",
    ["cnr-latn"]="dana",
    ["cs"]="dne",
    ["gr"]="ημέρα",
    ["lt"]="diena",
    ["ms"]="hari",
    ["sk"]="dňa",
    ["sl"]="dana",
    ["sq"]="dita",
    ["sr"]="дана",
    ["sr-latn"]="dana",
    ["ua"]="дня",
   },
  },
  ["december"]={
   ["labels"]={
    ["af"]="desember",
    ["ar"]="ديسمبر",
    ["ar-ma"]="دجنبر",
    ["ar-sy"]="كانون الأول",
    ["be"]="снежня",
    ["bg"]="декември",
    ["ca"]="desembre",
    ["cn"]="十二月",
    ["cnr"]="децембар",
    ["cnr-latn"]="decembar",
    ["cs"]="prosince",
    ["da"]="december",
    ["de"]="Dezember",
    ["en"]="December",
    ["eo"]="Decembro",
    ["es"]="diciembre",
    ["et"]="detsember",
    ["fa"]="دسامبر",
    ["fi"]="joulukuu",
    ["fr"]="décembre",
    ["gr"]="Δεκέμβριος",
    ["hr"]="prosinca",
    ["hu"]="december",
    ["hy"]="Դեկտեմբեր",
    ["id"]="Desember",
    ["it"]="dicembre",
    ["ja"]="12",
    ["kr"]="12",
    ["la"]="December",
    ["lt"]="gruodžio",
    ["mk"]="декември",
    ["ms"]="Disember",
    ["nb"]="desember",
    ["nl"]="december",
    ["nn"]="desember",
    ["pl"]="grudnia",
    ["pt"]="dezembro",
    ["ro"]="decembrie",
    ["ru"]="декабря",
    ["sk"]="decembra",
    ["sl"]="december",
    ["sq"]="Dhjetor",
    ["sr"]="децембар",
    ["sr-latn"]="decembar",
    ["sv"]="december",
    ["tk"]="dekabr",
    ["tr"]="aralık",
    ["ua"]="грудня",
    ["vi"]="tháng mười hai",
   },
  },
  ["december:jalali"]={
   ["labels"]={
    ["ca"]="Esfand",
    ["en"]="Esfand",
    ["fa"]="اسفند",
    ["hy"]="Էսֆանդ",
   },
  },
  ["december:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="дек.",
    ["ca"]="des",
    ["cnr"]="дец",
    ["cnr-latn"]="dec",
    ["cs"]="pros.",
    ["da"]="",
    ["de"]="Dez.",
    ["en"]="dec",
    ["eo"]="Dec.",
    ["es"]="dic.",
    ["et"]="dets",
    ["fi"]="",
    ["fr"]="déc.",
    ["gr"]="",
    ["hr"]="pro",
    ["hu"]="dec.",
    ["hy"]="Դեկ",
    ["id"]="Des",
    ["it"]="",
    ["la"]="",
    ["lt"]="dec",
    ["mk"]="дек.",
    ["ms"]="Dis.",
    ["nb"]="des.",
    ["nl"]="",
    ["nn"]="des.",
    ["pl"]="gru.",
    ["pt"]="",
    ["ro"]="dec.",
    ["ru"]="",
    ["sk"]="dec.",
    ["sl"]="dec",
    ["sr"]="дец",
    ["sr-latn"]="dec",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="груд",
    ["vi"]="",
   },
  },
  ["february"]={
   ["labels"]={
    ["af"]="februarie",
    ["ar"]="فبراير",
    ["ar-dz"]="فيفري",
    ["ar-sy"]="شباط",
    ["be"]="лютага",
    ["bg"]="февруари",
    ["ca"]="febrer",
    ["cn"]="二月",
    ["cnr"]="фебруар",
    ["cnr-latn"]="februar",
    ["cs"]="února",
    ["da"]="februar",
    ["de"]="Februar",
    ["en"]="February",
    ["eo"]="Februaro",
    ["es"]="febrero",
    ["et"]="veebruar",
    ["fa"]="فوریه",
    ["fi"]="helmikuu",
    ["fr"]="février",
    ["gr"]="Φεβρουάριος",
    ["hr"]="veljače",
    ["hu"]="február",
    ["hy"]="Պետրվար",
    ["id"]="Februari",
    ["it"]="febbraio",
    ["ja"]="2",
    ["kr"]="2",
    ["la"]="Februarius",
    ["lt"]="vasario",
    ["mk"]="февруари",
    ["ms"]="Februari",
    ["nb"]="februar",
    ["nl"]="februari",
    ["nn"]="februar",
    ["pl"]="lutego",
    ["pt"]="fevereiro",
    ["ro"]="februarie",
    ["ru"]="февраля",
    ["sk"]="februára",
    ["sl"]="februar",
    ["sq"]="Shkurt",
    ["sr"]="фебруар",
    ["sr-latn"]="februar",
    ["sv"]="februari",
    ["tk"]="fewral",
    ["tr"]="Şubat",
    ["ua"]="лютого",
    ["vi"]="tháng hai",
   },
  },
  ["february:jalali"]={
   ["labels"]={
    ["ca"]="Ordibehesht",
    ["en"]="Ordibehesht",
    ["fa"]="اردیبهشت",
    ["hy"]="Օրդիբեհեշթ",
   },
  },
  ["february:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="февр.",
    ["ca"]="febr",
    ["cnr"]="феб",
    ["cnr-latn"]="feb",
    ["cs"]="ún.",
    ["da"]="",
    ["de"]="Feb.",
    ["en"]="feb",
    ["eo"]="Feb.",
    ["es"]="feb.",
    ["et"]="veebr",
    ["fi"]="",
    ["fr"]="fév.",
    ["gr"]="",
    ["hr"]="velj",
    ["hu"]="feb.",
    ["hy"]="Փետ",
    ["id"]="Feb",
    ["it"]="",
    ["la"]="",
    ["lt"]="feb",
    ["mk"]="фев.",
    ["ms"]="Feb.",
    ["nb"]="feb.",
    ["nl"]="",
    ["nn"]="feb.",
    ["pl"]="lut.",
    ["pt"]="",
    ["ro"]="feb.",
    ["ru"]="",
    ["sk"]="feb.",
    ["sl"]="feb",
    ["sr"]="феб",
    ["sr-latn"]="feb",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="лют",
    ["vi"]="",
   },
  },
  ["figure"]={
   ["labels"]={
    ["af"]="Figuur ",
    ["ar"]="شكل ",
    ["be"]="Малюнак ",
    ["bg"]="Фигура ",
    ["ca"]="Figura ",
    ["cn"]="图 ",
    ["cnr"]="Слика ",
    ["cnr-latn"]="Slika ",
    ["cs"]="Obrázek ",
    ["da"]="Figur ",
    ["de"]="Abbildung ",
    ["en"]="Figure ",
    ["eo"]="Figuro ",
    ["es"]="Figura ",
    ["et"]="Joonis ",
    ["fa"]="شکل ",
    ["fi"]="Kuva ",
    ["fr"]="Figure ",
    ["gr"]="Σχήμα ",
    ["hr"]="Slika ",
    ["hu"]={ "", " ábra" },
    ["hy"]="Նկար ",
    ["id"]="Gambar ",
    ["it"]="Fig. ",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imago ",
    ["lt"]={ "", " pav." },
    ["mk"]="Слика ",
    ["ms"]="Angka ",
    ["nb"]="Figur ",
    ["nl"]="Figuur ",
    ["nn"]="Figur ",
    ["pl"]="Ilustracja ",
    ["pt"]="Figura ",
    ["ro"]="Figura ",
    ["ru"]="Рисунок ",
    ["sk"]="Obrázok ",
    ["sl"]="Slika ",
    ["sq"]="Figurë ",
    ["sr"]="Слика ",
    ["sr-latn"]="Slika ",
    ["sv"]="Figur ",
    ["tk"]="Surat ",
    ["tr"]="Şekil ",
    ["ua"]="Малюнок ",
    ["vi"]="Hình ",
   },
  },
  ["following:plural"]={
   ["labels"]={
    ["cnr"]="сљедеће",
    ["cnr-latn"]="sljedeće",
    ["cs"]="násl.",
    ["de"]="ff.",
    ["en"]="ff.",
    ["eo"]="sekvv",
    ["fr"]=hairspace .. "sqq",
    ["hy"]="ff.",
    ["ms"]="dsb.",
    ["pt"]="seg",
    ["ro"]="pl.",
    ["sk"]="násl.",
    ["sl"]="nasl.",
    ["sr"]="следеће",
    ["sr-latn"]="sledeće",
    ["sv"]="ff.",
    ["ua"]="наст",
   },
  },
  ["following:singular"]={
   ["labels"]={
    ["cnr"]="сљедећа",
    ["cnr-latn"]="sljedeća",
    ["cs"]="násl.",
    ["de"]="f.",
    ["en"]="f.",
    ["eo"]="sekv",
    ["fr"]=hairspace .. "sq",
    ["hy"]="f.",
    ["ms"]="dsb.",
    ["pt"]="seg",
    ["ro"]="sing.",
    ["sk"]="násl.",
    ["sl"]="nasl.",
    ["sr"]="следећа",
    ["sr-latn"]="sledeća",
    ["sv"]="f.",
    ["ua"]="наступний",
   },
  },
  ["followingpage"]={
   ["labels"]={
    ["ca"]="en la seguent pagina",
    ["cnr"]="на сљедећој страници",
    ["cnr-latn"]="na sljedećoj stranici",
    ["cs"]="na následující straně",
    ["de"]="auf einer Folgeseite",
    ["en"]="on a following page",
    ["eo"]="je sekvanta paĝo",
    ["es"]="en la siguiente pagina",
    ["et"]="järgmisel leheküljel",
    ["fa"]="در صفحات آینده",
    ["fi"]="seuraavalla sivulla",
    ["fr"]="sur la page suivante",
    ["hy"]="Հաջորդ էջում",
    ["id"]="di halaman berikutnya",
    ["lt"]="sekantis puslapis",
    ["mk"]="на следната страница",
    ["ms"]="pada halaman berikut",
    ["nl"]="op een volgende bladzijde",
    ["pt"]="pagina seguinte",
    ["ro"]="pagina următoare",
    ["sk"]="na nasledujúcej strane",
    ["sl"]="na naslednji strani",
    ["sq"]="në faqen në vazhdim",
    ["sr"]="на следећој страници",
    ["sr-latn"]="na sledećoj stranici",
    ["sv"]="på nästa sida",
   },
  },
  ["friday"]={
   ["labels"]={
    ["af"]="vrydag",
    ["ar"]="الجمعة",
    ["be"]="пятніца",
    ["bg"]="петък",
    ["ca"]="divendres",
    ["cn"]="星期五",
    ["cnr"]="петак",
    ["cnr-latn"]="petak",
    ["cs"]="pátek",
    ["da"]="fredag",
    ["de"]="Freitag",
    ["en"]="Friday",
    ["eo"]="vendredo",
    ["es"]="viernes",
    ["et"]="reede",
    ["fa"]="جمعه",
    ["fi"]="perjantai",
    ["fr"]="vendredi",
    ["gr"]="Παρασκευή",
    ["hr"]="petak",
    ["hu"]="péntek",
    ["hy"]="ուրբաթ",
    ["id"]="Jumat",
    ["it"]="venerdì",
    ["ja"]="金曜日",
    ["kr"]="금요일",
    ["la"]="Dies Veneris",
    ["lt"]="penktadienis",
    ["mk"]="петок",
    ["ms"]="Jumaat",
    ["nb"]="fredag",
    ["nl"]="vrijdag",
    ["nn"]="fredag",
    ["pl"]="piątek",
    ["pt"]="sexta-feira",
    ["ro"]="vineri",
    ["ru"]="пятница",
    ["sk"]="piatok",
    ["sl"]="petek",
    ["sq"]="Premte",
    ["sr"]="петак",
    ["sr-latn"]="petak",
    ["sv"]="fredag",
    ["tk"]="bäşinji gün",
    ["tr"]="cuma",
    ["ua"]="п'ятниця",
    ["vi"]="thứ sáu",
   },
  },
  ["friday:mnem"]={
   ["labels"]={
    ["bg"]="пт",
    ["ca"]="dv",
    ["cnr"]="пет",
    ["cnr-latn"]="pet",
    ["cs"]="pá",
    ["de"]="Fr.",
    ["en"]="fri",
    ["eo"]="ven.",
    ["es"]="vi",
    ["fi"]="pe",
    ["fr"]="ven.",
    ["hy"]="Ուրբ",
    ["id"]="Jm",
    ["lt"]="pn",
    ["ms"]="Jum",
    ["sk"]="pi",
    ["sl"]="pet",
    ["sq"]="prem",
    ["sr"]="пет",
    ["sr-latn"]="pet",
    ["ua"]="пт",
   },
  },
  ["graphic"]={
   ["labels"]={
    ["af"]="Grafiek ",
    ["ar"]="رسم ",
    ["be"]="Графіка ",
    ["bg"]="Графичен ",
    ["ca"]="Gràfica ",
    ["cn"]="插图 ",
    ["cnr"]="График ",
    ["cnr-latn"]="Grafik ",
    ["cs"]="Graf ",
    ["da"]="Grafik ",
    ["de"]="Grafik ",
    ["en"]="Graphic ",
    ["eo"]="Grafiko ",
    ["es"]="Gráfico ",
    ["et"]="Pilt ",
    ["fa"]="طرح ",
    ["fi"]="Grafiikka ",
    ["fr"]="Illustration ",
    ["gr"]="Γραφικό ",
    ["hr"]="Slika ",
    ["hu"]={ "", " kép" },
    ["hy"]="Գրաֆ ",
    ["id"]="Grafis ",
    ["it"]="Grafico ",
    ["ja"]="イラスト",
    ["la"]="Typus ",
    ["lt"]="Graphic ",
    ["mk"]="График ",
    ["ms"]="Grafik ",
    ["nb"]="Bilde ",
    ["nl"]="Grafiek ",
    ["nn"]="Bilete ",
    ["pl"]="Grafika ",
    ["pt"]="Gráfico ",
    ["ro"]="Graficul ",
    ["ru"]="График ",
    ["sk"]="Graf ",
    ["sl"]="Slika ",
    ["sq"]="Grafik ",
    ["sr"]="График ",
    ["sr-latn"]="Grafik ",
    ["sv"]="Grafik ",
    ["tk"]="Grafik ",
    ["tr"]="Grafik ",
    ["ua"]="График ",
    ["vi"]="Đồ thị ",
   },
  },
  ["hencefore"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما وضحنا سابقا",
    ["be"]="гл. вышэй",
    ["bg"]="виж по-горе",
    ["ca"]="com es mostra dalt",
    ["cnr"]="као што је приказано изнад",
    ["cnr-latn"]="kao što je prikazano iznad",
    ["cs"]="viz výše",
    ["da"]="se foroven",
    ["de"]="siehe oben",
    ["en"]="as we show above",
    ["eo"]="laŭsupre",
    ["es"]="como se muestra arriba",
    ["et"]="nii nagu üleval näidatud",
    ["fa"]="چنان‌که شرح دادیم",
    ["fi"]="kuten yllä näytämme",
    ["fr"]="ci-dessus",
    ["gr"]="",
    ["hr"]="vidi gore",
    ["hu"]="lásd feljebb",
    ["hy"]="ստորև նշված",
    ["id"]="seperti yang kami tunjukan diatas",
    ["it"]="come mostrato sopra",
    ["kr"]="그러므로",
    ["la"]="",
    ["lt"]="kaip parodyta aukščiau",
    ["mk"]="како што е прикажано погоре",
    ["ms"]="seperti yang kami tunjukkan di atas",
    ["nb"]="som vist over",
    ["nl"]="hierboven",
    ["nn"]="som vist over",
    ["pl"]="jak pokazano wyżej",
    ["pt"]="como mostrado em cima",
    ["ro"]="cum am arătat mai sus",
    ["ru"]="см. выше",
    ["sk"]="pozri hore",
    ["sl"]="glej zgoraj",
    ["sq"]="siç treguam më lart",
    ["sr"]="као што је показано изнад",
    ["sr-latn"]="kao što je pokazano iznad",
    ["sv"]="se ovan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано вище",
    ["vi"]="",
   },
  },
  ["hereafter"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما نوضح لاحقا",
    ["be"]="гл. ніжэй",
    ["bg"]="ў далейшым",
    ["ca"]="com es mostra baix",
    ["cnr"]="као што је приказано испод",
    ["cnr-latn"]="kao što je prikazano ispod",
    ["cs"]="viz níže",
    ["da"]="se forneden",
    ["de"]="siehe unten",
    ["en"]="as we show below",
    ["eo"]="laŭsube",
    ["es"]="como se muestra abajo",
    ["et"]="nii nagu all näidatud",
    ["fa"]="چنان‌که شرح خواهیم داد",
    ["fi"]="kuten alla näytämme",
    ["fr"]="ci-dessous",
    ["gr"]="",
    ["hr"]="vidi ispod",
    ["hu"]="lásd lejjebb",
    ["hy"]="ինչպես ցույց է տրված ստորև",
    ["id"]="seperti yang kami tunjukan sebelumnya",
    ["it"]="come mostrato sotto",
    ["kr"]="이후로",
    ["la"]="",
    ["lt"]="kaip parodyta žemiau",
    ["mk"]="како што е прикажано подолу",
    ["ms"]="seperti yang kami tunjukkan di bawah",
    ["nb"]="som vist under",
    ["nl"]="hieronder",
    ["nn"]="som vist under",
    ["pl"]="jak pokazano niżej",
    ["pt"]="como mostrado em baixo",
    ["ro"]="cum am arătat mai jos",
    ["ru"]="см. ниже",
    ["sk"]="pozri ďalej",
    ["sl"]="glej spodaj",
    ["sq"]="siç treguam më poshtë",
    ["sr"]="као што је показано ниже",
    ["sr-latn"]="kao što je pokazano niže",
    ["sv"]="se nedan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано нижче",
    ["vi"]="",
   },
  },
  ["intermezzo"]={
   ["labels"]={
    ["af"]="Intermezzo ",
    ["ar"]="فسحة ",
    ["be"]="Інтэрмецца ",
    ["bg"]="Интермецо ",
    ["ca"]="Intermedi ",
    ["cn"]="퉣 ",
    ["cnr"]="Дигресија ",
    ["cnr-latn"]="Digresija ",
    ["cs"]="Intermezzo ",
    ["da"]="Intermezzo ",
    ["de"]="Intermezzo ",
    ["en"]="Intermezzo ",
    ["eo"]="Intermezo ",
    ["es"]="Intermedio ",
    ["et"]="Vahemäng ",
    ["fi"]="Intermezzo ",
    ["fr"]="Intermède ",
    ["gr"]="Παύση ",
    ["hr"]="Intermeco ",
    ["hu"]={ "", " intermezzo" },
    ["hy"]="Ինտերմեցո ",
    ["id"]="Selingan ",
    ["it"]="Intermezzo ",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissum ",
    ["lt"]="Intermezzo ",
    ["mk"]="Дигресија ",
    ["ms"]="Intermezzo ",
    ["nb"]="Intermesso ",
    ["nl"]="Intermezzo ",
    ["nn"]="Intermesso ",
    ["pl"]="Intermezzo ",
    ["pt"]="Intermédio ",
    ["ro"]="Intermezzo ",
    ["ru"]="Вставка ",
    ["sk"]="Intermezzo ",
    ["sl"]="Intermezzo ",
    ["sq"]="Intermezzo ",
    ["sr"]="Дигресија ",
    ["sr-latn"]="Digresija ",
    ["sv"]="Intermezzo ",
    ["tk"]="Arakesme ",
    ["tr"]="",
    ["ua"]="Вставка ",
    ["vi"]="Intermezzo ",
   },
  },
  ["january"]={
   ["labels"]={
    ["af"]="januarie",
    ["ar"]="يناير",
    ["ar-dz"]="جانفي",
    ["ar-sy"]="كانون الثاني",
    ["be"]="студзеня",
    ["bg"]="януари",
    ["ca"]="gener",
    ["cn"]="一月",
    ["cnr"]="јануар",
    ["cnr-latn"]="januar",
    ["cs"]="ledna",
    ["da"]="januar",
    ["de"]="Januar",
    ["en"]="January",
    ["eo"]="Januaro",
    ["es"]="enero",
    ["et"]="jaanuar",
    ["fa"]="ژانویه",
    ["fi"]="tammikuu",
    ["fr"]="janvier",
    ["gr"]="Ιανουάριος",
    ["hr"]="siječnja",
    ["hu"]="január",
    ["hy"]="Հունվար",
    ["id"]="Januari",
    ["it"]="gennaio",
    ["ja"]="1",
    ["kr"]="1",
    ["la"]="Ianuarius",
    ["lt"]="sausio",
    ["mk"]="јануари",
    ["ms"]="Januari",
    ["nb"]="januar",
    ["nl"]="januari",
    ["nn"]="januar",
    ["pl"]="stycznia",
    ["pt"]="janeiro",
    ["ro"]="ianuarie",
    ["ru"]="января",
    ["sk"]="januára",
    ["sl"]="januar",
    ["sq"]="Janar",
    ["sr"]="јануар",
    ["sr-latn"]="januar",
    ["sv"]="januari",
    ["tk"]="ýanwar",
    ["tr"]="ocak",
    ["ua"]="січня",
    ["vi"]="tháng giêng",
   },
  },
  ["january:jalali"]={
   ["labels"]={
    ["ca"]="Farvardin",
    ["en"]="Farvardin",
    ["es"]="Farvardin",
    ["fa"]="فروردین",
    ["hy"]="Ֆարվարդին",
   },
  },
  ["january:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ян.",
    ["ca"]="gen",
    ["cnr"]="jaн",
    ["cnr-latn"]="jan",
    ["cs"]="led.",
    ["da"]="",
    ["de"]="Jan.",
    ["en"]="jan",
    ["eo"]="Jan.",
    ["es"]="ene.",
    ["et"]="jaan",
    ["fi"]="",
    ["fr"]="jan.",
    ["gr"]="",
    ["hr"]="sij",
    ["hu"]="jan.",
    ["hy"]="Հունվ",
    ["id"]="Jan",
    ["it"]="",
    ["la"]="",
    ["lt"]="jan",
    ["mk"]="jан.",
    ["ms"]="Jan.",
    ["nb"]="jan.",
    ["nl"]="",
    ["nn"]="jan.",
    ["pl"]="sty.",
    ["pt"]="",
    ["ro"]="ian.",
    ["ru"]="",
    ["sk"]="jan.",
    ["sl"]="jan",
    ["sr"]="јан",
    ["sr-latn"]="jan",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="січ",
    ["vi"]="",
   },
  },
  ["july"]={
   ["labels"]={
    ["af"]="julie",
    ["ar"]="يوليو",
    ["ar-dz"]="جويلة",
    ["ar-ma"]="يوليوز",
    ["ar-sy"]="تموز",
    ["be"]="ліпня",
    ["bg"]="юли",
    ["ca"]="juliol",
    ["cn"]="七月",
    ["cnr"]="jул",
    ["cnr-latn"]="jul",
    ["cs"]="července",
    ["da"]="juli",
    ["de"]="Juli",
    ["en"]="July",
    ["eo"]="Julio",
    ["es"]="julio",
    ["et"]="juuli",
    ["fa"]="ژوئیه",
    ["fi"]="heinäkuu",
    ["fr"]="juillet",
    ["gr"]="Ιούλιος",
    ["hr"]="srpnja",
    ["hu"]="július",
    ["hy"]="Հուլիս",
    ["id"]="Juli",
    ["it"]="luglio",
    ["ja"]="7",
    ["kr"]="7",
    ["la"]="Iulius",
    ["lt"]="liepos",
    ["mk"]="јули",
    ["ms"]="Julai",
    ["nb"]="juli",
    ["nl"]="juli",
    ["nn"]="juli",
    ["pl"]="lipca",
    ["pt"]="julho",
    ["ro"]="iulie",
    ["ru"]="июля",
    ["sk"]="júla",
    ["sl"]="julij",
    ["sq"]="Korrik",
    ["sr"]="jул",
    ["sr-latn"]="jul",
    ["sv"]="juli",
    ["tk"]="iýul",
    ["tr"]="temmuz",
    ["ua"]="липня",
    ["vi"]="tháng bảy",
   },
  },
  ["july:jalali"]={
   ["labels"]={
    ["ca"]="Mehr",
    ["en"]="Mehr",
    ["es"]="Mehr",
    ["fa"]="مهر",
    ["hy"]="Մեհր",
   },
  },
  ["july:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юли",
    ["ca"]="jul",
    ["cnr"]="jул",
    ["cnr-latn"]="jul",
    ["cs"]="čce",
    ["da"]="",
    ["de"]="Jul.",
    ["en"]="jul",
    ["eo"]="Jul.",
    ["es"]="jul.",
    ["et"]="juuli",
    ["fi"]="",
    ["fr"]="juill.",
    ["gr"]="",
    ["hr"]="srp",
    ["hu"]="júl.",
    ["hy"]="Հուլ",
    ["id"]="Jul",
    ["it"]="",
    ["la"]="",
    ["lt"]="jul",
    ["mk"]="јул.",
    ["ms"]="Julai",
    ["nb"]="juli",
    ["nl"]="",
    ["nn"]="juli",
    ["pl"]="lip.",
    ["pt"]="",
    ["ro"]="iul.",
    ["ru"]="",
    ["sk"]="júla",
    ["sl"]="jul",
    ["sr"]="јул",
    ["sr-latn"]="jul",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="лип",
    ["vi"]="",
   },
  },
  ["june"]={
   ["labels"]={
    ["af"]="junie",
    ["ar"]="يونيو",
    ["ar-dz"]="جوان",
    ["ar-sy"]="حزيران",
    ["be"]="чэрвня",
    ["bg"]="юни",
    ["ca"]="juny",
    ["cn"]="六月",
    ["cnr"]="jун",
    ["cnr-latn"]="jun",
    ["cs"]="června",
    ["da"]="juni",
    ["de"]="Juni",
    ["en"]="June",
    ["eo"]="Junio",
    ["es"]="junio",
    ["et"]="juuni",
    ["fa"]="ژوئن",
    ["fi"]="kesäkuu",
    ["fr"]="juin",
    ["gr"]="Ιούνιος",
    ["hr"]="lipnja",
    ["hu"]="június",
    ["hy"]="Հունիսի",
    ["id"]="Juni",
    ["it"]="giugno",
    ["ja"]="6",
    ["kr"]="6",
    ["la"]="Iunius",
    ["lt"]="birželio",
    ["mk"]="јуни",
    ["ms"]="Jun",
    ["nb"]="juni",
    ["nl"]="juni",
    ["nn"]="juni",
    ["pl"]="czerwca",
    ["pt"]="junho",
    ["ro"]="iunie",
    ["ru"]="июня",
    ["sk"]="júna",
    ["sl"]="junij",
    ["sq"]="Qershor",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="juni",
    ["tk"]="iýun",
    ["tr"]="haziran",
    ["ua"]="червня",
    ["vi"]="tháng sáu",
   },
  },
  ["june:jalali"]={
   ["labels"]={
    ["ca"]="Shahrivar",
    ["en"]="Shahrivar",
    ["es"]="Shahrivar",
    ["fa"]="شهریور",
    ["hy"]="Շահրիվար",
   },
  },
  ["june:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юни",
    ["ca"]="juny",
    ["cnr"]="jун",
    ["cnr-latn"]="jun",
    ["cs"]="čer.",
    ["da"]="",
    ["de"]="Jun.",
    ["en"]="jun",
    ["eo"]="Jun.",
    ["es"]="jun.",
    ["et"]="juuni",
    ["fi"]="",
    ["fr"]="juin",
    ["gr"]="",
    ["hr"]="lip",
    ["hu"]="jún.",
    ["hy"]="Հուն",
    ["id"]="Jun",
    ["it"]="",
    ["la"]="",
    ["lt"]="jun",
    ["mk"]="јун.",
    ["ms"]="Jun",
    ["nb"]="juni",
    ["nl"]="",
    ["nn"]="juni",
    ["pl"]="czerw.",
    ["pt"]="",
    ["ro"]="iun.",
    ["ru"]="",
    ["sk"]="júna",
    ["sl"]="jun",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="чер",
    ["vi"]="",
   },
  },
  ["line"]={
   ["labels"]={
    ["af"]="reël ",
    ["ar"]="سطر ",
    ["be"]="радок ",
    ["bg"]="ред ",
    ["ca"]="línia ",
    ["cn"]="行 ",
    ["cnr"]="линија ",
    ["cnr-latn"]="linija ",
    ["cs"]="řádek ",
    ["da"]="linie ",
    ["de"]="Zeile ",
    ["en"]="line ",
    ["eo"]="linio ",
    ["es"]="línea ",
    ["et"]="joon ",
    ["fa"]="سطر ",
    ["fi"]="rivi ",
    ["fr"]="ligne ",
    ["gr"]="Γραμμή ",
    ["hr"]="redak ",
    ["hu"]={ "", " sor" },
    ["hy"]="Տող ",
    ["id"]="Baris ",
    ["it"]="riga ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="line ",
    ["mk"]="линија ",
    ["ms"]="barisan ",
    ["nb"]="linje ",
    ["nl"]="regel ",
    ["nn"]="linje ",
    ["pl"]="wiersz ",
    ["pt"]="linha ",
    ["ro"]="linia ",
    ["ru"]="строка ",
    ["sk"]="riadok ",
    ["sl"]="vrstica ",
    ["sq"]="vijë ",
    ["sr"]="линија ",
    ["sr-latn"]="linija ",
    ["sv"]="rad ",
    ["tk"]="setir ",
    ["tr"]="satır ",
    ["ua"]="рядок ",
    ["vi"]="dòng ",
   },
  },
  ["lines"]={
   ["labels"]={
    ["af"]="reëls ",
    ["ar"]="السطور ",
    ["be"]="радкi ",
    ["bg"]="редове ",
    ["ca"]="línies ",
    ["cn"]="行 ",
    ["cnr"]="линије ",
    ["cnr-latn"]="linije ",
    ["cs"]="řádky ",
    ["da"]="linier ",
    ["de"]="Zeilen ",
    ["en"]="lines ",
    ["eo"]="linioj ",
    ["es"]="líneas ",
    ["et"]="jooned ",
    ["fa"]="سطرهای ",
    ["fi"]="rivie ",
    ["fr"]="lignes ",
    ["gr"]="Γραμμές ",
    ["hr"]="retci ",
    ["hu"]="sorok ",
    ["hy"]="Տողեր ",
    ["id"]="Baris ",
    ["it"]="righe ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="lines ",
    ["mk"]="линии ",
    ["ms"]="garisan ",
    ["nb"]="linjer ",
    ["nl"]="regels ",
    ["nn"]="linjer ",
    ["pl"]="wiersze ",
    ["pt"]="linhas ",
    ["ro"]="liniile ",
    ["ru"]="строки ",
    ["sk"]="riadky ",
    ["sl"]="vrstice ",
    ["sq"]="vijat ",
    ["sr"]="линије ",
    ["sr-latn"]="linije ",
    ["sv"]="rader ",
    ["tk"]="setirler ",
    ["tr"]="satırlar ",
    ["ua"]="рядки ",
    ["vi"]="dòng ",
   },
  },
  ["march"]={
   ["labels"]={
    ["af"]="maart",
    ["ar"]="مارس",
    ["ar-sy"]="آذار",
    ["be"]="сакавіка",
    ["bg"]="март",
    ["ca"]="març",
    ["cn"]="三月",
    ["cnr"]="март",
    ["cnr-latn"]="mart",
    ["cs"]="března",
    ["da"]="marts",
    ["de"]="März",
    ["en"]="March",
    ["eo"]="Marto",
    ["es"]="marzo",
    ["et"]="märts",
    ["fa"]="مارس",
    ["fi"]="maaliskuu",
    ["fr"]="mars",
    ["gr"]="Μάρτιος",
    ["hr"]="ožujka",
    ["hu"]="március",
    ["hy"]="Մարտ",
    ["id"]="Maret",
    ["it"]="marzo",
    ["ja"]="3",
    ["kr"]="3",
    ["la"]="Martius",
    ["lt"]="kovo",
    ["mk"]="март",
    ["ms"]="Mac",
    ["nb"]="mars",
    ["nl"]="maart",
    ["nn"]="mars",
    ["pl"]="marca",
    ["pt"]="março",
    ["ro"]="martie",
    ["ru"]="марта",
    ["sk"]="marca",
    ["sl"]="marec",
    ["sq"]="Mars",
    ["sr"]="март",
    ["sr-latn"]="mart",
    ["sv"]="mars",
    ["tk"]="mart",
    ["tr"]="mart",
    ["ua"]="березня",
    ["vi"]="tháng ba",
   },
  },
  ["march:jalali"]={
   ["labels"]={
    ["ca"]="Jordad",
    ["en"]="Khordad",
    ["es"]="Khordad",
    ["fa"]="خرداد",
    ["hy"]="Խորդադ",
   },
  },
  ["march:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="март",
    ["ca"]="març",
    ["cnr"]="мар",
    ["cnr-latn"]="mar",
    ["cs"]="břez.",
    ["da"]="",
    ["de"]="Mrz.",
    ["en"]="mar",
    ["eo"]="Mar.",
    ["es"]="mar.",
    ["et"]="märts",
    ["fi"]="",
    ["fr"]="mars",
    ["gr"]="",
    ["hr"]="ožu",
    ["hu"]="már.",
    ["hy"]="Մարտ",
    ["id"]="Mar",
    ["it"]="",
    ["la"]="",
    ["lt"]="mar",
    ["mk"]="мар.",
    ["ms"]="Mac",
    ["nb"]="mars",
    ["nl"]="",
    ["nn"]="mars",
    ["pl"]="mar.",
    ["pt"]="",
    ["ro"]="mar.",
    ["ru"]="",
    ["sk"]="mar.",
    ["sl"]="mar",
    ["sr"]="мар",
    ["sr-latn"]="mar",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="бер",
    ["vi"]="",
   },
  },
  ["may"]={
   ["labels"]={
    ["af"]="mei",
    ["ar"]="مايو",
    ["ar-dz"]="ماي",
    ["ar-ma"]="ماي",
    ["ar-sy"]="أيار",
    ["be"]="мая",
    ["bg"]="маӣ",
    ["ca"]="maig",
    ["cn"]="五月",
    ["cnr"]="мај",
    ["cnr-latn"]="mај",
    ["cs"]="května",
    ["da"]="maj",
    ["de"]="Mai",
    ["en"]="May",
    ["eo"]="Majo",
    ["es"]="mayo",
    ["et"]="mai",
    ["fa"]="مه",
    ["fi"]="toukokuu",
    ["fr"]="mai",
    ["gr"]="Μάιος",
    ["hr"]="svibnja",
    ["hu"]="május",
    ["hy"]="Մայիս",
    ["id"]="Mei",
    ["it"]="maggio",
    ["ja"]="5",
    ["kr"]="5",
    ["la"]="Maius",
    ["lt"]="gegužės",
    ["mk"]="мај",
    ["ms"]="Mei",
    ["nb"]="mai",
    ["nl"]="mei",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="maio",
    ["ro"]="mai",
    ["ru"]="мая",
    ["sk"]="mája",
    ["sl"]="maj",
    ["sq"]="Maj",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="maj",
    ["tk"]="maý",
    ["tr"]="mayıs",
    ["ua"]="травня",
    ["vi"]="tháng năm",
   },
  },
  ["may:jalali"]={
   ["labels"]={
    ["ca"]="Mordad",
    ["en"]="Mordad",
    ["es"]="Mordad",
    ["fa"]="مرداد",
    ["hy"]="Մորդադ",
    ["ua"]="-",
   },
  },
  ["may:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="май",
    ["ca"]="maig",
    ["cnr"]="мaj",
    ["cnr-latn"]="maj",
    ["cs"]="květ.",
    ["da"]="",
    ["de"]="Mai",
    ["en"]="may",
    ["eo"]="Maj.",
    ["es"]="may.",
    ["et"]="mai",
    ["fi"]="",
    ["fr"]="mai",
    ["gr"]="",
    ["hr"]="svi",
    ["hu"]="máj.",
    ["hy"]="Մայ",
    ["id"]="Mei",
    ["it"]="",
    ["la"]="",
    ["lt"]="may",
    ["mk"]="мај",
    ["ms"]="Mei",
    ["nb"]="mai",
    ["nl"]="",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="",
    ["ro"]="mai",
    ["ru"]="",
    ["sk"]="mája",
    ["sl"]="maj",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="травень",
    ["vi"]="",
   },
  },
  ["monday"]={
   ["labels"]={
    ["af"]="maandag",
    ["ar"]="الاثنين",
    ["be"]="панядзелак",
    ["bg"]="понеделник",
    ["ca"]="dilluns",
    ["cn"]="星期一",
    ["cnr"]="понеђељак",
    ["cnr-latn"]="poneđeljak",
    ["cs"]="pondělí",
    ["da"]="mandag",
    ["de"]="Montag",
    ["en"]="Monday",
    ["eo"]="lundo",
    ["es"]="lunes",
    ["et"]="esmaspäev",
    ["fa"]="دوشنبه",
    ["fi"]="maanantai",
    ["fr"]="lundi",
    ["gr"]="Δευτέρα",
    ["hr"]="ponedjeljak",
    ["hu"]="hétfő",
    ["hy"]="երկուշաբթի",
    ["id"]="Senin",
    ["it"]="lunedì",
    ["ja"]="月曜日",
    ["kr"]="월요일",
    ["la"]="Dies Lunae",
    ["lt"]="pirmadienis",
    ["mk"]="понеделник",
    ["ms"]="Isnin",
    ["nb"]="mandag",
    ["nl"]="maandag",
    ["nn"]="måndag",
    ["pl"]="poniedziałek",
    ["pt"]="segunda-feira",
    ["ro"]="luni",
    ["ru"]="понедельник",
    ["sk"]="pondelok",
    ["sl"]="ponedeljek",
    ["sq"]="Hane",
    ["sr"]="понедељак",
    ["sr-latn"]="ponedeljak",
    ["sv"]="måndag",
    ["tk"]="birinji gün",
    ["tr"]="pazartesi",
    ["ua"]="понеділок",
    ["vi"]="thứ hai",
   },
  },
  ["monday:mnem"]={
   ["labels"]={
    ["bg"]="пн",
    ["ca"]="dl",
    ["cnr"]="пон",
    ["cnr-latn"]="pon",
    ["cs"]="po",
    ["de"]="Mo.",
    ["en"]="mon",
    ["eo"]="lun.",
    ["es"]="lu",
    ["fi"]="ma",
    ["fr"]="lun.",
    ["hy"]="Երկ",
    ["id"]="Sn",
    ["lt"]="pr",
    ["ms"]="Isn",
    ["sk"]="po",
    ["sl"]="pon",
    ["sq"]="han",
    ["sr"]="пон",
    ["sr-latn"]="pon",
    ["ua"]="пн",
   },
  },
  ["month"]={
   ["labels"]={
    ["be"]="месяц",
    ["bg"]="месец",
    ["ca"]="mes",
    ["cnr"]="месец",
    ["cnr-latn"]="mesec",
    ["cs"]="měsíc",
    ["de"]="Monat",
    ["en"]="month",
    ["eo"]="monato",
    ["es"]="mes",
    ["et"]="kuu",
    ["fa"]="ماه",
    ["fi"]="kuukausi",
    ["fr"]="mois",
    ["hy"]="ամիս",
    ["id"]="bulan",
    ["kr"]="월",
    ["lt"]="mėnuo",
    ["mk"]="месец",
    ["ms"]="bulan",
    ["nl"]="maand",
    ["pt"]="mes",
    ["ro"]="lună",
    ["sk"]="mesiac",
    ["sl"]="mesec",
    ["sq"]="muaj",
    ["sr"]="месец",
    ["sr-latn"]="mesec",
    ["sv"]="månad",
    ["ua"]="місяць",
   },
  },
  ["november"]={
   ["labels"]={
    ["af"]="november",
    ["ar"]="نوفمبر",
    ["ar-ma"]="نونبر",
    ["ar-sy"]="تشرين الثاني",
    ["be"]="лістапада",
    ["bg"]="ноември",
    ["ca"]="novembre",
    ["cn"]="十一月",
    ["cnr"]="новембар",
    ["cnr-latn"]="novembar",
    ["cs"]="listopadu",
    ["da"]="november",
    ["de"]="November",
    ["en"]="November",
    ["eo"]="Novembro",
    ["es"]="noviembre",
    ["et"]="november",
    ["fa"]="نوامبر",
    ["fi"]="marraskuu",
    ["fr"]="novembre",
    ["gr"]="Νοέμβριος",
    ["hr"]="studenog",
    ["hu"]="november",
    ["hy"]="Նոյեմբեր",
    ["id"]="November",
    ["it"]="novembre",
    ["ja"]="11",
    ["kr"]="11",
    ["la"]="November",
    ["lt"]="lapkričio",
    ["mk"]="ноември",
    ["ms"]="November",
    ["nb"]="november",
    ["nl"]="november",
    ["nn"]="november",
    ["pl"]="listopada",
    ["pt"]="novembro",
    ["ro"]="noiembrie",
    ["ru"]="ноября",
    ["sk"]="novembra",
    ["sl"]="november",
    ["sq"]="Nëntor",
    ["sr"]="новембар",
    ["sr-latn"]="novembar",
    ["sv"]="november",
    ["tk"]="noýabr",
    ["tr"]="kasım",
    ["ua"]="листопада",
    ["vi"]="tháng mười một",
   },
  },
  ["november:jalali"]={
   ["labels"]={
    ["ca"]="Bahman",
    ["en"]="Bahman",
    ["es"]="Bahman",
    ["fa"]="بهمن",
    ["hy"]="Բահման",
   },
  },
  ["november:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ноем.",
    ["ca"]="nov",
    ["cnr"]="нов",
    ["cnr-latn"]="nov",
    ["cs"]="list.",
    ["da"]="",
    ["de"]="Nov.",
    ["en"]="nov",
    ["eo"]="Nov.",
    ["es"]="nov.",
    ["et"]="nov",
    ["fi"]="",
    ["fr"]="nov.",
    ["gr"]="",
    ["hr"]="stu",
    ["hu"]="nov.",
    ["hy"]="Նոյ",
    ["id"]="Nov",
    ["it"]="",
    ["la"]="",
    ["lt"]="nov",
    ["mk"]="ноем.",
    ["ms"]="Nov.",
    ["nb"]="nov.",
    ["nl"]="",
    ["nn"]="nov.",
    ["pl"]="lis.",
    ["pt"]="",
    ["ro"]="noiemb.",
    ["ru"]="",
    ["sk"]="nov.",
    ["sl"]="nov",
    ["sr"]="нов",
    ["sr-latn"]="nov",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="листопад",
    ["vi"]="",
   },
  },
  ["october"]={
   ["labels"]={
    ["af"]="oktober",
    ["ar"]="أكتوبر",
    ["ar-sy"]="تشرين الأول",
    ["be"]="кастрычніка",
    ["bg"]="октомври",
    ["ca"]="octubre",
    ["cn"]="十月",
    ["cnr"]="oктобар",
    ["cnr-latn"]="oktobar",
    ["cs"]="října",
    ["da"]="oktober",
    ["de"]="Oktober",
    ["en"]="October",
    ["eo"]="Oktobro",
    ["es"]="octubre",
    ["et"]="oktoober",
    ["fa"]="اکتبر",
    ["fi"]="lokakuu",
    ["fr"]="octobre",
    ["gr"]="Οκτώβριος",
    ["hr"]="listopada",
    ["hu"]="október",
    ["hy"]="հոկտեմբեր",
    ["id"]="Oktober",
    ["it"]="ottobre",
    ["ja"]="10",
    ["kr"]="10",
    ["la"]="October",
    ["lt"]="spalio",
    ["mk"]="октомври",
    ["ms"]="Oktober",
    ["nb"]="oktober",
    ["nl"]="oktober",
    ["nn"]="oktober",
    ["pl"]="października",
    ["pt"]="outubro",
    ["ro"]="octombrie",
    ["ru"]="октября",
    ["sk"]="októbra",
    ["sl"]="oktober",
    ["sq"]="Tetor",
    ["sr"]="октобар",
    ["sr-latn"]="oktobar",
    ["sv"]="oktober",
    ["tk"]="oktýabr",
    ["tr"]="ekim",
    ["ua"]="жовтня",
    ["vi"]="tháng mười",
   },
  },
  ["october:jalali"]={
   ["labels"]={
    ["ca"]="Dey",
    ["en"]="Dey",
    ["es"]="Dey",
    ["fa"]="دی",
    ["hy"]="Դեյ",
   },
  },
  ["october:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="окт.",
    ["ca"]="oct",
    ["cnr"]="oкт",
    ["cnr-latn"]="okt",
    ["cs"]="říj.",
    ["da"]="",
    ["de"]="Okt.",
    ["en"]="oct",
    ["eo"]="Okt.",
    ["es"]="oct.",
    ["et"]="okt",
    ["fi"]="",
    ["fr"]="oct.",
    ["gr"]="",
    ["hr"]="lis",
    ["hu"]="okt.",
    ["hy"]="Հոկ",
    ["id"]="Okt",
    ["it"]="",
    ["la"]="",
    ["lt"]="oct",
    ["mk"]="окт.",
    ["ms"]="Okt.",
    ["nb"]="okt.",
    ["nl"]="",
    ["nn"]="okt.",
    ["pl"]="paź.",
    ["pt"]="",
    ["ro"]="oct.",
    ["ru"]="",
    ["sk"]="okt.",
    ["sl"]="okt",
    ["sr"]="окт",
    ["sr-latn"]="okt",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="жов",
    ["vi"]="",
   },
  },
  ["page"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="صفحة ",
    ["be"]="старонка ",
    ["bg"]="страна ",
    ["ca"]="pagina ",
    ["cnr"]="страница ",
    ["cnr-latn"]="stranica ",
    ["cs"]="strana ",
    ["da"]="Side ",
    ["de"]="Seite ",
    ["en"]="page ",
    ["eo"]="paĝo ",
    ["es"]="página ",
    ["et"]="lehekülg ",
    ["fa"]="صفحه ",
    ["fi"]="Sivu ",
    ["fr"]="page ",
    ["gr"]="σελλίδα ",
    ["hr"]="stranica ",
    ["hu"]="oldal ",
    ["hy"]="էջ ",
    ["id"]="halaman ",
    ["it"]="pagina ",
    ["kr"]="쪽",
    ["la"]="",
    ["lt"]="puslapis ",
    ["mk"]="страница ",
    ["ms"]="muka surat ",
    ["nb"]="side ",
    ["nl"]="pagina ",
    ["nn"]="side ",
    ["pl"]="strona ",
    ["pt"]="pagina ",
    ["ro"]="pagină",
    ["ru"]="страница ",
    ["sk"]="strana ",
    ["sl"]="stran ",
    ["sq"]="faqe ",
    ["sr"]="страница ",
    ["sr-latn"]="stranica ",
    ["sv"]="Sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="сторінка ",
    ["vi"]="",
   },
  },
  ["part"]={
   ["labels"]={
    ["af"]="Deel ",
    ["ar"]="جزء ",
    ["be"]="Частка ",
    ["bg"]="Частка ",
    ["ca"]="Part ",
    ["cn"]={ "第 ", " 部分" },
    ["cnr"]="Дио ",
    ["cnr-latn"]="Dio ",
    ["cs"]="Část ",
    ["da"]="Del ",
    ["de"]="Teil ",
    ["en"]="Part ",
    ["eo"]="Parto ",
    ["es"]="Parte ",
    ["et"]="Osa ",
    ["fa"]="قسمت ",
    ["fi"]="Osa ",
    ["fr"]="Partie ",
    ["gr"]="Μέρος ",
    ["hr"]="Dio ",
    ["hu"]={ "", " rész" },
    ["hy"]="Մաս ",
    ["id"]="Bagian ",
    ["it"]="Parte ",
    ["ja"]={ "第", "パート" },
    ["kr"]={ "제", "부" },
    ["la"]="Pars ",
    ["lt"]={ "", " dalis" },
    ["ms"]="Bahagian ",
    ["nb"]="Del ",
    ["nl"]="Deel ",
    ["nn"]="Del ",
    ["pl"]="Część ",
    ["pt"]="Parte ",
    ["ro"]="Partea ",
    ["ru"]="Часть ",
    ["sk"]="Časť ",
    ["sl"]="Del ",
    ["sq"]="Pjesë ",
    ["sr"]="Део ",
    ["sr-latn"]="Deo ",
    ["sv"]="Del ",
    ["tk"]="Bölüm ",
    ["tr"]="Cilt ",
    ["ua"]="Частина ",
    ["vi"]="Phần ",
   },
  },
  ["precedingpage"]={
   ["labels"]={
    ["ca"]="en una pagina anterior",
    ["cnr"]="на претходној страници",
    ["cnr-latn"]="na prethodnoj stranici",
    ["comment"]=[["auf der vorigen Seite" ok, but not "auf einer vorigen Seite"]],
    ["cs"]="na předchozí straně",
    ["de"]="oben",
    ["en"]="on a preceding page",
    ["eo"]="sur antaŭa paĝo",
    ["es"]="en la pagina anterior",
    ["et"]="eelmisel lehel",
    ["fa"]="در صفحات گذشته",
    ["fi"]="edellisellä sivulla",
    ["fr"]="sur la page précédente",
    ["gr"]="σε προηγούμενη σελλίδα",
    ["hy"]="նախորդ էջ",
    ["id"]="di halaman sebelumnya",
    ["lt"]="ankstesniame puslapyje",
    ["mk"]="на претходната страница",
    ["ms"]="pada halaman sebelumnya",
    ["nl"]="op een voorgaande bladzijde",
    ["pt"]="na seguinte pagina",
    ["ro"]="la pagina precedentă",
    ["sk"]="na predchádzajúcej strane",
    ["sl"]="na prejšnji strani",
    ["sq"]="në faqen e kaluar",
    ["sr"]="на претходној страници",
    ["sr-latn"]="na prethodnoj stranici",
    ["sv"]="på föregående sida",
    ["ua"]="на схожій сторінці",
   },
  },
  ["saturday"]={
   ["labels"]={
    ["af"]="saterdag",
    ["ar"]="السبت",
    ["be"]="субота",
    ["bg"]="сряда",
    ["ca"]="dissabte",
    ["cn"]="星期六",
    ["cnr"]="субота",
    ["cnr-latn"]="subota",
    ["cs"]="sobota",
    ["da"]="lørdag",
    ["de"]="Samstag",
    ["en"]="Saturday",
    ["eo"]="sabato",
    ["es"]="sábado",
    ["et"]="laupäev",
    ["fa"]="شنبه",
    ["fi"]="lauantai",
    ["fr"]="samedi",
    ["gr"]="Σάββατο",
    ["hr"]="subota",
    ["hu"]="szombat",
    ["hy"]="շաբաթ",
    ["id"]="Sabtu",
    ["it"]="sabato",
    ["ja"]="土曜日",
    ["kr"]="토요일",
    ["la"]="Dies Saturni",
    ["lt"]="šeštadienis",
    ["mk"]="сабота",
    ["ms"]="Sabtu",
    ["nb"]="lørdag",
    ["nl"]="zaterdag",
    ["nn"]="laurdag",
    ["pl"]="sobota",
    ["pt"]="sábado",
    ["ro"]="sâmbătă",
    ["ru"]="суббота",
    ["sk"]="sobota",
    ["sl"]="sobota",
    ["sq"]="Shtune",
    ["sr"]="субота",
    ["sr-latn"]="subota",
    ["sv"]="lördag",
    ["tk"]="altynjy gün",
    ["tr"]="cumartesi",
    ["ua"]="субота",
    ["vi"]="thứ bảy",
   },
  },
  ["saturday:mnem"]={
   ["labels"]={
    ["bg"]="сб",
    ["cnr"]="суб",
    ["cnr-latn"]="sub",
    ["cs"]="so",
    ["de"]="Sa.",
    ["en"]="sat",
    ["eo"]="sab.",
    ["es"]="sa",
    ["fi"]="La",
    ["fr"]="sam.",
    ["hy"]="Շաբ",
    ["id"]="Sb",
    ["lt"]="še",
    ["ms"]="Sabtu",
    ["sk"]="so",
    ["sl"]="sob",
    ["sr"]="суб",
    ["sr-latn"]="sub",
    ["ua"]="суб",
   },
  },
  ["section"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Paragraaf ",
    ["ar"]="فصل ",
    ["bg"]="Cекция ",
    ["ca"]="Secció ",
    ["cn"]={ "第 ", " 节" },
    ["cnr"]="Одјељак ",
    ["cnr-latn"]="Odjeljak ",
    ["cs"]="Sekce ",
    ["da"]="",
    ["de"]="Abschnitt ",
    ["en"]="Section ",
    ["eo"]="Sekcio ",
    ["es"]="Sección ",
    ["et"]="jaos ",
    ["fa"]="بخش ",
    ["fi"]="Osio ",
    ["fr"]="Section ",
    ["gr"]="Ενότητα ",
    ["hr"]="Odjeljak ",
    ["hu"]="Fejezet ",
    ["hy"]="Բաժին ",
    ["id"]="Bagian ",
    ["it"]="",
    ["ja"]={ "第", "項" },
    ["kr"]={ "제", "절" },
    ["la"]="",
    ["lt"]="Skyrius ",
    ["mk"]="Поглавје ",
    ["ms"]="Seksyen ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podrozdział ",
    ["pt"]="",
    ["ro"]="Secție ",
    ["ru"]="",
    ["sk"]="Sekcia ",
    ["sl"]="Oddelek ",
    ["sq"]="Seksion ",
    ["sr"]="Одељак ",
    ["sr-latn"]="Odeljak ",
    ["sv"]="Avsnitt ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="Cекція ",
    ["vi"]="",
   },
  },
  ["see"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="انظر ",
    ["be"]="гл. ",
    ["bg"]="погледни ",
    ["ca"]="vore ",
    ["cnr"]="погледај ",
    ["cnr-latn"]="pogledaj ",
    ["cs"]="viz ",
    ["da"]="se ",
    ["de"]="siehe ",
    ["en"]="see ",
    ["eo"]="vidu ",
    ["es"]="ver: ",
    ["et"]="vaadake ",
    ["fa"]="نگاه کنید به ",
    ["fi"]="katso ",
    ["fr"]="cf. ",
    ["gr"]="",
    ["hr"]="vidi ",
    ["hu"]="lásd ",
    ["hy"]="Նայել ",
    ["id"]="Lihat ",
    ["it"]="cf. ",
    ["kr"]="",
    ["la"]="",
    ["lt"]="žiūrėti ",
    ["mk"]="види ",
    ["ms"]="lihat ",
    ["nb"]="se ",
    ["nl"]="zie ",
    ["nn"]="sjå ",
    ["pl"]="patrz ",
    ["pt"]="ver ",
    ["ro"]="vezi ",
    ["ru"]="см. ",
    ["sk"]="pozri ",
    ["sl"]="glej ",
    ["sq"]="shiko ",
    ["sr"]="види ",
    ["sr-latn"]="vidi ",
    ["sv"]="se ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="див. ",
    ["vi"]="",
   },
  },
  ["september"]={
   ["labels"]={
    ["af"]="september",
    ["ar"]="سبتمبر",
    ["ar-ma"]="شتنبر",
    ["ar-sy"]="أيلول",
    ["be"]="верасня",
    ["bg"]="септември",
    ["ca"]="setembre",
    ["cn"]="九月",
    ["cnr"]="септембар",
    ["cnr-latn"]="septembar",
    ["cs"]="září",
    ["da"]="september",
    ["de"]="September",
    ["en"]="September",
    ["eo"]="Septembro",
    ["es"]="septiembre",
    ["et"]="september",
    ["fa"]="سپتامبر",
    ["fi"]="syyskuu",
    ["fr"]="septembre",
    ["gr"]="Σεπτέμβριος",
    ["hr"]="rujna",
    ["hu"]="szeptember",
    ["hy"]="Սեպտեմբեր",
    ["id"]="September",
    ["it"]="settembre",
    ["ja"]="9",
    ["kr"]="9",
    ["la"]="September",
    ["lt"]="rugsėjo",
    ["mk"]="септември",
    ["ms"]="September",
    ["nb"]="september",
    ["nl"]="september",
    ["nn"]="september",
    ["pl"]="września",
    ["pt"]="setembro",
    ["ro"]="septembrie",
    ["ru"]="сентября",
    ["sk"]="septembra",
    ["sl"]="september",
    ["sq"]="Shtator",
    ["sr"]="септембар",
    ["sr-latn"]="septembar",
    ["sv"]="september",
    ["tk"]="sentýabr",
    ["tr"]="eylül",
    ["ua"]="вересня",
    ["vi"]="tháng chín",
   },
  },
  ["september:jalali"]={
   ["labels"]={
    ["en"]="Azar",
    ["es"]="Azar",
    ["fa"]="آذر",
    ["hy"]="Ազար",
   },
  },
  ["september:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="септ.",
    ["ca"]="set",
    ["cnr"]="сеп",
    ["cnr-latn"]="sep",
    ["cs"]="září",
    ["da"]="",
    ["de"]="Sep.",
    ["en"]="sep",
    ["eo"]="Sep.",
    ["es"]="sep.",
    ["et"]="sept",
    ["fi"]="",
    ["fr"]="sept.",
    ["gr"]="",
    ["hr"]="ruj",
    ["hu"]="szep.",
    ["hy"]="Սեպ",
    ["id"]="Sep",
    ["it"]="",
    ["la"]="",
    ["lt"]="sep",
    ["mk"]="септ.",
    ["ms"]="Sep.",
    ["nb"]="sep.",
    ["nl"]="",
    ["nn"]="sep.",
    ["pl"]="wrz.",
    ["pt"]="",
    ["ro"]="sept.",
    ["ru"]="",
    ["sk"]="sept.",
    ["sl"]="sep",
    ["sr"]="сеп.",
    ["sr-latn"]="sep.",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="вер",
    ["vi"]="",
   },
  },
  ["subsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى ",
    ["bg"]="Подсекция ",
    ["ca"]="Subsecció ",
    ["cn"]="",
    ["cnr"]="Пододјељак ",
    ["cnr-latn"]="Pododjeljak ",
    ["cs"]="Podsekce ",
    ["da"]="",
    ["de"]="Unterabschnitt ",
    ["en"]="Subsection ",
    ["eo"]="Subsekcio ",
    ["es"]="Subsección ",
    ["et"]="alajaotis ",
    ["fa"]="زیربخش ",
    ["fi"]="Alajakso ",
    ["fr"]="Soussection ",
    ["gr"]="Υπόενότητα ",
    ["hr"]="Pododjeljak ",
    ["hu"]="Alfejezet ",
    ["hy"]="Ենթաբաժին ",
    ["id"]="Subbagian ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="Poskyris ",
    ["mk"]="Подпоглавје ",
    ["ms"]="Subseksyen ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podpodrozdział ",
    ["pt"]="Subsecçao ",
    ["ro"]="Subsecțiunea ",
    ["ru"]="",
    ["sk"]="Podsekcia ",
    ["sl"]="Pododdelek ",
    ["sq"]="Nënseksion ",
    ["sr"]="Пододељак ",
    ["sr-latn"]="Pododeljak ",
    ["sv"]="Underavsnitt ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="Субсекція ",
    ["vi"]="",
   },
  },
  ["subsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى ",
    ["bg"]="Подподсекция ",
    ["ca"]="Subsubsecció ",
    ["cn"]="",
    ["cnr"]="Подпододјељак ",
    ["cnr-latn"]="Podpododjeljak ",
    ["cs"]="Podpodsekce ",
    ["da"]="",
    ["de"]="Unterunterabschnitt ",
    ["en"]="Subsubsection ",
    ["eo"]="Subsubsekcio ",
    ["es"]="Subsubsección ",
    ["et"]="alamjaotis ",
    ["fa"]="زیرزیربخش ",
    ["fi"]="Alakohta ",
    ["fr"]="Soussoussection ",
    ["gr"]="Υπουποενότητα ",
    ["hr"]="Podpododjeljak ",
    ["hu"]="Al-alfejezet ",
    ["hy"]="Ենթաենթաբաժին ",
    ["id"]="Subsubbagian ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподпоглавје ",
    ["ms"]="Subsubseksyen ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="Subsubsecçao ",
    ["ro"]="Sub subsecțiunea ",
    ["ru"]="",
    ["sk"]="Podpodsekcia ",
    ["sl"]="Podpododdelek ",
    ["sq"]="Nënnënseksion ",
    ["sr"]="Подпододељак ",
    ["sr-latn"]="Podpododeljak ",
    ["sv"]="Underunderavsnitt ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="Субсубсекція ",
    ["vi"]="",
   },
  },
  ["subsubsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى أدنى ",
    ["bg"]="Подподподсекция ",
    ["ca"]="Subsubsubsecció ",
    ["cn"]="",
    ["cnr"]="Подподпододјељак ",
    ["cnr-latn"]="Podpodpododjeljak ",
    ["cs"]="Podpodpodsekce ",
    ["da"]="",
    ["de"]="Unterunterunterabschnitt ",
    ["en"]="Subsubsubsection ",
    ["eo"]="Subsubsubsekcio ",
    ["es"]="Subsubsubsección ",
    ["et"]="",
    ["fa"]="زیرزیرزیربخش ",
    ["fi"]="Ala-alakohta ",
    ["fr"]="Soussoussoussection ",
    ["gr"]="Υπουπουποενότητα ",
    ["hr"]="Podpodpododjeljak ",
    ["hu"]="Al-al-alfejezet ",
    ["hy"]="Ենթաենթաենթաբաժին ",
    ["id"]="Subsubsubbagian ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподподпоглавје ",
    ["ms"]="Subsubsubseksyen ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="Subsubsubsecçao ",
    ["ro"]="Sub sub subsecțiunea",
    ["ru"]="",
    ["sk"]="Podpodpodsekcia ",
    ["sl"]="Podpodpododdelek ",
    ["sq"]="Nënnënnënseksion ",
    ["sr"]="Подподпододељак ",
    ["sr-latn"]="Podpodpododeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="Субсекція ",
    ["vi"]="",
   },
  },
  ["sunday"]={
   ["labels"]={
    ["af"]="sondag",
    ["ar"]="الأحد",
    ["be"]="нядзеля",
    ["bg"]="неделя",
    ["ca"]="diumenge",
    ["cn"]="星期日",
    ["cnr"]="неђеља",
    ["cnr-latn"]="neđelja",
    ["cs"]="neděle",
    ["da"]="søndag",
    ["de"]="Sonntag",
    ["en"]="Sunday",
    ["eo"]="dimanĉo",
    ["es"]="domingo",
    ["et"]="pühapäev",
    ["fa"]="یکشنبه",
    ["fi"]="sunnuntai",
    ["fr"]="dimanche",
    ["gr"]="Κυριακή",
    ["hr"]="nedjelja",
    ["hu"]="vasárnap",
    ["hy"]="կիրակի",
    ["id"]="Minggu",
    ["it"]="domenica",
    ["ja"]="日曜日",
    ["kr"]="일요일",
    ["la"]="Dies Solis",
    ["lt"]="sekmadienis",
    ["mk"]="недела",
    ["ms"]="Ahad",
    ["nb"]="søndag",
    ["nl"]="zondag",
    ["nn"]="sundag",
    ["pl"]="niedziela",
    ["pt"]="domingo",
    ["ro"]="duminică",
    ["ru"]="воскресенье",
    ["sk"]="nedeľa",
    ["sl"]="nedelja",
    ["sq"]="Diele",
    ["sr"]="недеља",
    ["sr-latn"]="nedelja",
    ["sv"]="söndag",
    ["tk"]="dynç gün",
    ["tr"]="pazar",
    ["ua"]="неділя",
    ["vi"]="chủ nhật",
   },
  },
  ["sunday:mnem"]={
   ["labels"]={
    ["bg"]="нд",
    ["ca"]="dg",
    ["cnr"]="неђ",
    ["cnr-latn"]="neđ",
    ["cs"]="ne",
    ["de"]="So.",
    ["en"]="sun",
    ["eo"]="dim.",
    ["es"]="do",
    ["fr"]="dim.",
    ["hy"]="Կիր",
    ["id"]="Mn",
    ["lt"]="Se",
    ["ms"]="Ahad",
    ["sk"]="ne",
    ["sl"]="ned",
    ["sr"]="нед",
    ["sr-latn"]="ned",
    ["ua"]="нд",
   },
  },
  ["table"]={
   ["labels"]={
    ["af"]="Tabel",
    ["ar"]="جدول ",
    ["be"]="Табліца ",
    ["bg"]="Таблица ",
    ["ca"]="Taula ",
    ["cn"]="表 ",
    ["cnr"]="Табела ",
    ["cnr-latn"]="Tabela ",
    ["cs"]="Tabulka ",
    ["da"]="Tabel ",
    ["de"]="Tabelle ",
    ["en"]="Table ",
    ["eo"]="Tabelo ",
    ["es"]="Tabla ",
    ["et"]="Tabel ",
    ["fa"]="جدول ",
    ["fi"]="Taulukko ",
    ["fr"]="Tableau ",
    ["gr"]="Πίνακας ",
    ["hr"]="Tablica ",
    ["hu"]={ "", " táblázat" },
    ["hy"]="Աղյուսակ ",
    ["id"]="Tabel ",
    ["it"]="Tabella ",
    ["ja"]="表",
    ["kr"]="표 ",
    ["la"]="Tabula ",
    ["lt"]={ "", " lentelė." },
    ["mk"]="Табела ",
    ["ms"]="Jadual ",
    ["nb"]="Tabell ",
    ["nl"]="Tabel ",
    ["nn"]="Tabell ",
    ["pl"]="Tabela ",
    ["pt"]="Tabela ",
    ["ro"]="Tabelul ",
    ["ru"]="Таблица ",
    ["sk"]="Tabuľka ",
    ["sl"]="Tabela ",
    ["sq"]="Tabela ",
    ["sr"]="Табела ",
    ["sr-latn"]="Tabela ",
    ["sv"]="Tabell ",
    ["tk"]="Tablisa ",
    ["tr"]="Tablo ",
    ["ua"]="Таблиця ",
    ["vi"]="Bảng ",
   },
  },
  ["thursday"]={
   ["labels"]={
    ["af"]="donderdag",
    ["ar"]="الخميس",
    ["be"]="чацвер",
    ["bg"]="четвъртък",
    ["ca"]="dijous",
    ["cn"]="星期四",
    ["cnr"]="четвртак",
    ["cnr-latn"]="četvrtak",
    ["cs"]="čtvrtek",
    ["da"]="torsdag",
    ["de"]="Donnerstag",
    ["en"]="Thursday",
    ["eo"]="ĵaŭdo",
    ["es"]="jueves",
    ["et"]="neljapäev",
    ["fa"]="پنج‌شنبه",
    ["fi"]="torstai",
    ["fr"]="jeudi",
    ["gr"]="Πέμπτη",
    ["hr"]="četvrtak",
    ["hu"]="csütörtök",
    ["hy"]="հինգշաբթի",
    ["id"]="Kamis",
    ["it"]="giovedì",
    ["ja"]="木曜日",
    ["kr"]="목요일",
    ["la"]="Dies Iovis",
    ["lt"]="ketvirtadienis",
    ["mk"]="четврток",
    ["ms"]="Khamis",
    ["nb"]="torsdag",
    ["nl"]="donderdag",
    ["nn"]="torsdag",
    ["pl"]="czwartek",
    ["pt"]="quinta-feira",
    ["ro"]="joi",
    ["ru"]="четверг",
    ["sk"]="štvrtok",
    ["sl"]="četrtek",
    ["sq"]="Enjte",
    ["sr"]="четвртак",
    ["sr-latn"]="četvrtak",
    ["sv"]="torsdag",
    ["tk"]="dördünji gün",
    ["tr"]="perşembe",
    ["ua"]="четвер",
    ["vi"]="thứ năm",
   },
  },
  ["thursday:mnem"]={
   ["labels"]={
    ["bg"]="чт",
    ["ca"]="dj",
    ["cnr"]="чет",
    ["cnr-latn"]="čet",
    ["cs"]="čt",
    ["de"]="Do.",
    ["en"]="thu",
    ["eo"]="ĵaŭ.",
    ["es"]="ju",
    ["fi"]="To",
    ["fr"]="jeu.",
    ["hy"]="Հնգ",
    ["id"]="Km",
    ["lt"]="Ke",
    ["ms"]="Kha",
    ["sk"]="št",
    ["sl"]="čet",
    ["sr"]="чет",
    ["sr-latn"]="čet",
    ["ua"]="чт",
   },
  },
  ["tuesday"]={
   ["labels"]={
    ["af"]="dinsdag",
    ["ar"]="الثلاثاء",
    ["be"]="аўторак",
    ["bg"]="вторник",
    ["ca"]="dimarts",
    ["cn"]="星期二",
    ["cnr"]="уторак",
    ["cnr-latn"]="utorak",
    ["cs"]="úterý",
    ["da"]="tirsdag",
    ["de"]="Dienstag",
    ["en"]="Tuesday",
    ["eo"]="mardo",
    ["es"]="martes",
    ["et"]="teisipäev",
    ["fa"]="سه‌شنبه",
    ["fi"]="tiistai",
    ["fr"]="mardi",
    ["gr"]="Τρίτη",
    ["hr"]="utorak",
    ["hu"]="kedd",
    ["hy"]="երեքշաբթի",
    ["id"]="Selasa",
    ["it"]="martedì",
    ["ja"]="火曜日",
    ["kr"]="화요일",
    ["la"]="Dies Martis",
    ["lt"]="antradienis",
    ["mk"]="вторник",
    ["ms"]="Selasa",
    ["nb"]="tirsdag",
    ["nl"]="dinsdag",
    ["nn"]="tysdag",
    ["pl"]="wtorek",
    ["pt"]="terça-feira",
    ["ro"]="marți",
    ["ru"]="вторник",
    ["sk"]="utorok",
    ["sl"]="torek",
    ["sq"]="Marte",
    ["sr"]="уторак",
    ["sr-latn"]="utorak",
    ["sv"]="tisdag",
    ["tk"]="ikinji gün",
    ["tr"]="salı",
    ["ua"]="вівторок",
    ["vi"]="thứ ba",
   },
  },
  ["tuesday:mnem"]={
   ["labels"]={
    ["bg"]="вт",
    ["ca"]="dm",
    ["cnr"]="уто",
    ["cnr-latn"]="uto",
    ["cs"]="út",
    ["de"]="Di.",
    ["en"]="tue",
    ["eo"]="mar.",
    ["es"]="ma",
    ["fi"]="Ti",
    ["fr"]="mar.",
    ["hy"]="Երք",
    ["id"]="Sl",
    ["lt"]="An",
    ["ms"]="Sel",
    ["sk"]="út",
    ["sl"]="tor",
    ["sr"]="уто",
    ["sr-latn"]="uto",
    ["ua"]="вт",
   },
  },
  ["wednesday"]={
   ["labels"]={
    ["af"]="woensdag",
    ["ar"]="الأربعاء",
    ["be"]="серада",
    ["bg"]="сряда",
    ["ca"]="dimecres",
    ["cn"]="星期三",
    ["cnr"]="сриједа",
    ["cnr-latn"]="srijeda",
    ["cs"]="středa",
    ["da"]="onsdag",
    ["de"]="Mittwoch",
    ["en"]="Wednesday",
    ["eo"]="merkredo",
    ["es"]="miércoles",
    ["et"]="kolmapäev",
    ["fa"]="چهارشنبه",
    ["fi"]="keskiviikko",
    ["fr"]="mercredi",
    ["gr"]="Τετάρτη",
    ["hr"]="srijeda",
    ["hu"]="szerda",
    ["hy"]="չորեքշաբթի",
    ["id"]="Rabu",
    ["it"]="mercoledì",
    ["ja"]="水曜日",
    ["kr"]="수요일",
    ["la"]="Dies Mercuri",
    ["lt"]="trečiadienis",
    ["mk"]="среда",
    ["ms"]="Rabu",
    ["nb"]="onsdag",
    ["nl"]="woensdag",
    ["nn"]="onsdag",
    ["pl"]="środa",
    ["pt"]="quarta-feira",
    ["ro"]="miercuri",
    ["ru"]="среда",
    ["sk"]="streda",
    ["sl"]="sreda",
    ["sq"]="Mërkure",
    ["sr"]="среда",
    ["sr-latn"]="sreda",
    ["sv"]="onsdag",
    ["tk"]="üçünji",
    ["tr"]="çarşamba",
    ["ua"]="середа",
    ["vi"]="thứ tư",
   },
  },
  ["wednesday:mnem"]={
   ["labels"]={
    ["bg"]="ср",
    ["ca"]="dim",
    ["cnr"]="сри",
    ["cnr-latn"]="sri",
    ["cs"]="st",
    ["de"]="Mi.",
    ["en"]="wed",
    ["eo"]="mer.",
    ["es"]="mi",
    ["fi"]="Ke",
    ["fr"]="mer.",
    ["hy"]="չոր",
    ["id"]="Rb",
    ["lt"]="Tr",
    ["ms"]="Rabu",
    ["sk"]="st",
    ["sl"]="sre",
    ["sr"]="сре",
    ["sr-latn"]="sre",
    ["ua"]="ср",
   },
  },
  ["year"]={
   ["labels"]={
    ["bg"]="година",
    ["ca"]="any",
    ["cnr"]="година",
    ["cnr-latn"]="godina",
    ["cs"]="rok",
    ["de"]="Jahr",
    ["en"]="year",
    ["eo"]="jaro",
    ["es"]="año",
    ["et"]="aasta",
    ["fa"]="سال",
    ["fi"]="Vuosi",
    ["fr"]="année",
    ["gr"]="έτος",
    ["hy"]="Տարի",
    ["id"]="tahun",
    ["kr"]="년",
    ["lt"]="metai",
    ["mk"]="година",
    ["ms"]="tahun",
    ["nl"]="jaar",
    ["pt"]="ano",
    ["ro"]="an",
    ["sk"]="rok",
    ["sl"]="leto",
    ["sq"]="viti",
    ["sr"]="година",
    ["sr-latn"]="godina",
    ["sv"]="år",
    ["ua"]="рік",
   },
  },
 },
 ["thesis"]={
  ["abstract"]={
   ["labels"]={
    ["ca"]="Resum",
    ["cnr"]="Апстрактно",
    ["cnr-latn"]="Apstraktno",
    ["cs"]="Abstrakt",
    ["en"]="Abstract",
    ["es"]="Resumen",
    ["fa"]="چکیده",
    ["fi"]="Tiivistelmä",
    ["fr"]="Abstrait",
    ["gr"]="Περίληψη",
    ["hy"]="Աբստրակտ",
    ["id"]="Abstrak",
    ["lt"]="Santrauka",
    ["ml"]="Abstrak",
    ["pt"]="Abstrato",
    ["ro"]="Abstract",
    ["sl"]="Abstrakten",
    ["sk"]="Abstrakt",
    ["sq"]="Abstrakt",
    ["sr"]="Апстрактно",
    ["sr-latn"]="Apstraktno",
    ["ua"]="Анотація",
   },
  },
  ["bachelorproject"]={
   ["labels"]={
    ["ca"]="Projecte de licenciatura",
    ["cnr"]="Дипломски пројекат",
    ["cnr-latn"]="Diplomski projekat",
    ["cs"]="Bakalářská práce",
    ["en"]="Bachelor's Project",
    ["es"]="Proyecto de licenciatura",
    ["fa"]="",
    ["fi"]="Bachelor-projekti",
    ["fr"]="Projet de Bachelor",
    ["gr"]="Πτυχιακή σχέδιο",
    ["hy"]="Ավարտական աշխատանք",
    ["id"]="Proyek Sarjana",
    ["lt"]="Bakalauro projektas",
    ["ml"]="Projek Sarjana Muda",
    ["pt"]="Projeto de Licenciatura", 
    ["ro"]="Proiect de licență",
    ["sl"]="Diplomski projekt",
    ["sk"]="Bakalársky projekt",
    ["sq"]="Projekti e bachelorit",
    ["sr"]="Дипломски пројекат",
    ["sr-latn"]="Diplomski projekat",
    ["ua"]="Бакалаврський проєкт",
   },
  },
  ["bachelorthesis"]={
   ["labels"]={
    ["ca"]="Tesi de licenciatura",
    ["cnr"]="Дипломски рад",
    ["cnr-latn"]="Diplomski rad",
    ["cs"]="Bakalářská práce",
    ["en"]="Bachelor's Thesis",
    ["es"]="Tesis de licenciatura",
    ["fa"]="پایان<200C>نامه کارشناسی",
    ["fi"]="Opinnäytetyö",
    ["fr"]="Mémoire de Bachelor",
    ["gr"]="Πτυχιακή εργασία",
    ["hy"]="Դիպլոմային աշխատանք",
    ["id"]="Skripsi",
    ["lt"]="Bakalauro baigiamasis darbas",
    ["ml"]="Tesis Sarjana Muda",
    ["pt"]="Tese de Licenciatura",
    ["ro"]="Teză de licență",
    ["sl"]="Diplomsko delo",
    ["sk"]="Bakalárska práca",
    ["sq"]="Tema e bachelorit",
    ["sr"]="Дипломски рад",
    ["sr-latn"]="Diplomski rad",
    ["ua"]="Бакалаврська робота",
   },
  },
  ["commentarybachelorthesis"]={
   ["labels"]={
    ["ca"]="Comentari de tesi de licenciatura",
    ["cnr"]="Коментар Дипломског рада",
    ["cnr-latn"]="Komentar Diplomskog rada",
    ["cs"]="Komentář k bakalářské práci",
    ["en"]="Commentary on Bachelor's Thesis",
    ["es"]="Comentario de tesis de licenciatura",
    ["fa"]="توضیحات پایان<200C>نامه کارشناسی",
    ["fi"]="Kommentti kandidaatintyöstä",
    ["fr"]="Commentaire sur le mémoire de licence",
    ["gr"]="Σχολιασμός πτυχιακής εργασίας",
    ["hy"]="Դիպլոմային աշխատանքի մեկնաբանություն",
    ["id"]="Komentar tentang Skripsi",
    ["lt"]="Komentaras apie bakalauro laipsnio baigiamąjį darbą",
    ["ml"]="Ulasan Tesis Sarjana Muda",
    ["pt"]="Comentario de tese de licenciatura",
    ["ro"]="Comentariu la teza de licență",
    ["sl"]="Komentar Diplomske naloge",
    ["sk"]="Komentár k bakalárskej práci",
    ["sq"]="Komentim në temën e bachelorit",
    ["sr"]="Коментар Дипломског рада",
    ["sr-latn"]="Komentar Diplomskog rada",
    ["ua"]="Коментар до бакалаврської роботи",
   },
  },
  ["commentarymasterthesis"]={
   ["labels"]={
    ["ca"]="Comentari de tesi de master ",
    ["cnr"]="Коментар Магистарског рада",
    ["cnr-latn"]="Komentar Magistarskog rada",
    ["cs"]="Komentář k diplomové práci",
    ["en"]="Commentary on Master's Thesis",
    ["es"]="Comentario de tesis de master ",
    ["fa"]="توضیحات پایان<200C>نامه کارشناسی ارشد",
    ["fi"]="Kommentti diplomityöstä",
    ["fr"]="",
    ["gr"]="Σχολιασμός μεταπτυχιακής εργασίας",
    ["hy"]="Մագիստրոսական թեզի մեկնաբանություն",
    ["id"]="Komentar tentang Tesis",
    ["lt"]="Komentaras apie magistro laipsnio baigiamąjį darbą",
    ["ml"]="Ulasan Tesis Sarjana",
    ["pt"]="Comentario de tese de mestrado",
    ["ro"]="Comentarii la teza de master",
    ["sl"]="Komentar Magistrskega dela",
    ["sk"]="Komentár k diplomovej práci",
    ["sq"]="Komentim në temën e masterit",
    ["sr"]="Коментар Магистарског рада",
    ["sr-latn"]="Komentar Magistarskog rada",
    ["ua"]="Коментар до магістерської роботи",
   },
  },
  ["commentaryphdthesis"]={
   ["labels"]={
    ["ca"]="Comentari de tesis de doctorat ",
    ["cnr"]="Коментар Докторске дисертације",
    ["cnr-latn"]="Komentar Doktorske disertacije",
    ["cs"]="Komentář k doktorské práci",
    ["en"]="Commentary on PhD~Thesis",
    ["es"]="Comentario de tesis de doctorado ",
    ["fa"]="توضیحات پایان<200C>نامه دکتری",
    ["fi"]="Väitöskirjan kommentit",
    ["fr"]="",
    ["gr"]="Σχολιασμός διδακτορικής διατριβής",
    ["hy"]="Թեկնածուական թեզի մեկնաբանություն",
    ["id"]="Komentar tentang Disertasi",
    ["lt"]="Komentaras apie daktaro disertacija",
    ["ml"]="Ulasan Tesis PhD",
    ["pt"]="Comentario de tese de douturamento",
    ["ro"]="Comentarii la teza de doctorat",
    ["sl"]="Komentar Doktorske disertacije",
    ["sk"]="Komentár k doktorskej práci",
    ["sq"]="Komentim në temën e doktoratures",
    ["sr"]="Коментар Докторске дисертације",
    ["sr-latn"]="Komentar Doktorske disertacije",
    ["ua"]="Коментар до докторської роботи",
   },
  },
  ["consultant"]={
   ["labels"]={
    ["ca"]="",
    ["cnr"]="Консултант",
    ["cnr-latn"]="Konsultant",
    ["cs"]="Konzultant",
    ["en"]="Consultant",
    ["es"]="Consultor",
    ["fa"]="مشاور",
    ["fi"]="Konsultti",
    ["fr"]="Consultant",
    ["gr"]="Σύμβουλος",
    ["hy"]="խորհրդատու",
    ["id"]="Konsultan",
    ["lt"]="Konsultantas",
    ["ml"]="Perunding",
    ["pt"]="Consultor",
    ["ro"]="Consultant",
    ["sl"]="Svetovalec",
    ["sk"]="Konzultant",
    ["sq"]="Konsultent",
    ["sr"]="Консултант",
    ["sr-latn"]="Konsultant",
    ["ua"]="Консультант",
   },
  },
  ["declaration"]={
   ["labels"]={
    ["ca"]="Declaracio",
    ["cnr"]="Изјава",
    ["cnr-latn"]="Izjava",
    ["cs"]="Čestné prohlášení",
    ["en"]="Declaration",
    ["es"]="Declaracion",
    ["fa"]="اعلامیه",
    ["fi"]="Declaration",
    ["fr"]="Déclaration",
    ["gr"]="Δήλωση",
    ["hy"]="Արձանագրություն",
    ["id"]="Deklarasi",
    ["lt"]="Deklaracija",
    ["ml"]="Pengisytiharan",
    ["pt"]="Declaraçao",
    ["ro"]="Declarație",
    ["sl"]="Izjava",
    ["sk"]="Čestné prehlásenie",
    ["sq"]="Deklarim",
    ["sr"]="Изјава",
    ["sr-latn"]="Izjava",
    ["ua"]="Чесне зізнання",
   },
  },
  ["documentation"]={
   ["labels"]={
    ["ca"]="Documentacio",
    ["cnr"]="Документација",
    ["cnr-latn"]="Dokumentacija",
    ["cs"]="Dokumentace",
    ["en"]="Documentation",
    ["es"]="Documentacion",
    ["fa"]="مستندات",
    ["fi"]="Dokumentaatio",
    ["fr"]="Notice d'utilisation",
    ["gr"]="Τεκμηρίωση",
    ["hy"]="Փաստաթղթավորում",
    ["id"]="Dokumentasi",
    ["lt"]="Dokumentacija",
    ["ml"]="Dokumentasi",
    ["pt"]="Documentaçao",
    ["ro"]="Documentare",
    ["sl"]="Dokumentacija",
    ["sk"]="Dokumentácia",
    ["sq"]="Dokumentim",
    ["sr"]="Документација",
    ["sr-latn"]="Dokumentacija",
    ["ua"]="Документація",
   },
  },
  ["finalthesis"]={
   ["labels"]={
    ["ca"]="Tesi final",
    ["cnr"]="Завршни рад",
    ["cnr-latn"]="Završni rad",
    ["cs"]="Závěrečná práce",
    ["en"]="Final Thesis",
    ["es"]="Tesis final",
    ["fa"]="پایان<200C>نامه نهایی",
    ["fi"]="Seminaarin opinnäytetyö",
    ["fr"]="Thèse finale",
    ["gr"]="Τελική διατριβή",
    ["hy"]="Վերջնական թեզ",
    ["id"]="Tesis Akhir",
    ["lt"]="Baigiamasis darbas",
    ["ml"]="Tesis Akhir",
    ["pt"]="Tese final",
    ["ro"]="Teza finală",
    ["sl"]="Zaključno delo",
    ["sk"]="Záverečná práca",
    ["sq"]="Tema përfundimtare",
    ["sr"]="Завршни рад",
    ["sr-latn"]="Završni rad",
    ["ua"]="Завершальна робота",
   },
  },
  ["insteadofassignment"]={
   ["labels"]={
    ["ca"]="EN COMPTES D'AQUESTA PAGINA\\par AQUESTA ES L'ORIGINAL\\par TAREA DE TESI",
    ["cnr"]="УМЕСТО ОВОГ ЛИСТА\\par ПОСТОИ ОРИГИНАЛ\\par РАДНИ ЗАДАТАК.\\par",
    ["cnr-latn"]= "UMJESTO ZADATKA\\par POSTOJI ORIGINAL\\par RADNI ZADATAK.",
    ["cs"]="NA MÍSTĚ TOHOTO LISTU\\par SE NACHÁZÍ ORIGINÁL\\par ZADÁNÍ PRÁCE.\\par",
    ["en"]="INSTEAD OF THIS SHEET\\par THERE IS THE ORIGINAL OF THE\\par THESIS ASSIGNMENT.\\par",
    ["es"]="EN VEZ DE ESTA PAGINA\\par ESTA ES LA ORIGINAL DE\\par TAREA DE TESIS",
    ["fa"]="به<200C>جای این صفحه\\\\par اصل تکلیف پایان<200C>نامه\\\\par در اینجا قرار دارد.\\\\par",
    ["fi"]="TÄMÄN SIVUN SIJAAN\\par SIELLÄ ON ALKUPERÄINEN \\par OPINNÄYTTÖTEHTÄVÄ.\\par",
    ["fr"]="A LA PLACE DE CETTE FEUILLE\\par IL Y A L'ORIGINAL\\par ....",
    ["gr"]="ΑΝΤΙ ΓΙΑ ΑΥΤΟ ΤΟ ΦΥΛΛΟ\\par ΥΠΑΡΧΕΙ ΤΟ ΠΡΩΤΟΤΥΠΟ ΤΗΣ ΕΡΓΑΣΙΑΣ\\par ΡΓΑΣΙΑ ΔΙΑΤΡΙΒΗΣ.\\par",
    ["hy"]="ԱՅՍ ԹԵՐԹԻ ՓՈԽԱՐԵՆ\\par ԿԱ ԹԵԶԻ ՕՐԻԳԻՆԱԼ\\par ՀԱՆՁՆԱՐԱՐՈՒԹՅՈՒՆԸ:\\par",
    ["id"]="ALIH-ALIH HALAMAN INI\\par ADA LEMBAR ASLI DARI\\par TUGAS TESIS.\\par",
    ["ml"]="SEBALIKNYA LEMBARAN INI\\par ADA YANG ASLI\\par TUGASAN TESIS.\\par",
    ["pt"]="EM VEZ DESTE PAGINA\\par EXISTE UMA PAGINA\\par ORIGINAL DESTA TESE.\\par",
    ["ro"]="ÎN LOC DE ACEASTĂ FIȘĂ\\par EXISTĂ ORIGINALUL\\par SARCINA TEZEI.\\par",
    ["sl"]="NAMESTO TEGA LISTA\\par JE ORIGINAL DIPLOMSKE NALOGE\\par.",
    ["sk"]="NA MIESTE TOHTO LISTU\\par SA NACHÁDZA ORIGINÁL\\par ZADANIA PRÁCE.\\par",
    ["sq"]="NË VEND TE KËSAJ FLETE\\par KA ORIGJNALIN E\\par DETYRËS PËR TEMË.\\par",
    ["sr"]="УМЕСТО ОВОГ ЛИСТА\\par ПОСТОИ ОРИГИНАЛ\\par РАДНИ ЗАДАТАК.\\par",
    ["sr-latn"]="UMESTO ZADATKA\\par POSTOJI ORIGINAL\\par RADNI ZADATAK.",
    ["ua"]="НА МІСЦІ ЦЬОГО ЛИСТА\\par ЗНАХОДИТЬСЯ ОРИГІНАЛ\\par ЗАВДАННЯ РОБОТИ.\\par",
   },
  },
  ["keywords"]={
   ["labels"]={
    ["ca"]="Paraules clau",
    ["cnr"]="Кључне ријечи",
    ["cnr-latn"]="Ključne riječi",
    ["cs"]="Klíčová slova",
    ["en"]="Key words",
    ["es"]="Palabras clave",
    ["fa"]="کلمات کلیدی",
    ["fi"]="Avainsanat",
    ["fr"]="Mots-clés",
    ["gr"]="Λέξεις κλειδιά",
    ["hy"]="Հիմնաբառեր",
    ["id"]="Kata Kunci",
    ["lt"]="Raktažodžiai",
    ["ml"]="Kata kunci",
    ["pt"]="Palavra-chave",
    ["ro"]="Cuvinte cheie",
    ["sl"]="Ključne besede",
    ["sk"]="Kľúčové slová",
    ["sq"]="Fjalët kyçe",
    ["sr"]="Кључне речи",
    ["sr-latn"]="Ključne reči",
    ["ua"]="Ключові слова",
   },
  },
  ["masterthesis"]={
   ["labels"]={
    ["ca"]="Tesi de master",
    ["cnr"]="Мастер рад",
    ["cnr-latn"]="Master rad",
    ["cs"]="Diplomová práce",
    ["en"]="Master's Thesis",
    ["es"]="Tesis de master",
    ["fa"]="پایان<200C>نامه کارشناسی ارشد",
    ["fi"]="Pro gradu tutkielma",
    ["fr"]="Mémoire de Master",
    ["gr"]="Μεταπτυχιακή εργασία",
    ["hy"]="Մագիստրոսական թեզ",
    ["id"]="Tesis",
    ["lt"]="Magistro baigiamasis darbas",
    ["ml"]="Tesis Sarjana",
    ["pt"]="Tese de Mestrado",
    ["ro"]="Teză de master",
    ["sl"]="Magistrsko delo",
    ["sk"]="Diplomová práca",
    ["sq"]="Tema e masterit",
    ["sr"]="Мастер рад",
    ["sr-latn"]="Master rad",
    ["ua"]="Магістерська робота",
   },
  },
  ["onday"]={
   ["labels"]={
    ["ca"]="el",
    ["cnr"]="На дан",
    ["cnr-latn"]="Na dan",
    ["comment"]="empty string means not used in the given language; to be checked: cnr, fa, sl, sr; gr: εκείνη την ημέρα -- ?? / spíš ne",
    ["cs"]="dne",
    ["en"]="",
    ["es"]="el",
    ["fa"]="در روز",
    ["fi"]="",
    ["fr"]="le",
    ["gr"]="",
    ["hy"]="",
    ["id"]="pada",
    ["lt"]="",
    ["ml"]="pada hari",
    ["pt"]="á",
    ["ro"]="în data de",
    ["sl"]="na dan",
    ["sk"]="dňa",
    ["sq"]="më",
    ["sr"]="На дан",
    ["sr-latn"]="Na dan",
    ["ua"]="дня",
   },
  },
  ["phdthesis"]={
   ["labels"]={
    ["ca"]="Tesi doctoral",
    ["cnr"]="Докторат",
    ["cnr-latn"]="Doktorat",
    ["comment"]="fi:or Väitöskirja PhD",
    ["cs"]="Doktorská práce",
    ["en"]="PhD~Thesis",
    ["es"]="Tesis de doctorado",
    ["fa"]="پایان<200C>نامه دکتری",
    ["fi"]="Väitöskirja",
    ["fr"]="Thèse de doctorat",
    ["gr"]="Διδακτορική διατριβή",
    ["hy"]="Դոկտորական թեզ",
    ["id"]="Disertasi",
    ["lt"]="Daktaro disertacija",
    ["ml"]="Tesis PhD",
    ["pt"]="Tese de Douturamento",
    ["ro"]="Teză de doctorat",
    ["sl"]="Doktorska disertacija",
    ["sk"]="Doktorská práca",
    ["sq"]="Tema e doktoratures",
    ["sr"]="Докторат",
    ["sr-latn"]="Doktorat",
    ["ua"]="Докторська робота",
   },
  },
  ["project"]={
   ["labels"]={
    ["ca"]="Projecte",
    ["cnr"]="Пројекат",
    ["cnr-latn"]="Projekat",
    ["cs"]="Projekt",
    ["en"]="Project",
    ["es"]="Proyecto",
    ["fa"]="پروژه",
    ["fi"]="Projekti",
    ["fr"]="Projet",
    ["gr"]="Σχέδιο",
    ["hy"]="Նախագիծ",
    ["id"]="Proyek",
    ["lt"]="Projektas",
    ["ml"]="Projek",
    ["pt"]="Projeto",
    ["ro"]="Proiect",
    ["sl"]="Projekt",
    ["sk"]="Projekt",
    ["sq"]="Projekt",
    ["sr"]="Пројекат",
    ["sr-latn"]="Projekat",
    ["ua"]="Проєкт",
   },
  },
  ["report"]={
   ["labels"]={
    ["ca"]="Informe",
    ["cnr"]="Извјештај",
    ["cnr-latn"]="Izvještaj",
    ["cs"]="Protokol",
    ["en"]="Report",
    ["es"]="Informe",
    ["fa"]="گزارش",
    ["fi"]="Reportti",
    ["fr"]="Rapport",
    ["gr"]="Αναφορά",
    ["hy"]="Զեկույց",
    ["id"]="Laporan",
    ["lt"]="protokolas",
    ["ml"]="Laporan",
    ["pt"]="Reporte",
    ["ro"]="Raport",
    ["sl"]="Poročilo",
    ["sk"]="Protokol",
    ["sq"]="Raport",
    ["sr"]="Извештај",
    ["sr-latn"]="Izveštaj",
    ["ua"]="Протокол",
   },
  },
  ["seminarthesis"]={
   ["labels"]={
    ["ca"]="Tesi de seminari",
    ["cnr"]="Семинарски рад",
    ["cnr-latn"]="Seminarski rad",
    ["cs"]="Seminární práce",
    ["en"]="Seminar Thesis",
    ["es"]="Tesis de seminario",
    ["fa"]="پایان<200C>نامه سمینار",
    ["fi"]="Seminaarin opinnäytetyö",
    ["fr"]="",
    ["gr"]="Εργασία σεμιναρίου",
    ["hy"]="Սեմինարային աշխատանք",
    ["id"]="Tesis Seminar",
    ["lt"]="Seminaro baigiamasis darbas",
    ["ml"]="Tesis Seminar",
    ["pt"]="Tese de seminario",
    ["ro"]="Teză de seminar",
    ["sl"]="Seminarska naloga",
    ["sk"]="Seminárna práca",
    ["sq"]="Tema e seminarit",
    ["sr"]="Семинарски рад",
    ["sr-latn"]="Seminarski rad",
    ["ua"]="Семінарська робота",
   },
  },
  ["signature"]={
   ["labels"]={
    ["ca"]="firma",
    ["cnr"]="Потпис",
    ["cnr-latn"]="Potpis",
    ["cs"]="podpis",
    ["en"]="signature",
    ["es"]="firma",
    ["fa"]="امضا",
    ["fi"]="Allekirjoitus",
    ["fr"]="signature",
    ["gr"]="Υπογραφή",
    ["hy"]="ստորագրություն",
    ["id"]="Tanda Tangan",
    ["lt"]="parašas",
    ["ml"]="tandatangan",
    ["pt"]="assinatura",
    ["ro"]="semnătură",
    ["sl"]="podpis",
    ["sk"]="podpis",
    ["sq"]="nënshkrimi",
    ["sr"]="Потпис",
    ["sr-latn"]="Potpis",
    ["ua"]="підпис",
   },
  },
  ["studentprofact"]={
   ["labels"]={
    ["ca"]="Activitats professionals de l'estudiant",
    ["cnr"]="Стручне активности ученика",
    ["cnr-latn"]="Stručne aktivnosti učenika",
    ["cs"]="Středoškolská odborná činnost",
    ["en"]="Students Professional Activities",
    ["es"]="Actividades profesionales del estudiante",
    ["fa"]="فعالیت<200C>های حرفه<200C>ای دانش<200C>آموزان",
    ["fi"]="Opiskelijoiden ammatillinen toiminta",
    ["fr"]="",
    ["gr"]="Επαγγελματικές δραστηριότητες των μαθητών",
    ["hy"]="Ուսանողների մասնագիտական գործունեություն",
    ["id"]="Kegiatan Professional Mahasiswa",
    ["lt"]="Studentų profesinė veikla",
    ["ml"]="Aktiviti Profesional Pelajar",
    ["pt"]="Atividades profissionais do estudante",
    ["ro"]="Activități profesionale pentru studenți",
    ["sl"]="Strokovne dejavnosti študentov",
    ["sk"]="Stredoškolská odborná činnosť",
    ["sq"]="Aktivitetet profesionale të studentit",
    ["sr"]="Стручне активности ученика",
    ["sr-latn"]="Stručne aktivnosti učenika",
    ["ua"]="Учнівська професійна діяльність",
   },
  },
  ["supervisor"]={
   ["labels"]={
    ["ca"]="Supervisor",
    ["cnr"]="Надзорник",
    ["cnr-latn"]="Nadzornik",
    ["cs"]="Vedoucí práce",
    ["en"]="Supervisor",
    ["es"]="Supervisor",
    ["fa"]="سرپرست",
    ["fi"]="Valvoja",
    ["fr"]="Superviseur",
    ["gr"]="Επόπτης",
    ["hy"]="Ղեկավար",
    ["id"]="Pengawas",
    ["lt"]="Darbo vadovas",
    ["ml"]="Penyelia",
    ["pt"]="Supervisor",
    ["ro"]="Supervizor",
    ["sl"]="Nadzornik",
    ["sk"]="Vedúci práce",
    ["sq"]="Mbikqyrës",
    ["sr"]="Надзорник",
    ["sr-latn"]="Nadzornik",
    ["ua"]="Керівник роботи",
   },
  },
  ["where"]={
   ["labels"]={
    ["ca"]="A",
    ["cnr"]="",
    ["cnr-latn"]="",
    ["cs"]="V",
    ["en"]="",
    ["es"]="En",
    ["fa"]="در",
    ["fi"]="",
    ["fr"]="à",
    ["gr"]="", --που --ko? --asi ne
    ["hy"]="",
    ["id"]="Di",
    ["lt"]="Kur",
    ["ml"]="Di",
    ["pt"]="Em",
    ["ro"]="Le",
    ["sl"]="V",
    ["sk"]="V",
    ["sq"]="Në",
    ["sr"]="",
    ["sr-latn"]="",
    ["ua"]="У",
   },
  },
 },
 ["titles"]={
  ["abbreviations"]={
   ["labels"]={
    ["af"]="Afkortings",
    ["ar"]="الاختصارات",
    ["be"]="Спіс скарачэнняў",
    ["bg"]="Съкращения",
    ["ca"]="Abreviacions",
    ["cn"]="缩略语",
    ["cnr"]="Скраћенице",
    ["cnr-latn"]="Skraćenice",
    ["cs"]="Seznam zkratek",
    ["da"]="Forkortelser",
    ["de"]="Abkürzungen",
    ["en"]="Abbreviations",
    ["eo"]="Mallongigoj",
    ["es"]="Abreviaturas",
    ["et"]="Lühend",
    ["fa"]="نشانه‌های اختصاری",
    ["fi"]="Lyhennyksi",
    ["fr"]="Abréviations",
    ["gr"]="Συντομογραφίες",
    ["hr"]="Kratice",
    ["hu"]="Rövidítések",
    ["hy"]="Հապավումներ",
    ["id"]="Singkatan",
    ["it"]="Abbreviazioni",
    ["ja"]="略語",
    ["kr"]="약어",
    ["la"]="Notae",
    ["lt"]="Santrumpos",
    ["mk"]="Скратеници",
    ["ms"]="Singkatan",
    ["nb"]="Forkortelser",
    ["nl"]="Afkortingen",
    ["nn"]="Forkortingar",
    ["pl"]="Wykaz skrótów",
    ["pt"]="Abreviaturas",
    ["ro"]="Abrevieri",
    ["ru"]="Список сокращений",
    ["sk"]="Zoznam skratiek",
    ["sl"]="Kratice",
    ["sq"]="Shkurtesë",
    ["sr"]="Скраћенице",
    ["sr-latn"]="Skraćenice",
    ["sv"]="Förkortningar",
    ["tk"]="Gysgaltmalar",
    ["tr"]="Kısaltmalar",
    ["ua"]="Перелік скорочень",
    ["vi"]="Chữ viết tắt",
   },
  },
  ["content"]={
   ["labels"]={
    ["af"]="Inhoud",
    ["ar"]="المحتويات",
    ["be"]="Змест",
    ["bg"]="Съдържание",
    ["ca"]="Índex de continguts",
    ["cn"]="目录",
    ["cnr"]="Садржај",
    ["cnr-latn"]="Sadržaj",
    ["cs"]="Obsah",
    ["da"]="Indhold",
    ["de"]="Inhalt",
    ["en"]="Contents",
    ["eo"]="Enhavo",
    ["es"]="Contenido",
    ["et"]="Sisu",
    ["fa"]="فهرست مطالب",
    ["fi"]="Sisällys",
    ["fr"]="Table des matières",
    ["gr"]="Περιεχόμενα",
    ["hr"]="Sadržaj",
    ["hu"]="Tartalom",
    ["hy"]="Բովանդակություն",
    ["id"]="Konten",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="목차",
    ["la"]="Quod in libro continetur",
    ["lt"]="Turinys",
    ["mk"]="Содржина",
    ["ms"]="Kandungan",
    ["nb"]="Innhold",
    ["nl"]="Inhoud",
    ["nn"]="Innhald",
    ["pl"]="Spis treści",
    ["pt"]="Conteúdo",
    ["ro"]="Cuprins",
    ["ru"]="Содержание",
    ["sk"]="Obsah",
    ["sl"]="Kazalo",
    ["sq"]="Përmbajtja",
    ["sr"]="Садржај",
    ["sr-latn"]="Sadržaj",
    ["sv"]="Innehåll",
    ["tk"]="Mazmuny",
    ["tr"]="Fihrist",
    ["ua"]="Зміст",
    ["vi"]="Mục lục",
   },
  },
  ["figures"]={
   ["labels"]={
    ["af"]="Figure",
    ["ar"]="الأشكال",
    ["be"]="Спіс ілюстрацый",
    ["ca"]="Figures",
    ["cn"]="图",
    ["cnr"]="Слике",
    ["cnr-latn"]="Slike",
    ["cs"]="Seznam obrázků",
    ["da"]="Figurer",
    ["de"]="Abbildungen",
    ["en"]="Figures",
    ["eo"]="Figuroj",
    ["es"]="Figuras",
    ["et"]="Arvandmed",
    ["fa"]="فهرست اشکال",
    ["fi"]="Kuvi",
    ["fr"]="Figures",
    ["gr"]="Σχήματα",
    ["hr"]="Slike",
    ["hu"]="Ábrák",
    ["hy"]="Նկարազարդումներ",
    ["id"]="Gambar",
    ["it"]="Figure",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imagines",
    ["lt"]="Iliustracijos",
    ["mk"]="Листа на слики",
    ["ms"]="Angka",
    ["nb"]="Figurer",
    ["nl"]="Figuren",
    ["nn"]="Figurar",
    ["pl"]="Ilustracje",
    ["pt"]="Figuras",
    ["ro"]="Figuri",
    ["ru"]="Список иллюстраций",
    ["sk"]="Zoznam obrázkov",
    ["sl"]="Slike",
    ["sq"]="Figurat",
    ["sr"]="Слике",
    ["sr-latn"]="Slike",
    ["sv"]="Figurer",
    ["tk"]="Suratlar",
    ["tr"]="Şekiller",
    ["ua"]="Перелік ілюстрацій",
    ["vi"]="Danh sách hình vẽ",
   },
  },
  ["graphics"]={
   ["labels"]={
    ["af"]="Grafieke",
    ["ar"]="الرسوم",
    ["be"]="Графiка",
    ["bg"]="Графики",
    ["ca"]="Gràfiques",
    ["cn"]="图",
    ["cnr"]="Графици",
    ["cnr-latn"]="Grafici",
    ["cs"]="Seznam grafů",
    ["da"]="Grafik",
    ["de"]="Grafiken",
    ["en"]="Graphics",
    ["eo"]="Grafikoj",
    ["es"]="Gráficos",
    ["et"]="Graafika",
    ["fa"]="فهرست طرح‌ها",
    ["fi"]="Grafiikkaoi",
    ["fr"]="Graphiques",
    ["gr"]="Γραφικά",
    ["hr"]="Slike",
    ["hu"]="Grafikák",
    ["hy"]="Գծապատկեր",
    ["id"]="Grafik",
    ["it"]="Grafici",
    ["ja"]="グラフ",
    ["kr"]="그래픽 ",
    ["la"]="Typi",
    ["lt"]="Graphics",
    ["mk"]="Листа на графици",
    ["ms"]="Grafik",
    ["nb"]="Bilde",
    ["nl"]="Grafieken",
    ["nn"]="Bilete",
    ["pl"]="Grafiki",
    ["pt"]="Gráficos",
    ["ro"]="Grafice",
    ["ru"]="Список графиков",
    ["sk"]="Zoznam grafov",
    ["sl"]="Slike",
    ["sq"]="Grafike",
    ["sr"]="Графици",
    ["sr-latn"]="Grafici",
    ["sv"]="Grafik",
    ["tk"]="Grafikler",
    ["tr"]="Grafikler",
    ["ua"]="Перелік графіков",
    ["vi"]="Đồ thị",
   },
  },
  ["index"]={
   ["labels"]={
    ["af"]="Indeks",
    ["ar"]="الفهرس",
    ["be"]="Алфавітны паказальнік",
    ["bg"]="Индэкс",
    ["ca"]="Índex alfabètic",
    ["cn"]="索引",
    ["cnr"]="Индекс појмова",
    ["cnr-latn"]="Index pojmova",
    ["cs"]="Rejstřík",
    ["da"]="Indeks",
    ["de"]="Index",
    ["en"]="Index",
    ["eo"]="Indekso",
    ["es"]="Índice",
    ["et"]="Indeks",
    ["fa"]="نمایه",
    ["fi"]="Indeksiluku",
    ["fr"]="Index",
    ["gr"]="Ευρετήριο",
    ["hr"]="Indeks",
    ["hu"]="Index",
    ["hy"]="Այբբենական ցուցիչ",
    ["id"]="Indeks",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="찾아보기",
    ["la"]="Indices",
    ["lt"]="Rodyklė",
    ["mk"]="Индекс",
    ["ms"]="Indeks",
    ["nb"]="Register",
    ["nl"]="Index",
    ["nn"]="Register",
    ["pl"]="Indeks",
    ["pt"]="Índice",
    ["ro"]="Index",
    ["ru"]="Алфавитный указатель",
    ["sk"]="Register",
    ["sl"]="Stvarno kazalo",
    ["sq"]="Indeks",
    ["sr"]="Индекс појмова",
    ["sr-latn"]="Indeks pojmova",
    ["sv"]="Sakregister",
    ["tk"]="Indeks",
    ["tr"]="İndex",
    ["ua"]="Покажчик",
    ["vi"]="Chỉ số",
   },
  },
  ["intermezzi"]={
   ["labels"]={
    ["af"]="Intermezzos",
    ["ar"]="فسح",
    ["be"]="Спіс уставак",
    ["bg"]="Интермеца",
    ["ca"]="Intermedis",
    ["cn"]="퉣",
    ["cnr"]="Списак дигресија",
    ["cnr-latn"]="Spisak digresija",
    ["cs"]="Intermezza",
    ["da"]="Intermezzoer",
    ["de"]="Intermezzi",
    ["en"]="Intermezzos",
    ["eo"]="Intermezoj",
    ["es"]="Intermedios",
    ["et"]="Vahemängud",
    ["fi"]="Intermezzos",
    ["fr"]="Intermèdes",
    ["gr"]="Παύσεις",
    ["hr"]="Intermeci",
    ["hu"]="Intermezzok",
    ["hy"]="Ինտերլյուդներ",
    ["id"]="Selingan",
    ["it"]="Intermezzi",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissa",
    ["lt"]="Intermezzos",
    ["mk"]="Листа на дигресии",
    ["ms"]="Intermezzos",
    ["nb"]="Intermesso",
    ["nl"]="Intermezzo's",
    ["nn"]="Intermesso",
    ["pl"]="Intermezza",
    ["pt"]="Intermédios",
    ["ro"]="Intermzzo",
    ["ru"]="Список вставок",
    ["sk"]="Intermezzá",
    ["sl"]="Intermezzi",
    ["sq"]="Intermezzos",
    ["sr"]="Списак дигресија",
    ["sr-latn"]="Spisak digresija",
    ["sv"]="Intermezzon",
    ["tk"]="Arakesmeler",
    ["tr"]="",
    ["ua"]="Перелік вставок",
    ["vi"]="Intermezzos",
   },
  },
  ["logos"]={
   ["labels"]={
    ["af"]="Logos",
    ["ar"]="الشعارات",
    ["be"]="Лагатыпы",
    ["bg"]="Логотипи",
    ["ca"]="Logotips",
    ["cn"]="徽标",
    ["cnr"]="Логотипи",
    ["cnr-latn"]="Logotipi",
    ["cs"]="Loga",
    ["da"]="Logoer",
    ["de"]="Logos",
    ["en"]="Logos",
    ["eo"]="Markemblemoj",
    ["es"]="Logotipos",
    ["et"]="Logos",
    ["fa"]="فهرست لوگوها",
    ["fi"]="Vertauskuva",
    ["fr"]="Logos",
    ["gr"]="Λογότυπα",
    ["hr"]="Logotipi",
    ["hu"]="Fejlécek",
    ["hy"]="Լոգոներ",
    ["id"]="Logo",
    ["it"]="Logotipi",
    ["ja"]="理性",
    ["kr"]="이성",
    ["la"]="Typi negotiales",
    ["lt"]="Logos",
    ["mk"]="Логоа",
    ["ms"]="Logo",
    ["nb"]="Logoer",
    ["nl"]="Logo's",
    ["nn"]="Logoar",
    ["pl"]="Znaki",
    ["pt"]="Logotipos",
    ["ro"]="Logo-uri",
    ["ru"]="Логотипы",
    ["sk"]="Logá",
    ["sl"]="Logotipi",
    ["sq"]="Logot",
    ["sr"]="Логотипи",
    ["sr-latn"]="Logotipi",
    ["sv"]="Loggor",
    ["tk"]="Logolar",
    ["tr"]="Logolar",
    ["ua"]="Логотипи",
    ["vi"]="Biểu tượng",
   },
  },
  ["pubs"]={
   ["labels"]={
    ["af"]="",
    ["ca"]="Referències",
    ["cnr"]="Литература",
    ["cnr-latn"]="Literatura",
    ["cs"]="Literatura",
    ["da"]="",
    ["de"]="Literatur",
    ["en"]="References",
    ["eo"]="Referencoj",
    ["es"]="Bibliografía",
    ["et"]="Viited",
    ["fa"]="کتاب‌نامه",
    ["fi"]="Viittet",
    ["fr"]="Bibliographie",
    ["gr"]="Παραπομπές",
    ["hr"]="Literatura",
    ["hu"]="Bibliográfia",
    ["hy"]="Գրականութիւն",
    ["id"]="Referensi",
    ["it"]="Bibliografia",
    ["kr"]="참고문헌",
    ["la"]="",
    ["lt"]="Literatūra",
    ["mk"]="Литература",
    ["ms"]="Rujukan",
    ["nb"]="",
    ["nl"]="Literatuur",
    ["nn"]="",
    ["pl"]="Bibliografia",
    ["pt"]="Referencias",
    ["ro"]="Referințe",
    ["ru"]="",
    ["sk"]="Literatúra",
    ["sl"]="Literatura",
    ["sq"]="Referencat",
    ["sr"]="Литература",
    ["sr-latn"]="Literatura",
    ["sv"]="Litteraturförteckning",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="Посилання",
    ["vi"]="",
   },
  },
  ["tables"]={
   ["labels"]={
    ["af"]="Tabelle",
    ["ar"]="الجداول",
    ["be"]="Спіс табліц",
    ["ca"]="Taules",
    ["cn"]="表格",
    ["cnr"]="Табеле",
    ["cnr-latn"]="Tabele",
    ["cs"]="Seznam tabulek",
    ["da"]="Tabeller",
    ["de"]="Tabellen",
    ["en"]="Tables",
    ["eo"]="Tabeloj",
    ["es"]="Tablas",
    ["et"]="Tabelid",
    ["fa"]="فهرست جداول",
    ["fi"]="Taulukkoj",
    ["fr"]="Tableaux",
    ["gr"]="Πίνακες",
    ["hr"]="Tablice",
    ["hu"]="Táblázatok",
    ["hy"]="Աղյուսակներ",
    ["id"]="Tabel",
    ["it"]="Tabelle",
    ["ja"]="机",
    ["kr"]="표 ",
    ["la"]="Tabulae",
    ["lt"]="Lentelės",
    ["mk"]="Листа на табели",
    ["ms"]="Tables",
    ["nb"]="Tabeller",
    ["nl"]="Tabellen",
    ["nn"]="Tabellar",
    ["pl"]="Tabele",
    ["pt"]="Tabelas",
    ["ro"]="Tabele",
    ["ru"]="Список таблиц",
    ["sk"]="Zoznam tabuliek",
    ["sl"]="Tabele",
    ["sq"]="Tabelat",
    ["sr"]="Табеле",
    ["sr-latn"]="Tabele",
    ["sv"]="Tabeller",
    ["tk"]="Tablisalar",
    ["tr"]="Tablolar",
    ["ua"]="Перелік таблиць",
    ["vi"]="Danh sách bảng",
   },
  },
  ["units"]={
   ["labels"]={
    ["af"]="Eenhede",
    ["ar"]="الوحدات",
    ["be"]="Адзінкі вымярэння",
    ["bg"]="Адзінкі",
    ["ca"]="Unitats",
    ["cn"]="计量单位",
    ["cnr"]="Јединице",
    ["cnr-latn"]="Jedinice",
    ["cs"]="Jednotky",
    ["da"]="Enheder",
    ["de"]="Einheiten",
    ["en"]="Units",
    ["eo"]="Unuoj",
    ["es"]="Unidades",
    ["et"]="Ühikud",
    ["fa"]="واحدها",
    ["fi"]="Yksiköt",
    ["fr"]="Unités",
    ["gr"]="Μονάδες",
    ["hr"]="Jedinice",
    ["hu"]="Mértékegységek",
    ["hy"]="Չափման միավորներ",
    ["id"]="Satuan",
    ["it"]="Unità",
    ["ja"]="ユニッツ",
    ["kr"]="측정단위",
    ["la"]="Modi",
    ["lt"]="Units",
    ["mk"]="Единици",
    ["ms"]="Unit",
    ["nb"]="Enheter",
    ["nl"]="Eenheden",
    ["nn"]="Einingar",
    ["pl"]="Jednostki",
    ["pt"]="Unidades",
    ["ro"]="Unități",
    ["ru"]="Единицы измерения",
    ["sk"]="Jednotky",
    ["sl"]="Enote",
    ["sq"]="Njësitë",
    ["sr"]="Јединице",
    ["sr-latn"]="Jedinice",
    ["sv"]="Enheter",
    ["tk"]="Birlikler",
    ["tr"]="Birimler",
    ["ua"]="Одиниці виміру",
    ["vi"]="Đơn vị",
   },
  },
 },
}

local functions = data.labels.functions

functions.asin   = functions.arcsin
functions.acos   = functions.arccos
functions.atan   = functions.arctan
functions.asinh  = functions.arcsinh
functions.acosh  = functions.arccosh
functions.atanh  = functions.arctanh

functions.tg     = functions.tan
functions.ctg    = functions.cot
functions.arctg  = functions.arctan
functions.arcctg = functions.arccot
functions.arctgh = functions.arctanh

