/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkReconstructionByErosionImageFilter_h
#define sitkReconstructionByErosionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ReconstructionByErosionImageFilter
\brief grayscale reconstruction by erosion of an image

Reconstruction by erosion operates on a "marker" image and a "mask" image, and is defined as the erosion of the marker image with respect to the mask image iterated until stability.

The marker image must be less than or equal to the mask image (on a pixel by pixel basis).

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's book "Morphological Image Analysis: Principles and Applications", Second Edition, Springer, 2003.

Algorithm implemented in this filter is based on algorithm described by Kevin Robinson and Paul F. Whelan in "Efficient Morphological
 Reconstruction: A Downhill Filter", Pattern Recognition Letters, Volume 25, Issue 15, November 2004, Pages 1759-1767.

The algorithm, a description of the transform and some applications can be found in "Morphological Grayscale Reconstruction in Image Analysis:
 Applications and Efficient Algorithms", Luc Vincent, IEEE Transactions on image processing, Vol. 2, April 1993.

\author Richard Beare. Department of Medicine, Monash University, Melbourne, Australia.


\see MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByErosionImageFilter , OpeningByReconstructionImageFilter , ClosingByReconstructionImageFilter , ReconstructionImageFilter
\sa itk::simple::ReconstructionByErosion for the procedural interface
\sa itk::ReconstructionByErosionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ReconstructionByErosionImageFilter : public ImageFilter {
    public:
      using Self = ReconstructionByErosionImageFilter;

      /** Destructor */
      virtual ~ReconstructionByErosionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ReconstructionByErosionImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       */
      bool GetFullyConnected() const { return this->m_FullyConnected; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseInternalCopy ( bool UseInternalCopy ) { this->m_UseInternalCopy = UseInternalCopy; return *this; }

      /** Set the value of UseInternalCopy to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseInternalCopyOn() { return this->SetUseInternalCopy(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseInternalCopyOff() { return this->SetUseInternalCopy(false); }

      /**
       */
      bool GetUseInternalCopy() const { return this->m_UseInternalCopy; }

      /** Name of this class */
      std::string GetName() const { return std::string ("ReconstructionByErosionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image & markerImage, const Image & maskImage );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image * markerImage, const Image * maskImage );
      template <class TImageType> Image ExecuteInternal ( const Image * markerImage, const Image * maskImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_FullyConnected{false};

      bool  m_UseInternalCopy{true};


    };

    /**\
     * \brief grayscale reconstruction by erosion of an image
     *
     * This function directly calls the execute method of ReconstructionByErosionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ReconstructionByErosionImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image ReconstructionByErosion ( const Image & markerImage, const Image & maskImage, bool fullyConnected = false, bool useInternalCopy = true );

     /** @} */
}
#endif
