if(WIN32)
    string(REGEX MATCH "^([0-9]+)" CMAKE_CXX_COMPILER_VERSION_MAJOR "${CMAKE_CXX_COMPILER_VERSION}")

    if (CMAKE_SIZEOF_VOID_P EQUAL 8)
      set(Arch "x64")
    else()
        set(Arch "x86")
    endif()

    set(BASE_OUT_DIR "${CMAKE_CURRENT_BINARY_DIR}/../b_Qt${Qt6_VERSION}_${CMAKE_CXX_COMPILER_ID}${CMAKE_CXX_COMPILER_VERSION_MAJOR}_${Arch}")

    set(CMAKE_BINARY_DIR "${BASE_OUT_DIR}")
    set(CMAKE_RUNTIME_OUTPUT_DIRECTORY "${BASE_OUT_DIR}/runtime")
    set(LIBRARY_OUTPUT_PATH "${BASE_OUT_DIR}/lib")
    set(CMAKE_BUILD_FILES_DIRECTORY "${BASE_OUT_DIR}/cBuild")
    set(QT_QML_OUTPUT_DIRECTORY "${BASE_OUT_DIR}/qmlOut")
    set(EXECUTABLE_OUTPUT_PATH "${BASE_OUT_DIR}/target")
endif()
