// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// Qt-Security score:significant reason:default

import QtQuick
import QtQuick.Templates as T

T.Action {
    text: qsTr("Paste")
    icon.name: "edit-paste"
    icon.width: 24
    icon.height: 24
    shortcut: StandardKey.Paste
    enabled: !editor.readOnly && editor.hasOwnProperty("paste")
    onTriggered: editor.paste()

    required property var editor
}
