from _typeshed import StrPath
from pathlib import Path
from re import Match, Pattern
from typing import ClassVar, Final

from docutils import nodes
from docutils.parsers.rst import Directive
from docutils.parsers.rst.states import SpecializedBody

__docformat__: Final = "reStructuredText"

def adapt_path(path: str, source: StrPath = "", root_prefix: StrPath = "") -> str: ...

class Include(Directive):
    standard_include_path: Path
    def read_file(self, path: StrPath) -> str: ...
    def as_literal_block(self, text: str) -> list[nodes.literal_block]: ...
    def as_code_block(self, text: str) -> list[nodes.literal_block]: ...
    def custom_parse(self, text: str) -> list[nodes.Node]: ...
    def insert_into_input_lines(self, text: str) -> None: ...

class Raw(Directive): ...
class Replace(Directive): ...

class Unicode(Directive):
    comment_pattern: Pattern[str]

class Class(Directive): ...

class Role(Directive):
    argument_pattern: Pattern[str]

class DefaultRole(Directive): ...
class Title(Directive): ...

class MetaBody(SpecializedBody):
    def field_marker(  # type: ignore[override]
        self, match: Match[str], context: list[str], next_state: str | None
    ) -> tuple[list[str], str | None, list[str]]: ...
    def parsemeta(self, match: Match[str]): ...

class Meta(Directive):
    SMkwargs: ClassVar[dict[str, tuple[MetaBody]]]

class Date(Directive): ...
class TestDirective(Directive): ...
