/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.ast.PyAstTypeParameter;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypeHintsInspection;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyNewStyleGenericSyntaxInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyNewStyleGenericSyntaxInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/inspections/PyNewStyleGenericSyntaxInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyTypeParameter", "", "typeParameter", "Lcom/jetbrains/python/psi/PyTypeParameter;", "visitPyTypeParameterList", "node", "Lcom/jetbrains/python/psi/PyTypeParameterList;", "visitPyTypeAliasStatement", "Lcom/jetbrains/python/psi/PyTypeAliasStatement;", "visitPyFunction", "Lcom/jetbrains/python/psi/PyFunction;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "reportOldStyleTypeVarsUsage", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "reportAssignmentExpressions", "getTypeParameterType", "Lcom/jetbrains/python/psi/types/PyTypeParameterType;", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyNewStyleGenericSyntaxInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyNewStyleGenericSyntaxInspection.kt\ncom/jetbrains/python/inspections/PyNewStyleGenericSyntaxInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n4225#2,11:191\n13805#2,2:217\n1617#3,9:202\n1869#3:211\n1870#3:213\n1626#3:214\n1869#3,2:215\n1869#3,2:219\n1#4:212\n*S KotlinDebug\n*F\n+ 1 PyNewStyleGenericSyntaxInspection.kt\ncom/jetbrains/python/inspections/PyNewStyleGenericSyntaxInspection$Visitor\n*L\n120#1:191,11\n138#1:217,2\n121#1:202,9\n121#1:211\n121#1:213\n121#1:214\n122#1:215,2\n180#1:219,2\n121#1:212\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyTypeParameter(@NotNull PyTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            PyExpression boundExpression = typeParameter.getBoundExpression();
            PyExpression defaultExpression = typeParameter.getDefaultExpression();
            PyExpression pyExpression = boundExpression;
            if (pyExpression != null) {
                pyExpression.accept((PsiElementVisitor)new PyRecursiveElementVisitor(boundExpression, this){
                    final /* synthetic */ PyExpression $boundExpression;
                    final /* synthetic */ Visitor this$0;
                    {
                        this.$boundExpression = $boundExpression;
                        this.this$0 = $receiver;
                    }

                    public void visitPyElement(PyElement node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!(node instanceof PyParenthesizedExpression && node == this.$boundExpression || node instanceof PyTupleExpression && ((PyTupleExpression)node).getParent() == this.$boundExpression || !(node instanceof PyExpression))) {
                            PyExpression pyExpression = (PyExpression)node;
                            TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                            if (!PyTypeHintsInspection.Companion.isValidTypeHint(pyExpression, typeEvalContext)) {
                                this.this$0.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.type.hints.invalid.type.expression", new Object[0]));
                            }
                            if (node instanceof PyReferenceExpression) {
                                PyTypeParameterType pyTypeParameterType = Visitor.access$getTypeParameterType(this.this$0, (PyReferenceExpression)node);
                                if (pyTypeParameterType != null) {
                                    PyTypeParameterType pyTypeParameterType2 = pyTypeParameterType;
                                    Visitor visitor = this.this$0;
                                    PyTypeParameterType it = pyTypeParameterType2;
                                    boolean bl = false;
                                    visitor.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.new.style.generics.are.not.allowed.inside.type.param.bounds", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                                }
                            }
                        }
                        super.visitPyElement(node);
                    }
                });
            }
            if (defaultExpression != null) {
                ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)typeParameter);
                if (scopeOwner == null) {
                    return;
                }
                defaultExpression.accept((PsiElementVisitor)new PyRecursiveElementVisitor(this, scopeOwner){
                    final /* synthetic */ Visitor this$0;
                    final /* synthetic */ ScopeOwner $scopeOwner;
                    {
                        this.this$0 = $receiver;
                        this.$scopeOwner = $scopeOwner;
                    }

                    public void visitPyReferenceExpression(PyReferenceExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PyTypeParameterType pyTypeParameterType = Visitor.access$getTypeParameterType(this.this$0, node);
                        if (pyTypeParameterType != null) {
                            PyTypeParameterType pyTypeParameterType2 = pyTypeParameterType;
                            ScopeOwner scopeOwner = this.$scopeOwner;
                            Visitor visitor = this.this$0;
                            PyTypeParameterType it = pyTypeParameterType2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)scopeOwner, (Object)it.getScopeOwner()) || it.getDeclarationElement() instanceof PyTargetExpression) {
                                Object[] objectArray = new Object[]{node.getName()};
                                visitor.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.new.style.type.parameter.out.of.scope", objectArray), ProblemHighlightType.WARNING);
                            }
                        }
                        super.visitPyReferenceExpression(node);
                    }
                });
            }
        }

        public void visitPyTypeParameterList(@NotNull PyTypeParameterList node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List list = node.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeParameters(...)");
            List typeParameters = list;
            boolean lastIsDefault = false;
            boolean lastIsTypeVarTuple = false;
            for (PyTypeParameter typeParameter : typeParameters) {
                if (typeParameter.getDefaultExpressionText() != null) {
                    lastIsDefault = true;
                    if (lastIsTypeVarTuple && typeParameter.getKind() == PyAstTypeParameter.Kind.TypeVar) {
                        this.registerProblem((PsiElement)typeParameter, PyPsiBundle.message("INSP.type.hints.default.type.var.cannot.follow.type.var.tuple", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                    }
                } else if (lastIsDefault) {
                    this.registerProblem((PsiElement)typeParameter, PyPsiBundle.message("INSP.type.hints.non.default.type.vars.cannot.follow.defaults", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                }
                lastIsTypeVarTuple = typeParameter.getKind() == PyAstTypeParameter.Kind.TypeVarTuple;
            }
        }

        public void visitPyTypeAliasStatement(@NotNull PyTypeAliasStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression typeExpression = node.getTypeExpression();
            if (typeExpression != null) {
                PsiElement psiElement = (PsiElement)typeExpression;
                String string = PyPsiBundle.message("INSP.new.style.generics.old.style.type.vars.not.allowed.in.new.style.type.aliases", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportOldStyleTypeVarsUsage(psiElement, string);
                PsiElement psiElement2 = (PsiElement)typeExpression;
                String string2 = PyPsiBundle.message("INSP.new.style.generics.assignment.expressions.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this.reportAssignmentExpressions(psiElement2, string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitPyFunction(@NotNull PyFunction node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyAnnotation returnTypeAnnotation = (PyAnnotation)node.getAnnotation();
            PyTypeParameterList typeParameterList = (PyTypeParameterList)node.getTypeParameterList();
            if (typeParameterList != null) {
                void $this$forEach$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                PyAstParameterList pyAstParameterList = node.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstParameterList, (String)"getParameterList(...)");
                PsiElement psiElement = (PsiElement)pyAstParameterList;
                String string = PyPsiBundle.message("INSP.new.style.generics.mixing.old.style.and.new.style.type.vars.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportOldStyleTypeVarsUsage(psiElement, string);
                PyParameter[] pyParameterArray = ((PyParameterList)node.getParameterList()).getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)pyParameterArray, (String)"getParameters(...)");
                Object[] objectArray = pyParameterArray;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PyNamedParameter)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PyAnnotation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    PyNamedParameter it = (PyNamedParameter)element$iv$iv;
                    boolean bl2 = false;
                    if ((PyAnnotation)it.getAnnotation() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyAnnotation annotation = (PyAnnotation)element$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = (PsiElement)annotation;
                    String string2 = PyPsiBundle.message("INSP.new.style.generics.assignment.expressions.not.allowed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.reportAssignmentExpressions(psiElement2, string2);
                }
                if (returnTypeAnnotation != null) {
                    PsiElement psiElement3 = (PsiElement)returnTypeAnnotation;
                    String string3 = PyPsiBundle.message("INSP.new.style.generics.mixing.old.style.and.new.style.type.vars.not.allowed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    this.reportOldStyleTypeVarsUsage(psiElement3, string3);
                    PsiElement psiElement4 = (PsiElement)returnTypeAnnotation;
                    String string4 = PyPsiBundle.message("INSP.new.style.generics.assignment.expressions.not.allowed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    this.reportAssignmentExpressions(psiElement4, string4);
                }
            }
        }

        public void visitPyClass(@NotNull PyClass node) {
            PyArgumentList superClassExpressionList;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getTypeParameterList() != null && (superClassExpressionList = node.getSuperClassExpressionList()) != null) {
                PyExpression[] pyExpressionArray = node.getSuperClassExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getSuperClassExpressions(...)");
                Object[] $this$forEach$iv = pyExpressionArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyExpression ancestor = (PyExpression)element$iv;
                    boolean bl = false;
                    PyExpression reference = ancestor instanceof PySubscriptionExpression ? ((PySubscriptionExpression)ancestor).getOperand() : ancestor;
                    PyType type = this.myTypeEvalContext.getType((PyTypedElement)reference);
                    if (!(type instanceof PyClassLikeType)) continue;
                    String qName = ((PyClassLikeType)type).getClassQName();
                    if (Intrinsics.areEqual((Object)"typing.Generic", (Object)qName)) {
                        this.registerProblem((PsiElement)ancestor, PyPsiBundle.message("INSP.new.style.generics.classes.with.type.param.list.should.not.extend.generic", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                    if (!Intrinsics.areEqual((Object)"typing.Protocol", (Object)qName) && !Intrinsics.areEqual((Object)"typing_extensions.Protocol", (Object)qName) || !(ancestor instanceof PySubscriptionExpression)) continue;
                    this.registerProblem((PsiElement)((PySubscriptionExpression)ancestor).getIndexExpression(), PyPsiBundle.message("INSP.new.style.generics.extending.protocol.does.not.need.parameterization", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
                PsiElement psiElement = (PsiElement)superClassExpressionList;
                String string = PyPsiBundle.message("INSP.new.style.generics.mixing.old.style.and.new.style.type.vars.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportOldStyleTypeVarsUsage(psiElement, string);
                PsiElement psiElement2 = (PsiElement)superClassExpressionList;
                String string2 = PyPsiBundle.message("INSP.new.style.generics.assignment.expressions.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this.reportAssignmentExpressions(psiElement2, string2);
            }
        }

        private final void reportOldStyleTypeVarsUsage(PsiElement element, @InspectionMessage String message) {
            element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(this, message){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ String $message;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                }

                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PyTypeParameterType pyTypeParameterType = Visitor.access$getTypeParameterType(this.this$0, node);
                        if (pyTypeParameterType == null) break block1;
                        PyTypeParameterType pyTypeParameterType2 = pyTypeParameterType;
                        Visitor visitor = this.this$0;
                        String string = this.$message;
                        PyTypeParameterType it = pyTypeParameterType2;
                        boolean bl = false;
                        if (it.getDeclarationElement() instanceof PyTargetExpression && !(ScopeUtil.getScopeOwner((PsiElement)it.getDeclarationElement()) instanceof PyTypeAliasStatement)) {
                            visitor.registerProblem((PsiElement)node, string, ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                }
            });
        }

        private final void reportAssignmentExpressions(PsiElement element, @InspectionMessage String message) {
            Class[] classArray = new Class[]{PyAssignmentExpression.class};
            Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (boolean)false, (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyAssignmentExpression assignmentExpr = (PyAssignmentExpression)element$iv;
                boolean bl = false;
                this.registerProblem((PsiElement)assignmentExpr, message, ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final PyTypeParameterType getTypeParameterType(PyReferenceExpression $this$getTypeParameterType) {
            Object object = Ref.deref(PyTypingTypeProvider.getType((PyExpression)$this$getTypeParameterType, this.myTypeEvalContext));
            return object instanceof PyTypeParameterType ? (PyTypeParameterType)object : null;
        }

        public static final /* synthetic */ PyTypeParameterType access$getTypeParameterType(Visitor $this, PyReferenceExpression $receiver) {
            return $this.getTypeParameterType($receiver);
        }
    }
}

