/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import net.sourceforge.plantuml.preproc.Stdlib;

public class FutureBufferedImage {
    private final int width;
    private final int height;
    private final List<Integer> colors;
    private byte[] data;
    private BufferedImage image;

    public FutureBufferedImage(List<Integer> colors, int width, int height, byte[] data) {
        this.colors = colors;
        this.width = width;
        this.height = height;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getNow() {
        FutureBufferedImage futureBufferedImage = this;
        synchronized (futureBufferedImage) {
            if (this.image == null) {
                this.image = new BufferedImage(this.width, this.height, 2);
                try (ByteArrayInputStream is = new ByteArrayInputStream(this.data);){
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            int rgb = this.colors.get(Stdlib.read2bytes(is));
                            this.image.setRGB(x, y, rgb);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.data = null;
            }
        }
        return this.image;
    }
}

