/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AES {
    public static final Algorithm ALGORITHM = FipsAES.ALGORITHM;
    public static final Parameters OpenPGPCFB = new Parameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.OpenPGPCFB));
    public static final AuthParameters OCB = new AuthParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.OCB));
    public static final AuthParameters EAX = new AuthParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.EAX));
    public static final WrapParameters RFC3211_WRAP = new WrapParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.RFC3211_WRAP));

    private AES() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalKeyException("AES key must be of length 128, 192, or 256");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, FipsAES.ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean bl, SymmetricKey symmetricKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardWrapper(bl, AES.validateKey(symmetricKey, wrapParameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), wrapParameters, secureRandom);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean bl, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl, AES.validateKey(symmetricKey, authParameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), (AuthenticationParametersWithIV)authParameters);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl, AES.validateKey(symmetricKey, parameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), (ParametersWithIV)parameters, secureRandom);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final FipsAES.KeyGenerator keyGen;

        public KeyGenerator(GeneralParameters generalParameters, int n, SecureRandom secureRandom) {
            this.algorithm = (GeneralAlgorithm)generalParameters.getAlgorithm();
            this.keyGen = new FipsAES.KeyGenerator(n, secureRandom);
        }

        @Override
        public SymmetricKey doGenerateKey() {
            return new SymmetricSecretKey(this.algorithm, this.keyGen.generateKey().getKeyBytes());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class WrapParameters
    extends GeneralParametersWithIV<WrapParameters> {
        WrapParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        private WrapParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 16, byArray);
            ((Mode)generalAlgorithm.basicVariation()).checkIv(byArray, 16);
        }

        @Override
        WrapParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new WrapParameters(generalAlgorithm, byArray);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            super(generalAlgorithm, 16, byArray, n);
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 128));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            return new AuthParameters(generalAlgorithm, byArray, n);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 16, byArray);
            ((Mode)generalAlgorithm.basicVariation()).checkIv(byArray, 16);
        }

        @Override
        Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }
}

