/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.CharacterRule;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class CharacterCharacteristicsRule
implements Rule {
    public static final String ERROR_CODE = "INSUFFICIENT_CHARACTERISTICS";
    private List<CharacterRule> rules;
    private int numCharacteristics = 1;
    private boolean reportFailure = true;
    private boolean reportRuleFailures = true;

    public CharacterCharacteristicsRule() {
        this.rules = new ArrayList<CharacterRule>();
    }

    public CharacterCharacteristicsRule(CharacterRule ... r) {
        this(1, r);
    }

    public CharacterCharacteristicsRule(List<CharacterRule> l) {
        this(1, l);
    }

    public CharacterCharacteristicsRule(int n, CharacterRule ... r) {
        this(n, Arrays.asList(r));
    }

    public CharacterCharacteristicsRule(int n, List<CharacterRule> l) {
        this.setNumberOfCharacteristics(n);
        this.setRules(l);
    }

    public List<CharacterRule> getRules() {
        return this.rules;
    }

    public void setRules(List<CharacterRule> l) {
        this.rules = l;
    }

    public void setRules(CharacterRule ... r) {
        this.rules = Arrays.asList(r);
    }

    public void setNumberOfCharacteristics(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacteristics = n;
    }

    public boolean getReportFailure() {
        return this.reportFailure;
    }

    public void setReportFailure(boolean b) {
        this.reportFailure = b;
    }

    public int getNumberOfCharacteristics() {
        return this.numCharacteristics;
    }

    public boolean getReportRuleFailures() {
        return this.reportRuleFailures;
    }

    public void setReportRuleFailures(boolean b) {
        this.reportRuleFailures = b;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        if (this.numCharacteristics > this.rules.size()) {
            throw new IllegalStateException("Number of characteristics must be <= to the number of rules");
        }
        int successCount = 0;
        RuleResult result = new RuleResult();
        for (CharacterRule rule : this.rules) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                if (this.reportRuleFailures) {
                    result.getDetails().addAll(rr.getDetails());
                }
            } else {
                ++successCount;
            }
            result.getMetadata().merge(rr.getMetadata());
        }
        if (successCount < this.numCharacteristics) {
            result.setValid(false);
            if (this.reportFailure) {
                result.addError(ERROR_CODE, this.createRuleResultDetailParameters(successCount));
            }
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(int success) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("successCount", success);
        m.put("minimumRequired", this.numCharacteristics);
        m.put("ruleCount", this.rules.size());
        return m;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacteristics=%s,rules=%s,reportRuleFailures=%s", this.getClass().getName(), this.hashCode(), this.numCharacteristics, this.rules, this.reportRuleFailures);
    }
}

