/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamExternalResourceVerificationToken;
import software.amazon.awssdk.services.ec2.model.IpamExternalResourceVerificationTokenSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamExternalResourceVerificationTokensResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamExternalResourceVerificationTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamExternalResourceVerificationTokensResponse.getter(DescribeIpamExternalResourceVerificationTokensResponse::nextToken)).setter(DescribeIpamExternalResourceVerificationTokensResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamExternalResourceVerificationToken>> IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamExternalResourceVerificationTokens").getter(DescribeIpamExternalResourceVerificationTokensResponse.getter(DescribeIpamExternalResourceVerificationTokensResponse::ipamExternalResourceVerificationTokens)).setter(DescribeIpamExternalResourceVerificationTokensResponse.setter(Builder::ipamExternalResourceVerificationTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamExternalResourceVerificationTokenSet").unmarshallLocationName("ipamExternalResourceVerificationTokenSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamExternalResourceVerificationToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKENS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamExternalResourceVerificationTokensResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IpamExternalResourceVerificationToken> ipamExternalResourceVerificationTokens;

    private DescribeIpamExternalResourceVerificationTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamExternalResourceVerificationTokens = builder.ipamExternalResourceVerificationTokens;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamExternalResourceVerificationTokens() {
        return this.ipamExternalResourceVerificationTokens != null && !(this.ipamExternalResourceVerificationTokens instanceof SdkAutoConstructList);
    }

    public final List<IpamExternalResourceVerificationToken> ipamExternalResourceVerificationTokens() {
        return this.ipamExternalResourceVerificationTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamExternalResourceVerificationTokens() ? this.ipamExternalResourceVerificationTokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamExternalResourceVerificationTokensResponse)) {
            return false;
        }
        DescribeIpamExternalResourceVerificationTokensResponse other = (DescribeIpamExternalResourceVerificationTokensResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamExternalResourceVerificationTokens() == other.hasIpamExternalResourceVerificationTokens() && Objects.equals(this.ipamExternalResourceVerificationTokens(), other.ipamExternalResourceVerificationTokens());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamExternalResourceVerificationTokensResponse").add("NextToken", (Object)this.nextToken()).add("IpamExternalResourceVerificationTokens", this.hasIpamExternalResourceVerificationTokens() ? this.ipamExternalResourceVerificationTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamExternalResourceVerificationTokens": {
                return Optional.ofNullable(clazz.cast(this.ipamExternalResourceVerificationTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IpamExternalResourceVerificationTokenSet", IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamExternalResourceVerificationTokensResponse, T> g) {
        return obj -> g.apply((DescribeIpamExternalResourceVerificationTokensResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamExternalResourceVerificationToken> ipamExternalResourceVerificationTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamExternalResourceVerificationTokensResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamExternalResourceVerificationTokens(model.ipamExternalResourceVerificationTokens);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamExternalResourceVerificationToken.Builder> getIpamExternalResourceVerificationTokens() {
            List<IpamExternalResourceVerificationToken.Builder> result = IpamExternalResourceVerificationTokenSetCopier.copyToBuilder(this.ipamExternalResourceVerificationTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamExternalResourceVerificationTokens(Collection<IpamExternalResourceVerificationToken.BuilderImpl> ipamExternalResourceVerificationTokens) {
            this.ipamExternalResourceVerificationTokens = IpamExternalResourceVerificationTokenSetCopier.copyFromBuilder(ipamExternalResourceVerificationTokens);
        }

        @Override
        public final Builder ipamExternalResourceVerificationTokens(Collection<IpamExternalResourceVerificationToken> ipamExternalResourceVerificationTokens) {
            this.ipamExternalResourceVerificationTokens = IpamExternalResourceVerificationTokenSetCopier.copy(ipamExternalResourceVerificationTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamExternalResourceVerificationTokens(IpamExternalResourceVerificationToken ... ipamExternalResourceVerificationTokens) {
            this.ipamExternalResourceVerificationTokens(Arrays.asList(ipamExternalResourceVerificationTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamExternalResourceVerificationTokens(Consumer<IpamExternalResourceVerificationToken.Builder> ... ipamExternalResourceVerificationTokens) {
            this.ipamExternalResourceVerificationTokens(Stream.of(ipamExternalResourceVerificationTokens).map(c -> (IpamExternalResourceVerificationToken)((IpamExternalResourceVerificationToken.Builder)IpamExternalResourceVerificationToken.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamExternalResourceVerificationTokensResponse build() {
            return new DescribeIpamExternalResourceVerificationTokensResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamExternalResourceVerificationTokensResponse> {
        public Builder nextToken(String var1);

        public Builder ipamExternalResourceVerificationTokens(Collection<IpamExternalResourceVerificationToken> var1);

        public Builder ipamExternalResourceVerificationTokens(IpamExternalResourceVerificationToken ... var1);

        public Builder ipamExternalResourceVerificationTokens(Consumer<IpamExternalResourceVerificationToken.Builder> ... var1);
    }
}

