"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSampleNotebooks = void 0;
var _uuid = require("uuid");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getDemoNotebook = (dateString, visId) => {
  const uuids = [(0, _uuid.v4)()];
  const oneWeekAgo = new Date();
  oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
  return {
    name: 'OpenSearch Notebooks Quick Start Guide',
    path: 'OpenSearch Notebooks Quick Start Guide',
    dateCreated: dateString,
    dateModified: dateString,
    backend: 'kibana_1.0',
    paragraphs: [{
      output: [{
        result: `An OpenSearch Dashboards notebook is an interface that lets you easily combine code snippets, live visualizations, and narrative text in a single notebook interface.

Notebooks let you interactively explore data by running different visualizations that you can share with team members to collaborate on a project.

A notebook is a document composed of two elements: code blocks (Markdown/SQL/PPL) and visualizations.

Common use cases include creating postmortem reports, designing runbooks, building live infrastructure reports, and writing documentation.

You can also generate [reports](https://opensearch.org/docs/dashboards/reporting/) directly from your notebooks.

For more information, refer to the [documentation](https://opensearch.org/docs/dashboards/notebooks/).`,
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
An OpenSearch Dashboards notebook is an interface that lets you easily combine code snippets, live visualizations, and narrative text in a single notebook interface.

Notebooks let you interactively explore data by running different visualizations that you can share with team members to collaborate on a project.

A notebook is a document composed of two elements: code blocks (Markdown/SQL/PPL) and visualizations.

Common use cases include creating postmortem reports, designing runbooks, building live infrastructure reports, and writing documentation.

You can also generate [reports](https://opensearch.org/docs/dashboards/reporting/) directly from your notebooks.

For more information, refer to the [documentation](https://opensearch.org/docs/dashboards/notebooks/).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'Notebooks combine code blocks and visualizations for describing data. Code blocks support markdown, SQL, and PPL languages. Specify the input language on the first line using %[language type] syntax. For example, type %md for markdown, %sql for SQL, and %ppl for PPL. A sample visualization is shown below:',
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
Notebooks combine code blocks and visualizations for describing data. Code blocks support markdown, SQL, and PPL languages. Specify the input language on the first line using %\[language type\] syntax. For example, type %md for markdown, %sql for SQL, and %ppl for PPL. A sample visualization is shown below:`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: '',
        outputType: 'VISUALIZATION',
        execution_time: '0.017 ms'
      }],
      input: {
        inputText: `{"viewMode":"view","panels":{"1":{"gridData":{"x":0,"y":0,"w":50,"h":20,"i":"1"},"type":"visualization","explicitInput":{"id":"1","savedObjectId":"${visId}"}}},"isFullScreenMode":false,"filters":[],"useMargins":false,"id":"${uuids[0]}","timeRange":{"to":"${dateString}","from":"${oneWeekAgo}"},"title":"embed_viz_${uuids[0]}","query":{"query":"","language":"lucene"},"refreshConfig":{"pause":true,"value":15}}`,
        inputType: 'VISUALIZATION'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'You can add a new paragraph from the **Paragraph actions** menu on the top right of the page, the context menu on the top right of each paragraph, or the **Add paragraph** button on the bottom of the page.',
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
You can add a new paragraph from the **Paragraph actions** menu on the top right of the page, the context menu on the top right of each paragraph, or the **Add paragraph** button on the bottom of the page.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'You can also reorder, duplicate, or delete paragraphs from these menus.',
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
You can also reorder, duplicate, or delete paragraphs from these menus.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "To execute a paragraph, choose **Run**. To make changes to the input block, choose the downward arrow that's next to the paragraph title.",
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
To execute a paragraph, choose **Run**. To make changes to the input block, choose the downward arrow that's next to the paragraph title.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `There are three view modes:
- **View both**: allows you to edit paragraphs and view outputs on the same page.
- **Input only**: only shows input of each paragraph, allowing easier editing.
- **Output only**: only shows output of each paragraph and hides panels.`,
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
There are three view modes:
- **View both**: allows you to edit paragraphs and view outputs on the same page.
- **Input only**: only shows input of each paragraph, allowing easier editing.
- **Output only**: only shows output of each paragraph and hides panels.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To go back, choose **Notebooks** on the top left of your screen.',
        outputType: 'MARKDOWN',
        execution_time: '0 ms'
      }],
      input: {
        inputText: `%md
To go back, choose **Notebooks** on the top left of your screen.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }]
  };
};
const getRootCauseNotebook = (dateString, visIds) => {
  const uuids = [(0, _uuid.v4)(), (0, _uuid.v4)()];
  const oneWeekAgo = new Date();
  oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
  return {
    name: '[Logs] Sample Root Cause Event Analysis',
    path: '[Logs] Sample Root Cause Event Analysis',
    dateCreated: dateString,
    dateModified: dateString,
    backend: 'kibana_1.0',
    paragraphs: [{
      output: [{
        result: 'This notebook goes through a sample root cause event analysis using PPL and visualizations with the OpenSearch Dashboards sample web logs data.',
        outputType: 'MARKDOWN',
        execution_time: '0.016 ms'
      }],
      input: {
        inputText: `%md
This notebook goes through a sample root cause event analysis using PPL and visualizations with the OpenSearch Dashboards sample web logs data.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "First, let's bring up a few visualizations for a quick overview.",
        outputType: 'MARKDOWN',
        execution_time: '0.046 ms'
      }],
      input: {
        inputText: `%md
First, let's bring up a few visualizations for a quick overview.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: '',
        outputType: 'VISUALIZATION',
        execution_time: '0.017 ms'
      }],
      input: {
        inputText: `{"viewMode":"view","panels":{"1":{"gridData":{"x":0,"y":0,"w":50,"h":20,"i":"1"},"type":"visualization","explicitInput":{"id":"1","savedObjectId":"${visIds[0]}"}}},"isFullScreenMode":false,"filters":[],"useMargins":false,"id":"${uuids[0]}","timeRange":{"to":"${dateString}","from":"${oneWeekAgo}"},"title":"embed_viz_${uuids[0]}","query":{"query":"","language":"lucene"},"refreshConfig":{"pause":true,"value":15}}`,
        inputType: 'VISUALIZATION'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: '',
        outputType: 'VISUALIZATION',
        execution_time: '0.017 ms'
      }],
      input: {
        inputText: `{"viewMode":"view","panels":{"1":{"gridData":{"x":0,"y":0,"w":50,"h":20,"i":"1"},"type":"visualization","explicitInput":{"id":"1","savedObjectId":"${visIds[1]}"}}},"isFullScreenMode":false,"filters":[],"useMargins":false,"id":"${uuids[1]}","timeRange":{"to":"${dateString}","from":"${oneWeekAgo}"},"title":"embed_viz_${uuids[1]}","query":{"query":"","language":"lucene"},"refreshConfig":{"pause":true,"value":15}}`,
        inputType: 'VISUALIZATION'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `Let's take a look at the source data by the selected fields (search and fields).`,
        outputType: 'MARKDOWN',
        execution_time: '0.013 ms'
      }],
      input: {
        inputText: `%md
Let's take a look at the source data by the selected fields (search and fields).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, 
  response, bytes | head 20

`,
        // outputType: 'QUERY',
        execution_time: '0.008 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, 
  response, bytes | head 20

`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'Check for any error log with response code 404 or 503 (filter).',
        outputType: 'MARKDOWN',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%md
Check for any error log with response code 404 or 503 (filter).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response, bytes | where response='503' or response='404' | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response, bytes | where response='503' or response='404' | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "We see too many events. Let's quickly check which host has the issue (dedup).",
        outputType: 'MARKDOWN',
        execution_time: '0.014 ms'
      }],
      input: {
        inputText: `%md
We see too many events. Let's quickly check which host has the issue (dedup).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | dedup host | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.010 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | dedup host | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "We get too few events. Let's dedup in consecutive mode (dedup).",
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
We get too few events. Let's dedup in consecutive mode (dedup).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    dedup host consecutive=true | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    dedup host consecutive=true | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'How many IP addresses for each response (stats).',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
How many IP addresses for each response (stats).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count by response | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.008 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count by response | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "To dive deep, let's group by host and response, count, and sum (stats).",
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
To dive deep, let's group by host and response, count, and sum (stats).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `We don't see a meaningful response. Let's change to resp_code (rename).`,
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
We don't see a meaningful response. Let's change to resp_code (rename).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    stats count() as ip_count, sum(bytes) 
    as sum_bytes by host, response |
     rename response as resp_code | head 20

`,
        // outputType: 'QUERY',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    stats count() as ip_count, sum(bytes) 
    as sum_bytes by host, response |
     rename response as resp_code | head 20

`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "The data looks better now. Let's sort by `DESC count` and `ASC sum_bytes` (sort).",
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
The data looks better now. Let's sort by \`DESC count\` and \`ASC sum_bytes\` (sort).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | 
   rename response as resp_code | 
   sort - ip_count, + sum_bytes | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | 
   rename response as resp_code | 
   sort - ip_count, + sum_bytes | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "Let's check if we can perform aggregations after stats (eval).",
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
Let's check if we can perform aggregations after stats (eval).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    stats count() as ip_count, sum(bytes) 
    as sum_bytes by host, response | 
    rename response as resp_code | 
    sort - ip_count, + sum_bytes | 
    eval per_ip_bytes=sum_bytes/ip_count  | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' |
    stats count() as ip_count, sum(bytes) 
    as sum_bytes by host, response | 
    rename response as resp_code | 
    sort - ip_count, + sum_bytes | 
    eval per_ip_bytes=sum_bytes/ip_count  | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `Wait, what's meant by an evaluation. Can we really perform an evaluation?`,
        outputType: 'MARKDOWN',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%md
Wait, what's meant by an evaluation. Can we really perform an evaluation?`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | 
   rename response as resp_code | 
   sort - ip_count, + sum_bytes | 
   eval per_ip_bytes=sum_bytes/ip_count, 
    double_per_ip_bytes = 2 * per_ip_bytes | head 20
`,
        // outputType: 'QUERY',
        execution_time: '0.010 ms'
      }],
      input: {
        inputText: `%ppl
  source=opensearch_dashboards_sample_data_logs | fields host, clientip, response,
   bytes | where response='503' or response='404' | 
   stats count() as ip_count, sum(bytes) 
   as sum_bytes by host, response | 
   rename response as resp_code | 
   sort - ip_count, + sum_bytes | 
   eval per_ip_bytes=sum_bytes/ip_count, 
    double_per_ip_bytes = 2 * per_ip_bytes | head 20
`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }]
  };
};
const getSQLNotebook = dateString => {
  return {
    name: '[Flights] OpenSearch SQL Quick Start Guide',
    path: '[Flights] OpenSearch SQL Quick Start Guide',
    dateCreated: dateString,
    dateModified: dateString,
    backend: 'kibana_1.0',
    paragraphs: [{
      output: [{
        result: `OpenSearch SQL lets you write queries in SQL rather than the [OpenSearch query domain-specific language (DSL)](https://opensearch.org/docs/opensearch/query-dsl/full-text/). If you’re already familiar with SQL and don’t want to learn the query DSL, this feature is a great option.

For more information, please refer to the [documentation](https://opensearch.org/docs/search-plugins/sql/index/).`,
        outputType: 'MARKDOWN',
        execution_time: '0.013 ms'
      }],
      input: {
        inputText: `%md
OpenSearch SQL lets you write queries in SQL rather than the [OpenSearch query domain-specific language (DSL)](https://opensearch.org/docs/opensearch/query-dsl/full-text/). If you’re already familiar with SQL and don’t want to learn the query DSL, this feature is a great option.

For more information, please refer to the [documentation](https://opensearch.org/docs/search-plugins/sql/index/).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'This notebook shows you how to use SQL with the [OpenSearch Dashboards sample flight data](/app/home#/tutorial_directory).',
        outputType: 'MARKDOWN',
        execution_time: '0.010 ms'
      }],
      input: {
        inputText: `%md
This notebook shows you how to use SQL with the [OpenSearch Dashboards sample flight data](/app/home#/tutorial_directory).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To use SQL, add a code paragraph, type %sql on the first line, and then add SQL queries on the next line.',
        outputType: 'MARKDOWN',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%md
To use SQL, add a code paragraph, type %sql on the first line, and then add SQL queries on the next line.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'Select * from opensearch_dashboards_sample_data_flights limit 20;',
        // outputType: 'QUERY',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%sql
Select * from opensearch_dashboards_sample_data_flights limit 20;`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: "You can specify fields in the `SELECT` clause and use the `WHERE` clause to filter results. The following query finds flights heading to countries that start with 'A' that are more than 5000 miles away.",
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
You can specify fields in the \`SELECT\` clause and use the \`WHERE\` clause to filter results. The following query finds flights heading to countries that start with 'A' that are more than 5000 miles away.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `SELECT FlightNum,OriginCountry,OriginCityName,DestCountry,DestCityName,DistanceMiles FROM opensearch_dashboards_sample_data_flights WHERE DistanceMiles > 5000 AND DestCountry LIKE 'A%' LIMIT 20;`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%sql
SELECT FlightNum,OriginCountry,OriginCityName,DestCountry,DestCityName,DistanceMiles FROM opensearch_dashboards_sample_data_flights WHERE DistanceMiles > 5000 AND DestCountry LIKE 'A%' LIMIT 20;`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'OpenSearch SQL also supports subqueries:',
        outputType: 'MARKDOWN',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%md
OpenSearch SQL also supports subqueries:`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `SELECT opensearch_dashboards_sample_data_flights.FlightNum,opensearch_dashboards_sample_data_flights.OriginCountry,opensearch_dashboards_sample_data_flights.OriginCityName,opensearch_dashboards_sample_data_flights.DestCountry,opensearch_dashboards_sample_data_flights.DestCityName,opensearch_dashboards_sample_data_flights.DistanceMiles FROM opensearch_dashboards_sample_data_flights WHERE FlightNum IN (SELECT FlightNum FROM opensearch_dashboards_sample_data_flights WHERE DistanceMiles > 5000 AND DestCountry = 'AU') LIMIT 20;`,
        // outputType: 'QUERY',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%sql
SELECT opensearch_dashboards_sample_data_flights.FlightNum,opensearch_dashboards_sample_data_flights.OriginCountry,opensearch_dashboards_sample_data_flights.OriginCityName,opensearch_dashboards_sample_data_flights.DestCountry,opensearch_dashboards_sample_data_flights.DestCityName,opensearch_dashboards_sample_data_flights.DistanceMiles FROM opensearch_dashboards_sample_data_flights WHERE FlightNum IN (SELECT FlightNum FROM opensearch_dashboards_sample_data_flights WHERE DistanceMiles > 5000 AND DestCountry = 'AU') LIMIT 20;`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'OpenSearch SQL supports inner joins, cross joins, and left outer joins. The following query joins the flights index with itself to find flights departed from countries that are both origins and destinations.',
        outputType: 'MARKDOWN',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%md
OpenSearch SQL supports inner joins, cross joins, and left outer joins. The following query joins the flights index with itself to find flights departed from countries that are both origins and destinations.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
SELECT a.FlightNum,a.OriginCountry,a.OriginCityName,a.DestCountry,a.DestCityName,a.DistanceMiles FROM opensearch_dashboards_sample_data_flights a JOIN opensearch_dashboards_sample_data_flights b on a.OriginCountry = b.DestCountry LIMIT 20`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%sql
SELECT a.FlightNum,a.OriginCountry,a.OriginCityName,a.DestCountry,a.DestCityName,a.DistanceMiles FROM opensearch_dashboards_sample_data_flights a JOIN opensearch_dashboards_sample_data_flights b on a.OriginCountry = b.DestCountry LIMIT 20`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'For aggregations, use the `GROUP BY` clause. The following query finds the countries with more than 500 flights departed.',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
For aggregations, use the \`GROUP BY\` clause. The following query finds the countries with more than 500 flights departed.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `SELECT OriginCountry,COUNT(1) FROM opensearch_dashboards_sample_data_flights GROUP BY OriginCountry HAVING COUNT(1) > 500 LIMIT 20;`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%sql
SELECT OriginCountry,COUNT(1) FROM opensearch_dashboards_sample_data_flights GROUP BY OriginCountry HAVING COUNT(1) > 500 LIMIT 20;`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'OpenSearch SQL supports expressions.',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
OpenSearch SQL supports expressions.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `SELECT abs(-1.234), abs(-1 * abs(-5)), dayofmonth(DATE '2021-07-07');`,
        // outputType: 'QUERY',
        execution_time: '0.005 ms'
      }],
      input: {
        inputText: `%sql
SELECT abs(-1.234), abs(-1 * abs(-5)), dayofmonth(DATE '2021-07-07');`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }]
  };
};
const getPPLNotebook = dateString => {
  return {
    name: '[Logs] OpenSearch Piped Processing Language (PPL) Quick Start Guide',
    path: '[Logs] OpenSearch Piped Processing Language (PPL) Quick Start Guide',
    dateCreated: dateString,
    dateModified: dateString,
    backend: 'kibana_1.0',
    paragraphs: [{
      output: [{
        result: `Query DSL is powerful and fast, but it has a steep learning curve because it doesn’t have a human-readable interface. It's also difficult to create ad hoc queries and explore your data. SQL lets you extract and analyze data in a declarative manner.

OpenSearch makes its search and query engine robust by introducing Piped Processing Language (PPL).

PPL enables developers, DevOps engineers, support engineers, site reliability engineers (SREs), and IT managers to effectively discover and explore log data stored in OpenSearch.

With PPL, you can extract insights from your data with a sequence of commands delimited by pipes (|). PPL supports a comprehensive set of commands including search, where, fields, rename, dedup, sort, eval, head, top, and rare. PPL also supports functions, operators and expressions.

Even if you're new to OpenSearch and are only familiar with the pipe (|) syntax, you can still be productive from day one.`,
        outputType: 'MARKDOWN',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%md
Query DSL is powerful and fast, but it has a steep learning curve because it doesn’t have a human-readable interface. It's also difficult to create ad hoc queries and explore your data. SQL lets you extract and analyze data in a declarative manner.

OpenSearch makes its search and query engine robust by introducing Piped Processing Language (PPL).

PPL enables developers, DevOps engineers, support engineers, site reliability engineers (SREs), and IT managers to effectively discover and explore log data stored in OpenSearch.

With PPL, you can extract insights from your data with a sequence of commands delimited by pipes (|). PPL supports a comprehensive set of commands including search, where, fields, rename, dedup, sort, eval, head, top, and rare. PPL also supports functions, operators and expressions.

Even if you're new to OpenSearch and are only familiar with the pipe (|) syntax, you can still be productive from day one.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `Piped Processing Language (PPL) is a query language that lets you use pipe (|) syntax to explore, discover, and query data stored in OpenSearch.

For more information, refer to the [documentation](https://opensearch.org/docs/search-plugins/ppl/index/).`,
        outputType: 'MARKDOWN',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%md
Piped Processing Language (PPL) is a query language that lets you use pipe (|) syntax to explore, discover, and query data stored in OpenSearch.

For more information, refer to the [documentation](https://opensearch.org/docs/search-plugins/ppl/index/).`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'In this notebook, we will demonstrate some simple PPL queries with the [OpenSearch Dashboards sample web logs](/app/home#/tutorial_directory). ',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
In this notebook, we will demonstrate some simple PPL queries with the [OpenSearch Dashboards sample web logs](/app/home#/tutorial_directory). `,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To use PPL, add a code paragraph, type `%ppl` on the first line, and add your PPL query on the next line. PPL uses `source` to specify indices and `head` to limit results.',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
To use PPL, add a code paragraph, type \`%ppl\` on the first line, and add your PPL query on the next line. PPL uses \`source\` to specify indices and \`head\` to limit results.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
source=opensearch_dashboards_sample_data_logs | head 20`,
        // outputType: 'QUERY',
        execution_time: '0.026 ms'
      }],
      input: {
        inputText: `%ppl
source=opensearch_dashboards_sample_data_logs | head 20`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To specify fields to include and filter results, use the `field` and `where` commands. The next query returns hosts with failed responses.',
        outputType: 'MARKDOWN',
        execution_time: '0.007 ms'
      }],
      input: {
        inputText: `%md
To specify fields to include and filter results, use the \`field\` and \`where\` commands. The next query returns hosts with failed responses.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
source=opensearch_dashboards_sample_data_logs | fields host, clientip, response, bytes | where response='503' or response='404'`,
        // outputType: 'QUERY',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%ppl
source=opensearch_dashboards_sample_data_logs | fields host, clientip, response, bytes | where response='503' or response='404'`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To see most common hosts from the previous result, use the `top` command.',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
To see most common hosts from the previous result, use the \`top\` command.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | top host`,
        // outputType: 'QUERY',
        execution_time: '0.008 ms'
      }],
      input: {
        inputText: `%ppl
source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | top host`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: 'To perform aggregations on search results, use the `stats` command.',
        outputType: 'MARKDOWN',
        execution_time: '0.006 ms'
      }],
      input: {
        inputText: `%md
To perform aggregations on search results, use the \`stats\` command.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `
source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | stats count(1) by host`,
        // outputType: 'QUERY',
        execution_time: '0.011 ms'
      }],
      input: {
        inputText: `%ppl
source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | stats count(1) by host`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }, {
      output: [{
        result: `For more information, refer to the [documentation](https://opensearch.org/docs/search-plugins/ppl/index/).

To see how to perform sample root cause event analysis using PPL and visualizations, see the "\[Logs\] Sample Root Cause Event Analysis" notebook.`,
        outputType: 'MARKDOWN',
        execution_time: '0.009 ms'
      }],
      input: {
        inputText: `%md
For more information, refer to the [documentation](https://opensearch.org/docs/search-plugins/ppl/index/).

To see how to perform sample root cause event analysis using PPL and visualizations, see the "\[Logs\] Sample Root Cause Event Analysis" notebook.`,
        inputType: 'MARKDOWN'
      },
      dateCreated: dateString,
      dateModified: dateString,
      id: 'paragraph_' + (0, _uuid.v4)()
    }]
  };
};
const getSampleNotebooks = visIds => {
  const dateString = new Date().toISOString();
  return [{
    savedNotebook: getDemoNotebook(dateString, visIds[2]),
    dateModified: dateString,
    dateCreated: dateString
  }, {
    savedNotebook: getSQLNotebook(dateString),
    dateModified: dateString,
    dateCreated: dateString
  }, {
    savedNotebook: getPPLNotebook(dateString),
    dateModified: dateString,
    dateCreated: dateString
  }, {
    savedNotebook: getRootCauseNotebook(dateString, visIds),
    dateModified: dateString,
    dateCreated: dateString
  }];
};
exports.getSampleNotebooks = getSampleNotebooks;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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