/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        if (!request.containsHeader("Expect")) {
            RequestConfig config;
            ProtocolVersion version;
            HttpClientContext clientContext = HttpClientContext.cast(context);
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : clientContext.getProtocolVersion();
            if (entity != null && entity.getContentLength() != 0L && !version.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0) && (config = clientContext.getRequestConfigOrDefault()).isExpectContinueEnabled()) {
                request.addHeader("Expect", (Object)"100-continue");
            }
        }
    }
}

