/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectorProfile;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.model.EntityProfile;
import org.opensearch.timeseries.model.Job;

public class GetAnomalyDetectorResponse
extends ActionResponse
implements ToXContentObject {
    public static final String DETECTOR_PROFILE = "detectorProfile";
    public static final String ENTITY_PROFILE = "entityProfile";
    private long version;
    private String id;
    private long primaryTerm;
    private long seqNo;
    private AnomalyDetector detector;
    private Job adJob;
    private ADTask realtimeAdTask;
    private ADTask historicalAdTask;
    private RestStatus restStatus;
    private DetectorProfile detectorProfile;
    private EntityProfile entityProfile;
    private boolean profileResponse;
    private boolean returnJob;
    private boolean returnTask;

    public GetAnomalyDetectorResponse(StreamInput in) throws IOException {
        super(in);
        this.profileResponse = in.readBoolean();
        if (this.profileResponse) {
            String profileType = in.readString();
            if (DETECTOR_PROFILE.equals(profileType)) {
                this.detectorProfile = new DetectorProfile(in);
            } else {
                this.entityProfile = new EntityProfile(in);
            }
        } else {
            this.detectorProfile = null;
            this.id = in.readString();
            this.version = in.readLong();
            this.primaryTerm = in.readLong();
            this.seqNo = in.readLong();
            this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
            this.detector = new AnomalyDetector(in);
            this.returnJob = in.readBoolean();
            this.adJob = this.returnJob ? new Job(in) : null;
            this.returnTask = in.readBoolean();
            this.realtimeAdTask = in.readBoolean() ? new ADTask(in) : null;
            this.historicalAdTask = in.readBoolean() ? new ADTask(in) : null;
        }
    }

    public GetAnomalyDetectorResponse(long version, String id, long primaryTerm, long seqNo, AnomalyDetector detector, Job adJob, boolean returnJob, ADTask realtimeAdTask, ADTask historicalAdTask, boolean returnTask, RestStatus restStatus, DetectorProfile detectorProfile, EntityProfile entityProfile, boolean profileResponse) {
        this.version = version;
        this.id = id;
        this.primaryTerm = primaryTerm;
        this.seqNo = seqNo;
        this.detector = detector;
        this.restStatus = restStatus;
        this.returnJob = returnJob;
        this.adJob = this.returnJob ? adJob : null;
        this.returnTask = returnTask;
        if (this.returnTask) {
            this.realtimeAdTask = realtimeAdTask;
            this.historicalAdTask = historicalAdTask;
        } else {
            this.realtimeAdTask = null;
            this.historicalAdTask = null;
        }
        this.detectorProfile = detectorProfile;
        this.entityProfile = entityProfile;
        this.profileResponse = profileResponse;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.profileResponse) {
            out.writeBoolean(true);
            if (this.detectorProfile != null) {
                out.writeString(DETECTOR_PROFILE);
                this.detectorProfile.writeTo(out);
            } else if (this.entityProfile != null) {
                out.writeString(ENTITY_PROFILE);
                this.entityProfile.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
            out.writeString(this.id);
            out.writeLong(this.version);
            out.writeLong(this.primaryTerm);
            out.writeLong(this.seqNo);
            out.writeEnum((Enum)this.restStatus);
            this.detector.writeTo(out);
            if (this.returnJob) {
                out.writeBoolean(true);
                this.adJob.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(this.returnTask);
            if (this.realtimeAdTask != null) {
                out.writeBoolean(true);
                this.realtimeAdTask.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.historicalAdTask != null) {
                out.writeBoolean(true);
                this.historicalAdTask.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.profileResponse) {
            if (this.detectorProfile != null) {
                this.detectorProfile.toXContent(builder, params);
            } else {
                this.entityProfile.toXContent(builder, params);
            }
        } else {
            builder.startObject();
            builder.field("_id", this.id);
            builder.field("_version", this.version);
            builder.field("_primary_term", this.primaryTerm);
            builder.field("_seq_no", this.seqNo);
            builder.field("anomaly_detector", (ToXContent)this.detector);
            if (this.returnJob) {
                builder.field("anomaly_detector_job", (ToXContent)this.adJob);
            }
            if (this.returnTask) {
                builder.field("realtime_task", (ToXContent)this.realtimeAdTask);
                builder.field("historical_analysis_task", (ToXContent)this.historicalAdTask);
            }
            builder.endObject();
        }
        return builder;
    }

    public DetectorProfile getDetectorProfile() {
        return this.detectorProfile;
    }

    public Job getAdJob() {
        return this.adJob;
    }

    public ADTask getRealtimeAdTask() {
        return this.realtimeAdTask;
    }

    public ADTask getHistoricalAdTask() {
        return this.historicalAdTask;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public static GetAnomalyDetectorResponse fromActionResponse(ActionResponse actionResponse, NamedWriteableRegistry namedWriteableRegistry) {
        if (actionResponse instanceof GetAnomalyDetectorResponse) {
            return (GetAnomalyDetectorResponse)actionResponse;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamStreamOutput osso = new OutputStreamStreamOutput((OutputStream)baos);
            actionResponse.writeTo((StreamOutput)osso);
            InputStreamStreamInput input = new InputStreamStreamInput((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            NamedWriteableAwareStreamInput namedWriteableAwareInput = new NamedWriteableAwareStreamInput((StreamInput)input, namedWriteableRegistry);
            return new GetAnomalyDetectorResponse((StreamInput)namedWriteableAwareInput);
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to parse ActionResponse into GetAnomalyDetectorResponse", e);
        }
    }
}

