/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.log;

import com.github.kokorin.jaffree.LogLevel;
import com.github.kokorin.jaffree.log.LogMessage;
import com.github.kokorin.jaffree.util.ParseUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LogMessageIterator
implements Iterator<LogMessage> {
    private final Iterator<String> lineIterator;
    private String nextLine = null;
    private LogLevel nextLogLevel = null;

    public LogMessageIterator(Iterator<String> lineIterator) {
        this.lineIterator = lineIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        if (!this.lineIterator.hasNext()) {
            return false;
        }
        this.nextLine = this.lineIterator.next();
        this.nextLogLevel = ParseUtil.parseLogLevel(this.nextLine);
        return true;
    }

    @Override
    public LogMessage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more messages");
        }
        String message = this.nextLine;
        LogLevel logLevel = this.nextLogLevel;
        this.nextLine = null;
        this.nextLogLevel = null;
        while (this.lineIterator.hasNext()) {
            String line = this.lineIterator.next();
            LogLevel lineLogLevel = ParseUtil.parseLogLevel(line);
            if (lineLogLevel != null) {
                this.nextLine = line;
                this.nextLogLevel = lineLogLevel;
                break;
            }
            message = message + "\n" + line;
        }
        return new LogMessage(logLevel, message);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

