/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class MetaData extends Base {

	public MetaData(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * returns the namespace URL of the metadata
	 *
	 * @return the namespace URL of the metadata
	 * @throws Lib3MFException
	 */
	public String getNameSpace() throws Lib3MFException {
		Pointer bytesNeededNameSpace = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getnamespace.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededNameSpace, null}));
		int sizeNameSpace = bytesNeededNameSpace.getInt(0);
		Pointer bufferNameSpace = new Memory(sizeNameSpace);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getnamespace.invokeInt(new java.lang.Object[]{mHandle, sizeNameSpace, bytesNeededNameSpace, bufferNameSpace}));
		return new String(bufferNameSpace.getByteArray(0, sizeNameSpace - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets a new namespace URL of the metadata
	 *
	 * @param nameSpace the new namespace URL of the metadata
	 * @throws Lib3MFException
	 */
	public void setNameSpace(String nameSpace) throws Lib3MFException {
		byte[] bytesNameSpace = nameSpace.getBytes(StandardCharsets.UTF_8);
		Memory bufferNameSpace = new Memory(bytesNameSpace.length + 1);
		bufferNameSpace.write(0, bytesNameSpace, 0, bytesNameSpace.length);
		bufferNameSpace.setByte(bytesNameSpace.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_setnamespace.invokeInt(new java.lang.Object[]{mHandle, bufferNameSpace}));
	}

	/**
	 * returns the name of a metadata
	 *
	 * @return the name of the metadata
	 * @throws Lib3MFException
	 */
	public String getName() throws Lib3MFException {
		Pointer bytesNeededName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededName, null}));
		int sizeName = bytesNeededName.getInt(0);
		Pointer bufferName = new Memory(sizeName);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getname.invokeInt(new java.lang.Object[]{mHandle, sizeName, bytesNeededName, bufferName}));
		return new String(bufferName.getByteArray(0, sizeName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets a new name of a metadata
	 *
	 * @param name the new name of the metadata
	 * @throws Lib3MFException
	 */
	public void setName(String name) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_setname.invokeInt(new java.lang.Object[]{mHandle, bufferName}));
	}

	/**
	 * returns the (namespace+name) of a metadata
	 *
	 * @return the key (namespace+name) of the metadata
	 * @throws Lib3MFException
	 */
	public String getKey() throws Lib3MFException {
		Pointer bytesNeededKey = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getkey.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededKey, null}));
		int sizeKey = bytesNeededKey.getInt(0);
		Pointer bufferKey = new Memory(sizeKey);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getkey.invokeInt(new java.lang.Object[]{mHandle, sizeKey, bytesNeededKey, bufferKey}));
		return new String(bufferKey.getByteArray(0, sizeKey - 1), StandardCharsets.UTF_8);
	}

	/**
	 * returns, whether a metadata must be preserved
	 *
	 * @return returns, whether a metadata must be preserved
	 * @throws Lib3MFException
	 */
	public boolean getMustPreserve() throws Lib3MFException {
		Pointer bufferMustPreserve = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getmustpreserve.invokeInt(new java.lang.Object[]{mHandle, bufferMustPreserve}));
		return bufferMustPreserve.getByte(0) != 0;
	}

	/**
	 * sets whether a metadata must be preserved
	 *
	 * @param mustPreserve a new value whether a metadata must be preserved
	 * @throws Lib3MFException
	 */
	public void setMustPreserve(boolean mustPreserve) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_setmustpreserve.invokeInt(new java.lang.Object[]{mHandle, mustPreserve}));
	}

	/**
	 * returns the type of a metadata
	 *
	 * @return the type of the metadata
	 * @throws Lib3MFException
	 */
	public String getType() throws Lib3MFException {
		Pointer bytesNeededType = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_gettype.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededType, null}));
		int sizeType = bytesNeededType.getInt(0);
		Pointer bufferType = new Memory(sizeType);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_gettype.invokeInt(new java.lang.Object[]{mHandle, sizeType, bytesNeededType, bufferType}));
		return new String(bufferType.getByteArray(0, sizeType - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets a new type of a metadata. This must be a simple XML type
	 *
	 * @param type a new type of the metadata
	 * @throws Lib3MFException
	 */
	public void setType(String type) throws Lib3MFException {
		byte[] bytesType = type.getBytes(StandardCharsets.UTF_8);
		Memory bufferType = new Memory(bytesType.length + 1);
		bufferType.write(0, bytesType, 0, bytesType.length);
		bufferType.setByte(bytesType.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_settype.invokeInt(new java.lang.Object[]{mHandle, bufferType}));
	}

	/**
	 * returns the value of the metadata
	 *
	 * @return the value of the metadata
	 * @throws Lib3MFException
	 */
	public String getValue() throws Lib3MFException {
		Pointer bytesNeededValue = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getvalue.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededValue, null}));
		int sizeValue = bytesNeededValue.getInt(0);
		Pointer bufferValue = new Memory(sizeValue);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_getvalue.invokeInt(new java.lang.Object[]{mHandle, sizeValue, bytesNeededValue, bufferValue}));
		return new String(bufferValue.getByteArray(0, sizeValue - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets a new value of the metadata
	 *
	 * @param value a new value of the metadata
	 * @throws Lib3MFException
	 */
	public void setValue(String value) throws Lib3MFException {
		byte[] bytesValue = value.getBytes(StandardCharsets.UTF_8);
		Memory bufferValue = new Memory(bytesValue.length + 1);
		bufferValue.write(0, bytesValue, 0, bytesValue.length);
		bufferValue.setByte(bytesValue.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_metadata_setvalue.invokeInt(new java.lang.Object[]{mHandle, bufferValue}));
	}


}

