/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.ide;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.deployment.ide.IdeConfig;
import io.quarkus.deployment.ide.IdeFileBuildItem;
import io.quarkus.deployment.ide.IdeRunningProcessBuildItem;
import io.quarkus.deployment.ide.IdeUtil;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.dev.spi.DevModeType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class IdeProcessor {
    private static final Logger log = Logger.getLogger(IdeProcessor.class);
    private static final Map<String, List<Ide>> IDE_MARKER_FILES = Map.of(".idea", Collections.singletonList(Ide.IDEA), ".project", Arrays.asList(Ide.VSCODE, Ide.ECLIPSE), "nbactions.xml", Collections.singletonList(Ide.NETBEANS), "nb-configuration.xml", Collections.singletonList(Ide.NETBEANS));
    private static Map<Predicate<ProcessInfo>, Ide> IDE_PROCESSES = new HashMap<Predicate<ProcessInfo>, Ide>();
    private static final Map<Ide, Function<ProcessInfo, String>> IDE_ARGUMENTS_EXEC_INDICATOR = new HashMap<Ide, Function<ProcessInfo, String>>();

    @BuildStep
    public EffectiveIdeBuildItem effectiveIde(LaunchModeBuildItem launchModeBuildItem, IdeConfig ideConfig, IdeFileBuildItem ideFile, IdeRunningProcessBuildItem ideRunningProcess) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        Ide result = null;
        if (ideConfig.target() == IdeConfig.Target.auto) {
            if (ideFile.getDetectedIDEs().size() == 1) {
                result = ideFile.getDetectedIDEs().iterator().next();
            } else {
                Set<Ide> runningIdes = ideRunningProcess.getDetectedIDEs();
                if (runningIdes.size() == 1) {
                    result = runningIdes.iterator().next();
                } else {
                    ArrayList<Ide> matches = new ArrayList<Ide>();
                    for (Ide file : ideFile.getDetectedIDEs()) {
                        for (Ide process : runningIdes) {
                            if (file != process) continue;
                            matches.add(file);
                        }
                    }
                    if (matches.size() == 0 && runningIdes.size() > 0) {
                        result = runningIdes.iterator().next();
                    } else if (matches.size() >= 1) {
                        result = (Ide)((Object)matches.get(0));
                    }
                }
            }
        } else if (ideConfig.target() == IdeConfig.Target.idea) {
            result = Ide.IDEA;
        } else if (ideConfig.target() == IdeConfig.Target.eclipse) {
            result = Ide.ECLIPSE;
        } else if (ideConfig.target() == IdeConfig.Target.vscode) {
            result = Ide.VSCODE;
        } else if (ideConfig.target() == IdeConfig.Target.netbeans) {
            result = Ide.NETBEANS;
        }
        if (result == null) {
            return null;
        }
        return new EffectiveIdeBuildItem(result);
    }

    @BuildStep
    public IdeFileBuildItem detectIdeFiles(LaunchModeBuildItem launchModeBuildItem, BuildSystemTargetBuildItem buildSystemTarget) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        EnumSet<Ide> result = EnumSet.noneOf(Ide.class);
        Path root = buildSystemTarget.getOutputDirectory();
        for (int i = 0; i < 3 && (root = root.getParent()) != null && result.isEmpty(); ++i) {
            for (Map.Entry<String, List<Ide>> entry : IDE_MARKER_FILES.entrySet()) {
                String file = entry.getKey();
                List<Ide> ides = entry.getValue();
                if (!Files.exists(root.resolve(file), new LinkOption[0])) continue;
                result.addAll(ides);
            }
        }
        return new IdeFileBuildItem(result);
    }

    @BuildStep
    public IdeRunningProcessBuildItem detectRunningIdeProcesses(LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        EnumSet<Ide> result = EnumSet.noneOf(Ide.class);
        List<Object> processInfos = Collections.emptyList();
        try {
            processInfos = ProcessUtil.runningProcesses();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        block2: for (ProcessInfo processInfo : processInfos) {
            for (Map.Entry<Predicate<ProcessInfo>, Ide> entry : IDE_PROCESSES.entrySet()) {
                Function<ProcessInfo, String> execIndicator;
                String machineSpecificCommand;
                if (!entry.getKey().test(processInfo)) continue;
                Ide ide = entry.getValue();
                if (IDE_ARGUMENTS_EXEC_INDICATOR.containsKey((Object)ide) && (machineSpecificCommand = (execIndicator = IDE_ARGUMENTS_EXEC_INDICATOR.get((Object)ide)).apply(processInfo)) != null) {
                    ide.setMachineSpecificCommand(machineSpecificCommand);
                }
                result.add(ide);
                continue block2;
            }
        }
        return new IdeRunningProcessBuildItem(result);
    }

    static {
        IDE_PROCESSES.put(processInfo -> !(!processInfo.containInCommand("idea") && !processInfo.containInCommand("IDEA") || !processInfo.command.endsWith("java") && !processInfo.command.endsWith("java.exe")), Ide.IDEA);
        IDE_PROCESSES.put(processInfo -> processInfo.containInCommand("code"), Ide.VSCODE);
        IDE_PROCESSES.put(processInfo -> processInfo.containInCommand("eclipse"), Ide.ECLIPSE);
        IDE_PROCESSES.put(processInfo -> processInfo.containInArguments("netbeans") || processInfo.containInCommand("nbexec"), Ide.NETBEANS);
        IDE_ARGUMENTS_EXEC_INDICATOR.put(Ide.NETBEANS, processInfo -> {
            String platform = processInfo.getArgumentThatContains("nbexec");
            if (platform != null && !platform.isEmpty()) {
                platform = platform.substring(0, platform.indexOf("platform")).concat("bin").concat(File.separator);
                platform = IdeUtil.isWindows() ? platform.concat("netbeans.exe") : platform.concat("netbeans");
                return platform;
            }
            return null;
        });
        IDE_ARGUMENTS_EXEC_INDICATOR.put(Ide.IDEA, processInfo -> {
            String command = processInfo.getCommand();
            int jbrIndex = command.indexOf("jbr");
            if (jbrIndex > -1 && (command.endsWith("java") || command.endsWith("java.exe"))) {
                String ideaHome = command.substring(0, jbrIndex);
                return ideaHome + "bin" + File.separator + "idea" + (IdeUtil.isWindows() ? ".bat" : ".sh");
            }
            return null;
        });
        IDE_PROCESSES = Collections.unmodifiableMap(IDE_PROCESSES);
    }

    private static class ProcessUtil {
        private ProcessUtil() {
        }

        public static List<ProcessInfo> runningProcesses() {
            ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
            ProcessHandle.allProcesses().forEach(p -> {
                ProcessHandle.Info info = p.info();
                Optional<String> command = info.command();
                if (command.isPresent()) {
                    result.add(new ProcessInfo(command.get(), info.commandLine().orElse(""), info.arguments().orElse(null)));
                }
            });
            return result;
        }
    }

    private static class ProcessInfo {
        private final String command;
        private final String commandLine;
        private final String[] arguments;

        public ProcessInfo(String command, String commandLine, String[] arguments) {
            this.command = command;
            this.commandLine = commandLine;
            this.arguments = arguments;
        }

        public String getCommand() {
            return this.command;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        private boolean containInCommand(String value) {
            return this.command.contains(value) || this.commandLine.contains(value);
        }

        private boolean containInArguments(String value) {
            if (this.arguments != null) {
                for (String argument : this.arguments) {
                    if (!argument.contains(value)) continue;
                    return true;
                }
            }
            return false;
        }

        private String getArgumentThatContains(String contain) {
            if (this.arguments != null) {
                for (String argument : this.arguments) {
                    if (!argument.contains(contain)) continue;
                    return argument;
                }
            }
            return null;
        }
    }
}

