/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.populator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.aesh.command.Command;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.AeshContext;
import org.aesh.selector.SelectorType;

public class AeshCommandPopulator<O, CI extends CommandInvocation>
implements CommandPopulator<O, CI> {
    private final O instance;

    public AeshCommandPopulator(O instance) {
        this.instance = instance;
    }

    @Override
    public void populateObject(ProcessedCommand<Command<CI>, CI> processedCommand, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode mode) throws CommandLineParserException, OptionValidatorException {
        if (processedCommand.parserExceptions().size() > 0 && mode == CommandLineParser.Mode.VALIDATE) {
            throw processedCommand.parserExceptions().get(0);
        }
        for (ProcessedOption option : processedCommand.getOptions()) {
            if (option.getValues() != null && option.getValues().size() > 0) {
                option.injectValueIntoField(this.getObject(), invocationProviders, aeshContext, mode == CommandLineParser.Mode.VALIDATE);
                continue;
            }
            if (option.getDefaultValues().size() > 0 && option.selectorType() == SelectorType.NO_OP) {
                option.injectValueIntoField(this.getObject(), invocationProviders, aeshContext, mode == CommandLineParser.Mode.VALIDATE);
                continue;
            }
            if (option.getOptionType().equals((Object)OptionType.GROUP) && option.getProperties().size() > 0) {
                option.injectValueIntoField(this.getObject(), invocationProviders, aeshContext, mode == CommandLineParser.Mode.VALIDATE);
                continue;
            }
            this.resetField(this.getObject(), option.getFieldName(), option.hasValue());
        }
        if (processedCommand.getArguments() != null && (processedCommand.getArguments().getValues().size() > 0 || processedCommand.getArguments().getDefaultValues().size() > 0)) {
            processedCommand.getArguments().injectValueIntoField(this.getObject(), invocationProviders, aeshContext, mode == CommandLineParser.Mode.VALIDATE);
        } else if (processedCommand.getArguments() != null) {
            this.resetField(this.getObject(), processedCommand.getArguments().getFieldName(), true);
        }
        if (processedCommand.getArgument() != null && (processedCommand.getArgument().getValues().size() > 0 || processedCommand.getArgument().getDefaultValues().size() > 0)) {
            processedCommand.getArgument().injectValueIntoField(this.getObject(), invocationProviders, aeshContext, mode == CommandLineParser.Mode.VALIDATE);
        } else if (processedCommand.getArgument() != null) {
            this.resetField(this.getObject(), processedCommand.getArgument().getFieldName(), true);
        }
    }

    private void resetField(Object instance, String fieldName, boolean hasValue) {
        try {
            Field field = this.getField(instance.getClass(), fieldName);
            if (field == null) {
                return;
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if (field.getType().isPrimitive()) {
                if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, false);
                } else if (Integer.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Short.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Character.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Character.valueOf('\u0000'));
                } else if (Byte.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Long.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0L);
                } else if (Float.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Float.valueOf(0.0f));
                } else if (Double.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0.0);
                }
            } else if (!hasValue && field.getType().equals(Boolean.class)) {
                field.set(instance, Boolean.FALSE);
            } else {
                field.set(instance, null);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return this.getField(clazz.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    @Override
    public O getObject() {
        return this.instance;
    }
}

