/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.FieldDeref;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.function.BiFunction;

final class FieldGetViaHandle
extends Item {
    private final FieldDeref fieldDeref;
    private final MemoryOrder mode;

    FieldGetViaHandle(FieldDeref fieldDeref, MemoryOrder mode) {
        this.fieldDeref = fieldDeref;
        this.mode = mode;
    }

    @Override
    public ClassDesc type() {
        return this.fieldDeref.type();
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return ConstImpl.ofFieldVarHandle(this.fieldDeref.desc()).process(this.fieldDeref.instance().process(node.prev(), op), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "get";
            case MemoryOrder.Opaque -> "getOpaque";
            case MemoryOrder.Acquire -> "getAcquire";
            case MemoryOrder.Volatile -> "getVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(this.type(), this.fieldDeref.instance().type()));
    }
}

