/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.function.SetReturningFunctionRenderer;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleType;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;

@Incubating
public class SelfRenderingSqmSetReturningFunction<T>
extends SqmSetReturningFunction<T> {
    private final @Nullable ArgumentsValidator argumentsValidator;
    private final SetReturningFunctionTypeResolver setReturningTypeResolver;
    private final SetReturningFunctionRenderer renderer;
    private @Nullable AnonymousTupleType<T> type;

    public SelfRenderingSqmSetReturningFunction(SqmSetReturningFunctionDescriptor descriptor, SetReturningFunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver setReturningTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(name, descriptor, arguments, nodeBuilder);
        this.renderer = renderer;
        this.argumentsValidator = argumentsValidator;
        this.setReturningTypeResolver = setReturningTypeResolver;
    }

    @Override
    public SelfRenderingSqmSetReturningFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmSetReturningFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        return context.registerCopy(this, new SelfRenderingSqmSetReturningFunction<T>(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
    }

    @Override
    public AnonymousTupleType<T> getType() {
        AnonymousTupleType<Object> type = this.type;
        if (type == null && (type = (this.type = this.getSetReturningTypeResolver().resolveTupleType(this.getArguments(), this.nodeBuilder().getTypeConfiguration()))) == null) {
            throw new IllegalStateException("SetReturningFunctionTypeResolver returned a null tuple type");
        }
        return type;
    }

    protected boolean isTypeResolved() {
        return this.type != null;
    }

    public SetReturningFunctionRenderer getFunctionRenderer() {
        return this.renderer;
    }

    protected @Nullable ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    public SetReturningFunctionTypeResolver getSetReturningTypeResolver() {
        return this.setReturningTypeResolver;
    }

    protected List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        FunctionArgumentTypeResolver argumentTypeResolver;
        if (sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        SqmSetReturningFunctionDescriptor sqmSetReturningFunctionDescriptor = this.getFunctionDescriptor();
        if (sqmSetReturningFunctionDescriptor instanceof AbstractSqmSetReturningFunctionDescriptor) {
            AbstractSqmSetReturningFunctionDescriptor setReturningFunctionDescriptor = (AbstractSqmSetReturningFunctionDescriptor)sqmSetReturningFunctionDescriptor;
            v0 = setReturningFunctionDescriptor.getArgumentTypeResolver();
        } else {
            v0 = argumentTypeResolver = null;
        }
        if (argumentTypeResolver == null) {
            ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
            for (int i = 0; i < sqmArguments.size(); ++i) {
                sqlAstArguments.add((SqlAstNode)sqmArguments.get(i).accept(walker));
            }
            return sqlAstArguments;
        }
        FunctionArgumentTypeResolverTypeAccess typeAccess = new FunctionArgumentTypeResolverTypeAccess(walker, this, argumentTypeResolver);
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
        for (int i = 0; i < sqmArguments.size(); ++i) {
            typeAccess.argumentIndex = i;
            sqlAstArguments.add((SqlAstNode)walker.visitWithInferredType(sqmArguments.get(i), typeAccess));
        }
        return sqlAstArguments;
    }

    @Override
    public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
        List<SqlAstNode> arguments;
        try {
            arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        }
        catch (SqlTreeCreationException ex) {
            if (!lateral && ex.getMessage().contains("Could not locate TableGroup")) {
                throw new IllegalArgumentException("Could not construct set-returning function. Maybe you forgot to use 'lateral'?", (Throwable)((Object)ex));
            }
            throw ex;
        }
        ArgumentsValidator validator = this.argumentsValidator;
        if (validator != null) {
            validator.validateSqlTypes(arguments, this.getFunctionName());
        }
        SqlTypedMapping[] selectableMappings = this.getSetReturningTypeResolver().resolveFunctionReturnType(arguments, identifierVariable, lateral, withOrdinality, walker);
        AnonymousTupleTableGroupProducer tableGroupProducer = this.getType().resolveTableGroupProducer(identifierVariable, selectableMappings, walker.getFromClauseAccess());
        return new FunctionTableGroup(navigablePath, tableGroupProducer, new SetReturningFunctionExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, tableGroupProducer, identifierVariable), identifierVariable, tableGroupProducer.getColumnNames(), tableGroupProducer.getCompatibleTableExpressions(), lateral, canUseInnerJoins, this.getFunctionRenderer().rendersIdentifierVariable(arguments, walker.getCreationContext().getSessionFactory()), walker.getCreationContext().getSessionFactory());
    }

    private static class FunctionArgumentTypeResolverTypeAccess
    implements Supplier<MappingModelExpressible<?>> {
        private final SqmToSqlAstConverter converter;
        private final SqmSetReturningFunction<?> function;
        private final FunctionArgumentTypeResolver argumentTypeResolver;
        private int argumentIndex;

        public FunctionArgumentTypeResolverTypeAccess(SqmToSqlAstConverter converter, SqmSetReturningFunction<?> function, FunctionArgumentTypeResolver argumentTypeResolver) {
            this.converter = converter;
            this.function = function;
            this.argumentTypeResolver = argumentTypeResolver;
        }

        @Override
        public MappingModelExpressible<?> get() {
            return this.argumentTypeResolver.resolveFunctionArgumentType(this.function.getArguments(), this.argumentIndex, this.converter);
        }
    }

    private record SetReturningFunctionExpression(String functionName, SetReturningFunctionRenderer functionRenderer, List<SqlAstNode> arguments, AnonymousTupleTableGroupProducer tableGroupProducer, String tableIdentifierVariable) implements SelfRenderingExpression,
    FunctionExpression
    {
        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public List<? extends SqlAstNode> getArguments() {
            return this.arguments;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            this.functionRenderer.render(sqlAppender, this.arguments, this.tableGroupProducer, this.tableIdentifierVariable, walker);
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.tableGroupProducer;
        }
    }
}

