/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.util;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.RuntimeResourceVisitor;

public class ScoreSystem {
    public static EndpointScores latestScores;
    public static final RuntimeResourceVisitor ScoreVisitor;

    static {
        ScoreVisitor = new RuntimeResourceVisitor(){
            int overallScore = 0;
            int overallTotal = 0;
            final List<EndpointScore> endpoints = new ArrayList<EndpointScore>();

            @Override
            public void visitRuntimeResource(String httpMethod, String fullPath, RuntimeResource runtimeResource) {
                ServerMediaType serverMediaType = runtimeResource.getProduces();
                List<MediaType> produces = Collections.emptyList();
                if (serverMediaType != null && serverMediaType.getSortedOriginalMediaTypes() != null && serverMediaType.getSortedOriginalMediaTypes().length >= 1) {
                    produces = Arrays.asList(serverMediaType.getSortedOriginalMediaTypes());
                }
                ServerRestHandler[] handlerChain = runtimeResource.getHandlerChain();
                ArrayList<RequestFilterEntry> requestFilters = new ArrayList<RequestFilterEntry>();
                for (ServerRestHandler serverRestHandler : handlerChain) {
                    if (!(serverRestHandler instanceof ResourceRequestFilterHandler)) continue;
                    ResourceRequestFilterHandler requestFilterHandler = (ResourceRequestFilterHandler)serverRestHandler;
                    requestFilters.add(new RequestFilterEntry(requestFilterHandler.getFilter().getClass().getName(), requestFilterHandler.isPreMatch()));
                }
                List<MediaType> consumes = runtimeResource.getConsumes();
                if (runtimeResource.getScore() == null) {
                    return;
                }
                int score = 0;
                int total = 0;
                for (Map.Entry<Category, List<Diagnostic>> scoreEntry : runtimeResource.getScore().entrySet()) {
                    for (Diagnostic diagnostic : scoreEntry.getValue()) {
                        score += diagnostic.score;
                    }
                    total += 100;
                }
                score = (int)Math.floor((float)score / (float)total * 100.0f);
                this.overallScore += score;
                this.overallTotal += 100;
                this.endpoints.add(new EndpointScore(runtimeResource.getResourceClass().getName(), httpMethod, fullPath, produces, consumes, runtimeResource.getScore(), score, requestFilters));
            }

            @Override
            public void visitEnd() {
                if (this.overallScore == 0) {
                    return;
                }
                this.overallScore = (int)Math.floor((float)this.overallScore / (float)this.overallTotal * 100.0f);
                latestScores = new EndpointScores(this.overallScore, this.endpoints);
            }

            @Override
            public void visitStart() {
                this.endpoints.clear();
                this.overallScore = 0;
                this.overallTotal = 0;
            }
        };
    }

    public static enum Category {
        Writer,
        Resource,
        Execution;

    }

    public static class Diagnostic {
        public final String message;
        public final int score;
        public static Diagnostic ExecutionNonBlocking = new Diagnostic("Dispatched on the IO thread", 100);
        public static Diagnostic ExecutionBlocking = new Diagnostic("Relies on a blocking worker thread", 0);
        public static Diagnostic ExecutionVirtualThread = new Diagnostic("Relies on a virtual thread", 66);
        public static Diagnostic ResourceSingleton = new Diagnostic("Single resource instance for all requests", 100);
        public static Diagnostic ResourcePerRequest = new Diagnostic("New resource instance for every request", 0);
        public static Diagnostic WriterRunTime = new Diagnostic("Run time writers required", 0);
        public static Diagnostic WriterNotRequired = new Diagnostic("No writers required", 100);

        public Diagnostic(String message, int percentageScore) {
            this.message = message;
            this.score = percentageScore;
        }

        public String toString() {
            return this.message + ": " + this.score + "/100";
        }

        public static Diagnostic WriterBuildTime(MessageBodyWriter<?> buildTimeWriter) {
            return new Diagnostic("Single writer set at build time: " + buildTimeWriter.getClass().getName(), 90);
        }

        public static Diagnostic WriterBuildTimeDirect(MessageBodyWriter<?> buildTimeWriter) {
            return new Diagnostic("Single direct writer set at build time: " + buildTimeWriter.getClass().getName(), 100);
        }

        public static Diagnostic WriterBuildTimeMultiple(List<MessageBodyWriter<?>> buildTimeWriters) {
            return new Diagnostic("Multiple writers set at build time: [" + Diagnostic.getClassNames(buildTimeWriters) + "]", 50);
        }

        private static String getClassNames(List<MessageBodyWriter<?>> buildTimeWriters) {
            ArrayList<String> classNames = new ArrayList<String>(buildTimeWriters.size());
            for (MessageBodyWriter<?> buildTimeWriter : buildTimeWriters) {
                classNames.add(buildTimeWriter.getClass().getName());
            }
            return String.join((CharSequence)", ", classNames);
        }
    }

    public static class RequestFilterEntry {
        public final String name;
        public final boolean preMatch;

        public String getName() {
            String removeSubClass = this.name.replace("_Subclass", "");
            String finalFilterName = removeSubClass.replaceAll("\\$.*?\\$", "::");
            return finalFilterName;
        }

        public RequestFilterEntry(String name, boolean preMatch) {
            this.name = name;
            this.preMatch = preMatch;
        }
    }

    public static class EndpointScore {
        public final String className;
        public final String httpMethod;
        public final String fullPath;
        public final List<MediaType> produces;
        public final List<MediaType> consumes;
        public final Map<Category, List<Diagnostic>> diagnostics;
        public final int score;
        public final List<RequestFilterEntry> requestFilterEntries;

        public EndpointScore(String className, String httpMethod, String fullPath, List<MediaType> produces, List<MediaType> consumes, Map<Category, List<Diagnostic>> diagnostics, int score, List<RequestFilterEntry> requestFilterEntries) {
            this.className = className;
            this.httpMethod = httpMethod;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
            this.diagnostics = diagnostics;
            this.score = score;
            this.requestFilterEntries = requestFilterEntries;
        }
    }

    public static class EndpointScores {
        public final List<EndpointScore> endpoints;
        public final int score;

        public EndpointScores(int score, List<EndpointScore> endpoints) {
            this.score = score;
            this.endpoints = endpoints;
        }
    }
}

