/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.NameIdMapperHelper;
import org.keycloak.protocol.saml.mappers.SAMLNameIdMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeNameIdMapper
extends AbstractSAMLProtocolMapper
implements SAMLNameIdMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "saml-user-attribute-nameid-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Attribute Mapper For NameID";
    }

    public String getDisplayCategory() {
        return "NameID Mapper";
    }

    public String getHelpText() {
        return "Map user attribute to SAML NameID value.";
    }

    @Override
    public String mapperNameId(String nameIdFormat, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        return userSession.getUser().getFirstAttribute((String)mappingModel.getConfig().get("user.attribute"));
    }

    static {
        NameIdMapperHelper.setConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.attribute");
        property.setLabel("usermodel.attr.label");
        property.setHelpText("usermodel.attr.tooltip");
        property.setType("UserProfileAttributeList");
        property.setRequired(Boolean.TRUE.booleanValue());
        configProperties.add(property);
    }
}

