/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.common.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.InternalServiceProviders;
import io.quarkus.grpc.common.runtime.graal.Target_io_grpc_ServiceProviders_PriorityAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceConfigurationError;

@TargetClass(className="io.grpc.ServiceProviders")
final class Target_io_grpc_ServiceProviders {
    Target_io_grpc_ServiceProviders() {
    }

    @Substitute
    static boolean isAndroid(ClassLoader cl) {
        return false;
    }

    @Substitute
    private static <T> T createForHardCoded(Class<T> klass, Class<?> rawClass) {
        try {
            return rawClass.asSubclass(klass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            throw new ServiceConfigurationError(String.format("Provider %s could not be instantiated %s", rawClass.getName(), t), t);
        }
    }

    @Substitute
    public static <T> List<T> loadAll(Class<T> klass, Iterable<Class<?>> hardcoded, ClassLoader cl, final Target_io_grpc_ServiceProviders_PriorityAccessor<T> priorityAccessor) {
        Iterable candidates = InternalServiceProviders.getCandidatesViaHardCoded(klass, hardcoded);
        ArrayList list = new ArrayList();
        for (Object current : candidates) {
            if (!priorityAccessor.isAvailable(current)) continue;
            list.add(current);
        }
        Collections.sort(list, Collections.reverseOrder(new Comparator<T>(){

            @Override
            public int compare(T f1, T f2) {
                int pd = priorityAccessor.getPriority(f1) - priorityAccessor.getPriority(f2);
                if (pd != 0) {
                    return pd;
                }
                return f1.getClass().getName().compareTo(f2.getClass().getName());
            }
        }));
        return Collections.unmodifiableList(list);
    }
}

