/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.container;

import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.DefaultCommandContainer;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;

public class AeshCommandContainer<CI extends CommandInvocation>
extends DefaultCommandContainer<CI> {
    private CommandLineParser<CI> parser;
    private String errorMessage;

    public AeshCommandContainer(CommandLineParser<CI> parser) {
        if (parser != null && parser.getProcessedCommand() != null) {
            this.parser = parser;
        }
    }

    public AeshCommandContainer(ProcessedCommand<Command<CI>, CI> processedCommand) {
        this.parser = new AeshCommandLineParser<CI>(processedCommand);
    }

    public AeshCommandContainer(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public CommandLineParser<CI> getParser() {
        return this.parser;
    }

    @Override
    public boolean haveBuildError() {
        return this.errorMessage != null;
    }

    @Override
    public String getBuildErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void close() {
    }

    public void addChild(CommandContainer<CI> commandContainer) throws CommandLineParserException {
        this.getParser().addChildParser(commandContainer.getParser());
    }

    public String toString() {
        return "AeshCommandContainer{parser=" + this.parser + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

