/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.server.common.MetadataVersion;

public final class ClusterDelta {
    private final ClusterImage image;
    private final HashMap<Integer, Optional<BrokerRegistration>> changedBrokers = new HashMap();
    private final HashMap<Integer, Optional<ControllerRegistration>> changedControllers = new HashMap();

    public ClusterDelta(ClusterImage image) {
        this.image = image;
    }

    public HashMap<Integer, Optional<BrokerRegistration>> changedBrokers() {
        return this.changedBrokers;
    }

    public HashMap<Integer, Optional<ControllerRegistration>> changedControllers() {
        return this.changedControllers;
    }

    public BrokerRegistration broker(int nodeId) {
        Optional<BrokerRegistration> result = this.changedBrokers.get(nodeId);
        if (result != null) {
            return result.orElse(null);
        }
        return this.image.broker(nodeId);
    }

    public void finishSnapshot() {
        for (Integer brokerId : this.image.brokers().keySet()) {
            if (this.changedBrokers.containsKey(brokerId)) continue;
            this.changedBrokers.put(brokerId, Optional.empty());
        }
        for (Integer controllerId : this.image.controllers().keySet()) {
            if (this.changedControllers.containsKey(controllerId)) continue;
            this.changedControllers.put(controllerId, Optional.empty());
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public void replay(RegisterBrokerRecord record) {
        BrokerRegistration broker = BrokerRegistration.fromRecord(record);
        this.changedBrokers.put(broker.id(), Optional.of(broker));
    }

    public void replay(UnregisterBrokerRecord record) {
        this.changedBrokers.put(record.brokerId(), Optional.empty());
    }

    public void replay(RegisterControllerRecord record) {
        ControllerRegistration controller = new ControllerRegistration.Builder(record).build();
        this.changedControllers.put(controller.id(), Optional.of(controller));
    }

    private BrokerRegistration getBrokerOrThrow(int brokerId, long epoch, String action) {
        BrokerRegistration broker = this.broker(brokerId);
        if (broker == null) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but that broker was not registered.");
        }
        if (broker.epoch() != epoch) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but the given epoch, " + epoch + ", did not match the current broker epoch, " + broker.epoch());
        }
        return broker;
    }

    public void replay(FenceBrokerRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.id(), record.epoch(), "fence");
        this.changedBrokers.put(record.id(), Optional.of(curRegistration.cloneWith(BrokerRegistrationFencingChange.FENCE.asBoolean(), Optional.empty(), Optional.empty())));
    }

    public void replay(UnfenceBrokerRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.id(), record.epoch(), "unfence");
        this.changedBrokers.put(record.id(), Optional.of(curRegistration.cloneWith(BrokerRegistrationFencingChange.UNFENCE.asBoolean(), Optional.empty(), Optional.empty())));
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.brokerId(), record.brokerEpoch(), "change");
        BrokerRegistrationFencingChange fencingChange = BrokerRegistrationFencingChange.fromValue(record.fenced()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for fenced field: %d", record, record.fenced())));
        BrokerRegistrationInControlledShutdownChange inControlledShutdownChange = BrokerRegistrationInControlledShutdownChange.fromValue(record.inControlledShutdown()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for inControlledShutdown field: %d", record, record.inControlledShutdown())));
        Optional<List<Uuid>> directoriesChange = Optional.ofNullable(record.logDirs()).filter(list -> !list.isEmpty());
        BrokerRegistration nextRegistration = curRegistration.cloneWith(fencingChange.asBoolean(), inControlledShutdownChange.asBoolean(), directoriesChange);
        if (!curRegistration.equals(nextRegistration)) {
            this.changedBrokers.put(record.brokerId(), Optional.of(nextRegistration));
        }
    }

    public ClusterImage apply() {
        HashMap<Integer, BrokerRegistration> newBrokers = new HashMap<Integer, BrokerRegistration>(this.image.brokers().size());
        for (Map.Entry<Integer, BrokerRegistration> entry : this.image.brokers().entrySet()) {
            int n = entry.getKey();
            Optional<BrokerRegistration> change = this.changedBrokers.get(n);
            if (change == null) {
                newBrokers.put(n, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newBrokers.put(n, change.get());
        }
        for (Map.Entry<Integer, Object> entry : this.changedBrokers.entrySet()) {
            int n = entry.getKey();
            Optional brokerRegistration = (Optional)entry.getValue();
            if (newBrokers.containsKey(n)) continue;
            brokerRegistration.ifPresent(registration -> newBrokers.put(nodeId, (BrokerRegistration)registration));
        }
        HashMap<Integer, ControllerRegistration> newControllers = new HashMap<Integer, ControllerRegistration>(this.image.controllers().size());
        for (Map.Entry<Integer, ControllerRegistration> entry : this.image.controllers().entrySet()) {
            int nodeId2 = entry.getKey();
            Optional<ControllerRegistration> change = this.changedControllers.get(nodeId2);
            if (change == null) {
                newControllers.put(nodeId2, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newControllers.put(nodeId2, change.get());
        }
        for (Map.Entry<Integer, Optional<ControllerRegistration>> entry : this.changedControllers.entrySet()) {
            int nodeId3 = entry.getKey();
            Optional<ControllerRegistration> controllerRegistration = entry.getValue();
            if (newControllers.containsKey(nodeId3)) continue;
            controllerRegistration.ifPresent(registration -> newControllers.put(nodeId3, (ControllerRegistration)registration));
        }
        return new ClusterImage(newBrokers, newControllers);
    }

    public String toString() {
        return "ClusterDelta(changedBrokers=" + String.valueOf(this.changedBrokers) + ", changedControllers=" + String.valueOf(this.changedControllers) + ")";
    }
}

