/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataDelta;

public interface CoordinatorMetadataImage {
    public static final CoordinatorMetadataImage EMPTY = CoordinatorMetadataImage.emptyImage();

    public Set<Uuid> topicIds();

    public Set<String> topicNames();

    public Optional<TopicMetadata> topicMetadata(String var1);

    public Optional<TopicMetadata> topicMetadata(Uuid var1);

    public CoordinatorMetadataDelta emptyDelta();

    public long version();

    public boolean isEmpty();

    private static CoordinatorMetadataImage emptyImage() {
        return new CoordinatorMetadataImage(){

            @Override
            public Set<Uuid> topicIds() {
                return Set.of();
            }

            @Override
            public Set<String> topicNames() {
                return Set.of();
            }

            @Override
            public Optional<TopicMetadata> topicMetadata(String topicName) {
                return Optional.empty();
            }

            @Override
            public Optional<TopicMetadata> topicMetadata(Uuid topicId) {
                return Optional.empty();
            }

            @Override
            public CoordinatorMetadataDelta emptyDelta() {
                return CoordinatorMetadataDelta.EMPTY;
            }

            @Override
            public long version() {
                return 0L;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    public static interface TopicMetadata {
        public String name();

        public Uuid id();

        public int partitionCount();

        public List<String> partitionRacks(int var1);
    }
}

