/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;

public class StreamJoinedInternal<K, V1, V2>
extends StreamJoined<K, V1, V2> {
    private final DslStoreSuppliers passedInDslStoreSuppliers;

    public StreamJoinedInternal(StreamJoined<K, V1, V2> streamJoined, InternalStreamsBuilder builder) {
        super(streamJoined);
        TopologyConfig topologyConfig;
        this.passedInDslStoreSuppliers = this.dslStoreSuppliers;
        if (this.dslStoreSuppliers == null && (topologyConfig = builder.internalTopologyBuilder().topologyConfigs()) != null) {
            this.dslStoreSuppliers = topologyConfig.resolveDslStoreSuppliers().orElse(null);
        }
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V1> valueSerde() {
        return this.valueSerde;
    }

    public Serde<V2> otherValueSerde() {
        return this.otherValueSerde;
    }

    public String name() {
        return this.name;
    }

    public String storeName() {
        return this.storeName;
    }

    public DslStoreSuppliers passedInDslStoreSuppliers() {
        return this.passedInDslStoreSuppliers;
    }

    public DslStoreSuppliers dslStoreSuppliers() {
        return this.dslStoreSuppliers;
    }

    public WindowBytesStoreSupplier thisStoreSupplier() {
        return this.thisStoreSupplier;
    }

    public WindowBytesStoreSupplier otherStoreSupplier() {
        return this.otherStoreSupplier;
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    Map<String, String> logConfig() {
        return this.topicConfig;
    }
}

