/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.streams.StreamsCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.streams.StreamsGroupMember;
import org.apache.kafka.coordinator.group.streams.TasksTuple;
import org.apache.kafka.coordinator.group.streams.TopologyMetadata;
import org.apache.kafka.coordinator.group.streams.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.streams.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.GroupSpecImpl;
import org.apache.kafka.coordinator.group.streams.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignor;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignorException;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredTopology;
import org.apache.kafka.image.MetadataImage;

public class TargetAssignmentBuilder {
    private final String groupId;
    private final int groupEpoch;
    private final TaskAssignor assignor;
    private final Map<String, String> assignmentConfigs;
    private final Map<String, StreamsGroupMember> updatedMembers = new HashMap<String, StreamsGroupMember>();
    private Map<String, StreamsGroupMember> members = Map.of();
    private MetadataImage metadataImage = MetadataImage.EMPTY;
    private Map<String, TasksTuple> targetAssignment = Map.of();
    private ConfiguredTopology topology;
    private Map<String, String> staticMembers = Map.of();

    public TargetAssignmentBuilder(String groupId, int groupEpoch, TaskAssignor assignor, Map<String, String> assignmentConfigs) {
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = groupEpoch;
        this.assignor = Objects.requireNonNull(assignor);
        this.assignmentConfigs = Objects.requireNonNull(assignmentConfigs);
    }

    static AssignmentMemberSpec createAssignmentMemberSpec(StreamsGroupMember member, TasksTuple targetAssignment) {
        return new AssignmentMemberSpec(member.instanceId(), member.rackId(), targetAssignment.activeTasks(), targetAssignment.standbyTasks(), targetAssignment.warmupTasks(), member.processId(), member.clientTags(), Map.of(), Map.of());
    }

    public TargetAssignmentBuilder withMembers(Map<String, StreamsGroupMember> members) {
        this.members = members;
        return this;
    }

    public TargetAssignmentBuilder withStaticMembers(Map<String, String> staticMembers) {
        this.staticMembers = staticMembers;
        return this;
    }

    public TargetAssignmentBuilder withMetadataImage(MetadataImage metadataImage) {
        this.metadataImage = metadataImage;
        return this;
    }

    public TargetAssignmentBuilder withTargetAssignment(Map<String, TasksTuple> targetAssignment) {
        this.targetAssignment = targetAssignment;
        return this;
    }

    public TargetAssignmentBuilder withTopology(ConfiguredTopology topology) {
        this.topology = topology;
        return this;
    }

    public TargetAssignmentBuilder addOrUpdateMember(String memberId, StreamsGroupMember member) {
        this.updatedMembers.put(memberId, member);
        return this;
    }

    public TargetAssignmentBuilder removeMember(String memberId) {
        return this.addOrUpdateMember(memberId, null);
    }

    public TargetAssignmentResult build() throws TaskAssignorException {
        GroupAssignment newGroupAssignment;
        HashMap memberSpecs = new HashMap();
        this.members.forEach((memberId, member) -> memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec(member, this.targetAssignment.getOrDefault(memberId, TasksTuple.EMPTY))));
        this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
            if (updatedMemberOrNull == null) {
                memberSpecs.remove(memberId);
            } else {
                String previousMemberId;
                TasksTuple assignment = this.targetAssignment.getOrDefault(memberId, TasksTuple.EMPTY);
                if (updatedMemberOrNull.instanceId().isPresent() && (previousMemberId = this.staticMembers.get(updatedMemberOrNull.instanceId().get())) != null && !previousMemberId.equals(memberId)) {
                    assignment = this.targetAssignment.getOrDefault(previousMemberId, TasksTuple.EMPTY);
                }
                memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec(updatedMemberOrNull, assignment));
            }
        });
        if (this.topology.isReady()) {
            if (this.topology.subtopologies().isEmpty()) {
                throw new IllegalStateException("Subtopologies must be present if topology is ready.");
            }
            newGroupAssignment = this.assignor.assign(new GroupSpecImpl(Collections.unmodifiableMap(memberSpecs), this.assignmentConfigs), new TopologyMetadata(this.metadataImage, this.topology.subtopologies().get()));
        } else {
            newGroupAssignment = new GroupAssignment(memberSpecs.keySet().stream().collect(Collectors.toMap(x -> x, x -> MemberAssignment.empty())));
        }
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        HashMap<String, TasksTuple> newTargetAssignment = new HashMap<String, TasksTuple>();
        memberSpecs.keySet().forEach(memberId -> {
            TasksTuple oldMemberAssignment = this.targetAssignment.get(memberId);
            TasksTuple newMemberAssignment = this.newMemberAssignment(newGroupAssignment, (String)memberId);
            newTargetAssignment.put((String)memberId, newMemberAssignment);
            if (oldMemberAssignment == null) {
                records.add(StreamsCoordinatorRecordHelpers.newStreamsGroupTargetAssignmentRecord(this.groupId, memberId, newMemberAssignment));
            } else if (!newMemberAssignment.equals(oldMemberAssignment)) {
                records.add(StreamsCoordinatorRecordHelpers.newStreamsGroupTargetAssignmentRecord(this.groupId, memberId, newMemberAssignment));
            }
        });
        records.add(StreamsCoordinatorRecordHelpers.newStreamsGroupTargetAssignmentEpochRecord(this.groupId, this.groupEpoch));
        return new TargetAssignmentResult(records, newTargetAssignment);
    }

    private TasksTuple newMemberAssignment(GroupAssignment newGroupAssignment, String memberId) {
        MemberAssignment newMemberAssignment = newGroupAssignment.members().get(memberId);
        if (newMemberAssignment != null) {
            return new TasksTuple(newMemberAssignment.activeTasks(), newMemberAssignment.standbyTasks(), newMemberAssignment.warmupTasks());
        }
        return TasksTuple.EMPTY;
    }

    public record TargetAssignmentResult(List<CoordinatorRecord> records, Map<String, TasksTuple> targetAssignment) {
        public TargetAssignmentResult {
            Objects.requireNonNull(records);
            Objects.requireNonNull(targetAssignment);
        }
    }
}

