/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.kafka.clients.consumer.internals.SensorBuilder;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.utils.Utils;

public class FetchMetricsManager {
    private final Metrics metrics;
    private final FetchMetricsRegistry metricsRegistry;
    private final Sensor throttleTime;
    private final Sensor bytesFetched;
    private final Sensor recordsFetched;
    private final Sensor fetchLatency;
    private final Sensor recordsLag;
    private final Sensor recordsLead;
    private int assignmentId = 0;
    private Set<TopicPartition> assignedPartitions = Collections.emptySet();

    public FetchMetricsManager(Metrics metrics, FetchMetricsRegistry metricsRegistry) {
        this.metrics = metrics;
        this.metricsRegistry = metricsRegistry;
        this.throttleTime = new SensorBuilder(metrics, "fetch-throttle-time").withAvg(metricsRegistry.fetchThrottleTimeAvg).withMax(metricsRegistry.fetchThrottleTimeMax).build();
        this.bytesFetched = new SensorBuilder(metrics, "bytes-fetched").withAvg(metricsRegistry.fetchSizeAvg).withMax(metricsRegistry.fetchSizeMax).withMeter(metricsRegistry.bytesConsumedRate, metricsRegistry.bytesConsumedTotal).build();
        this.recordsFetched = new SensorBuilder(metrics, "records-fetched").withAvg(metricsRegistry.recordsPerRequestAvg).withMeter(metricsRegistry.recordsConsumedRate, metricsRegistry.recordsConsumedTotal).build();
        this.fetchLatency = new SensorBuilder(metrics, "fetch-latency").withAvg(metricsRegistry.fetchLatencyAvg).withMax(metricsRegistry.fetchLatencyMax).withMeter(new WindowedCount(), metricsRegistry.fetchRequestRate, metricsRegistry.fetchRequestTotal).build();
        this.recordsLag = new SensorBuilder(metrics, "records-lag").withMax(metricsRegistry.recordsLagMax).build();
        this.recordsLead = new SensorBuilder(metrics, "records-lead").withMin(metricsRegistry.recordsLeadMin).build();
    }

    public Sensor throttleTimeSensor() {
        return this.throttleTime;
    }

    void recordLatency(String node, long requestLatencyMs) {
        String nodeTimeName;
        Sensor nodeRequestTime;
        this.fetchLatency.record(requestLatencyMs);
        if (!node.isEmpty() && (nodeRequestTime = this.metrics.getSensor(nodeTimeName = "node-" + node + ".latency")) != null) {
            nodeRequestTime.record(requestLatencyMs);
        }
    }

    void recordBytesFetched(int bytes) {
        this.bytesFetched.record(bytes);
    }

    void recordRecordsFetched(int records) {
        this.recordsFetched.record(records);
    }

    void recordBytesFetched(String topic, int bytes) {
        String name = FetchMetricsManager.topicBytesFetchedMetricName(topic);
        this.maybeRecordDeprecatedBytesFetched(name, topic, bytes);
        Sensor bytesFetched = new SensorBuilder(this.metrics, name, () -> Map.of("topic", topic)).withAvg(this.metricsRegistry.topicFetchSizeAvg).withMax(this.metricsRegistry.topicFetchSizeMax).withMeter(this.metricsRegistry.topicBytesConsumedRate, this.metricsRegistry.topicBytesConsumedTotal).build();
        bytesFetched.record(bytes);
    }

    void recordRecordsFetched(String topic, int records) {
        String name = FetchMetricsManager.topicRecordsFetchedMetricName(topic);
        this.maybeRecordDeprecatedRecordsFetched(name, topic, records);
        Sensor recordsFetched = new SensorBuilder(this.metrics, name, () -> Map.of("topic", topic)).withAvg(this.metricsRegistry.topicRecordsPerRequestAvg).withMeter(this.metricsRegistry.topicRecordsConsumedRate, this.metricsRegistry.topicRecordsConsumedTotal).build();
        recordsFetched.record(records);
    }

    void recordPartitionLag(TopicPartition tp, long lag) {
        this.recordsLag.record(lag);
        String name = FetchMetricsManager.partitionRecordsLagMetricName(tp);
        this.maybeRecordDeprecatedPartitionLag(name, tp, lag);
        Sensor recordsLag = new SensorBuilder(this.metrics, name, () -> Utils.mkMap(Utils.mkEntry("topic", tp.topic()), Utils.mkEntry("partition", String.valueOf(tp.partition())))).withValue(this.metricsRegistry.partitionRecordsLag).withMax(this.metricsRegistry.partitionRecordsLagMax).withAvg(this.metricsRegistry.partitionRecordsLagAvg).build();
        recordsLag.record(lag);
    }

    void recordPartitionLead(TopicPartition tp, long lead) {
        this.recordsLead.record(lead);
        String name = FetchMetricsManager.partitionRecordsLeadMetricName(tp);
        this.maybeRecordDeprecatedPartitionLead(name, tp, lead);
        Sensor recordsLead = new SensorBuilder(this.metrics, name, () -> Utils.mkMap(Utils.mkEntry("topic", tp.topic()), Utils.mkEntry("partition", String.valueOf(tp.partition())))).withValue(this.metricsRegistry.partitionRecordsLead).withMin(this.metricsRegistry.partitionRecordsLeadMin).withAvg(this.metricsRegistry.partitionRecordsLeadAvg).build();
        recordsLead.record(lead);
    }

    void maybeUpdateAssignment(SubscriptionState subscription) {
        int newAssignmentId = subscription.assignmentId();
        if (this.assignmentId != newAssignmentId) {
            Set<TopicPartition> newAssignedPartitions = subscription.assignedPartitions();
            for (TopicPartition tp : this.assignedPartitions) {
                if (newAssignedPartitions.contains(tp)) continue;
                this.metrics.removeSensor(FetchMetricsManager.partitionRecordsLagMetricName(tp));
                this.metrics.removeSensor(FetchMetricsManager.partitionRecordsLeadMetricName(tp));
                this.metrics.removeMetric(this.partitionPreferredReadReplicaMetricName(tp));
                this.metrics.removeSensor(FetchMetricsManager.deprecatedMetricName(FetchMetricsManager.partitionRecordsLagMetricName(tp)));
                this.metrics.removeSensor(FetchMetricsManager.deprecatedMetricName(FetchMetricsManager.partitionRecordsLeadMetricName(tp)));
                this.metrics.removeMetric(this.deprecatedPartitionPreferredReadReplicaMetricName(tp));
            }
            for (TopicPartition tp : newAssignedPartitions) {
                if (this.assignedPartitions.contains(tp)) continue;
                this.maybeRecordDeprecatedPreferredReadReplica(tp, subscription);
                MetricName metricName = this.partitionPreferredReadReplicaMetricName(tp);
                this.metrics.addMetricIfAbsent(metricName, null, (config, now) -> subscription.preferredReadReplica(tp, 0L).orElse(-1));
            }
            this.assignedPartitions = newAssignedPartitions;
            this.assignmentId = newAssignmentId;
        }
    }

    @Deprecated
    private void maybeRecordDeprecatedBytesFetched(String name, String topic, int bytes) {
        if (FetchMetricsManager.shouldReportDeprecatedMetric(topic)) {
            Sensor deprecatedBytesFetched = new SensorBuilder(this.metrics, FetchMetricsManager.deprecatedMetricName(name), () -> FetchMetricsManager.topicTags(topic)).withAvg(this.metricsRegistry.topicFetchSizeAvg).withMax(this.metricsRegistry.topicFetchSizeMax).withMeter(this.metricsRegistry.topicBytesConsumedRate, this.metricsRegistry.topicBytesConsumedTotal).build();
            deprecatedBytesFetched.record(bytes);
        }
    }

    @Deprecated
    private void maybeRecordDeprecatedRecordsFetched(String name, String topic, int records) {
        if (FetchMetricsManager.shouldReportDeprecatedMetric(topic)) {
            Sensor deprecatedRecordsFetched = new SensorBuilder(this.metrics, FetchMetricsManager.deprecatedMetricName(name), () -> FetchMetricsManager.topicTags(topic)).withAvg(this.metricsRegistry.topicRecordsPerRequestAvg).withMeter(this.metricsRegistry.topicRecordsConsumedRate, this.metricsRegistry.topicRecordsConsumedTotal).build();
            deprecatedRecordsFetched.record(records);
        }
    }

    @Deprecated
    private void maybeRecordDeprecatedPartitionLag(String name, TopicPartition tp, long lag) {
        if (FetchMetricsManager.shouldReportDeprecatedMetric(tp.topic())) {
            Sensor deprecatedRecordsLag = new SensorBuilder(this.metrics, FetchMetricsManager.deprecatedMetricName(name), () -> FetchMetricsManager.topicPartitionTags(tp)).withValue(this.metricsRegistry.partitionRecordsLag).withMax(this.metricsRegistry.partitionRecordsLagMax).withAvg(this.metricsRegistry.partitionRecordsLagAvg).build();
            deprecatedRecordsLag.record(lag);
        }
    }

    @Deprecated
    private void maybeRecordDeprecatedPartitionLead(String name, TopicPartition tp, double lead) {
        if (FetchMetricsManager.shouldReportDeprecatedMetric(tp.topic())) {
            Sensor deprecatedRecordsLead = new SensorBuilder(this.metrics, FetchMetricsManager.deprecatedMetricName(name), () -> FetchMetricsManager.topicPartitionTags(tp)).withValue(this.metricsRegistry.partitionRecordsLead).withMin(this.metricsRegistry.partitionRecordsLeadMin).withAvg(this.metricsRegistry.partitionRecordsLeadAvg).build();
            deprecatedRecordsLead.record(lead);
        }
    }

    @Deprecated
    private void maybeRecordDeprecatedPreferredReadReplica(TopicPartition tp, SubscriptionState subscription) {
        if (FetchMetricsManager.shouldReportDeprecatedMetric(tp.topic())) {
            MetricName metricName = this.deprecatedPartitionPreferredReadReplicaMetricName(tp);
            this.metrics.addMetricIfAbsent(metricName, null, (config, now) -> subscription.preferredReadReplica(tp, 0L).orElse(-1));
        }
    }

    private static String topicBytesFetchedMetricName(String topic) {
        return "topic." + topic + ".bytes-fetched";
    }

    private static String topicRecordsFetchedMetricName(String topic) {
        return "topic." + topic + ".records-fetched";
    }

    private static String partitionRecordsLeadMetricName(TopicPartition tp) {
        return String.valueOf(tp) + ".records-lead";
    }

    private static String partitionRecordsLagMetricName(TopicPartition tp) {
        return String.valueOf(tp) + ".records-lag";
    }

    private static String deprecatedMetricName(String name) {
        return name + ".deprecated";
    }

    private static boolean shouldReportDeprecatedMetric(String topic) {
        return topic.contains(".");
    }

    private MetricName partitionPreferredReadReplicaMetricName(TopicPartition tp) {
        Map<String, String> metricTags = Utils.mkMap(Utils.mkEntry("topic", tp.topic()), Utils.mkEntry("partition", String.valueOf(tp.partition())));
        return this.metrics.metricInstance(this.metricsRegistry.partitionPreferredReadReplica, metricTags);
    }

    @Deprecated
    private MetricName deprecatedPartitionPreferredReadReplicaMetricName(TopicPartition tp) {
        Map<String, String> metricTags = FetchMetricsManager.topicPartitionTags(tp);
        return this.metrics.metricInstance(this.metricsRegistry.partitionPreferredReadReplica, metricTags);
    }

    @Deprecated
    static Map<String, String> topicTags(String topic) {
        return Map.of("topic", topic.replace('.', '_'));
    }

    @Deprecated
    static Map<String, String> topicPartitionTags(TopicPartition tp) {
        return Utils.mkMap(Utils.mkEntry("topic", tp.topic().replace('.', '_')), Utils.mkEntry("partition", String.valueOf(tp.partition())));
    }
}

