/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Encoding;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.exception.JSVException;
import org.jmol.api.GenericFileInterface;
import org.jmol.util.Logger;

@J2SIgnoreImport(value={FileOutputStream.class})
public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static Map<String, String> htCorrelationCache;
    private static String cacheDir;
    private static String nciResolver;
    private static String nmrdbServerH1;
    private static String nmrdbServerC13;
    private static int stringCount;

    static {
        jsDocumentBase = "";
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        htCorrelationCache = new Hashtable<String, String>();
        cacheDir = null;
        nciResolver = "https://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServerH1 = "https://nmr-prediction.service.zakodium.com/v1/predict/proton?POST?{\"molfile\":\"$MOLFILE\",\"includeJDX\":true}";
        nmrdbServerC13 = "https://nmr-prediction.service.zakodium.com/v1/predict/carbon?POST?{\"molfile\":\"$MOLFILE\",\"includeJDX\":true}";
    }

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string);
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2);
                sB.appendC('\n');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return sB.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForStringOrBytes(Object object) {
        return object == null ? null : new BufferedReader(new StringReader(object instanceof String ? (String)object : new String((byte[])object)));
    }

    public static BufferedReader getBufferedReaderFromName(String string) throws Exception {
        if (string == null) {
            throw new JSVException("Cannot find " + string);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + string);
        String string2 = JSVFileManager.getFullPathName(string);
        if (!string2.equals(string)) {
            Logger.info("JSVFileManager getBufferedReaderFromName " + string2);
        }
        return JSVFileManager.getUnzippedBufferedReaderFromName(string2);
    }

    public static String getFullPathName(String string) throws JSVException {
        try {
            if (appletDocumentBase == null) {
                if (JSVFileManager.isURL(string)) {
                    URL uRL = new URL(null, string, null);
                    return uRL.toString();
                }
                return JSVFileManager.newFile(string).getFullPath();
            }
            if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                string = "file:///" + string;
            } else if (string.startsWith("cache://")) {
                return string;
            }
            URL uRL = new URL(appletDocumentBase, string, null);
            return uRL.toString();
        }
        catch (Exception exception) {
            throw new JSVException("Cannot create path for " + string);
        }
    }

    public static boolean isURL(String string) {
        int n = urlPrefixes.length;
        while (--n >= 0) {
            if (!string.startsWith(urlPrefixes[n])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String string) {
        int n = 0;
        while (n < urlPrefixes.length) {
            if (string.startsWith(urlPrefixes[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = JSVFileManager.urlTypeIndex(string);
        return n < 0 || n == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String string) throws Exception {
        BufferedInputStream bufferedInputStream;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0 && (stringArray = PT.split(string, "|")) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getSimulationReader(string);
        }
        InputStream inputStream = JSVFileManager.getInputStream(string, true, null);
        if (inputStream instanceof SB || inputStream instanceof String) {
            return new BufferedReader(new StringReader(inputStream.toString()));
        }
        if (JSVFileManager.isAB(inputStream)) {
            return new BufferedReader(new StringReader(new String((byte[])inputStream)));
        }
        InputStream inputStream2 = bufferedInputStream = new BufferedInputStream(inputStream);
        if (JSVFileManager.isGzip(bufferedInputStream)) {
            inputStream2 = ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newGZIPInputStream(inputStream2);
        }
        return new BufferedReader(new InputStreamReader(inputStream2, "UTF-8"));
    }

    public static String getAbbrSimulationFileName(String string) {
        String string2 = JSVFileManager.getSimulationType(string);
        String string3 = JSVFileManager.getAbbreviatedSimulationName(string, string2, true);
        return string3;
    }

    static String getAbbreviatedSimulationName(String string, String string2, boolean bl) {
        return string.indexOf("MOL=") >= 0 ? String.valueOf(bl ? SIMULATION_PROTOCOL : "") + "MOL=" + JSVFileManager.getSimulationHash(string, string2) : string;
    }

    private static String getSimulationHash(String string, String string2) {
        String string3 = String.valueOf(string2) + Math.abs(string.substring(string.indexOf("V2000") + 1).hashCode());
        if (Logger.debugging) {
            System.out.println("JSVFileManager hash for " + string + " = " + string3);
        }
        return string3;
    }

    public static String getSimulationFileData(String string, String string2) {
        return JSVFileManager.cacheGet(string.startsWith("MOL=") ? string.substring(4) : JSVFileManager.getAbbreviatedSimulationName(string, string2, false));
    }

    public static void cachePut(String string, String string2) {
        if (Logger.debugging) {
            Logger.debug("JSVFileManager cachePut " + string2 + " for " + string);
        }
        if (string2 != null) {
            htCorrelationCache.put(string, string2);
            if (cacheDir != null && string.indexOf(":") < 0) {
                try {
                    new File(cacheDir).mkdirs();
                    File file = new File(cacheDir, string);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(string2.getBytes());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static String cacheGet(String string) {
        String string2 = htCorrelationCache.get(string);
        if (Logger.debugging) {
            Logger.info("JSVFileManager cacheGet " + string2 + " for " + string);
        }
        return string2;
    }

    private static BufferedReader getSimulationReader(String string) {
        String string2 = JSVFileManager.cacheGet(string);
        if (string2 == null) {
            string2 = JSVFileManager.getNMRSimulationJCampDX(string.substring(SIMULATION_PROTOCOL.length()));
            JSVFileManager.cachePut(string, string2);
        }
        return JSVFileManager.getBufferedReaderForStringOrBytes(string2);
    }

    public static boolean isAB(Object object) {
        return AU.isAB(object);
    }

    public static boolean isZipFile(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    private static boolean isGzip(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 31 && byArray[1] == -117;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OC oC) throws JSVException {
        try {
            byte[] byArray = new byte[1024];
            byte[] byArray2 = oC == null ? new byte[4096] : null;
            int n = 0;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                n2 += n;
                if (oC == null) {
                    if (n2 >= byArray2.length) {
                        byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
                    }
                    System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                    continue;
                }
                oC.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            if (oC == null) {
                return AU.arrayCopyByte(byArray2, n2);
            }
            return String.valueOf(n2) + " bytes";
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static String postByteArray(String string, byte[] byArray) {
        Object object = null;
        try {
            object = JSVFileManager.getInputStream(string, false, byArray);
        }
        catch (Exception exception) {
            object = exception.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = JSVFileManager.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (JSVException jSVException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object == null ? "" : JSVFileManager.fixUTF((byte[])object);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = JSVFileManager.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (IOException iOException) {
                Logger.error("fixUTF error " + iOException);
            }
        }
        return new String(byArray);
    }

    public static InputStream getInputStream(String string, boolean bl, byte[] byArray) throws JSVException {
        int n;
        boolean bl2 = JSVFileManager.isURL(string);
        boolean bl3 = appletDocumentBase != null;
        Object object = null;
        String string2 = null;
        if (bl2 && (n = string.indexOf("?POST?")) >= 0) {
            string2 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        if (bl3 || bl2) {
            URL uRL;
            try {
                uRL = new URL(appletDocumentBase, string, null);
            }
            catch (Exception exception) {
                throw new JSVException("Cannot read " + string);
            }
            Logger.info("JSVFileManager opening URL " + uRL + (string2 == null ? "" : " with POST of " + string2.length() + " bytes"));
            object = JSVFileManager.viewer.apiPlatform.getURLContents(uRL, byArray, string2, false);
        } else {
            if (bl) {
                Logger.info("JSVFileManager opening file " + string);
            }
            object = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(string);
        }
        if (object instanceof String) {
            throw new JSVException("\n" + (String)object);
        }
        return (InputStream)object;
    }

    private static String getNMRSimulationJCampDX(String string) {
        String string2;
        String string3;
        boolean bl;
        int n = 0;
        String string4 = null;
        String string5 = JSVFileManager.getSimulationType(string);
        if (string.startsWith(string5)) {
            string = string.substring(string5.length() + 1);
        }
        if (bl = string.startsWith("MOL=")) {
            n = (string = string.substring(4)).indexOf("/n__Jmol");
            if (n > 0) {
                string = String.valueOf(string.substring(0, n)) + PT.rep(string.substring(n), "/n", "\n");
            }
            string4 = string = PT.rep(string, "\\n", "\n");
        }
        String string6 = JSVFileManager.getSimulationHash(string, string5);
        if (Logger.debugging) {
            Logger.info("JSVFileManager type=" + string5 + " key=" + string6 + " name=" + string);
        }
        if ((string3 = JSVFileManager.cacheGet(string6)) != null) {
            return string3;
        }
        String string7 = string2 = bl ? null : PT.rep(nciResolver, "%FILE", PT.escapeUrl(string));
        if (!bl && (string4 = JSVFileManager.getFileAsString(string2)) == null || string4.indexOf("<html") >= 0) {
            Logger.error("no MOL data returned by NCI");
            return null;
        }
        boolean bl2 = string5.equals("C13");
        String string8 = bl2 ? nmrdbServerC13 : nmrdbServerH1;
        string8 = string8.replace("$MOLFILE", string4);
        JSVFileManager.cachePut("url", string8);
        String string9 = JSVFileManager.getFileAsString(string8);
        if ((string9 == null ? (string9 = "Error: Error fetching simulation") : string9).indexOf("Error:") >= 0) {
            return string9;
        }
        Map<String, Object> map = new JSJSONParser().parseMap(string9, true);
        JSVFileManager.cachePut("json", string9);
        return JSVFileManager.processJSON(string6, string2, string8, string, string5, string4, map, bl2, bl);
    }

    private static String processJSON(String string, String string2, String string3, String string4, String string5, String string6, Map<String, Object> map, boolean bl, boolean bl2) {
        Object object;
        Map map2 = (Map)map.get("data");
        String string7 = (String)map2.get("molfile");
        if (string7 == null) {
            System.out.println("JSVFileManager: no MOL file returned from EPFL");
            string7 = string6;
        }
        int[] nArray = JSVFileManager.getAtomMap(string7, string6);
        JSVFileManager.cachePut("mol", string6);
        byte[] byArray = bl2 || !JSViewer.isJS ? null : string6.getBytes();
        viewer.syncScript("JSVSTR:" + string6);
        String string8 = "<Signals src=" + PT.esc(string3.substring(0, string3.indexOf(63))) + ">\n";
        string5 = bl ? "13C" : "1HNMR";
        String string9 = (String)map2.get("jcamp");
        string9 = JSVFileManager.hackNewNmriumSimulationJCAMP(string9);
        Lst lst = (Lst)map2.get("signals");
        String string10 = JSVFileManager.getval(string9, "##$BF1");
        float f = string10 == null ? (float)(bl ? 100 : 400) : Float.parseFloat(string10);
        SB sB = new SB();
        int n = lst.size();
        while (--n >= 0) {
            object = (Map)lst.get(n);
            sB.append("<Signal ");
            JSVFileManager.setAttr(sB, "type", string5, null);
            Integer n2 = (Integer)((Lst)object.get("atoms")).get(0);
            if (nArray == null) {
                JSVFileManager.setAttr(sB, "atoms", n2, null);
            } else {
                sB.append("atoms=\"").appendI(nArray[n2]).append("\" ");
            }
            JSVFileManager.setAttr(sB, "multiplicity", "multiplicity", (Map<String, Object>)object);
            Number number = (Number)object.get("delta");
            float[] fArray = JSVFileManager.getSignalMinMax((Map<String, Object>)object, number.floatValue(), f, bl);
            JSVFileManager.setAttr(sB, "xMin", "" + fArray[0], null);
            JSVFileManager.setAttr(sB, "xMax", "" + fArray[1], null);
            JSVFileManager.setAttr(sB, "integral", "nbAtoms", (Map<String, Object>)object);
            sB.append("></Signal>\n");
        }
        sB.append("</Signals>");
        string8 = String.valueOf(string8) + sB.toString();
        if (Logger.debugging) {
            Logger.info(string8);
        }
        JSVFileManager.cachePut("xml", string8);
        string9 = "##TITLE=" + (bl2 ? "JMOL SIMULATION/" + string5 : string4) + "\n" + string9.substring(string9.indexOf("\n##") + 1);
        n = string6.indexOf("\n");
        n = string6.indexOf("\n", n + 1);
        if (n > 0 && n == string6.indexOf("\n \n")) {
            string6 = String.valueOf(string6.substring(0, n + 1)) + "Created " + JSVFileManager.viewer.apiPlatform.getDateFormat("8824") + " by JSpecView " + JSVersion.VERSION + string6.substring(n + 1);
        }
        n = 0;
        n = string9.indexOf("##.");
        object = JSVFileManager.getAbbreviatedSimulationName(string4, string5, false);
        int n3 = ((String)object).indexOf("id='");
        if (bl2 && n3 > 0) {
            object = ((String)object).substring(n3 + 4, (String.valueOf(object) + "'").indexOf("'", n3 + 4));
        }
        JSVFileManager.cachePut(String.valueOf(string5) + "-json.jcamp", string9);
        string9 = String.valueOf(string9.substring(0, n)) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + PT.esc((String)object) + " type=\"MOL\" src=" + PT.esc(string2) + ">\n" + string6 + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + string8 + "\n" + string9.substring(n);
        JSVFileManager.cachePut("jcamp", string9);
        JSVFileManager.cachePut(string, string9);
        return string9;
    }

    /*
     * Exception decompiling
     */
    private static float[] getSignalMinMax(Map<String, Object> var0, float var1_1, float var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl32 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl32 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String hackNewNmriumSimulationJCAMP(String string) {
        String string2 = JSVFileManager.getline(string, "##.SHIFT REFERENCE=INTERNAL");
        String string3 = JSVFileManager.getval(string, "##$OFFSET");
        if (string2 != null && string3 != null) {
            string2 = String.valueOf(string2.substring(0, string2.lastIndexOf(", ") + 2)) + string3;
            string = JSVFileManager.setline(string, "##$OFFSET", null);
            string = JSVFileManager.setline(string, "##.SHIFT REFERENCE=INTERNAL", string2);
        }
        return string;
    }

    private static String getline(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        return string.substring(n, string.indexOf("\n", n));
    }

    private static String getval(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        String string3 = string.substring(string.indexOf("=", n) + 1, string.indexOf("\n", n));
        if ((n = string3.indexOf("$$")) >= 0) {
            string3 = string3.substring(n);
        }
        return string3.trim();
    }

    private static String setline(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        if (string3 == null) {
            return String.valueOf(string.substring(0, n)) + string.substring(string.indexOf("\n", n) + 1);
        }
        return String.valueOf(string.substring(0, n)) + string3 + string.substring(string.indexOf("\n", n));
    }

    private static int[] getAtomMap(String string, String string2) {
        P3[] p3Array;
        P3[] p3Array2 = JSVFileManager.getCoord(string);
        int n = p3Array2.length;
        if (n != (p3Array = JSVFileManager.getCoord(string2)).length) {
            return null;
        }
        int[] nArray = new int[n];
        BS bS = new BS();
        bS.setBits(0, n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            P3 p3 = p3Array2[n2];
            int n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                if ((double)p3.distanceSquared(p3Array[n3]) < 0.1) {
                    bS.clear(n3);
                    nArray[n2] = n3;
                    if (n2 == n3) break;
                    bl = true;
                    break;
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
            ++n2;
        }
        return (int[])(bl ? nArray : null);
    }

    private static P3[] getCoord(String string) {
        String[] stringArray = PT.split(string, "\n");
        float[] fArray = new float[3];
        int n = Integer.parseInt(stringArray[3].substring(0, 3).trim());
        P3[] p3Array = new P3[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[4 + n2];
            PT.parseFloatArrayInfested(PT.getTokens(string2.substring(0, 31)), fArray);
            p3Array[n2] = P3.new3(fArray[0], fArray[1], fArray[2]);
            ++n2;
        }
        return p3Array;
    }

    private static void setAttr(SB sB, String string, Object object, Map<String, Object> map) {
        sB.append(String.valueOf(string) + "=\"").appendO(map == null ? object : map.get(object)).append("\" ");
    }

    private static URL getResource(Object object, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = object.getClass().getResource(string);
            if (uRL == null) {
                stringArray[0] = "Couldn't find file: " + string;
            }
        }
        catch (Exception exception) {
            stringArray[0] = "Exception " + exception + " in getResource " + string;
        }
        return uRL;
    }

    public static String getResourceString(Object object, String string, String[] stringArray) {
        URL uRL = JSVFileManager.getResource(object, string, stringArray);
        if (uRL == null) {
            stringArray[0] = "Error loading resource " + string;
            return null;
        }
        if (uRL instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)uRL));
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent(), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
        }
        return sB.toString();
    }

    public static String getJmolFilePath(String string) {
        try {
            string = JSVFileManager.getFullPathName(string);
        }
        catch (JSVException jSVException) {
            return null;
        }
        return appletDocumentBase == null ? string.replace('\\', '/') : string;
    }

    public static String getTagName(String string) {
        if (string == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(string)) {
            try {
                if (string.startsWith(SIMULATION_PROTOCOL)) {
                    return JSVFileManager.getAbbrSimulationFileName(string);
                }
                String string2 = new URL(null, string, null).getFile();
                return string2.substring(string2.lastIndexOf(47) + 1);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return JSVFileManager.newFile(string).getName();
    }

    private static GenericFileInterface newFile(String string) {
        return JSVFileManager.viewer.apiPlatform.newFile(string);
    }

    public static void setDocumentBase(JSViewer jSViewer, URL uRL) {
        viewer = jSViewer;
        appletDocumentBase = uRL;
    }

    public static String getSimulationType(String string) {
        return string.indexOf("C13/") >= 0 ? "C13" : "H1";
    }
}

