/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deformably register two images using a diffeomorphic demons algorithm.


This class was contributed by Tom Vercauteren, INRIA &amp; Mauna Kea
Technologies, based on a variation of the DemonsRegistrationFilter . The basic modification is to use diffeomorphism exponentials.

See T. Vercauteren, X. Pennec, A. Perchant and N. Ayache, "Non-
parametric Diffeomorphic Image Registration with the Demons
Algorithm", Proc. of MICCAI 2007.

DiffeomorphicDemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the deformation field which will map a moving image onto
a fixed image.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


Tom Vercauteren, INRIA &amp; Mauna Kea Technologies

WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/ux2obj


See:
 DemonsRegistrationFilter

 DemonsRegistrationFunction

 itk::DiffeomorphicDemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkDiffeomorphicDemonsRegistrationFilter.h
*/
public class DiffeomorphicDemonsRegistrationFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DiffeomorphicDemonsRegistrationFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DiffeomorphicDemonsRegistrationFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DiffeomorphicDemonsRegistrationFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DiffeomorphicDemonsRegistrationFilter::~DiffeomorphicDemonsRegistrationFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DiffeomorphicDemonsRegistrationFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DiffeomorphicDemonsRegistrationFilter::DiffeomorphicDemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DiffeomorphicDemonsRegistrationFilter() {
    this(SimpleITKJNI.new_DiffeomorphicDemonsRegistrationFilter(), true);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(VectorDouble StandardDeviations) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(StandardDeviations), StandardDeviations);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(double value) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DiffeomorphicDemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  VectorDouble getStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::DiffeomorphicDemonsRegistrationFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseGradientType(UseGradientTypeType UseGradientType)
*/
public  void setUseGradientType(DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType UseGradientType) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setUseGradientType(swigCPtr, this, UseGradientType.swigValue());
  }

  /**
UseGradientTypeType itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseGradientType() const
*/
public  DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType getUseGradientType() {
    return DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType.swigToEnum(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getUseGradientType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseFirstOrderExp(bool UseFirstOrderExp)

Use a first-order approximation of the exponential. This amounts to
using an update rule of the type s &lt;- s o (Id + u) instead of s
&lt;- s o exp(u)

*/
public  void setUseFirstOrderExp(boolean UseFirstOrderExp) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setUseFirstOrderExp(swigCPtr, this, UseFirstOrderExp);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOn()

Set the value of UseFirstOrderExp to true or false respectfully.

*/
public  void useFirstOrderExpOn() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_useFirstOrderExpOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOff()
*/
public  void useFirstOrderExpOff() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_useFirstOrderExpOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseFirstOrderExp() const

Use a first-order approximation of the exponential. This amounts to
using an update rule of the type s &lt;- s o (Id + u) instead of s
&lt;- s o exp(u)

*/
public  boolean getUseFirstOrderExp() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getUseFirstOrderExp(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumUpdateStepLength(double MaximumUpdateStepLength)

Set/Get the maximum length in terms of pixels of the vectors in the
update buffer.

*/
public  void setMaximumUpdateStepLength(double MaximumUpdateStepLength) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setMaximumUpdateStepLength(swigCPtr, this, MaximumUpdateStepLength);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumUpdateStepLength() const
*/
public  double getMaximumUpdateStepLength() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getMaximumUpdateStepLength(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  void setSmoothDisplacementField(boolean SmoothDisplacementField) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setSmoothDisplacementField(swigCPtr, this, SmoothDisplacementField);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public  void smoothDisplacementFieldOn() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_smoothDisplacementFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public  void smoothDisplacementFieldOff() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_smoothDisplacementFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  boolean getSmoothDisplacementField() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getSmoothDisplacementField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  void setSmoothUpdateField(boolean SmoothUpdateField) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setSmoothUpdateField(swigCPtr, this, SmoothUpdateField);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public  void smoothUpdateFieldOn() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_smoothUpdateFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public  void smoothUpdateFieldOff() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_smoothUpdateFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  boolean getSmoothUpdateField() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getSmoothUpdateField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(VectorDouble UpdateFieldStandardDeviations) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(UpdateFieldStandardDeviations), UpdateFieldStandardDeviations);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(double value) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  VectorDouble getUpdateFieldStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getUpdateFieldStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  double getMaximumError() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public  void setIntensityDifferenceThreshold(double IntensityDifferenceThreshold) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setIntensityDifferenceThreshold(swigCPtr, this, IntensityDifferenceThreshold);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public  double getIntensityDifferenceThreshold() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getIntensityDifferenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseImageSpacing() const
*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::DiffeomorphicDemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetRMSChange() const

Set/Get the root mean squared change of the previous iteration. May
not be used by all solvers.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getRMSChange(swigCPtr, this);
  }

  /**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the overlapping region between the two images. This
value is calculated for the current iteration

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMetric() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getMetric(swigCPtr, this);
  }

  /**
void itk::simple::DiffeomorphicDemonsRegistrationFilter::StopRegistration()

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  void stopRegistration() {
    SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_stopRegistration(swigCPtr, this);
  }

  /**
std::string itk::simple::DiffeomorphicDemonsRegistrationFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DiffeomorphicDemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage, Image initialDisplacementField) {
    return new Image(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(initialDisplacementField), initialDisplacementField), true);
  }

  /**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.DiffeomorphicDemonsRegistrationFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

  public final static class UseGradientTypeType {
    public final static DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType Symmetric = new DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType("Symmetric");
    public final static DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType Fixed = new DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType("Fixed");
    public final static DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType WarpedMoving = new DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType("WarpedMoving");
    public final static DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType MappedMoving = new DiffeomorphicDemonsRegistrationFilter.UseGradientTypeType("MappedMoving");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static UseGradientTypeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + UseGradientTypeType.class + " with value " + swigValue);
    }

    private UseGradientTypeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private UseGradientTypeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private UseGradientTypeType(String swigName, UseGradientTypeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static UseGradientTypeType[] swigValues = { Symmetric, Fixed, WarpedMoving, MappedMoving };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
