/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StrictVersionConstraints {
    public static final StrictVersionConstraints EMPTY = new StrictVersionConstraints(ImmutableSet.of()){

        @Override
        public StrictVersionConstraints union(StrictVersionConstraints other) {
            return other;
        }

        @Override
        public StrictVersionConstraints intersect(StrictVersionConstraints other) {
            return EMPTY;
        }

        @Override
        public StrictVersionConstraints minus(StrictVersionConstraints other) {
            return EMPTY;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(ModuleIdentifier module) {
            return false;
        }

        @Override
        public String toString() {
            return "no modules";
        }
    };
    private final ImmutableSet<ModuleIdentifier> modules;

    private StrictVersionConstraints(ImmutableSet<ModuleIdentifier> modules) {
        this.modules = modules;
    }

    public static StrictVersionConstraints of(ImmutableSet<ModuleIdentifier> modules) {
        if (modules.isEmpty()) {
            return EMPTY;
        }
        return new StrictVersionConstraints(modules);
    }

    public ImmutableSet<ModuleIdentifier> getModules() {
        return this.modules;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean contains(ModuleIdentifier module) {
        return this.modules.contains((Object)module);
    }

    public StrictVersionConstraints union(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return this;
        }
        if (this == other) {
            return this;
        }
        if (this.modules.equals(other.modules)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(this.modules.size() + other.modules.size()));
        builder.addAll(this.modules);
        builder.addAll(other.modules);
        return StrictVersionConstraints.of((ImmutableSet<ModuleIdentifier>)builder.build());
    }

    public StrictVersionConstraints intersect(StrictVersionConstraints other) {
        if (other.modules == this.modules) {
            return this;
        }
        if (other == EMPTY) {
            return EMPTY;
        }
        ImmutableSet<ModuleIdentifier> smaller = this.modules.size() < other.modules.size() ? this.modules : other.modules;
        ImmutableSet<ModuleIdentifier> larger = smaller == this.modules ? other.modules : this.modules;
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)smaller.size());
        for (ModuleIdentifier module : smaller) {
            if (!larger.contains(module)) continue;
            builder.add((Object)module);
        }
        return StrictVersionConstraints.of((ImmutableSet<ModuleIdentifier>)builder.build());
    }

    public String toString() {
        return "modules=" + this.modules;
    }

    public StrictVersionConstraints minus(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return this;
        }
        if (this == other || this == EMPTY) {
            return EMPTY;
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)this.modules.size());
        for (ModuleIdentifier module : this.modules) {
            if (other.modules.contains((Object)module)) continue;
            builder.add((Object)module);
        }
        return StrictVersionConstraints.of((ImmutableSet<ModuleIdentifier>)builder.build());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictVersionConstraints that = (StrictVersionConstraints)o;
        return this.modules.equals(that.modules);
    }

    public int hashCode() {
        return this.modules.hashCode();
    }
}

