---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Heroku API key or application authorization token'
---

## Description

The response body contains content that matches the pattern of a Heroku API key or application authorization token was identified. API keys and authorization tokens can be used to perform API calls on behalf of a user or account. A malicious actor with access to these tokens can access the Heroku API platform and all deployed applications.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate an API key for the identified user:

- Sign in to your account and visit <https://dashboard.heroku.com/account>
- Under the "API Key" section, select "Regenerate API Key"
- When prompted, select "Regenerate API Key" in the "Regenerate API Key" dialog

To regenerate an application authorization token:

- Sign in to your account and visit <https://dashboard.heroku.com/account/applications>
- Under the "Authorizations" section, find the registered authorization that contains the identified token
- Select the pencil icon
- Select "Regenerate token"

For more information on API keys, see [their FAQ on generating API keys](https://help.heroku.com/PBGP6IDE/how-should-i-generate-an-api-key-that-allows-me-to-use-the-heroku-platform-api).
Heroku does not have any documentation on application authorization tokens.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.59 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
