---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Flutterwave test secret key'
---

## Description

The response body contains content that matches the pattern of a test Flutterwave secret key was identified. Secret keys have the highest level of privileges and can authorize any action on your account. However, this is a test key so it can only be used for fake transactions. A malicious actor with access to this key can send webhook and email events.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate your key:

- Sign in and go to <https://app.flutterwave.com/dashboard/home>
- Select "Settings" on the left-hand menu
- Select "API Keys" under "Developers" on the left-hand menu
- Ensure "Test mode" is activated
- Select "Generate secret key" to rotate the public, secret, and encryption key

For more information, please see the [Flutterwave documentation on authentication](https://developer.flutterwave.com/docs/authentication).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.46 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
