---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token PGP private key'
---

## Description

The response body contains content that matches the pattern of a PGP private key was identified. PGP private keys are used to encrypt and decrypt messages. A malicious actor with access to this key can encrypt and decrypt all past and future messages. Note that past messages encrypted using this key should be considered compromised, and new messages cannot be considered trusted.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). PGP keys cannot be rotated, a new key must be created. For more information, please see [GnuPG's documentation on generating keys](https://gnupg.org/gph/en/manual.html#AEN26)

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.166 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
