---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Anthropic API key'
---

## Description

The response body contains content that matches the pattern of an Anthropic API key was detected. Anthropic keys are used to access generative AI services. Malicious actors could use these keys to build up excessive charges to your account.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To remediate a leaked Anthropic key, you should delete it from the list of API keys for your organization.

- Sign in to your [Anthropic account](https://console.anthropic.com/)
- Go to "API settings" by selecting your profile icon and then selecting "API Keys" or through the Settings tab
- Identify the leaked API key and select the meatball menu (three horizontal dots) next to the key you want to delete
- Select "Delete API Key"
- Note: Deleting an API key is a permanent action and cannot be undone
- Generate a new key by selecting "Create Key" and give it a descriptive name

For more information, please see Anthropic's website: <https://support.anthropic.com/en/articles/8384961-what-should-i-do-if-i-suspect-my-api-key-has-been-compromised>.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.130 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
