---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: イテレーション
description: 期間が限定されたワークフロー、プログラム増分、ケイデンス、スプリント。
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabにおけるイテレーションとは、特定の期間（通常は1～3週間）に処理されるイシューをグループ化する、期間が限定されたワークフローを指します。

チームはイテレーションを使用して、開発速度と変動性のメトリクスを追跡できます。複数の同時期間で同じ作業アイテムを追跡するには、イテレーションを[マイルストーン](../../project/milestones/_index.md)とともに使用します。そのために、グループ内でさまざまな[イテレーションケイデンス](#iteration-cadences)を作成し、管理します。

たとえば、次のように使用できます:

- 8～12週間にわたるプログラム増分（Pl）のマイルストーン。
- 2週間にわたるスプリントのイテレーション。

GitLabにおいて、イテレーションはマイルストーンと似ていますが、いくつかの違いがあります:

- イテレーションはグループでのみ利用できる。
- イテレーションはイテレーションケイデンスにグループ化される。
- イテレーションには、開始日と終了日の両方が必要である
- イテレーションの日付範囲は、イテレーションケイデンス内で重複できない。

## イテレーションを使用した計画ワークフロー {#planning-workflows-with-iterations}

イテレーションを使用して、一定期間における作業を整理および追跡できます。次の例では、イテレーションを使用してチームが一貫したデリバリーサイクルを維持する方法を示します。

### スプリント計画と実行 {#sprint-planning-and-execution}

イテレーションを使用して、チームが一定期間における作業を計画して実行し、予測可能なデリバリーケイデンスを維持できるようにします。チームがスプリントで作業する場合、各イテレーションは、作業アイテムの計画、実行、およびデリバリーのための明確なタイムボックスを提供します。詳細については、[チュートリアル: GitLabを使用してScrumを促進する](../../../tutorials/scrum_events/_index.md)を参照してください。

たとえば、2週間のスプリントを実行する場合、チームは複数のワークストリームを調整する必要があることがよくあります。開発チームは現在のスプリントの実装状況を追跡し、プロダクトマネージャーは今後のスプリントのバックログアイテムを準備します。

イテレーションを使用することで、以下のことが可能になります:

- チームはスプリントスケジュール全体を可視化できる。
- 作業がスプリント間で自動的にロールオーバーされる。
- 関係者は、バーンダウンチャートを使用してスプリントの進捗状況を追跡できる。
- チームは複数のスプリントにわたって開発速度を測定できる。

この構造により、チームは進捗状況を視覚的に把握しながら、作業を着実に完了できます。

スプリントにイテレーションを設定することで、以下のことが可能になります:

- 各チームは同じイテレーションケイデンスで作業できる。
- チームはイテレーションレポートで作業ステータスを表示できる。
- スプリント計画がより予測しやすくなる。

### 迅速な開発サイクル {#rapid-development-cycles}

チームが頻繁なリリースを必要とする場合、イテレーションを使用することで、より短い開発サイクルを実現できます。エクストリームプログラミング（XP）などの手法を用いる場合、チームは1週間のイテレーションを使用することで、迅速なフィードバックループを維持できます。

たとえば、迅速に変更を実装する場合、チームはイテレーションごとに複数回、本番環境にデプロイすることがあります。チームは毎週のイテレーションで作業を追跡しながら、コードの準備ができた時点でいつでもリリースできる柔軟性を維持します。

イテレーションを使用することで、以下のことが可能になります:

- チームは構造化されたタイムボックスを維持できる。
- 開発速度を追跡できる。
- チームは、週単位のメトリクスに基づいて計画を調整できる。
- ステークホルダーは毎週具体的な進捗を確認できる。

このアプローチは、チームがアジャイルのプラクティスと組織化された計画のバランスを取るのに役立ちます。

迅速なサイクルにイテレーションを使用することで、以下のことが可能になります:

- 作業が週単位で明確に整理される。
- チームはより小さな単位で進捗状況を追跡できる。
- リリースプランがイテレーションの境界と一致する。

## イテレーションケイデンス {#iteration-cadences}

{{< history >}}

- GitLab 14.1で`iteration_cadences`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/5077)されました。デフォルトでは無効になっています。
- GitLab 15.0で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/354977)されました: スケジュールされたすべてのイテレーションは、ケイデンスの開始日と同じ曜日に開始する必要があります。最初のイテレーションが開始された後は、ケイデンスの開始日を編集できません。
- GitLab 15.0の[GitLab.comおよびGitLab Self-Managedで有効化されました](https://gitlab.com/gitlab-org/gitlab/-/issues/354878)。
- GitLab 15.4で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/367493)されました: ケイデンスで新しい自動開始日を選択できます。今後のイテレーションは、変更された開始日と同じ曜日に開始するようにスケジュールされます。イテレーションケイデンスは、自動スケジュール機能をオフにすることで、手動で管理できます。
- GitLab 15.5で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/354878)になりました。機能フラグ`iteration_cadences`は削除されました。

{{< /history >}}

イテレーションケイデンスはイテレーションのコンテナであり、イテレーションのスケジュール設定を自動化するために使用できます。これらを使用して、1、2、3、または4週間ごとにイテレーションの作成を自動化できます。イテレーションケイデンスを設定して、未完了のイシューを次のイテレーションに自動的にロールオーバーすることもできます。

### イテレーションケイデンスを作成する {#create-an-iteration-cadence}

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナー以上のロールが必要です。

イテレーションケイデンスを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。
1. **新しいイテレーションケイデンス**を選択します。
1. イテレーションケイデンスのタイトルと説明を入力します。

   イテレーションケイデンスを手動で管理するには、**自動スケジュールを有効にする**チェックボックスをオフにして、次の手順をスキップします。
1. 自動スケジュールを使用するには、必須フィールドに入力します。
   - イテレーションケイデンスの自動開始日を選択します。イテレーションは、開始日の曜日と同じ曜日に開始するようにスケジュールされます。
   - **期間**ドロップダウンリストから、各イテレーションの期間を週数で選択します。
   - **今後のイテレーション**ドロップダウンリストから、GitLabで作成および管理する今後のイテレーションの数を選択します。
   - オプション。未完了のイシューを次のイテレーションに移動するには、**ロールオーバーを有効にする**チェックボックスをオンにします。現在のイテレーションの終了時に、[Automation Bot](#gitlab-automation-bot-user)は、すべてのオープンイシューを次のイテレーションに移動します。イシューは、インスタンスのタイムゾーン（デフォルトではUTC）の午前0時に移動されます。管理者は、インスタンスのタイムゾーンを変更できます。
1. **ケイデンスを作成**を選択します。ケイデンスリストのページが開きます。

作成したケイデンスを手動で管理するには、[イテレーションを手動で作成する](#create-an-iteration-manually)を参照してください。

### イテレーションリストを表示する {#view-the-iterations-list}

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。

ケイデンス内のすべてのイテレーションを日付の降順で表示するには、そのイテレーションケイデンスを選択します。そこで新しいイテレーションを作成したり、イテレーションを選択したりして、より詳細なビューを取得したりできます。

{{< alert type="note" >}}

プロジェクトでイシュートラッキングが[オフ](../../project/settings/_index.md#configure-project-features-and-permissions)になっている場合、イテレーションリストを表示するには、そのURLを入力します。そのためには、プロジェクトまたはグループのURLに`/-/cadences`を追加します。たとえば、`https://gitlab.com/gitlab-org/sample-data-templates/sample-gitlab-project/-/cadences`のようになります。[イシュー339009](https://gitlab.com/gitlab-org/gitlab/-/issues/339009)により、この改善を追跡しています。

{{< /alert >}}

### イテレーションケイデンスを編集する {#edit-an-iteration-cadence}

前提要件:

- グループのプランナー以上のロールが必要です。

イテレーションケイデンスを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。
1. 編集するケイデンスの右側にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、次に**ケイデンスを編集**を選択します。
1. フィールドを編集します。
   - 自動スケジュールを使用しており、**自動開始日**フィールドを編集する場合は、既存の現在のイテレーションまたは過去のイテレーションと重複しない新しい開始日を設定する必要があります。
   - **今後のイテレーション**の編集は、非破壊的なアクションです。たとえば、今後のイテレーションがすでに10回存在する場合、**今後のイテレーション**の数を`2`回に変更しても、既存の8回の今後のイテレーションは削除されません。
1. **変更を保存**を選択します。

#### イテレーションケイデンスの自動スケジュールをオン/オフにする {#turn-on-and-off-automatic-scheduling-for-an-iteration-cadence}

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。
1. 自動スケジュールをオンまたはオフにするケイデンスの右側にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、次に**ケイデンスを編集**を選択します。
1. **自動スケジュールを有効にする**チェックボックスをオンまたはオフにします。
1. 自動スケジュールをオンにする場合は、必須フィールドの**自動開始日**、**期間**、**今後のイテレーション**に入力します。
   - **自動開始日**には、既存のオープンイテレーションと重複しない任意の日付を選択できます。今後のイテレーションがある場合、自動スケジュールは選択した期間に合わせて自動開始日を適切に調整します。
1. **変更を保存**を選択します。

#### 例: 手動イテレーションケイデンスの自動スケジュールをオンにする {#example-turn-on-automatic-scheduling-for-a-manual-iteration-cadence}

4月15日、金曜日の時点で、手動イテレーションケイデンスに3回のイテレーションがあるとします:

- 4月4日、月曜日～4月8日、金曜日（完了）
- 4月12日、火曜日～4月15日、金曜日（進行中）
- 5月3日、火曜日～5月6日、金曜日（今後）

このシナリオで選択できる最も早い**自動開始日**は4月16日の土曜日になります。これは、4月15日が進行中のイテレーションと重複するためです。

4月18日の月曜日を自動開始日として選択し、2回の今後のイテレーションまで毎週イテレーションを自動化する場合、変換後は、次のようなイテレーションになります:

- 4月4日、月曜日～4月8日、金曜日（完了）
- 4月12日、火曜日～4月15日、金曜日（進行中）
- 4月18日、月曜日～4月24日、日曜日（今後）
- 4月25日、月曜日～5月1日、日曜日（今後）

既存の今後のイテレーション「4月12日、火曜日～4月15日、金曜日」が「4月18日、月曜日～4月24日、日曜日」に変更されます。

少なくとも2回の今後のイテレーションがスケジュールされているという要件を満たすために、追加の今後のイテレーション「4月25日、月曜日～5月1日、日曜日」がスケジュールされます。

### イテレーションケイデンスを削除する {#delete-an-iteration-cadence}

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナー以上のロールが必要です。

イテレーションケイデンスを削除すると、そのケイデンス内のすべてのイテレーションも削除されます。

イテレーションケイデンスを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。
1. 削除するケイデンスの右側にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、次に**ケイデンスを削除**を選択します。
1. **ケイデンスを削除**を選択します。

### GitLab Automationボットユーザー {#gitlab-automation-bot-user}

イテレーションのロールオーバーが有効になっている場合、現在のイテレーションの終了時に、すべてのオープンイシューが次のイテレーションに移動されます。

イテレーションは特別なGitLab Automation Botユーザーによって変更され、イシューの[システムノート](../../project/system_notes.md)で確認できます。このユーザーは、[請求対象ユーザー](../../../subscriptions/manage_users_and_seats.md#criteria-for-non-billable-users)ではないため、ライセンス制限数にはカウントされません。

GitLab.comでは、これは`automation-bot1`ユーザーと呼ばれます。

## イテレーションを手動で作成する {#create-an-iteration-manually}

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

イテレーションケイデンスで自動スケジュールが有効になっている場合、イテレーションはスケジュールに従って作成されます。このオプションを無効にすると、イテレーションを手動で作成できます。

前提要件:

- グループのプランナー以上のロールが必要です。
- グループに少なくとも1つのイテレーションケイデンスがあり、イテレーションケイデンスで[自動スケジュールを無効にする](#turn-on-and-off-automatic-scheduling-for-an-iteration-cadence)必要があります。

イテレーションを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択します。
1. イテレーションを作成するケイデンスの右側にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、次に**イテレーションを追加**を選択します。
1. フィールドに入力します。
1. **イテレーションを作成**を選択します。イテレーションの詳細ページが開きます。

## イテレーションを編集する {#edit-an-iteration}

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナー以上のロールが必要です。

イテレーションを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択し、イテレーションケイデンスを選択します。
1. 編集するイテレーションを選択します。イテレーションの詳細ページが開きます。
1. 右上隅で、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、次に**編集**を選択します。
1. フィールドを編集します:
   - イテレーションケイデンスで[自動スケジュールが無効になっている](#turn-on-and-off-automatic-scheduling-for-an-iteration-cadence)場合にのみ、**タイトル**、**開始日**、**期限**を編集できます。
1. **変更を保存**を選択します。

## イテレーションを削除する {#delete-an-iteration}

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナー以上のロールが必要です。
- イテレーションケイデンスでは[自動スケジュールを無効にする](#turn-on-and-off-automatic-scheduling-for-an-iteration-cadence)必要があります。

イテレーションを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択し、イテレーションケイデンスを選択します。
1. 編集するイテレーションを選択します。イテレーションの詳細ページが開きます。
1. 右上隅で、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**削除**を選択します。
1. **削除**を選択します。

## イテレーションレポート {#iteration-report}

イテレーションレポートを確認することで、イテレーションの進捗状況を追跡できます。イテレーションレポートには、イテレーションに割り当てられたすべてのイシューとそのステータスのリストが表示されます。

レポートには、イテレーション内のイシュー総数の内訳も表示されます。オープンイテレーションレポートには、完了、未開始、および進行中のイシューの概要が表示されます。完了イテレーションレポートには、期限までに完了したイシューの総数が表示されます。

### イテレーションレポートを表示する {#view-an-iteration-report}

イテレーションレポートを表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択し、イテレーションケイデンスを選択します。
1. イテレーションを選択します。

### イテレーションのバーンダウンチャートとバーンアップチャート {#iteration-burndown-and-burnup-charts}

イテレーションレポートには、[マイルストーン](../../project/milestones/_index.md)を表示するときと同様に、[バーンダウンチャートとバーンアップチャート](../../project/milestones/burndown_and_burnup_charts.md)が含まれています:

- バーンダウンチャートは、スコープ全体における完了の進捗状況を追跡するのに役立ちます。
- バーンアップチャートでは、特定のタイムボックスに追加され、完了したイシューの毎日の合計数とウェイトを追跡できます。

#### サブグループまたはプロジェクトにスコープを絞ったイテレーションチャートを表示する {#view-iteration-charts-scoped-to-subgroups-or-projects}

グループ内のサブグループまたはプロジェクトのいずれかで作成されたイテレーションのバーンダウンチャートとバーンアップチャートを表示します。この操作を行うと、チャートにはサブグループまたはプロジェクトに属するイシューのみがカウントされます。

たとえば、グループに`Project 1`と`Project 2`という名前の2つのプロジェクトがあるとします。また、各プロジェクトには、グループの同じイテレーションに割り当てられた単一のイシューがあります。

グループ用に生成されたイテレーションレポートには、以下のようにグループのすべてのプロジェクトのイシュー数が表示されます:

- 完了: 2件中0件
- 未完了: 2件中0件
- 未開始: 2件中2件
- バーンダウンチャートのイシューの合計: 2
- バーンアップチャートのイシューの合計: 2

`Project 1`用に生成されたイテレーションレポートには、以下のようにこのプロジェクトに属するイシューのみが表示されます:

- 完了: 1件中0件
- 未完了: 1件中0件
- 未開始: 1件中1件
- バーンダウンチャートのイシューの合計: 1
- バーンアップチャートのイシューの合計: 1

### ラベルでイシューをグループ化する {#group-issues-by-label}

ラベルでイシューの一覧をグループ化して、チームに属するイシューを表示することで、各ラベルに割り当てられるスコープをより正確に理解できます。

ラベルでイシューをグループ化するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **イテレーション**を選択し、イテレーションケイデンスを選択します。
1. イテレーションを選択します。
1. **グループ化**ドロップダウンリストから、**ラベル**を選択します。
1. **ラベルで絞り込む**ドロップダウンリストから、グループ化するラベルを選択します。
1. ラベルのドロップダウンリストの外側の領域を選択します。ページが選択したラベルでグループ化されます。

## 関連トピック {#related-topics}

- [イシューをイテレーションに追加する](../../project/issues/managing_issues.md#add-an-issue-to-an-iteration)
- [チュートリアル: GitLabを使用してアジャイルイテレーションを実行する](../../../tutorials/agile_sprint/_index.md)
