---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: このチュートリアルでは、保護されたワークフローをGitLabプロジェクト用に構築する方法を説明します。
title: 'チュートリアル: プロジェクト用の保護されたワークフローを構築する'
description: セキュリティ、承認ルール、ブランチ保護。
---

<!-- vale gitlab_base.FutureTense = NO -->

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

チームが新しいプロジェクトを開始する場合、効率性と適切なレビューのバランスが取れたワークフローが必要です。GitLabでは、ユーザーグループを作成し、それらのグループと保護ブランチを組み合わせて、それらの保護を承認ルールで適用できます。

このチュートリアルでは、サンプルプロジェクト「Excelsior」の`1.x`と`1.x.x`のリリースブランチに対する保護を設定し、プロジェクトの最小限の承認ワークフローを作成します:

1. [`engineering`グループを作成する](#create-the-engineering-group)
1. [`engineering`でサブグループを作成する](#create-subgroups-in-engineering)
1. [ユーザーをサブグループに追加する](#add-users-to-the-subgroups)
1. [Excelsiorプロジェクトを作成する](#create-the-excelsior-project)
1. [基本的なCODEOWNERSファイルを追加する](#add-a-basic-codeowners-file)
1. [承認ルールを設定する](#configure-approval-rules)
1. [ブランチでコードオーナーの承認を適用する](#enforce-codeowner-approval-on-branches)
1. [リリースブランチを作成する](#create-the-release-branches)

## はじめる前 {#before-you-begin}

- メンテナーロール以上が必要です。
- マネージャーとそのメールアドレスのリストが必要です。
- バックエンドエンジニアとフロントエンドエンジニア、およびそれらのメールアドレスのリストが必要です。
- ブランチ名の[セマンティックバージョニング](https://semver.org/)を理解している必要があります。

## `engineering`グループを作成する {#create-the-engineering-group}

Excelsiorプロジェクトをセットアップする前に、プロジェクトを所有するグループを作成する必要があります。ここでは、エンジニアリンググループをセットアップします:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規グループ**を選択します。
1. **グループを作成**を選択します。
1. **グループ名**に`Engineering`を入力します。
1. **グループURL**に、`engineering`と入力します。
1. **表示レベル**を**プライベート**に設定します。
1. GitLabに最も役立つ情報が表示されるように、エクスペリエンスをパーソナライズします:
   - **ロール**で、**System administrator**（システム管理者）を選択します。
   - **だれがこのグループを使用しますか?**で、**自分の会社やチーム**を選択します。
   - **このグループを何に使う予定ですか?**で、**コードを保存したい**を選択します。
1. グループへのメンバーの招待はスキップしてください。このチュートリアルの後のセクションでユーザーを追加します。
1. **グループを作成**を選択します。

次に、より詳細な制御を行うために、この`engineering`グループにサブグループを追加します。

## `engineering`でサブグループを作成する {#create-subgroups-in-engineering}

`engineering`グループは良いスタートですが、Excelsiorプロジェクトのバックエンドエンジニア、フロントエンドエンジニア、およびマネージャーには、異なるタスクと、異なる専門分野があります。

ここでは、エンジニアリンググループにさらに3つの詳細なサブグループを作成して、ユーザーを仕事の種類別にセグメント化します。`managers`、`frontend`、`backend`。次に、これらの新しいグループを`engineering`グループのメンバーとして追加します。

まず、新しいサブグループを作成します:

1. 左側のサイドバーで**検索または移動先**を選択し、`engineering`を検索します。`Engineering`という名前のグループを選択します:

   ![検索結果のエンジニアリンググループ](img/search_engineering_v16_2.png)

1. `engineering`グループの概要ページの右上隅にある**新しいサブグループ**を選択します。
1. **サブグループ名**に、`Managers`を入力します。
1. **表示レベル**を**プライベート**に設定します。
1. **サブグループを作成**を選択します。

次に、`engineering`グループのメンバーとしてサブグループを追加します:

1. 左側のサイドバーで**検索または移動先**を選択し、`engineering`を検索します。`Engineering`という名前のグループを選択します。
1. **管理** > **メンバー**を選択します。
1. 右上にある**グループを招待**を選択します。
1. **招待するグループを選択**で、`Engineering / Managers`を選択します。
1. サブグループを追加するときに、**メンテナー**のロールを選択します。これにより、`engineering`グループとそのプロジェクトにアクセスするときに、サブグループのメンバーが継承できる最高のロールが構成されます。
1. オプション。有効期限日を選択します。
1. **招待**を選択します。

このプロセスを繰り返して、`backend`と`frontend`のサブグループを作成します。完了したら、`engineering`グループをもう一度検索します。概要ページには、次のように3つのサブグループが表示されます:

![エンジニアリンググループには3つのサブグループがあります](img/subgroup_structure_v16_1.png)

## ユーザーをサブグループに追加する {#add-users-to-the-subgroups}

前の手順で、親グループ（`engineering`）にサブグループを追加したときに、サブグループのメンバーをMaintainerのロールに制限しました。このロールは、`engineering`が所有するプロジェクトに対して継承できる最高のロールです。結果:

- ユーザー1はゲストのロールで`manager`サブグループに追加され、`engineering`プロジェクトでゲストのロールを受け取ります。
- ユーザー2はオーナーのロールで`manager`グループに追加されます。このロールは、設定した最大のロール（Maintainer）よりも高いため、ユーザー2はオーナーの代わりにMaintainerのロールを受け取ります。

ユーザーを`frontend`サブグループに追加するには:

1. 左側のサイドバーで**検索または移動先**を選択し、`frontend`を検索します。`Frontend`グループを選択します。
1. **管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。
1. フィールドに入力します。デフォルトで**デベロッパー**ロールを選択し、このユーザーが他のユーザーの作業をレビューする場合は**メンテナー**に増やします。
1. **招待**を選択します。
1. これらの手順を繰り返して、すべてのフロントエンドエンジニアを`frontend`サブグループに追加します。

次に、`backend`グループと`managers`グループで同じことを行います。同じユーザーが複数のサブグループのメンバーになることができます。

## Excelsiorプロジェクトを作成する {#create-the-excelsior-project}

グループ構造が整ったので、チームが作業する`excelsior`プロジェクトを作成します。フロントエンドエンジニアとバックエンドエンジニアの両方が関与しているため、`excelsior`は、作成したばかりの小さいサブグループのいずれかではなく、`engineering`に属している必要があります。

新しい`excelsior`プロジェクトを作成するには:

1. 左側のサイドバーで**検索または移動先**を選択し、`engineering`を検索します。`Engineering`という名前のグループを選択します。
1. `engineering`グループの概要ページの左側のサイドバーの上部にある**新規作成**（{{< icon name="plus" >}}）と**このグループで > 新規プロジェクト/リポジトリ**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**フィールドに、`Excelsior`を入力します。**プロジェクトslug**には、`excelsior`が自動的に入力された状態になります。
   - **表示レベル**で、**公開**を選択します。
   - **リポジトリを初期化しREADMEファイルを生成する**を選択して、初期ファイルをリポジトリに追加します。
1. **プロジェクトを作成**を選択します。

GitLabは`excelsior`プロジェクトを作成し、そのホームページにリダイレクトします。次のようになります:

![新しい、ほぼ空のExcelsiorプロジェクト](img/new_project_v16_2.png)

次のステップでは、このページの機能を使用します。

## 基本的なCODEOWNERSファイルを追加する {#add-a-basic-codeowners-file}

CODEOWNERSファイルをプロジェクトのルートディレクトリに追加して、適切なサブグループにレビューをルーティングします。この例では、4つのルールを設定します:

- すべての変更は、`engineering`グループの誰かがレビューする必要があります。
- マネージャーは、CODEOWNERSファイル自体の変更をレビューする必要があります。
- フロントエンドエンジニアは、フロントエンドファイルへの変更をレビューする必要があります。
- バックエンドエンジニアは、バックエンドファイルへの変更をレビューする必要があります。

{{< alert type="note" >}}

GitLab Freeは、オプションのレビューのみをサポートしています。レビューを必須にするには、GitLab PremiumまたはGitLab Ultimateが必要です。

{{< /alert >}}

CODEOWNERSファイルを`excelsior`プロジェクトに追加するには:

1. 左側のサイドバーで**検索または移動先**を選択し、`Excelsior`を検索します。プロジェクト`Excelsior`を選択します。
1. ブランチ名の横にあるプラスアイコン（{{< icon name="plus" >}}）を選択し、**新しいファイル**を選択します: ![プロジェクトに新しいファイルを作成する](img/new_file_v16_2.png)
1. **ファイル名**に、`CODEOWNERS`を入力します。これにより、プロジェクトのルートディレクトリに`CODEOWNERS`という名前のファイルが作成されます。
1. この例を編集領域に貼り付け、グループ構造と一致しない場合は`@engineering/`を変更します:

   ```plaintext
   # All changes should be reviewed by someone in the engineering group
   * @engineering

   # A manager should review any changes to this file
   CODEOWNERS @engineering/managers

   # Frontend files should be reviewed by FE engineers
   [Frontend] @engineering/frontend
   *.scss
   *.js

   # Backend files should be reviewed by BE engineers
   [Backend] @engineering/backend
   *.rb
   ```

1. **コミットメッセージ**のに、次のように貼り付けます:

   ```plaintext
   Adds a new CODEOWNERS file

   Creates a small CODEOWNERS file to:
   - Route backend and frontend changes to the right teams
   - Route CODEOWNERS file changes to managers
   - Request all changes be reviewed
   ```

1. **変更をコミットする**を選択します。

CODEOWNERSファイルがプロジェクトの`main`ブランチに配置され、このプロジェクトで作成された今後のすべてのブランチで使用できるようになりました。

## 承認ルールを設定する {#configure-approval-rules}

CODEOWNERSファイルは、ディレクトリとファイルタイプに適したレビュアーを記述しています。承認ルールは、マージリクエストをそれらのレビュアーに転送します。ここでは、新しいCODEOWNERSファイルの情報を使用し、リリースブランチの保護を追加する承認ルールを設定します:

1. 左側のサイドバーで**検索または移動先**を選択し、`Excelsior`を検索します。プロジェクト`Excelsior`を選択します。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションで、**承認ルール**までスクロールします。
1. **承認ルールを追加**を選択します。
1. `Enforce CODEOWNERS`という名前のルールを作成します。
1. **全ての保護ブランチ**を選択します。
1. GitLab PremiumおよびGitLab Ultimateでルールを必須にするには、**承認が必要**を`1`に設定します。
1. `managers`グループを承認者として追加します。
1. **承認ルールを追加**を選択します。
1. **承認の設定**までスクロールし、**マージリクエストの承認ルールの編集を防ぎます。**が選択されていることを確認します。
1. **変更を保存**を選択します。

追加すると、`Enforce CODEOWNERS`ルールは次のようになります:

![新しい承認ルールが適用されました](img/approval_rules_v16_2.png)

## ブランチでコードオーナーの承認を適用する {#enforce-codeowner-approval-on-branches}

プロジェクトにいくつかの保護を設定したので、これらの保護を組み合わせて、プロジェクトの重要なブランチを保護する準備ができました:

- ユーザーは論理的なグループとサブグループに分類されます。
- CODEOWNERSファイルは、ファイルの種類とディレクトリの主題分野のエキスパートを記述しています。
- 承認ルールは、（GitLab Freeで）主題分野のエキスパートが変更をレビューすることを推奨（またはGitLab PremiumおよびGitLab Ultimateで）必須にします。

`excelsior`プロジェクトは、リリースブランチ名に[セマンティックバージョニング](https://semver.org/)を使用するため、リリースブランチが`1.x`と`1.x.x`のパターンに従うことを知っています。これらのブランチに追加されたすべてのコードを主題分野のエキスパートがレビューし、マネージャーがリリースブランチにマージされる作業について最終的な決定を下すことを希望します。

ブランチごとに保護を作成するのではなく、ワイルドカードブランチルールを構成して、複数のブランチを保護します:

1. 左側のサイドバーで**検索または移動先**を選択し、`Excelsior`を検索します。プロジェクト`Excelsior`を選択します。
1. **設定** > **リポジトリ**を選択します。
1. **ブランチルール**を展開します。
1. **ブランチルールの追加** > **ブランチ名またはパターン**を選択します。
1. ドロップダウンリストから`1.*`と入力し、**ワイルドカードの作成`1.*`**を選択します。
1. コミットを直接プッシュするのではなく、すべてのユーザーにマージリクエストを送信させるには、次のようにします:
   1. **マージを許可**セクションで、**編集**を選択し、**メンテナー**に設定して、**変更を保存**を選択します。
   1. **プッシュとマージを許可**セクションで、**編集**を選択し、**なし**に設定して、**変更を保存**を選択します。
   1. **強制プッシュを許可**を無効のままにします。
1. GitLab PremiumとGitLab Ultimateで、コードオーナーが作業するファイルへの変更をレビューすることを要求するには、**コードオーナーの承認が必要**を切り替えます。
1. ブランチの表で、`Default`とマークされたルールを見つけます。（お使いのGitLabのバージョンによっては、このブランチの名前が`main`または`master`になっている場合があります）。このブランチの値が、`1.*`ルールに使用した設定と一致するように設定します。

`1.*`ブランチがまだ存在していなくても、ルールが適用されるようになりました:

![mainと1.xが保護されるようになりました](img/branch_list_v16_1.png)

## リリースブランチを作成する {#create-the-release-branches}

すべてのブランチ保護が適用されたので、1.0.0リリースブランチを作成する準備ができました:

1. 左側のサイドバーで**検索または移動先**を選択し、`Excelsior`を検索します。プロジェクト`Excelsior`を選択します。
1. 左側のサイドバーで、**コード** > **ブランチ**を選択します。
1. 右上隅で、**新しいブランチ**を選択します。`1.0.0`という名前を付けます。
1. **ブランチを作成**を選択します。

ブランチ保護がUIに表示されるようになりました:

- 左側のサイドバーで、**コード** > **ブランチ**を選択します。ブランチのリストでは、`1.0.0`ブランチが保護されていることを示す必要があります:

  ![1.0.0が保護されていることを示すブランチのリスト](img/branch_is_protected_v16_2.png)

- 左側のサイドバーで、**設定** > **リポジトリ**を選択し、**ブランチルール**を展開して、すべての保護ブランチの詳細を表示します:

  ![保護されたブランチとその保護のリスト](img/protections_in_place_v16_2.png)

おつかれさまでした。エンジニアはそれぞれのブランチで独立して作業でき、1.0.0リリースブランチの検討のために提出されたすべてのコードは、主題分野のエキスパートによってレビューされます。
