---
stage: Verify
group: Pipeline Authoring
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: "`needs`でジョブをより早く開始する"
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[`needs`](_index.md#needs)キーワードを使用すると、パイプライン内のジョブ間に依存関係を作成できます。ジョブは、パイプラインの`stages`設定に関係なく、依存関係が満たされるとすぐに実行されます。ステージが定義されていないパイプライン（事実上1つの大きなステージ）を設定することもでき、ジョブは引き続き適切な順序で実行されます。このパイプライン構造は、一種の[有向非巡回グラフ](https://en.wikipedia.org/wiki/Directed_acyclic_graph)です。

たとえば、特定のツールや個別のWebサイトをメインプロジェクトの一部として構築できます。`needs`を使用すると、これらのジョブ間の依存関係を指定でき、GitLabは各ステージの完了を待つ代わりに、可能な限り早くジョブを実行します。

CI/CDの他のソリューションとは異なり、GitLabでは、ステージ構成のある実行フローとステージレスの実行フローのいずれかを選択する必要はありません。`needs`キーワードを使用するだけで、任意のジョブでこの機能を利用でき、1つのパイプライン内でステージ構成とステージレス構成を組み合わせたハイブリッドな実装が可能です。

次のようなモノレポについて考えてみましょう:

```plaintext
./service_a
./service_b
./service_c
./service_d
```

このプロジェクトでは、パイプラインを次の3つのステージに分けて構成できます:

| build     | test     | deploy |
|-----------|----------|--------|
| `build_a` | `test_a` | `deploy_a` |
| `build_b` | `test_b` | `deploy_b` |
| `build_c` | `test_c` | `deploy_c` |
| `build_d` | `test_d` | `deploy_d` |

`needs`を使用して、`a`のジョブを`b`、`c`、`d`のジョブとは別に関連付けることで、ジョブの実行を効率化できます。`build_a`のビルドには非常に時間がかかる可能性がありますが、`test_b`はそれを待つ必要はありません。`build_b`が完了したらすぐに開始するように設定できます。これにより、はるかに高速化できる可能性があります。

必要に応じて、`c`および`d`のジョブはそのままステージ順で実行させることもできます。

`needs`キーワードは[`parallel`](_index.md#parallel)キーワードとも併用でき、パイプラインで並列処理を行うための強力なオプションを提供します。

## ユースケース {#use-cases}

[`needs`](_index.md#needs)キーワードを使用すると、CI/CDパイプラインのジョブ間にさまざまな種類の依存関係を定義できます。依存関係を扇状に分岐させたり、扇状に集約させたり、さらにそれらを再び1つにマージする（ダイヤモンド型の依存関係を構築する）こともできます。これらの依存関係は、次のパイプラインに使用できます:

- マルチプラットフォームのビルドを処理する。
- オペレーティングシステムのビルドのように、依存関係が複雑に入り組んでいる。
- 個別にデプロイ可能だが関連性のあるマイクロサービスのデプロイグラフがある。

さらに、`needs`は、パイプライン全体のスピードを向上させ、迅速なフィードバックを提供するのに役立ちます。不要にジョブ同士がブロックしないように依存関係を構築することで、パイプラインステージに関係なく、パイプラインを可能な限り高速に実行でき、出力（エラーを含む）をデベロッパーができるだけ早く確認できるようになります。
