---
stage: Growth
group: Engagement
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ブロードキャストメッセージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabでは、ブロードキャストメッセージを2種類、GitLabインスタンスのユーザーに表示できます:

- バナー
- 通知

[ブロードキャストメッセージAPI](../api/broadcast_messages.md)を使用してブロードキャストメッセージを管理できます。

{{< alert type="warning" >}}

ブロードキャストメッセージは、ターゲティング設定に関係なく、APIを通じて公開されます。機密情報や秘密情報を含めないでください。また、特定のグループやプロジェクトに非公開情報を伝達するためにブロードキャストメッセージを使用しないでください。

{{< /alert >}}

## バナー {#banners}

バナーはページ上部に表示され、オプションでコマンドラインにGitリモートレスポンスとして表示されます。

![歓迎メッセージを表示するブロードキャストメッセージのバナー](img/broadcast_messages_banner_v17_7.png)

```shell
$ git push
...
remote:
remote: **Welcome to GitLab** :wave:
remote:
...
```

複数のバナーが同時にアクティブになっている場合は、作成順にページ上部に表示されます。コマンドラインには、最新のバナーのみが表示されます。

## 通知 {#notifications}

GitLabは、ページの右下に通知を表示します。これらにはプレースホルダーを含めることができ、現在のユーザーの属性に置き換えられます:

![名前プレースホルダーを使用したブロードキャストメッセージ通知](img/broadcast_messages_notification_v17_7.png)

```markdown
{{name}}, would you like to give us feedback?
<a href="example.com">Take our survey!</a>
```

複数の通知が同時にアクティブになっている場合は、最新のもののみが表示されます。

通知は、次のプレースホルダーをサポートしています:

- `{{email}}`
- `{{name}}`
- `{{user_id}}`
- `{{username}}`
- `{{instance_id}}`

ユーザーがサインインしていない場合、ユーザー関連の値は空です。

## ブロードキャストメッセージを追加 {#add-a-broadcast-message}

GitLabインスタンスのユーザーにメッセージを表示するには、ブロードキャストメッセージを追加します。

{{< alert type="warning" >}}

ブロードキャストメッセージは、ターゲティング設定に関係なく、APIを通じて公開されます。機密情報や秘密情報を含めないでください。また、特定のグループやプロジェクトに非公開情報を伝達するためにブロードキャストメッセージを使用しないでください。

{{< /alert >}}

ブロードキャストメッセージを追加するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. 左側のサイドバーの下部にある**メッセージ**を選択します。
1. 右側で、**新しいメッセージを追加**を選択します。
1. **メッセージ**テキストを追加します:
   - メッセージの内容には、Markdown、絵文字、および`a`および`br` HTMLタグを含めることができます。
   - `br`タグは改行を挿入します。
   - `a` HTMLタグは、次のCSSプロパティを持つ`class`および`style`属性を受け入れます:
     - `color`
     - `border`
     - `background`
     - `padding`
     - `margin`
     - `text-decoration`
1. **種類**で、`banner`または`notification`を選択します。
1. **テーマ**を選択します。デフォルトのテーマは`indigo`です。
1. ユーザーがブロードキャストメッセージを無視できるようにするには、**却下可能**を選択します。
1. オプション。コマンドラインにGitリモートレスポンスとしてブロードキャストメッセージを表示しないようにするには、**Gitリモートレスポンス**をクリアします。
1. オプション。メッセージをユーザーのサブセットのみに表示するには、**対象のブロードキャストメッセージ**を選択します:
   - すべてのページのすべてのユーザーに表示します。
   - 特定の一致するページのすべてのユーザーに表示します。
   - グループまたはプロジェクトページで特定のロールを持つユーザーのみに表示します。この設定は、グループ、サブグループ、およびプロジェクトページにメッセージを表示しますが、Gitリモートレスポンスには表示しません。
1. 必要に応じて、ブロードキャストメッセージを表示する**対象のロール**を選択します。
1. 必要に応じて、そのパスに一致するURLにのみブロードキャストメッセージを表示するように**対象のパス**を追加します。複数のURLを照合してパスを指定するには、ワイルドカード文字`*`を使用します。例:
   - グループまたはプロジェクトの**マイルストーン**インデックスページの場合は`*/-/milestones`。
   - 個々のマイルストーンページのみの場合は`*/-/milestones/*`。
   - インデックスおよび個々のマイルストーンページの両方の場合は`*/-/milestones*`。
1. メッセージの開始日と終了日として日付と時刻（UTC）を選択します。
1. **ブロードキャストメッセージを追加**を選択します。

ブロードキャストメッセージが期限切れになると、ユーザーインターフェースには表示されなくなりますが、ブロードキャストメッセージのリストには引き続き表示されます。

## ブロードキャストメッセージを編集 {#edit-a-broadcast-message}

ブロードキャストメッセージを変更する必要がある場合は、編集できます。

ブロードキャストメッセージを編集するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. 左側のサイドバーの下部にある**メッセージ**を選択します。
1. ブロードキャストメッセージのリストから、メッセージの編集ボタンを選択します。
1. 必要な変更を加えたら、**ブロードキャストメッセージを更新**を選択します。

期限切れのメッセージは、終了日を変更することで再びアクティブにできます。

## ブロードキャストメッセージを削除 {#delete-a-broadcast-message}

ブロードキャストメッセージが不要になった場合は、削除できます。ブロードキャストメッセージがアクティブな間に削除できます。

ブロードキャストメッセージを削除するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. 左側のサイドバーの下部にある**メッセージ**を選択します。
1. ブロードキャストメッセージのリストから、メッセージの削除ボタンを選択します。

ブロードキャストメッセージを削除すると、ブロードキャストメッセージのリストから削除されます。
