# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/storagetransfer/v1/transfer.proto for package 'Google.Cloud.StorageTransfer.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/storagetransfer/v1/transfer_pb'

module Google
  module Cloud
    module StorageTransfer
      module V1
        module StorageTransferService
          # Storage Transfer Service and its protos.
          # Transfers data between between Google Cloud Storage buckets or from a data
          # source external to Google to a Cloud Storage bucket.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.storagetransfer.v1.StorageTransferService'

            # Returns the Google service account that is used by Storage Transfer
            # Service to access buckets in the project where transfers
            # run or in other projects. Each Google service account is associated
            # with one Google Cloud project. Users
            # should add this service account to the Google Cloud Storage bucket
            # ACLs to grant access to Storage Transfer Service. This service
            # account is created and owned by Storage Transfer Service and can
            # only be used by Storage Transfer Service.
            rpc :GetGoogleServiceAccount, ::Google::Cloud::StorageTransfer::V1::GetGoogleServiceAccountRequest, ::Google::Cloud::StorageTransfer::V1::GoogleServiceAccount
            # Creates a transfer job that runs periodically.
            rpc :CreateTransferJob, ::Google::Cloud::StorageTransfer::V1::CreateTransferJobRequest, ::Google::Cloud::StorageTransfer::V1::TransferJob
            # Updates a transfer job. Updating a job's transfer spec does not affect
            # transfer operations that are running already.
            #
            # **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
            # field can be modified using this RPC (for example, to set a job's status to
            # [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
            # [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
            # [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
            rpc :UpdateTransferJob, ::Google::Cloud::StorageTransfer::V1::UpdateTransferJobRequest, ::Google::Cloud::StorageTransfer::V1::TransferJob
            # Gets a transfer job.
            rpc :GetTransferJob, ::Google::Cloud::StorageTransfer::V1::GetTransferJobRequest, ::Google::Cloud::StorageTransfer::V1::TransferJob
            # Lists transfer jobs.
            rpc :ListTransferJobs, ::Google::Cloud::StorageTransfer::V1::ListTransferJobsRequest, ::Google::Cloud::StorageTransfer::V1::ListTransferJobsResponse
            # Pauses a transfer operation.
            rpc :PauseTransferOperation, ::Google::Cloud::StorageTransfer::V1::PauseTransferOperationRequest, ::Google::Protobuf::Empty
            # Resumes a transfer operation that is paused.
            rpc :ResumeTransferOperation, ::Google::Cloud::StorageTransfer::V1::ResumeTransferOperationRequest, ::Google::Protobuf::Empty
            # Starts a new operation for the specified transfer job.
            # A `TransferJob` has a maximum of one active `TransferOperation`. If this
            # method is called while a `TransferOperation` is active, an error is
            # returned.
            rpc :RunTransferJob, ::Google::Cloud::StorageTransfer::V1::RunTransferJobRequest, ::Google::Longrunning::Operation
            # Deletes a transfer job. Deleting a transfer job sets its status to
            # [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
            rpc :DeleteTransferJob, ::Google::Cloud::StorageTransfer::V1::DeleteTransferJobRequest, ::Google::Protobuf::Empty
            # Creates an agent pool resource.
            rpc :CreateAgentPool, ::Google::Cloud::StorageTransfer::V1::CreateAgentPoolRequest, ::Google::Cloud::StorageTransfer::V1::AgentPool
            # Updates an existing agent pool resource.
            rpc :UpdateAgentPool, ::Google::Cloud::StorageTransfer::V1::UpdateAgentPoolRequest, ::Google::Cloud::StorageTransfer::V1::AgentPool
            # Gets an agent pool.
            rpc :GetAgentPool, ::Google::Cloud::StorageTransfer::V1::GetAgentPoolRequest, ::Google::Cloud::StorageTransfer::V1::AgentPool
            # Lists agent pools.
            rpc :ListAgentPools, ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsRequest, ::Google::Cloud::StorageTransfer::V1::ListAgentPoolsResponse
            # Deletes an agent pool.
            rpc :DeleteAgentPool, ::Google::Cloud::StorageTransfer::V1::DeleteAgentPoolRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
