/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.css.om.typed.CSSStyleValueList;

public class AbstractValueList<V extends Value>
extends ComponentValue
implements CSSStyleValueList<V> {
    private static final long serialVersionUID = 1L;
    ArrayList<V> items;
    private char separator;

    public AbstractValueList() {
        this(',');
    }

    public AbstractValueList(char s) {
        this(s, 5);
    }

    public AbstractValueList(char s, int initialCapacity) {
        this.separator = s;
        this.items = new ArrayList(initialCapacity);
    }

    @Override
    public AbstractValueList<V> clone() {
        AbstractValueList clon = (AbstractValueList)super.clone();
        clon.items = new ArrayList(clon.getLength());
        for (Value item : this.items) {
            clon.items.add(item.clone());
        }
        clon.separator = this.separator;
        return clon;
    }

    public char getSeparatorChar() {
        return this.separator;
    }

    @Override
    public CSSValue.CssType getCssValueType() {
        return CSSValue.CssType.LIST;
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.INVALID;
    }

    public boolean add(V value) {
        boolean b = this.items.add(value);
        this.componentAdded((Value)value);
        return b;
    }

    public String getCssText() {
        int length = this.items.size();
        StringBuilder sb = new StringBuilder(length * 8);
        if (length > 0) {
            sb.append(((Value)this.items.get(0)).toString());
        }
        for (int i = 1; i < length; ++i) {
            sb.append(this.separator);
            sb.append(((Value)this.items.get(i)).toString());
        }
        return sb.toString();
    }

    public V item(int index) {
        return (V)((Value)this.items.get(index));
    }

    @Override
    public int getLength() {
        return this.items.size();
    }

    public Iterator<V> iterator() {
        return this.items.iterator();
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public V remove(int index) {
        Value item = (Value)this.items.remove(index);
        this.componentRemoved(item);
        return (V)item;
    }

    public V set(int index, V value) {
        Value v = (Value)this.items.set(index, value);
        this.getComponentHandler().listValueChanged(index, (Value)value);
        return (V)v;
    }
}

