/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DelegatingContentHandler
implements EntityResolver,
DTDHandler,
ContentHandler,
LexicalHandler,
ErrorHandler {
    private ContentHandler delegate;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errorHandler;

    public DelegatingContentHandler() {
    }

    public DelegatingContentHandler(ContentHandler handler) {
        this.setDelegateContentHandler(handler);
        if (handler instanceof EntityResolver) {
            this.setDelegateEntityResolver((EntityResolver)((Object)handler));
        }
        if (handler instanceof DTDHandler) {
            this.setDelegateDTDHandler((DTDHandler)((Object)handler));
        }
        if (handler instanceof LexicalHandler) {
            this.setDelegateLexicalHandler((LexicalHandler)((Object)handler));
        }
        if (handler instanceof ErrorHandler) {
            this.setDelegateErrorHandler((ErrorHandler)((Object)handler));
        }
    }

    public ContentHandler getDelegateContentHandler() {
        return this.delegate;
    }

    public void setDelegateContentHandler(ContentHandler handler) {
        this.delegate = handler;
    }

    public void setDelegateEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setDelegateDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setDelegateLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setDelegateErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.entityResolver != null) {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.delegate.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.delegate.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.delegate.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.delegate.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.delegate.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegate.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.delegate.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.delegate.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.delegate.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }
}

