/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.GenericQueue;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpCookedConnection;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;

public class OtpMbox {
    OtpNode home;
    OtpErlangPid self;
    GenericQueue queue;
    String name;
    Links links;
    private long unlink_id;

    OtpMbox(OtpNode otpNode, OtpErlangPid otpErlangPid, String string) {
        this.self = otpErlangPid;
        this.home = otpNode;
        this.name = string;
        this.unlink_id = 1L;
        this.queue = new GenericQueue();
        this.links = new Links(10);
    }

    OtpMbox(OtpNode otpNode, OtpErlangPid otpErlangPid) {
        this(otpNode, otpErlangPid, null);
    }

    public OtpErlangPid self() {
        return this.self;
    }

    public synchronized boolean registerName(String string) {
        return this.home.registerName(string, this);
    }

    public String getName() {
        return this.name;
    }

    public OtpErlangObject receive() throws OtpErlangExit, OtpErlangDecodeException {
        try {
            return this.receiveMsg().getMsg();
        }
        catch (OtpErlangExit otpErlangExit) {
            throw otpErlangExit;
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw otpErlangDecodeException;
        }
    }

    public OtpErlangObject receive(long l) throws OtpErlangExit, OtpErlangDecodeException {
        try {
            OtpMsg otpMsg = this.receiveMsg(l);
            if (otpMsg != null) {
                return otpMsg.getMsg();
            }
        }
        catch (OtpErlangExit otpErlangExit) {
            throw otpErlangExit;
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw otpErlangDecodeException;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public OtpInputStream receiveBuf() throws OtpErlangExit {
        return this.receiveMsg().getMsgBuf();
    }

    public OtpInputStream receiveBuf(long l) throws InterruptedException, OtpErlangExit {
        OtpMsg otpMsg = this.receiveMsg(l);
        if (otpMsg != null) {
            return otpMsg.getMsgBuf();
        }
        return null;
    }

    public OtpMsg receiveMsg() throws OtpErlangExit {
        OtpMsg otpMsg = (OtpMsg)this.queue.get();
        switch (otpMsg.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject otpErlangObject = otpMsg.getMsg();
                    throw new OtpErlangExit(otpErlangObject, otpMsg.getSenderPid());
                }
                catch (OtpErlangDecodeException otpErlangDecodeException) {
                    throw new OtpErlangExit("unknown", otpMsg.getSenderPid());
                }
            }
        }
        return otpMsg;
    }

    public OtpMsg receiveMsg(long l) throws InterruptedException, OtpErlangExit {
        OtpMsg otpMsg = (OtpMsg)this.queue.get(l);
        if (otpMsg == null) {
            return null;
        }
        switch (otpMsg.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject otpErlangObject = otpMsg.getMsg();
                    throw new OtpErlangExit(otpErlangObject, otpMsg.getSenderPid());
                }
                catch (OtpErlangDecodeException otpErlangDecodeException) {
                    throw new OtpErlangExit("unknown", otpMsg.getSenderPid());
                }
            }
        }
        return otpMsg;
    }

    public void send(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) {
        try {
            String string = otpErlangPid.node();
            if (string.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(otpErlangPid, (OtpErlangObject)otpErlangObject.clone()));
            } else {
                OtpCookedConnection otpCookedConnection = this.home.getConnection(string);
                if (otpCookedConnection == null) {
                    return;
                }
                otpCookedConnection.send(this.self, otpErlangPid, otpErlangObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send(String string, OtpErlangObject otpErlangObject) {
        this.home.deliver(new OtpMsg(this.self, string, (OtpErlangObject)otpErlangObject.clone()));
    }

    public void send(String string, String string2, OtpErlangObject otpErlangObject) {
        try {
            String string3 = this.home.node();
            if (string2.equals(string3)) {
                this.send(string, otpErlangObject);
            } else if (string2.indexOf(64, 0) < 0 && string2.equals(string3.substring(0, string3.indexOf(64, 0)))) {
                this.send(string, otpErlangObject);
            } else {
                OtpCookedConnection otpCookedConnection = this.home.getConnection(string2);
                if (otpCookedConnection == null) {
                    return;
                }
                otpCookedConnection.send(this.self, string, otpErlangObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exit(OtpErlangObject otpErlangObject) {
        this.home.closeMbox(this, otpErlangObject);
    }

    public void exit(String string) {
        this.exit(new OtpErlangAtom(string));
    }

    public void exit(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) {
        this.exit(2, otpErlangPid, otpErlangObject);
    }

    public void exit(OtpErlangPid otpErlangPid, String string) {
        this.exit(otpErlangPid, new OtpErlangAtom(string));
    }

    private void exit(int n, OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) {
        try {
            String string = otpErlangPid.node();
            if (string.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(3, this.self, otpErlangPid, otpErlangObject));
            } else {
                OtpCookedConnection otpCookedConnection = this.home.getConnection(string);
                if (otpCookedConnection == null) {
                    return;
                }
                switch (n) {
                    case 1: {
                        otpCookedConnection.exit(this.self, otpErlangPid, otpErlangObject);
                        break;
                    }
                    case 2: {
                        otpCookedConnection.exit2(this.self, otpErlangPid, otpErlangObject);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void link(OtpErlangPid otpErlangPid) throws OtpErlangExit {
        block7: {
            if (!this.links.addLink(this.self, otpErlangPid, true)) {
                return;
            }
            try {
                String string = otpErlangPid.node();
                if (string.equals(this.home.node())) {
                    if (!this.home.deliver(new OtpMsg(1, this.self, otpErlangPid))) {
                        throw new OtpErlangExit("noproc", otpErlangPid);
                    }
                    break block7;
                }
                OtpCookedConnection otpCookedConnection = this.home.getConnection(string);
                if (otpCookedConnection != null) {
                    otpCookedConnection.link(this.self, otpErlangPid);
                    otpCookedConnection.node_link(this.self, otpErlangPid, true);
                    break block7;
                }
                throw new OtpErlangExit("noproc", otpErlangPid);
            }
            catch (OtpErlangExit otpErlangExit) {
                this.links.removeLink(this.self, otpErlangPid);
                throw otpErlangExit;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void unlink(OtpErlangPid otpErlangPid) {
        long l;
        if ((l = this.unlink_id++) == 0L) {
            l = this.unlink_id++;
        }
        if (this.links.setUnlinking(this.self, otpErlangPid, l)) {
            try {
                String string = otpErlangPid.node();
                if (string.equals(this.home.node())) {
                    this.home.deliver(new OtpMsg(4, this.self, otpErlangPid));
                } else {
                    OtpCookedConnection otpCookedConnection = this.home.getConnection(string);
                    if (otpCookedConnection != null) {
                        otpCookedConnection.unlink(this.self, otpErlangPid, l);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized OtpErlangPid[] linked() {
        return this.links.remotePids();
    }

    public boolean ping(String string, long l) {
        return this.home.ping(string, l);
    }

    public String[] getNames() {
        return this.home.getNames();
    }

    public OtpErlangPid whereis(String string) {
        return this.home.whereis(string);
    }

    public void close() {
        this.home.closeMbox(this);
    }

    protected void finalize() {
        this.close();
        this.queue.flush();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OtpMbox)) {
            return false;
        }
        OtpMbox otpMbox = (OtpMbox)object;
        return otpMbox.self.equals(this.self);
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    void deliver(OtpMsg otpMsg) {
        switch (otpMsg.type()) {
            case 1: 
            case 3: 
            case 4: 
            case 35: 
            case 36: {
                this.handle_link_operation(otpMsg);
                break;
            }
            default: {
                this.queue.put(otpMsg);
            }
        }
    }

    private synchronized void handle_link_operation(OtpMsg otpMsg) {
        OtpErlangPid otpErlangPid = otpMsg.getSenderPid();
        String string = otpErlangPid.node();
        boolean bl = string.equals(this.home.node());
        OtpCookedConnection otpCookedConnection = bl ? null : this.home.getConnection(string);
        switch (otpMsg.type()) {
            case 1: {
                if (!this.links.addLink(this.self, otpErlangPid, false) || bl) break;
                if (otpCookedConnection != null) {
                    otpCookedConnection.node_link(this.self, otpErlangPid, true);
                    break;
                }
                this.links.removeLink(this.self, otpErlangPid);
                this.queue.put(new OtpMsg(3, otpErlangPid, this.self, new OtpErlangAtom("noconnection")));
                break;
            }
            case 4: 
            case 35: {
                long l = otpMsg.getUnlinkId();
                boolean bl2 = this.links.removeActiveLink(this.self, otpErlangPid);
                try {
                    if (bl) {
                        this.home.deliver(new OtpMsg(36, this.self, otpErlangPid, l));
                        break;
                    }
                    if (otpCookedConnection == null) break;
                    if (bl2) {
                        otpCookedConnection.node_link(this.self, otpErlangPid, false);
                    }
                    otpCookedConnection.unlink_ack(this.self, otpErlangPid, l);
                }
                catch (Exception exception) {}
                break;
            }
            case 36: {
                this.links.removeUnlinkingLink(this.self, otpMsg.getSenderPid(), otpMsg.getUnlinkId());
                break;
            }
            case 3: {
                if (!this.links.removeActiveLink(this.self, otpMsg.getSenderPid())) break;
                this.queue.put(otpMsg);
            }
        }
    }

    synchronized void breakLinks(OtpErlangObject otpErlangObject) {
        Link[] linkArray = this.links.clearLinks();
        if (linkArray != null) {
            int n = linkArray.length;
            for (int i = 0; i < n; ++i) {
                OtpCookedConnection otpCookedConnection;
                if (linkArray[i].getUnlinking() != 0L) continue;
                OtpErlangPid otpErlangPid = linkArray[i].remote();
                String string = otpErlangPid.node();
                if (!string.equals(this.home.node()) && (otpCookedConnection = this.home.getConnection(string)) != null) {
                    otpCookedConnection.node_link(this.self, otpErlangPid, false);
                }
                this.exit(1, otpErlangPid, otpErlangObject);
            }
        }
    }
}

