/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.timescale;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class TimescaleTable
extends PostgreTableRegular {
    private static final Log log = Log.getLog(TimescaleTable.class);

    public TimescaleTable(PostgreSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
    }

    @Override
    protected void readTableStatistics(@NotNull JDBCSession session) throws DBException, SQLException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsTableStatistics()) {
            return;
        }
        if (!this.isHypertable(session)) {
            super.readTableStatistics(session);
            return;
        }
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT total_bytes as total_rel_size, table_bytes as rel_size FROM hypertable_detailed_size(?)");){
            dbStat.setLong(1, this.getObjectId());
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    this.fetchStatistics(dbResult);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isHypertable(@NotNull JDBCSession session) throws SQLException {
        String sql = "SELECT 1 FROM timescaledb_information.hypertables WHERE hypertable_schema = ? AND hypertable_name = ?";
        try (JDBCPreparedStatement stmt = session.prepareStatement(sql);){
            boolean bl;
            block14: {
                stmt.setString(1, this.getSchema().getName());
                stmt.setString(2, this.getName());
                JDBCResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            log.error((Object)("Failed to check if table is a hypertable: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    protected void fetchStatistics(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        super.fetchStatistics(dbResult);
    }
}

