/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.backup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class JDBCDatabasePostgresBackupHandler
implements JDBCDatabaseBackupHandler {
    private static final Log log = Log.getLog(JDBCDatabasePostgresBackupHandler.class);

    public void doBackup(@NotNull Connection connection, int currentSchemaVersion, @NotNull InternalDatabaseConfig databaseConfig) throws DBException {
        block23: {
            try {
                URI uri = new URI(databaseConfig.getUrl().replace("jdbc:", ""));
                Path workspace = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().resolve("backup");
                if (!IOUtils.isFileFromDefaultFS((Path)workspace)) {
                    log.warn((Object)"Backup to an external workspace is not supported");
                    return;
                }
                Path backupFile = workspace.resolve(uri.getPath().replace("/", "") + "_backup_version_" + databaseConfig.getSchema() + currentSchemaVersion + ".zip");
                if (!Files.notExists(backupFile, new LinkOption[0])) break block23;
                Files.createDirectories(workspace, new FileAttribute[0]);
                ProcessBuilder processBuilder = JDBCDatabasePostgresBackupHandler.getBuilder(databaseConfig, uri, backupFile);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                try (InputStream inputStream = process.getInputStream();
                     InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    StringBuilder processOutput = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        processOutput.append(line).append("\n");
                    }
                    int exitCode = process.waitFor();
                    if (exitCode == 0) {
                        log.info((Object)"Postgres backup successful");
                        break block23;
                    }
                    Files.deleteIfExists(backupFile);
                    log.error((Object)("Postgres backup failed with output: " + processOutput.toString()));
                    throw new DBException("Postgres backup failed");
                }
                catch (IOException e) {
                    log.error((Object)"Error reading process output", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)("Create backup is failed: " + e.getMessage()));
                throw new DBException("Create backup is failed: " + e.getMessage());
            }
        }
    }

    private static ProcessBuilder getBuilder(@NotNull InternalDatabaseConfig databaseConfig, URI uri, Path backupFile) {
        String databaseName = uri.getPath();
        if (databaseName != null) {
            int questionMarkIndex;
            if (databaseName.startsWith("/")) {
                databaseName = databaseName.substring(1);
            }
            if ((questionMarkIndex = databaseName.indexOf("?")) != -1) {
                databaseName = databaseName.substring(0, questionMarkIndex);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder("pg_dump", "--host", uri.getHost(), "--port", String.valueOf(uri.getPort()), "--blobs", "--verbose", "--file", backupFile.toAbsolutePath().toString());
        if (CommonUtils.isNotEmpty((String)databaseConfig.getSchema())) {
            processBuilder.command().add("--schema");
            processBuilder.command().add(databaseConfig.getSchema());
        }
        String backupCommand = String.join((CharSequence)" ", processBuilder.command());
        log.info((Object)("Command started: " + backupCommand));
        processBuilder.command().add("--username");
        processBuilder.command().add(databaseConfig.getUser());
        processBuilder.command().add(databaseName);
        if (CommonUtils.isNotEmpty((String)databaseConfig.getPassword())) {
            processBuilder.environment().put("PGPASSWORD", databaseConfig.getPassword());
        }
        return processBuilder;
    }
}

