/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IRowController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class ColumnInfoPanel
extends Composite {
    private PropertyTreeViewer propViewer;

    public ColumnInfoPanel(Composite parent, int style, IValueController valueController) {
        super(parent, style);
        if (valueController instanceof IAttributeController) {
            this.createPanel((IAttributeController)valueController);
        }
    }

    protected void createPanel(IAttributeController valueController) {
        PropertyCollector infoItem = new PropertyCollector((Object)valueController.getBinding().getMetaAttribute(), false);
        infoItem.collectProperties();
        valueController.getValueManager().contributeProperties((DBPPropertyManager)infoItem, valueController);
        DBDRowIdentifier rowIdentifier = valueController.getRowIdentifier();
        if (rowIdentifier != null) {
            infoItem.addProperty(null, "Key", DataEditorsMessages.controls_column_info_panel_property_key, (Object)new CellKeyInfo(valueController.getRowController(), rowIdentifier));
        }
        this.setLayout((Layout)new FillLayout());
        this.propViewer = new PropertyTreeViewer((Composite)this, 768);
        this.propViewer.loadProperties((DBPPropertySource)infoItem);
    }

    public void layoutProperties() {
        this.getParent().layout();
        this.propViewer.repackColumns();
    }

    public static class CellKeyInfo
    implements DBPObject {
        @NotNull
        private final IRowController rowController;
        @NotNull
        private final DBDRowIdentifier rowIdentifier;

        public CellKeyInfo(@NotNull IRowController rowController, @NotNull DBDRowIdentifier rowIdentifier) {
            this.rowController = rowController;
            this.rowIdentifier = rowIdentifier;
        }

        @Property(viewable=true, order=1, category="general")
        public String getType() {
            return this.rowIdentifier.getKeyType();
        }

        @Property(viewable=true, order=2, category="general")
        public String getName() {
            return this.rowIdentifier.getUniqueKey().getName();
        }

        @Property(viewable=true, order=3, category="columns")
        public List<KeyColumnValue> getColumns() {
            List<DBDAttributeBinding> rowAttributes = this.rowController.getRowAttributes();
            ArrayList<KeyColumnValue> columns = new ArrayList<KeyColumnValue>();
            for (DBDAttributeBinding binding : this.rowIdentifier.getAttributes()) {
                columns.add(new KeyColumnValue(binding, this.rowController.getAttributeValue(binding)));
            }
            return columns;
        }

        public String toString() {
            return "";
        }
    }

    public static class KeyColumnValue
    implements DBPNamedObject {
        private DBDAttributeBinding attribute;
        private Object value;

        public KeyColumnValue(DBDAttributeBinding attribute, @Nullable Object value) {
            this.attribute = attribute;
            this.value = value;
        }

        @NotNull
        public String getName() {
            return this.attribute.getName();
        }

        public String toString() {
            return DBUtils.isNullValue((Object)this.value) ? "[NULL]" : this.value.toString();
        }
    }
}

