/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dnd;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorInputTransfer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;

public class NavigatorTransferInfo {
    private static final Log log = Log.getLog(NavigatorTransferInfo.class);
    private final String name;
    private final DBNNode node;
    private final Object object;

    public NavigatorTransferInfo(@NotNull String name, @NotNull DBNNode node, @Nullable Object object) {
        this.node = node;
        this.object = object;
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object getObject() {
        return this.object;
    }

    @Nullable
    public EditorInputTransfer.EditorInputData createEditorInputData() {
        if (this.node instanceof DBNDatabaseNode) {
            DatabaseNodeEditorInput input = new DatabaseNodeEditorInput((DBNDatabaseNode)this.node);
            return EditorInputTransfer.createEditorInputData((String)"org.jkiss.dbeaver.ui.editors.entity.EntityEditor", (IEditorInput)input);
        }
        File file = new File(this.name);
        if (file.exists()) {
            try {
                IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
                IEditorDescriptor editor = EditorUtils.getFileEditorDescriptor((File)file, (IWorkbenchWindow)window);
                FileStoreEditorInput input = new FileStoreEditorInput(EFS.getStore((URI)file.toURI()));
                return EditorInputTransfer.createEditorInputData((String)editor.getId(), (IEditorInput)input);
            }
            catch (Exception e) {
                log.warn((Object)("Error creating editor input for file '" + String.valueOf(file) + "'"), (Throwable)e);
            }
        }
        return null;
    }
}

